---
title: Crystal 0.5.6 released!
version: 0.5.6
summary: Automatic documentation is here
thumbnail: +
author: asterite
---

[Crystal 0.5.6](https://github.com/crystal-lang/crystal/releases/tag/0.5.6) has been released!

The most important feature of this release is the incluson of a prelimiary `doc` command
that generates automatic documentation. Now you can [browse the API docs for the standard library](https://crystal-lang.org/api).

We will polish and improve the style with time, but at least it has lots of small nice features:

<ul class="goals spaced">
  <li>Documentation must be written using <a href="http://daringfireball.net/projects/markdown/" target="_blank">Markdown</a>, which is pretty popular and easy to read and write.</li>
  <li>You have a class tree at the left</li>
  <li>Superclass, included modules and knwon subclasses are shown</li>
  <li>References to types are automatically linked</li>
  <li>References to types mentioned in type restrictions are linked</li>
  <li>References to methods must be written like <code>#method</code> or <code>Type#method</code></li>
  <li>A "View Source" link is provided for every method, that takes you to the line of code where the method is defined (only for code that is hosted on <a href="https://github.com/" target="_blank">GitHub</a> for now)</li>
  <li>Code sections are highlighted, so examples showing usage of a class or method can be easily embedded and will be nicely formatted.</li>
</ul>

As usual, the documentation generator is [written in Crystal itself](https://github.com/crystal-lang/crystal/blob/master/src/compiler/crystal/tools/doc/generator.cr),
with a small (still incomplete) [Markdown parser](https://github.com/crystal-lang/crystal/blob/8039530863db02f050a1973f1ade9924acdfbcfe/src/markdown/parser.cr)
and [using ECR](https://github.com/crystal-lang/crystal/blob/master/src/compiler/crystal/tools/doc/html/type.html) (similar to [ERB](http://en.wikipedia.org/wiki/ERuby), only processed at compile-time).

One interesting aspect of this documentation generator is that the normal semantic analysis phase of the compiler
is applied before it. In this way the documentation generator can have precise type and method information.
Not only that, but the semantic phase does macro expansion, so code generated by macros will stil appear in documentation.

Furthermore, you can attach comments to macro invocations:

```ruby
class Foo
  # The comment for some_property
  property some_property
end
```

Once the `property` macro is expanded the comment attached to that macro call is attached to the
generated nodes. Finally, when you click on "View Source" for the generated method it will take
you to the location of the macro invocation, as the compiler keeps a link between the two.
All of this means that there's no need to tell the documentation generator that there are special
macros that generate code that needs to be shown in this or that way.

Having the documentation generator as a built-in tool means documentation of libraries will be consistent
and people won't have to worry about which documentation generator to choose. We believe a language
is more than just the language itself and that good integrated tools are indispensable for a good,
smooth experience.

Now there's just one thing missing: the documentation itself! We will add it, little by little, and you
are very welcome to help us out. Luckily [Yukihiro Matsumoto kindly let us use some Ruby documentation as
a starting point](https://twitter.com/yukihiro_matz/status/549317901002342400), given that a lot of
APIs are very similar, if not equal. So どうもありがとうございます to him :-)
