---
title: Crystal 0.5.4 released!
version: 0.5.4
summary:
thumbnail: +
author: asterite
---

[Crystal 0.5.4](https://github.com/crystal-lang/crystal/releases/tag/0.5.4) has been released!

The [GitHub repository](https://github.com/crystal-lang/crystal) recently surpassed the 1000 stars,
which might mean there's real interest in this language.
Let's make it possible and have fun along the way! :-)

This release includes many bugs fixes and small improvements, like naming consistency.

Most notably, you can now subclass generic types.

```ruby
# Define a new generic class that subclass another one
class MyArray(T) < Array(T)
end

# Define a non-generic class that subclass an instance of a generic another one
class MyInt32Array < Array(Int32)
end
```

There's also a more compact way to define JSON mappings:

```ruby
require "json"

class Person
  json_mapping({
    name: String,
    age: Int32
  })
end

person = Person.from_json %({"name": "John", "age": 30})
p person #=> #<Person:0x10220CF20 @name="John", @age=30>
```

Please read the [Changelog](https://github.com/crystal-lang/crystal/releases/tag/0.5.4) for all the details.

You can install Crystal by following [these instructions](/install).

> **THANKS:**
> We'd like to thank everyone that help us by sending pull requests, suggesting improvements and changes,
> adding documentation, fixing tpyos and talking about it in social media like [Twitter](https://twitter.com/search?q=crystal-lang.org)
> and [Reddit](http://www.reddit.com/r/crystal_programming).
