---
title: "Crystal: the <i>lingua franca</i> at Bright"
author: beta-ziliani
summary: "Crystal is a good common ground for developers with different backgrounds."
comment_href: https://disqus.com/home/discussion/crystal-lang/bright_and_manas_partner_together_to_create_crystal_development_tools_37/
company: Bright Security
image: /assets/blog/2024-02-02-bright-banner.jpg
categories: success
---

[Bright Security](https://brightsec.com/) is a developer-centric Dynamic Application Security Testing Solution, also known as a DAST. Founded in 2018, their mission is to help organizations ship secure Applications and APIs at the speed of business, by enabling quick & iterative scans to identify true and critical security vulnerabilities without compromising quality or software delivery speeds.

Bright is responsible for the development of an intelligent exploiter for securing web apps and APIs, which searches for endpoints and attacks them with a large set of potential security threats. These attacks are conceived by a specialized group of AppSec researchers.

Previously, when Bright was called NeuraLegion, they started coding their exploiter in Ruby. However, the need for performance and safety made them [quickly switch to Crystal](https://crystal-lang.org/2017/09/25/neuralegion-and-crystal/).

Fast-forward to today, many developers came and went, each with their own language of choice: those working in the core functionalities of the exploiter are mostly proficient in Ruby or C++, while AppSec researchers typically work in Python. How do they find a common language to develop the engine and the attacks?

Crystal sits well between dynamic languages like Ruby or Python and static languages like Java and C++. Thus, it sounds like it could be  the language to help developers communicate, no matter from which end of the spectrum they come from.

As C++ developer Alexander Kutsan [explained at length](https://www.youtube.com/watch?v=baoDYTD_cjY) in [CrystalConf 2023](https://www.youtube.com/watch?v=baoDYTD_cjY), learning Crystal is not only easy for Ruby devs: those coming from backgrounds as different as Python and C++ can also learn it pretty quickly. This eliminates the need to hire specialized Crystal devs: the language has low entry barriers, and more advanced topics can be learned on the way.

As a concrete example, AppSec researchers now code their attacks directly in Crystal. There is no need to translate them from Python. Afterwards, core application developers only need to ensure the quality of the code meets the standards of the rest of the application. Having a common language like Crystal meeting the requirements of low- and high-level developers helps reduce work, and increase efficiency, both, on the team operations level and on the application level.
