---
title: Behind the scenes of the past two months
summary: What’s been going on after the 1.0 release
thumbnail: +
author: beta-ziliani
comment_href: https://disqus.com/home/discussion/crystal-lang/behind_the_scenes_of_the_past_two_months/
categories: project
---

A couple of months since the first official release, the steam of PR reviewing and merging has appeased a bit. This gives us an opportunity to share some of what’s been happening behind the scenes: a bunch of big things are coming!

We’ve already mentioned important [changes in the Core Team composition](https://crystal-lang.org/2021/03/22/crystal-core-team-announcements.html). In practice, this involved a great deal of passing knowledge on to the new leadership. More importantly, the 1.0 release presented us with an opportunity to pause and think about how we want the language to evolve and how we want to conduct the project from a higher perspective.

Thus, we have set the following list of priorities to help us steer our actions:

## Transparency

Transparency has always been a cornerstone of how Crystal is led and developed. It is very important for us to continue along this line, and we’re thinking of new ways to let our community know how the decision processes work in the governance of Crystal. In this respect we took two steps: first, we published the [Crystal governance document](https://crystal-lang.org/reference/governance.html), where we outlined the bodies in charge of running Crystal, together with the processes we follow for making decisions about the language. Second, we published a new [Team page](https://crystal-lang.org/team), where everyone can see at a glance who is involved in the day-to-day management of the language.

## Growing the Core Team

With a few members becoming inactive, we wanted to grow the number of core members to keep our pace and, if possible, increase it. In this respect, we are very happy to announce that [Oleh Prypin (oprypin)](https://github.com/oprypin/) is our newest addition to the team, and our second run of voting in a member in accordance with the new governance (the first one being for my own inclusion). Oleh has been an active member of our community since 2015, and has shown a great capacity to improve the language and its ecosystem in every one of his contributions.

## Fixed releases

We want the community to know when to expect each new release, so we are working on ways to make them more regular, with a freeze period of 2-3 weeks in order to let people update their shards and programs, and work on possible regressions. We are still working on the details, but likely there will be three months between a 1.x and 1.(x+1) release.

## Native support on Windows and the newly released Macs

Aiming for wider adoption, we want every major platform to have a native Crystal compiler. We have made significant steps towards Windows support, with the sockets library being almost ready. As for the ARM Macs, we need to get our compiler working with the latest versions of the LLVM framework, a hard stone to crack in which we have already made good progress.


As you can see, these past two months have been quite busy attacking several fronts, including the preparation of what will surely be an amazing [conference](https://crystal-lang.org/2021/04/22/crystal-conference-1.0-launch.html).


We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](/sponsors). To maintain and increase the development pace, donations and sponsorships are essential. [OpenCollective](https://opencollective.com/crystal-lang) is available for that. Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!

Stay tuned, there’s a lot more coming!
