---
title: Organising a Crystal conference in 2020
summary: An overview of what you can expect at Raw Crystal 2020 and some insight on the organisation process.
thumbnail: +
author: lbarasti
comment_href: https://disqus.com/home/discussion/crystal-lang/organising_a_crystal_conference_in_2020/
categories: community
tags: [community, events]
---

Since I started exploring Crystal, I've always been impressed with how supportive people in the community were. It's the kind of feeling that makes you look forward to engage with fellow humans sharing a passion for building things.

Last month, I decided to turn that feeling into action by organising a community-driven, online conference dedicated to Crystal and its users. That conference now has a name - Raw Crystal 2020 - and a date: Friday, 11 December 2020.

<img src="/assets/blog/2020-11-raw-crystal-banner.png" width="417" height="176" class="center" alt="Raw Crystal 2020 logo"/>

Let me give you an overview of what you can expect to see at the conference and share some insight on the organisation process.

## Why a Crystal conference?
This being my first conference as organiser, I thought I should put into words the purposes of the event, so that I could base my decisions on them. Here is what I came up with.
* **Build a sense of community**: many of us across the world choose Crystal for their studies, experimentation, side projects and production system. Raw Crystal should give these people the opportunity to connect and build a trusted network.
* **Build a collection of knowledge**: by recording and sharing the conference talks, we hope to leave a trail of knowledge that others can pick up and build upon in the future.
* **Share knowledge and spark ideas**: we hope that the talks and conversations you'll have at the conference will make you want to start something new, or simply just tackle an old problem in a novel way.

## The search for speakers
After reading a few articles on the subject, I realised that finding speakers was going to be the most challenging part of the organisation. So before even thinking of a landing page for the conference, I launched [a simple Google form](https://forms.gle/tDSfrTQuWhSVmQo4A) to gather talk proposals.

Only a handful of talks came through over the first week, so I decided to proactively get in touch with prospective speakers to prompt them to contribute.
I selected a few people based on their activity on the various Crystal channels - e.g. forum, gitter, github - and on their involvement in interesting projects - cherry-picked from shard aggregators websites such as [crystalshards.xyz](http://crystalshards.xyz).

I also leveraged my network of Crystal friends. In particular, I asked Jack Thorne - of [Chicago Crystal](https://www.buzzsprout.com/1030945) fame - to look after and moderate a panel discussion to close the event - kudos Jack!
<img src="/assets/blog/2020-11-raw-crystal-jack.png" width="617"  class="center" alt="A couple of messages I exchanged Jack on Slack. I asked: would you be up for moderating a panel discussion at a conference, if we were to have one? He answered: yes!"/>

In parallel, I engaged with a few members of the Crystal core team to secure a keynote speaker - thanks Brian - and look for collaborators in the organisation of the event.

Finally, with the idea of ensuring a broad coverage of topics - from the language tool ecosystem to web application development - I decided to pick three featured speakers. You can find their names on the [event page](https://www.eventbrite.co.uk/e/raw-crystal-2020-tickets-127439094763), if you are curious.

## Compromising on time
Picking a time for the conference was quite challenging: on one hand, I wanted to make the event accessible to as many people across the world as possible. On the other hand, it is impossible to make everyone happy on a global scale.

I decided to make a choice based on the following constraints:
* the selected schedule should be friendly to people based in Argentina - that's where many members of the core team are based
* the selected schedule should not affect my circadian rhythm too badly - I'm based in London, UK
* the total span of the event should be manageable for a single person to run - so no marathons

I also reviewed geo data related to users of my personal blog and to users of my YouTube channel. This reminded me that Crystal has a significant number of friends in North America.

Based on all the above, I decided to go for a 6-hour-long conference starting at 16:00 UTC.
<img src="/assets/blog/2020-11-raw-crystal-schedule.png" width="617"  class="center" alt="Event schedule: the event will start at 8 am PST on Friday 11, December 2020, and close around 1 pm PST on the same day."/>

If these times don't work for you, then despair not! I will be sharing the recording of the talks on YouTube after the event.

## Code of conduct first
Before launching a landing page for the event, I decided to define a code of conduct, to avoid any misunderstanding.

I found [this article](https://blog.tito.io/posts/code-of-conduct-for-virtual-events/) on _Adapting Your Code of Conduct for Virtual Events_ extremely valuable, and ended up deriving the CoC for Raw Crystal 2020 from the one designed at ~~[#causeascene](https://hashtagcauseascene.com/code-of-conduct/)~~.

You'll find the conference CoC on the closing paragraph of the [event page](https://www.eventbrite.co.uk/e/raw-crystal-2020-tickets-127439094763).

## Registrations in numbers - so far
As of Wednesday 18 November, 86 people have registered to the conference.
<img src="/assets/blog/2020-11-raw-crystal-registrations.png" width="617"  class="center" alt="Registrations by day: 24 registration on 12 Nov, 21 on the 13th, around 10 on the 14th, 15th and 16th, around 5 on the 17th and on the 18th."/>
It was exciting to see a spike registrations as soon as the tickets were made available. The numbers have now gone down a bit, but I'm expecting to see another spike a day or two before registration closure.

Attendees are registering from all over the world, with some fearless folks based in Australia, South Korea, China and India ready to tune in way past bed time.
<img src="/assets/blog/2020-11-raw-crystal-geo.png" width="617"  class="center" alt="Registrations across the word: 28 registrations in North America, 43 in Europe, 8 in South America, 7 between Asia and Australia."/>
Around 50% of the registrations come from Europe; 30% of the registrations come from North America.

## What's next?
A lot has been decided already, but I'm still working out a few crucial details - mainly, which software we'll be using to run and record the event.

I am also looking forward to finalising the speakers line-up for you to see and plan your conference day.

Meanwhile, I'll be happy to read your comments below, listen to your suggestions and answer any questions!
