---
title: Shards 0.12.0 released!
summary: Shards has a new development release.
thumbnail: +
author: bcardiff
categories: community
tags: ecosystem
---

[Shards 0.12.0](https://github.com/crystal-lang/shards/releases/tag/v0.12.0) has been released!

This release of shards is focused on solving some papercuts issues and adding features that will come in handy to enable a healthy package ecosystem that will work against different versions of the language, plus reducing the friction of working on fixes here and there. Don't miss out on the rest of the [release changelog](https://github.com/crystal-lang/shards/releases/tag/v0.12.0).

> **NOTE:** To use this new release you will need to build shards from sources or use a nightly Crystal release until 1.0.0-pre1 is tagged.

You shall notice better error messages when a dependency’s `shard.yml` file triggers an error thanks to [#408](https://github.com/crystal-lang/shards/pull/408).

During development you might need to switch the source or fork of a dependency. This scenario was not being handled correctly in multiple commands and should be fixed now. When possible, shards will try to honor the version chosen despite the change of source. If the source ends up ambiguous, an error will be displayed.

A source will be ambiguous, for example, if your application requires packages `A` and `B` that both require `C` but they point to different forks. Read more at [#419](https://github.com/crystal-lang/shards/pull/419), [#429](https://github.com/crystal-lang/shards/pull/429).

In a previous release the crystal property became effectively mandatory and is used to declare for which versions of the compiler and std-lib the package is expected to work. At the same time, the flag `--ignore-crystal-version` was added to opt-out this check. Sometimes shards might just work with another crystal version than the one declared. We encourage maintainers to test, publish and declare the crystal versions they choose to support.

During the development of a major crystal release with potential breaking-changes (from 0.x to 1.x, and 1.x to 2.x) it is reasonable to run projects’ CIs against nightly with `--ignore-crystal-version`. Once the stable major release is out and the ecosystem caught up, there will be no need for `--ignore-crystal-version`. Note that using the crystal property helps prune the search space.

In this release Shards will read the `SHARDS_OPTS` environment variable for additional CLI options. So the CI can use `SHARDS_OPTS=--ignore-crystal-version` if the `shards install` command is implicitly run somewhere. Read more at [#417](https://github.com/crystal-lang/shards/pull/417), [#420](https://github.com/crystal-lang/shards/pull/420).

The featured feature of this release is shards overrides. Since it’s the first iteration of it, we are eager for feedback. We expect this first cut will enable and simplify some workflows and also assist in the transition on the upcoming major release of crystal. The feature was implemented in [#422](https://github.com/crystal-lang/shards/pull/422) and it’s motivation is explained in [#412](https://github.com/crystal-lang/shards/issues/412).

With local overrides feature you will be able to have a `shard.override.yml` or specify such file using `SHARDS_OVERRIDE` environment variable. If a dependency is listed in the override file, that version will be used, no matter what the rest of the dependency graph states.

With the above mentioned logic there are a couple of workflows that become simpler:

* As the developer of a shard I might use my working copy of it instead of checking out a new version.
* Bypass restrictions of intermediate packages that might be preventing me to use newer releases.
* Work on a patch on a deep dependency without needing to fork and tweak dependencies all the way down.
* Test against upstream development of dependencies without complicating the development workflow.

How are you going to use these new features?
