---
title: "Crystal Survey 2017 Results"
author: sdogruyol
summary: ""
thumbnail: ""
categories: community
---

This year, the Crystal team launched the first official [State of Crystal survey](https://crystal-lang.org/2017/07/31/launching-the-2017-state-of-crystal-survey.html). We're amazed by the fantastic feedback from the community.

We received ***757 responses***. Thanks a lot to everyone who took the time to respond! We tried our best to read through all of your comments and suggestions.

Without further ado, let's take a look at the results.

## How did you discover Crystal?

![19.9% Google or other search engines, 19.4% HackerNews, 15.6% Reddit, 10.9% Twitter](https://cdn.pbrd.co/images/GUwgT8n.png
  "19.9% Google or other search engines, 19.4% HackerNews, 15.6% Reddit, 10.9% Twitter")
(hover for more info)

We wanted to learn how you discovered Crystal, and were surprised to find that a lot of you arrived at Crystal through search engines. On the other hand, we confirmed how important HackerNews and Reddit are to divulge young and small projects such as Crystal. Every now and then, someone from the community posts something interesting about Crystal, the post makes it to HN and Reddit front pages and in the next few days we notice a wave of new users and contributors on the different community channels.

## Using Crystal

![47.2% Yes, I'm using Crystal for hobby projects, 32.1% No, but I' planning to use Crystal, %10.7 No, I'm not using Crystal, %9.9 Yes, I'm Using Crystal in production](https://cdn.pbrd.co/images/GP33qmx.png
"%47.2 Yes, I'm using Crystal for hobby projects, 32.1% No, but I'm planning to use Crystal, 10.7% No, I'm not using Crystal, 9.9% Yes, I'm Using Crystal in production")
(hover for more info)

There's a deeper story that we see in these numbers, which is consistent with what we hear in informal discussions about Crystal: the community is eager to start using the language in production, but is waiting for more concrete signals from the project. A considerable part of the community doesn't even mind about that and trusts the ecosystem enough to take the leap.

![34.7% Less than a month, 19% More than 12 months, 18.9% 1-3 Months, 15.2% 3-6 Months](https://cdn.pbrd.co/images/GP35Uvi.png
  "34.7% Less than a month, 19% More than 12 months, 18.9% 1-3 Months, 15.2% 3-6 Months")
(hover for more info)

Crystal community is growing rapidly. We've got a steady growing user base with a lot of new Crystal developers joining every week.

![63.1% Less than 1.000, 23% 1000 to 10000 lines, 11.5% Not sure, 2% 10000 to 100000 lines](https://cdn.pbrd.co/images/GP38e1h.png
"63.1% Less than 1.000, 23% 1000 to 10000 lines, 11.5% Not sure, 2% 10000 to 100000 lines")
(hover for more info)

Most of the current Crystal projects are less than 1000 lines, however there are also 17 projects which are in between 10000 and 100000 lines.

![46.6% Yes, 32.9% Not sure, 11.9% No, 8.9% Not applicable](https://cdn.pbrd.co/images/GP39tRi.png
  "46.6% Yes, 32.9% Not sure, 11.9% No, 8.9% Not applicable")
(hover for more info)

Crystal is a beauty, we know that a lot of you are excited to use it for your daily work :)

## What are some ways you or your company are using Crystal at work?

220 people answered this free form question. Here are the most common answers to how companies are using Crystal:

- Microservices
- CPU performance intensive apps
- CLI tools
- Background workers
- Big Data processing
- Ruby replacement

Some very interesting ones

- Genome analysis
- HPC
- Embedded GUI applications

## How could we help make Crystal more accepted at your company?

No surprises in the list: we know all of these are the main gaps to fill and we're happy to be aligned with the community.

- Stable release (1.0)
- Parallelism
- Windows support
- More resources and documentation
- Better tools (IDEs e.g)
- More libraries
- More streamlined release cycles

## What editor(s) do you use when writing Crystal?

Crystal developers do love using Vim, here's the major editors being used

- Vim - 34%
- Atom - 32.2%
- Visual Studio Code - 28.8%
- Sublime Text - 28.4%
- Emacs - 8.1%

### Platforms

![Linux 66%, Mac OS 57.5%, Windows 17.9%, 2.8% BSD-variant](https://cdn.pbrd.co/images/GPbEV09.png
  "Linux 66%, Mac OS 57.5%, Windows 17.9%, 2.8% BSD-variant")
(hover for more info)

Linux is the main platform Crystal developers choose followed by Mac OS. There's also a notable amount (17.9%) of Crystal developers using Windows.

![Linux 91.2%, Mac OS 41.5%, Windows 31.1%, Android 13.1%, iOS 10.9%, 5.3% BSD-variant, 9.4% Javascript, 6% Embeeded](https://cdn.pbrd.co/images/GPbIN3w.png
  "Linux 91.2%, Mac OS 41.5%, Windows 31.1%, Android 13.1%, iOS 10.9%, 5.3% BSD-variant, 9.4% Javascript, 6% Embeeded")

We see a similar pattern in target platforms. Linux is the most targeted platform. Interestingly we see Android, iOS and Javascript in a noticable ratio.

### Towards 1.0

![0.23.* 56.9%, Not sure 22.4%, Master 6.4%](https://cdn.pbrd.co/images/GPbKSji.png
  "0.23.* 56.9%, Not sure 22.4%, Master 6.4%")
(hover for more info)

Crystal developers tend to follow the latest stable release.

![No 60.7%, Yes, but it happens rarely 29.8%, Yes, and it happens oftern 9.4%](https://cdn.pbrd.co/images/GPdzxCW.png
  "No 60.7%, Yes, but it happens rarely 29.8%, Yes, and it happens oftern 9.4%")
(hover for more info)

We try to keep breaking changes as minimum as possible. More than %60 of Crystal developers don't have any significant changes to their code when upgrading to a new version.

![OS Package manager 86.4%, Binary tarballs 7%, Manually 4.7%](https://cdn.pbrd.co/images/GPdDVTd.png
  "OS Package manager 86.4%, Binary tarballs 7%, Manually 4.7%")
(hover for more info)

Using OS package managers to install Crystal is the most common and simple way to start. There are also prebuilt binary tarballs for major platforms.

## What critical libraries are missing in the Crystal ecosystem?

To improve the Crystal ecosystem, we asked what libraries are needed the most

- GUI
- ORM
- Third party SDKs (AWS, Google, etc.)
- Machine learning

## What development tools, if any, can make you more productive when working with Crystal?

We asked what tools would make Crystal developers more productive.

- IDE
- Debugger
- Code coverage & Linters
- Faster compile times

## Learning Resources

### Which learning resources, if any, did you use to learn Crystal?

- The official Crystal docs (https://crystal-lang.org/reference/)
- Crystal for Rubyists (http://www.crystalforrubyists.com/)
- Gitter/IRC/Help from the community
- Ruby background :)

![How difficult did you find learning Crystal?](https://cdn.pbrd.co/images/GQ5ea8Q.png
  "How difficult did you find learning Crystal?")

From 1 to 5, 1 being not difficult and 5 being very difficult.

## Crystal's Future

![Yes 42.8%, No 31.8%, 25.4% I don't know](https://cdn.pbrd.co/images/GQ5f1wZ.png
  "Yes 42.8%, No 31.8%, 25.4% I don't know")

## What can we make to make you well informed about Crystal's future?

- More blog posts
- Monthly development updates
- More social media (Twitter, Facebook e.g) activity and interaction.
- More transparency.

## What improvements are needed before Crystal v1.0 can be released? (General feedback)

- Parallelism
- Windows support
- Stable APIs
- Compiler improvements
- Better type inference

## Community & Demographics

![Yes 64.7%, I don't know 33.3%, 2.0% No](https://cdn.pbrd.co/images/GQ5lQzp.png
  "[Yes 64.7%, I don't know 33.3%, 2.0% No")

Crystal community takes its' welcoming and niceness from Ruby. We’re happy to see that over 64% of all respondents said they feel welcome in the Crystal community, with 33.3% not sure.

## What can we do to make you feel more welcome in the Crystal community?

- Feeling quite welcome already :)
- Merch store!
- More events, meetups, project discussion

## What domain do you use Crystal in?

Crystal developers use Crystal for many different domains.

1. Servers / Backend
2. Web Development
3. Network Programming
4. DevOps
5. IoT
6. Data Science
7. Gaming
8. Big Data

## Which programming languages are you most comfortable with?

Crystal developers come from various programming languages, most of them being dynamic programming languages. However Ruby definitely has a special place :)

1. Ruby
2. JavaScript
3. Python
4. PHP
5. Java
6. C
7. C++
8. C#

---

## Closing Thoughts

At the end of the survey, we asked: “Anything else you’d like to tell us?”

I’ll let some of the quotes speak for themselves:

> Keep up the great work!

> I love Crystal, and I want to use it more! Thank you!

> Crystal is my first loved programming language :)

> I can't wait for the 1.0 release! Great job on everything so far.

> I love you guys, keep it up! As a Rubyist with no prior experience with compiled languages, this was definitely and by far the easiest way to learn about them and get used to a strongly typed language.

Thanks to everyone who make Crystal and this survey possible <3

Happy Crystalling!
