---
title: Sponsors
layout: wide
section: community
---

<section markdown="1" class="content">
Building a programming language from scratch is not an easy feat.
It takes long hours, quite a few headaches and some very talented developers.
It’s also not cheap, and we don’t have the financial backing that a multinational corporation would:
this project was funded with our own work and the contribution of a bunch of generous souls all over the globe.

While we have a dedicated team working on the development of Crystal,
we need all the help we can get to realize its potential,
and below is a list of all the humans and organizations that have made it possible for us to get this far.
</section>

<section class="side-section">
  <h2>Enterprise Support</h2>
  <aside class="content">
  <p>Our Corporate Sponsorship tiers start at $5,000/month, but let’s talk and find a partnership model that suits you.</p>
  <a href="mailto:crystal@manas.tech" class="hex">Contact Us</a>
  </aside>
  {%- include pages/sponsors/sponsor-cards.html %}
</section>

<hr />

<section class="side-section reversed">
  <h2>Supporters</h2>

   {%- include pages/sponsors/table.html %}

  <aside class="sponsors-sidebar" id="contribute">
  <p>If you like this project, you can become a sponsor in only 3 simple steps via OpenCollective.</p>
  <a href="https://opencollective.com/crystal-lang" class="hex">Contribute</a>

  <h3>FAQ</h3>
  <dl>
  <dt>What is this list?</dt>
  <dd markdown="1">
  These are the companies and individuals contributing to help sustain
  Crystal's development. See the [Open Collective campaign](https://opencollective.com/crystal-lang)
  for more details.
  </dd>

  <dt>My URL is not listed</dt>
  <dd markdown="1">
  When eligible, we grab the website and avatar from the sponsor's [Open Collective profile](https://opencollective.com).
  If that fails, we try to use your GitHub or Twitter accounts listed in that same profile.
  </dd>

  <dt>When is this page updated?</dt>
  <dd markdown="1">
  We update the current sponsors in this page weekly.
  </dd>

  <dt>How is the list ordered?</dt>
  <dd markdown="1">
  It is ordered by level of contribution and total amount contributed so
  far. Columns are sortable.
  </dd>

  <dt>How long are contributors listed?</dt>
  <dd markdown="1">
  Contributors are listed forever, but after two months of the last payment they are considered as contributing $0.
  </dd>

  <dt>There seems to be an error, how can I fix it?</dt>
  <dd markdown="1">
  If there is any mismatch information you would like to correct, please [contact us](mailto:crystal@manas.tech).
  </dd>
  </dl>

  <h3>Original Sponsors</h3>
  <p>Meet our <a href="/sponsors/original-sponsors/">original sponsors</a>.</p>
  </aside>
</section>
