---
title: Media
description: |
  As the language and the community continues to grow it is important to have
  basic understanding about how and for what purposes the Crystal brand and
  associated works can be used.
section: docs
---

## Assets

We’ve put together some assets and guidelines to help you determine the best way
to use our brand and logos.

### Logo

> **NOTE:** Important
> Make sure to follow the [guidelines](#guidelines) described below when using any of this material.

<div class="cards-list">
  {%- include media/gallery_item.html img="media/crystal_logo.svg" name="Logo" %}
  {%- include media/gallery_item.html img="media/crystal_logo-stacked_version.svg" name="Logo stacked" %}
  {%- include media/gallery_item.html img="media/crystal_icon.svg" name="Icon" %}
</div>

<div class="link-item">
  <a href="/media/crystal-media-kit-6e57ec7.zip">
    {%- include icons/download.svg %}
    Download all assets in a zip file
  </a>
</div>

### Color

<div class="cards-list">
  {%- include media/color_sample.html color="Black" hex="#000" %}
  {%- include media/color_sample.html color="White" hex="#FFF" %}
  {%- include media/color_sample.html color="Gray" hex="#777" %}
</div>

### Font

{% include media/font_sample.html name="Roboto" %}
{% include media/font_sample.html name="Roboto Medium" %}
{% include media/font_sample.html name="Roboto Mono" %}

<div class="link-item">
  <a href="https://fonts.google.com/selection?query=robot&selection.family=Roboto+Mono:500|Roboto:400,500" target="_blank">
    {%- include icons/font-download.svg %}
    Get them from Google Fonts
  </a>
</div>

<hr />

## Guidelines

**What can you do with the Crystal logos and brand?**

<ul class="yes">
  <li>Print them on any merchandise you want, as long as you don’t sell it.</li>
  <li>Use them in presentations, papers and talks. </li>
  <li>Use them to advertise something you’ve created with Crystal.</li>
  <li>Use them in blog posts, articles or news about Crystal.</li>
  <li>Use them for educational purposes, as long as it’s available for free. </li>
</ul>

**Don’t do these things with the Crystal logos and brand:**

<ul class="no">
  <li>Change their colors, dimensions or add your own text.</li>
  <li>Sell Crystal artwork or merchandise without permission.</li>
  <li>Integrate your own logo with Crystal logos.</li>
  <li>Use the Crystal logos as your brand, company or app image.</li>
  <li>Use the logo in a way that could suggest sponsorship or endorsement by Crystal.</li>
</ul>

**Don’t hesitate to contact us if:**

* You want permission to sell Crystal merchandise.
* You want to use these logos for commercial purposes.
* You have questions about the use of Crystal brand and logos.

<div class="link-item">
  <a href="mailto:crystal@manas.tech">
    {%- include icons/alternate-mail.svg %}
    crystal@manas.tech
  </a>
</div>
