---
title: Crystal governance
layout: page
description: |
  This text outlines the governance process for Crystal. Governance is based
  around a steering council. The council has broad authority, which they seek to
  exercise as rarely as possible.
section: community
---

## The steering council

### Composition

The steering council is a committee formed ideally by an odd and small number of
people: 3 or 5.

### Current steering council

The current steering council consists of:

- Ary Borenszweig
- Brian Cardiff
- Beta Ziliani

### Mandate

The steering council shall work to:

1. Maintain the quality and stability of the Crystal language, compiler, std-lib
   and any other project under [crystal-lang organization](http://github.com/crystal-lang).

2. Make contributing as accessible, inclusive, and sustainable as possible.

3. Manage the relationship with Manas.Tech as the host for Crystal and
   coordinate with it other aspects of Crystal at large (communications,
   conferences, etc.).

4. Establish appropriate decision-making processes for change proposals.

5. Seek consensus among contributors and the core team before acting in a formal
   capacity.

6. Act as a "court of final appeal" for decisions where all other methods have
   failed.

### Powers

The council has broad authority to make decisions about the project.
For example, they can:

1. Accept or reject language change proposals.

2. Enforce or update the project's code of conduct.

3. Work with Manas.Tech to manage any project assets.

4. Delegate parts of their authority to other subcommittees or processes.

5. However, they cannot directly modify this document, or affect the membership
   of the core team, except via the mechanisms specified here.

The council should look for ways to use these powers as little as possible.
Instead of voting, it's better to seek consensus.
Instead of ruling on individual change proposals, it's better to define a
standard process for change proposals decision making.

To use its powers, the council votes. Every council member must either vote or
explicitly abstain. Members with conflicts of interest on a particular vote must
abstain. Passing requires a strict majority of non-abstaining council members.

Whenever possible, the council's deliberations and votes shall be held in public.

### Electing the council

Manas.Tech reserves the rights to elect, remove and replace members of the
council, but it vows to honor the leadership of the original creators of the
language (Ary, Brian, Juan), regardless of their employment relationship to
Manas. Before doing so, Manas will follow the advice process, consulting with
the council and core-team and hearing their input before acting.
That consultation is non-binding however.

Membership in the council does not necessarily imply being part of the core team.

### Ejecting core team members

In exceptional circumstances, it may be necessary to remove someone from the
core team against their will. (For example: egregious and ongoing code of
conduct violations.) This can be accomplished by a steering council vote.

## The core team

### Role

The core team is the group of trusted contributors who manage Crystal. They
assume many roles required to achieve the project's goals, especially those
that require a high level of trust. They make the decisions that shape the
future of the project. Their main mission is to keep Crystal moving forward,
either through their own contributions and/or by helping community contributions
be shaped in an accepted way, or reject them.

Core team members are expected to act as role models for the community and
custodians of the project, on behalf of the community and all those who rely on
Crystal.

They will intervene, where necessary, in online discussions or at official
Crystal events on the rare occasions that a situation arises that requires
intervention.

They have shared management over the contributions on the GitHub repositories.
Concretely, that means having write access to crystal-lang repositories.

### Prerogatives

Core team members are entitled to:

- Participate in formal votes to nominate new team members.

- Discuss in every important project decision (changes to the language,
infrastructure, etc.).

- Approve PRs.

- Merge approved PRs (they have access privilege to the crystal-lang
repositories).

### Membership

Crystal core team members demonstrate:

- A good grasp of the philosophy of the Crystal Project.

- A solid track record of being constructive and helpful.

- Contributions to the project's goals, in any form.

- Willingness to dedicate some time to improving Crystal.

- Positive and welcoming stewarding of the community.

As the project matures, contributions go beyond code. Here's an incomplete list
of areas where contributions may be considered for joining the core team, in no
particular order:

- Working on community management and outreach.

- Providing support on the community channels.

- Triaging tickets.

- Writing patches (code, docs, or tests).

- Reviewing patches (code, docs, or tests).

- Participating in design decisions.

- Providing expertise in a particular domain (security, i18n, etc.).

- Managing the infrastructure (CI, website, distribution packages etc.).

- Maintaining related projects (alternative interpreters, core infrastructure
like packaging, etc.).

- Creating visual designs.

Core team membership acknowledges sustained and valuable efforts that align well
with the philosophy and the goals of the Crystal project.

It is granted by receiving at least two-thirds positive votes of active core
team members in a vote that is open for two weeks and with no veto by the
steering council.

Core team members are always looking for promising contributors, teaching them
how the project is managed, and submitting their names to the core team's vote
when they're ready. There's no time limit on core team membership.

### Inactive members

In order to provide the general public with a reasonable idea of how many people
maintain Crystal, core team members who have stopped contributing are encouraged
to declare themselves as _inactive_. Core team members will be categorized as
inactive when:

- They voluntarily indicate they want to do so.

- They are unresponsive to voting calls.

Inactive members lose their active privileges like voting and commit access.
At any point, an inactive member can resume their contributions without a need
for a new vote to occur.

### Core team alumni

Members who haven't made any non-trivial contribution in two years will be
categorized as _alumni_. To record and honor their contributions, core team
alumni will continue to be listed alongside active and inactive core team
members; and, if they later want to resume contributing, they can ask to be
considered back again **subject to core team voting**.

The initial active core team members will consist of everyone currently listed
in the "Crystallers" team on Github (access granted for core members only) that
have been active in the past two years, and the initial alumni will consist of
everyone in that list that have been inactive in the past two years.

## Changing this document

Changes to this document require:

- That the change proposal is published for comment from the community during
two weeks.

- At least a two-thirds majority of votes cast in a steering council vote which
should be open for two weeks.
