#!/bin/bash

##########################################################################################
# Name:         VCDS (VAG-COM diagnosis system) - Installationsskript (Linux)            #
# Description:  With this file you can install VCDS (VAG-COM diagnosis system) on Linux. #
# Author:       Steve Zabka                                                              #
# Author URI:   https://cryinkfly.com                                                    #
# License:      MIT                                                                      #
# Copyright (c) 2020-2021                                                                #
# Time/Date:    11:10/20.10.2023                                                         #
# Version:      1.1                                                                      #
##########################################################################################

##############################################################################
# DESCRIPTION
##############################################################################

# With the help of my script, You get a way to install the VCDS (VAG-COM diagnosis system) on your Linux system. 
# Certain packages and programs that are required will be set up on your system.
#
# But it's important to know, that my script only helps You to get the program to run and nothing more!
#
# And so, You must to purchase the licenses directly from the manufacturer of the program VCDS (VAG-COM diagnosis system)!

##############################################################################

############################################################################################################################################################
# 1. Step: Open a Terminal and run this command: cd Downloads && chmod +x vcds-install.sh && bash vcds-install.sh
# 2. Step: The installation will now start and set up everything for you automatically!
############################################################################################################################################################

##############################################################################
# ALL FUNCTIONS ARE ARRANGED HERE:
##############################################################################

##############################################################################

# Here all languages are called up via an extra language file for the installation!

function languages {
    wget -N https://github.com/cryinkfly/VCDS-VAG-COM-diagnosis-system---Linux-Wine-Version-/raw/main/scripts/stable-branch/languages.sh &&
    chmod +x languages.sh &&
    clear &&
    . languages.sh
}

##############################################################################

# The minimum requirements for installing VCDS (VAG-COM diagnosis system) will be installed here!

function check-requirement {
echo "$text_1"
echo -n "$text_1_1"
read answer
if [ "$answer" != "${answer#[YyJj]}" ] ;then
    install-requirement &&
    wmctrl -r ':ACTIVE:' -b toggle,fullscreen &&
    select-your-os
else
    exit;
fi
}

function install-requirement {
if VERB="$( which apt-get )" 2> /dev/null; then
   echo "Debian-based"
   sudo apt-get update &&
   sudo apt-get install dialog wmctrl software-properties-common
elif VERB="$( which dnf )" 2> /dev/null; then
   echo "RedHat-based"
   sudo dnf update &&
   sudo dnf install dialog wmctrl
elif VERB="$( which pacman )" 2> /dev/null; then
   echo "Arch-based"
   sudo pacman -Sy --needed dialog wmctrl
elif VERB="$( which zypper )" 2> /dev/null; then
   echo "openSUSE-based"
   su -c 'zypper up && zypper install dialog wmctrl'
elif VERB="$( which xbps-install )" 2> /dev/null; then
   echo "Void-based"
   sudo xbps-install -Sy dialog wmctrl
elif VERB="$( which eopkg )" 2> /dev/null; then
   echo "Solus-based"
   sudo eopkg install dialog wmctrl
elif VERB="$( which emerge )" 2> /dev/null; then
    echo "Gentoo-based"
    sudo emerge -av dev-util/dialog x11-misc/wmctrl
else
   echo "I can't find your package manager!"
   exit;
fi
}

##############################################################################

# For the installation of VCDS (VAG-COM diagnosis system) one of the supported Linux distributions must be selected! - Part 1

function select-your-os {
HEIGHT=15
WIDTH=200
CHOICE_HEIGHT=10
BACKTITLE="$text_5"
TITLE="$text_5_1"
MENU="$text_5_2"

OPTIONS=(1 "Arch Linux, Manjaro Linux, EndeavourOS, ..."
         2 "Debian 10, MX Linux 19.4, Raspberry Pi Desktop, ..."
         3 "Debian 11"
         4 "Fedora 37"
         5 "Fedora 38"
         6 "openSUSE Leap 15.4"
         7 "openSUSE Leap 15.5"
         8 "openSUSE Tumbleweed"
         9 "Red Hat Enterprise Linux 8.x"
         10 "Solus"
         11 "Ubuntu 20.04, Linux Mint 20.x, Pop!_OS 20.04, ..."
         12 "Ubuntu 22.04, Linux Mint 21.x, Pop!_OS 21.04, ..."
         13 "Ubuntu 23.04"
         14 "Ubuntu 23.10"
         15 "Void Linux"
         16 "Gentoo Linux")

CHOICE=$(dialog --clear \
                --backtitle "$BACKTITLE" \
                --title "$TITLE" \
                --menu "$MENU" \
                $HEIGHT $WIDTH $CHOICE_HEIGHT \
                "${OPTIONS[@]}" \
                2>&1 >/dev/tty)

clear
case $CHOICE in         
        1)
            
            archlinux-1
            ;;
            
        2)
        
            debian-based-1 &&
            sudo add-apt-repository 'deb https://dl.winehq.org/wine-builds/debian/ buster main' &&
            debian-based-2
            ;;  
            
        3)
        
            debian-based-1 &&
            sudo add-apt-repository 'deb https://dl.winehq.org/wine-builds/debian/ bullseye main' &&
            debian-based-2
            ;;  
            
        4)
            
            fedora-based-1 &&
            sudo dnf config-manager --add-repo https://dl.winehq.org/wine-builds/fedora/37/winehq.repo &&
            fedora-based-2
            ;;  
            
        5) 
        
            fedora-based-1 &&
            sudo dnf config-manager --add-repo https://dl.winehq.org/wine-builds/fedora/38/winehq.repo &&
            fedora-based-2
            ;;  
        
        6)
        
            su -c 'zypper up && zypper rr https://download.opensuse.org/repositories/Emulators:/Wine/openSUSE_Leap_15.4/ wine && zypper ar -cfp 95 https://download.opensuse.org/repositories/Emulators:/Wine/openSUSE_Leap_15.4/ wine && zypper install p7zip-full curl wget wine cabextract' &&
            select-your-path
            ;;
            
        7)
            
            su -c 'zypper up && zypper rr https://download.opensuse.org/repositories/Emulators:/Wine/openSUSE_Leap_15.5/ wine && zypper ar -cfp 95 https://download.opensuse.org/repositories/Emulators:/Wine/openSUSE_Leap_15.5/ wine && zypper install p7zip-full curl wget wine cabextract' &&
            select-your-path
            ;;  
            
        8)
            
            su -c 'zypper up && zypper install p7zip-full curl wget wine cabextract' &&
            select-your-path
            ;;    
            
        9)
        
            redhat-linux &&
            select-your-path
            ;;
            
        10)
        
            solus-linux &&
            select-your-path
            ;;
            
        11) 
        
            debian-based-1 &&
            sudo apt-add-repository -r 'deb https://dl.winehq.org/wine-builds/ubuntu/ focal main' &&
            wget -q https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_20.04/Release.key -O Release.key -O- | sudo apt-key add - &&
            sudo apt-add-repository 'deb https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_20.04/ ./' &&
            debian-based-2
            ;;
            
        12) 
            
            debian-based-1 &&
            sudo add-apt-repository -r 'deb https://dl.winehq.org/wine-builds/ubuntu/ jammy main' &&
            wget -q https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_22.04/Release.key -O Release.key -O- | sudo apt-key add - &&
            sudo apt-add-repository 'deb https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_22.04/ ./' &&
            debian-based-2
            ;;
            
        13) 
        
            debian-based-1 &&
            sudo add-apt-repository -r 'deb https://dl.winehq.org/wine-builds/ubuntu/ lunar main' &&
            wget -q https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_23.04/Release.key -O Release.key -O- | sudo apt-key add - &&
            sudo apt-add-repository 'deb https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_23.04/ ./' &&
            debian-based-2
            ;;
            
        14)

            debian-based-1 &&
            sudo add-apt-repository -r 'deb https://dl.winehq.org/wine-builds/ubuntu/ mantic main' &&
            wget -q https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_23.10/Release.key -O Release.key -O- | sudo apt-key add - &&
            sudo apt-add-repository 'deb https://download.opensuse.org/repositories/Emulators:/Wine:/Debian/xUbuntu_23.10/ ./' &&
            debian-based-2
            ;;
            
        15)
        
            void-linux &&
            select-your-path
            ;;

        16)

            gentoo-linux &&
            select-your-path
            ;;

esac
}

##############################################################################

# For the installation of VCDS (VAG-COM diagnosis system) one of the supported Linux distributions must be selected! - Part 2

function archlinux-1 {

HEIGHT=15
WIDTH=60
CHOICE_HEIGHT=2
BACKTITLE="$text_3"
TITLE="$text_3_1"
MENU="$text_3_2"

OPTIONS=(1 "$text_3_3"
         2 "$text_3_4")

CHOICE=$(dialog --clear \
                --backtitle "$BACKTITLE" \
                --title "$TITLE" \
                --menu "$MENU" \
                $HEIGHT $WIDTH $CHOICE_HEIGHT \
                "${OPTIONS[@]}" \
                2>&1 >/dev/tty)

clear
case $CHOICE in
        1)
            archlinux-2 &&
            select-your-path
            ;;
        2)
            sudo echo "[multilib]" >> /etc/pacman.conf &&
            sudo echo "Include = /etc/pacman.d/mirrorlist" >> /etc/pacman.conf &&
            archlinux-2 &&
            select-your-path
            ;;
esac
}

function archlinux-2 {
   sudo pacman -Sy --needed wine wine-mono wine_gecko winetricks p7zip curl cabextract samba ppp
}
   
function debian-based-1 {
    sudo apt-get update &&
    sudo apt-get upgrade &&
    sudo dpkg --add-architecture i386  &&
    wget -nc https://dl.winehq.org/wine-builds/winehq.key &&
    sudo apt-key add winehq.key
}

function debian-based-2 {
    sudo apt-get update &&
    sudo apt-get upgrade &&
    sudo apt-get install p7zip p7zip-full p7zip-rar curl winbind cabextract wget &&
    sudo apt-get install --install-recommends winehq-staging &&
    select-your-path
}

function fedora-based-1 {
    sudo dnf update &&
    sudo dnf upgrade &&
    sudo dnf install https://mirrors.rpmfusion.org/free/fedora/rpmfusion-free-release-$(rpm -E %fedora).noarch.rpm https://mirrors.rpmfusion.org/nonfree/fedora/rpmfusion-nonfree-release-$(rpm -E %fedora).noarch.rpm
}

function fedora-based-2 {
    sudo dnf install p7zip p7zip-plugins curl wget wine cabextract &&
    select-your-path
}

function redhat-linux {
   sudo subscription-manager repos --enable codeready-builder-for-rhel-8-x86_64-rpms &&
   sudo rpm -Uvh https://dl.fedoraproject.org/pub/epel/epel-release-latest-8.noarch.rpm &&
   sudo dnf upgrade &&
   sudo dnf install wine
}

function solus-linux {
   sudo eopkg install wine winetricks p7zip curl cabextract samba ppp
}

function void-linux {
   sudo xbps-install -Sy wine wine-mono wine-gecko winetricks p7zip curl cabextract samba ppp
}

function gentoo-linux {
    sudo emerge -av virtual/wine app-emulation/winetricks app-emulation/wine-mono app-emulation/wine-gecko app-arch/p7zip app-arch/cabextract net-misc/curl net-fs/samba net-dialup/ppp
}

##############################################################################

# Here you can determine how VCDS (VAG-COM diagnosis system) should be installed! (Installation location)

function select-your-path {

HEIGHT=15
WIDTH=200
CHOICE_HEIGHT=2
CHOICE_WIDTH=200
BACKTITLE="$text_4"
TITLE="$text_4_1"
MENU="$text_4_2"

OPTIONS=(1 "$text_4_3"
         2 "$text_4_4")

CHOICE=$(dialog --clear \
                --backtitle "$BACKTITLE" \
                --title "$TITLE" \
                --menu "$MENU" \
                $HEIGHT $WIDTH $CHOICE_HEIGHT \
                "${OPTIONS[@]}" \
                2>&1 >/dev/tty)

clear
case $CHOICE in
        1)
            winetricks-standard
            ;;
        2)
            select-your-path-custom &&
            winetricks-custom
            ;;
esac
}


function select-your-path-custom {
    dialog --backtitle "$text_5" \
    --title "$text_5_1" \
    --msgbox "$text_5_2" 14 200

    filename=$(dialog --stdout --title "$text_5_3" --backtitle "$text_5_4" --fselect $HOME/ 14 100)
}

##############################################################################

# VCDS (VAG-COM diagnosis system) will now be installed using Wine and Winetricks!

function winetricks-standard {
   clear
   mkdir -p /home/$USER/.wineprefixes/vcds &&
   cd /home/$USER/.wineprefixes/vcds &&
   wget -N https://raw.githubusercontent.com/Winetricks/winetricks/master/src/winetricks &&
   chmod +x winetricks &&
   WINEPREFIX=/home/$USER/.wineprefixes/vcds sh winetricks -q corefonts win8 &&
   mkdir -p vcdsdownload &&
   cd vcdsdownload &&
   wget https://dltemp.ross-tech.com/VCDS/download/O8934p/VCDS-Release-21.9.0-Installer.exe -O VCDS.exe &&
   WINEPREFIX=/home/$USER/.wineprefixes/vcds wine VCDS.exe &&
   logfile-installation-standard &&
   program-exit
}

function winetricks-custom {
   clear
   mkdir -p $filename &&
   cd $filename &&
   wget -N https://raw.githubusercontent.com/Winetricks/winetricks/master/src/winetricks &&
   chmod +x winetricks &&
   WINEPREFIX=$filename sh winetricks -q corefonts win8 &&
   mkdir -p vcdsdownload &&
   cd svcdsdownload &&
   wget https://dltemp.ross-tech.com/VCDS/download/R6E5A1/VCDS-Release-23.3.1-Installer.exe -o VCDS.exe &&
   WINEPREFIX=/home/$USER/.wineprefixes/vcds wine VCDS.exe &&
   logfile-installation-custom &&
   program-exit
}

##############################################################################

# A log file will now be created here so that it can be checked in the future whether an installation of VCDS (VAG-COM diagnosis system) already exists on your system.

function logfile-installation {
   mkdir -p "/$HOME/.local/share/vcds/logfiles" && 
   exec 5> /$HOME/.local/share/vcds/logfiles/install-log.txt
   BASH_XTRACEFD="5"
   set -x
}

function logfile-installation-standard {
   mkdir -p "/$HOME/.local/share/vcds/logfiles" &&
   cd "/$HOME/.local/share/vcds/logfiles" &&
   echo "/home/$USER/.wineprefixes/vcds/logfiles" >> path-log.txt
}

function logfile-installation-custom {
   mkdir -p "/$HOME/.local/share/vcds/logfiles" &&
   cd "/$HOME/.local/share/vcds/logfiles" &&
   echo "$filename" >> path-log.txt
}

##############################################################################

# The installation is complete and will be terminated.

function program-exit {
    dialog --backtitle "$text_6" \
    --title "$text_6_1" \
    --msgbox "$text_6_2" 14 200
    
    clear
    exit
}

##############################################################################
# THE INSTALLATION PROGRAM IS STARTED HERE:
##############################################################################

logfile-installation &&
clear &&
languages &&
check-requirement

############################################################################################################################################################
