/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.elasticsearch.test;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Setting.Property;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.plugins.Plugin;

import io.crate.common.unit.TimeValue;

public final class InternalSettingsPlugin extends Plugin {

    public static final Setting<Boolean> MERGE_ENABLED =
        Setting.boolSetting("index.merge.enabled", true, Property.IndexScope, Property.NodeScope);
    public static final Setting<Long> INDEX_CREATION_DATE_SETTING =
        Setting.longSetting(IndexMetadata.SETTING_CREATION_DATE, -1, -1, Property.IndexScope, Property.NodeScope);
    public static final Setting<TimeValue> TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING =
        Setting.timeSetting("index.translog.retention.check_interval", new TimeValue(10, TimeUnit.MINUTES),
            new TimeValue(-1, TimeUnit.MILLISECONDS), Property.Dynamic, Property.IndexScope);
    public static final Setting<String> INDEX_UUID =
        Setting.simpleString("index.uuid", Property.IndexScope, Property.NodeScope);

    @Override
    public List<Setting<?>> getSettings() {
        return Arrays.asList(
                MERGE_ENABLED,
                INDEX_CREATION_DATE_SETTING,
                TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING,
                IndexService.GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING,
                IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING,
                INDEX_UUID,
                IndexSettings.INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING,
                IndexSettings.FILE_BASED_RECOVERY_THRESHOLD_SETTING,
                FsService.ALWAYS_REFRESH_SETTING
            );
    }
}
