/*
 * Licensed to Crate.io GmbH ("Crate") under one or more contributor
 * license agreements.  See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.  Crate licenses
 * this file to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * However, if you have executed another commercial license agreement
 * with Crate these terms will supersede the license and you may use the
 * software solely pursuant to the terms of the relevant commercial agreement.
 */

package io.crate.replication.logical.metadata;

import static org.assertj.core.api.Assertions.assertThat;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.test.ESTestCase;
import org.junit.Test;

import io.crate.metadata.RelationName;

public class PublicationsMetadataTest extends ESTestCase {

    public static PublicationsMetadata createMetadata() {
        Map<String, Publication> map = Map.of(
            "pub1",
            new Publication(
                "user1",
                false,
                List.of(new RelationName("s1", "t1"), new RelationName("s1", "t2"))
            ),
            "myPub2",
            new Publication("user2", true, List.of())
        );
        return new PublicationsMetadata(map);
    }

    @Test
    public void testStreaming() throws IOException {
        PublicationsMetadata pubs = createMetadata();
        BytesStreamOutput out = new BytesStreamOutput();
        pubs.writeTo(out);

        StreamInput in = out.bytes().streamInput();
        PublicationsMetadata pubs2 = new PublicationsMetadata(in);
        assertThat(pubs2).isEqualTo(pubs);

    }
}
