/*
 * Licensed to Crate.io GmbH ("Crate") under one or more contributor
 * license agreements.  See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.  Crate licenses
 * this file to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * However, if you have executed another commercial license agreement
 * with Crate these terms will supersede the license and you may use the
 * software solely pursuant to the terms of the relevant commercial agreement.
 */

package io.crate.sql.tree;

import java.util.Objects;

public final class CreateTableAs<T> extends Statement {

    private final Table<T> name;
    private final Query query;
    private final boolean ifNotExists;

    public CreateTableAs(Table<T> name, Query query, boolean ifNotExists) {
        this.name = name;
        this.query = query;
        this.ifNotExists = ifNotExists;
    }

    public Table<T> name() {
        return this.name;
    }

    public Query query() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAs(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTableAs)) {
            return false;
        }
        CreateTableAs<?> that = (CreateTableAs<?>) o;
        return name.equals(that.name) &&
            query.equals(that.query) &&
            ifNotExists == that.ifNotExists;
    }

    public boolean ifNotExists() {
        return ifNotExists;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, query, ifNotExists);
    }

    @Override
    public String toString() {
        return "CreateTableAs{" +
               "name=" + name +
               ", query=" + query +
               '}';
    }
}

