/*
 * Licensed to Crate.io GmbH ("Crate") under one or more contributor
 * license agreements.  See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.  Crate licenses
 * this file to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * However, if you have executed another commercial license agreement
 * with Crate these terms will supersede the license and you may use the
 * software solely pursuant to the terms of the relevant commercial agreement.
 */

package io.crate.sql.tree;

import java.util.List;
import java.util.Objects;

public class CreateSubscription<T> extends Statement {

    private final String name;
    private final T connectionInfo;
    private final List<String> publications;
    private final GenericProperties<T> properties;

    public CreateSubscription(String name,
                              T connectionInfo,
                              List<String> publications,
                              GenericProperties<T> properties) {
        this.name = name;
        this.connectionInfo = connectionInfo;
        this.publications = publications;
        this.properties = properties;
    }

    public String name() {
        return name;
    }

    public T connectionInfo() {
        return connectionInfo;
    }

    public List<String> publications() {
        return publications;
    }

    public GenericProperties<T> properties() {
        return properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSubscription(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateSubscription<?> that = (CreateSubscription<?>) o;
        return name.equals(that.name) && connectionInfo.equals(that.connectionInfo) && publications.equals(that.publications) &&
               properties.equals(that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, connectionInfo, publications, properties);
    }

    @Override
    public String toString() {
        return "CreateSubscription{" +
               "name='" + name + '\'' +
               ", connection='" + connectionInfo + '\'' +
               ", publications=" + publications +
               ", properties=" + properties +
               '}';
    }
}
