/*
 * Licensed to Crate.io GmbH ("Crate") under one or more contributor
 * license agreements.  See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.  Crate licenses
 * this file to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * However, if you have executed another commercial license agreement
 * with Crate these terms will supersede the license and you may use the
 * software solely pursuant to the terms of the relevant commercial agreement.
 */

package io.crate.data.breaker;

/**
 * Accounts for memory of rows representations to avoid OutOfMemoryErrors.
 * Calculated memory usage can be released.
 */
public interface RowAccounting<T> {

    /**
     * Accounts memory usage of the supplied row representation.
     * May throw an exception if it thinks that the entities accounted for
     * occupy too much memory.
     * @return estimated number of bytes for the row
     * @throws CircuitBreakingException if too much memory would be consumed after materializing this row.
     */
    long accountForAndMaybeBreak(T row);

    /**
     * Stops accounting for previously accounted rows.
     */
    void release();
}
