/*
 * Licensed to Crate.io GmbH ("Crate") under one or more contributor
 * license agreements.  See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.  Crate licenses
 * this file to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * However, if you have executed another commercial license agreement
 * with Crate these terms will supersede the license and you may use the
 * software solely pursuant to the terms of the relevant commercial agreement.
 */

package io.crate.beans;

/**
 * The QueryStatsMBean interface is required to define a standard MBean,
 * such as a standard MBean is composed of an MBean interface and a class.
 * <p>
 * The QueryStatsMBean interface lists the methods for all exposed attributes.
 *
 * @see <a href="https://docs.oracle.com/javase/tutorial/jmx/mbeans/standard.html">
 * https://docs.oracle.com/javase/tutorial/jmx/mbeans/standard.html</a>
 */
@SuppressWarnings("unused")
public interface QueryStatsMBean {

    long getSelectQueryTotalCount();

    long getInsertQueryTotalCount();

    long getUpdateQueryTotalCount();

    long getDeleteQueryTotalCount();

    long getManagementQueryTotalCount();

    long getDDLQueryTotalCount();

    long getCopyQueryTotalCount();

    long getUndefinedQueryTotalCount();

    long getSelectQuerySumOfDurations();

    long getInsertQuerySumOfDurations();

    long getUpdateQuerySumOfDurations();

    long getDeleteQuerySumOfDurations();

    long getManagementQuerySumOfDurations();

    long getDDLQuerySumOfDurations();

    long getCopyQuerySumOfDurations();

    long getUndefinedQuerySumOfDurations();

    long getSelectQueryFailedCount();

    long getInsertQueryFailedCount();

    long getUpdateQueryFailedCount();

    long getDeleteQueryFailedCount();

    long getManagementQueryFailedCount();

    long getDDLQueryFailedCount();

    long getCopyQueryFailedCount();

    long getUndefinedQueryFailedCount();
}
