/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import io.crate.Plugin;
import io.crate.metadata.FunctionIdent;
import io.crate.metadata.FunctionImplementation;
import io.crate.operation.scalar.IsEvenScalarFunction;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class ExamplePlugin
implements Plugin {
    public static final String EXECUTE_PER_ROW_SETTING = "plugin.example.executeScalarPerRow";
    private static final Logger LOGGER = LogManager.getLogger(ExamplePlugin.class);
    private final boolean executePerRow;

    public ExamplePlugin(Settings settings) {
        this.executePerRow = settings.getAsBoolean(EXECUTE_PER_ROW_SETTING, Boolean.valueOf(true));
        LOGGER.info("ExamplePlugin loaded, execute scalar function per row: {}", (Object)this.executePerRow);
    }

    public String name() {
        return "example-plugin";
    }

    public String description() {
        return "A example plugin demonstrating crate's plugin infrastructure.";
    }

    public Settings additionalSettings() {
        return Settings.builder().put("setting.for.crate", "foo").build();
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Setting.simpleString((String)"setting.for.crate", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    }

    public Collection<Module> createGuiceModules() {
        LOGGER.info("Registering new scalar function using MapBinder");
        return Collections.singletonList(new AbstractModule(){

            protected void configure() {
                MapBinder functionBinder = MapBinder.newMapBinder((Binder)this.binder(), FunctionIdent.class, FunctionImplementation.class);
                functionBinder.addBinding((Object)new FunctionIdent("is_even", Collections.singletonList(DataTypes.LONG))).toInstance((Object)new IsEvenScalarFunction());
            }
        });
    }
}

