from collections import namedtuple
from typing import Any, Optional

class LexerError(Exception): ...

Position = namedtuple('Position', ['line', 'column'])

class JavaToken:
    value: Any = ...
    position: Any = ...
    javadoc: Any = ...
    def __init__(self, value: Any, position: Optional[Any] = ..., javadoc: Optional[Any] = ...) -> None: ...
    def __eq__(self, other: Any) -> Any: ...

class EndOfInput(JavaToken): ...

class Keyword(JavaToken):
    VALUES: Any = ...

class Modifier(Keyword):
    VALUES: Any = ...

class BasicType(Keyword):
    VALUES: Any = ...

class Literal(JavaToken): ...
class Integer(Literal): ...
class DecimalInteger(Literal): ...
class OctalInteger(Integer): ...
class BinaryInteger(Integer): ...
class HexInteger(Integer): ...
class FloatingPoint(Literal): ...
class DecimalFloatingPoint(FloatingPoint): ...
class HexFloatingPoint(FloatingPoint): ...

class Boolean(Literal):
    VALUES: Any = ...

class Character(Literal): ...
class String(Literal): ...
class Null(Literal): ...

class Separator(JavaToken):
    VALUES: Any = ...

class Operator(JavaToken):
    MAX_LEN: int = ...
    VALUES: Any = ...
    INFIX: Any = ...
    PREFIX: Any = ...
    POSTFIX: Any = ...
    ASSIGNMENT: Any = ...
    LAMBDA: Any = ...
    METHOD_REFERENCE: Any = ...
    def is_infix(self): ...
    def is_prefix(self): ...
    def is_postfix(self): ...
    def is_assignment(self): ...

class Annotation(JavaToken): ...
class Identifier(JavaToken): ...

class JavaTokenizer:
    IDENT_START_CATEGORIES: Any = ...
    IDENT_PART_CATEGORIES: Any = ...
    data: Any = ...
    ignore_errors: Any = ...
    errors: Any = ...
    current_line: int = ...
    start_of_line: int = ...
    operators: Any = ...
    whitespace_consumer: Any = ...
    javadoc: Any = ...
    def __init__(self, data: Any, ignore_errors: bool = ...) -> None: ...
    i: int = ...
    j: int = ...
    def reset(self) -> None: ...
    def consume_whitespace(self) -> None: ...
    def read_string(self) -> None: ...
    def try_operator(self): ...
    def read_comment(self): ...
    def read_decimal_float_or_integer(self): ...
    def read_hex_integer_or_float(self): ...
    def read_digits(self, digits: Any) -> None: ...
    def read_decimal_integer(self) -> None: ...
    def read_hex_integer(self) -> None: ...
    def read_bin_integer(self) -> None: ...
    def read_octal_integer(self) -> None: ...
    def read_integer_or_float(self, c: Any, c_next: Any): ...
    def try_separator(self): ...
    def decode_data(self): ...
    def is_java_identifier_start(self, c: Any): ...
    def read_identifier(self): ...
    length: Any = ...
    def pre_tokenize(self) -> None: ...
    def tokenize(self) -> None: ...
    def error(self, message: Any, char: Optional[Any] = ...) -> None: ...

def tokenize(code: Any, ignore_errors: bool = ...): ...
def reformat_tokens(tokens: Any): ...
