/*
 * Decompiled with CFR 0.152.
 */
package com.metrics.halstead;

import com.metrics.halstead.ASTVisitorMod;
import com.metrics.halstead.HalsteadMetrics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class App {
    public static ASTVisitorMod parse(char[] str, String file) {
        IProblem[] problems;
        ASTParser parser = ASTParser.newParser(13);
        Hashtable<String, String> options = JavaCore.getDefaultOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "13");
        options.put("org.eclipse.jdt.core.compiler.compliance", "13");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "13");
        parser.setCompilerOptions(options);
        parser.setSource(str);
        parser.setKind(8);
        parser.setResolveBindings(true);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        for (IProblem problem : problems = cu.getProblems()) {
            if (problem.getID() == 1610613332 || problem.getID() == 1610613329 || problem.getID() == 1610613328) continue;
            System.out.println(file + "  CompilationUnit problem Message " + problem.getMessage() + " \t At line= " + problem.getSourceLineNumber() + "\t Problem ID=" + problem.getID());
        }
        ASTVisitorMod visitor = new ASTVisitorMod();
        cu.accept(visitor);
        return visitor;
    }

    public static char[] ReadFileToCharArray(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[10];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString().toCharArray();
    }

    public static List<char[]> ParseFilesInDir(List<String> JavaFiles) throws IOException {
        if (JavaFiles.isEmpty()) {
            System.out.println("There is no java source code in the provided directory");
            System.exit(0);
        }
        ArrayList<char[]> FilesRead = new ArrayList<char[]>();
        for (int i = 0; i < JavaFiles.size(); ++i) {
            FilesRead.add(App.ReadFileToCharArray(JavaFiles.get(i)));
        }
        return FilesRead;
    }

    public static List<String> retrieveFiles(String directory) {
        ArrayList<String> Files = new ArrayList<String>();
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            System.out.println("The provided path is not a valid directory");
            System.exit(1);
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Files.addAll(App.retrieveFiles(file.getAbsolutePath()));
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            Files.add(file.getAbsolutePath());
        }
        return Files;
    }

    public static void main(String[] args) throws IOException {
        String DirName = null;
        DirName = args[0];
        List<String> JavaFiles = Arrays.asList(DirName);
        List<char[]> FilesRead = App.ParseFilesInDir(JavaFiles);
        int DistinctOperators = 0;
        int DistinctOperands = 0;
        int TotalOperators = 0;
        int TotalOperands = 0;
        int OperatorCount = 0;
        int OperandCount = 0;
        for (int i = 0; i < FilesRead.size(); ++i) {
            ASTVisitorMod ASTVisitorFile = App.parse(FilesRead.get(i), JavaFiles.get(i));
            DistinctOperators = ASTVisitorFile.oprt.size();
            DistinctOperands = ASTVisitorFile.names.size();
            OperatorCount = 0;
            for (int f : ASTVisitorFile.oprt.values()) {
                OperatorCount += f;
            }
            TotalOperators = OperatorCount;
            OperandCount = 0;
            for (int f : ASTVisitorFile.names.values()) {
                OperandCount += f;
            }
            TotalOperands = OperandCount;
            HalsteadMetrics hal = new HalsteadMetrics();
            hal.setParameters(DistinctOperators, DistinctOperands, TotalOperators, TotalOperands);
            double volume = hal.getVolume();
            System.out.println(volume);
        }
    }

    public static void writeUsingFiles(String data) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("02/halstead_metric.csv", true));
        writer.newLine();
        writer.write(data);
        writer.close();
    }
}

