﻿#include"../localedef.h"

namespace fast_io_i18n
{
namespace
{

inline constexpr std::size_t monetary_mon_grouping_storage[]{3,2};

inline constexpr std::size_t numeric_grouping_storage[]{3};

inline constexpr lc_all lc_all_global{.identification={.name=tsc("tcy_IN"),.encoding=tsc(FAST_IO_LOCALE_ENCODING),.title=tsc("Tulu language locale for India"),.source=tsc("IndLinux.org, Samsung Electronics Co., Ltd.\t\t;\t\tfast_io"),.address=tsc("https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc("fast_io"),.email=tsc("alexey.merzlyakov@samsung.com;euloanty@live.com"),.tel=tsc(""),.fax=tsc(""),.language=tsc("Tulu"),.territory=tsc("India"),.revision=tsc("0.1"),.date=tsc("2014-09-30")},.monetary={.int_curr_symbol=tsc("INR "),.currency_symbol=tsc("₹"),.mon_decimal_point=tsc("."),.mon_thousands_sep=tsc(","),.mon_grouping={monetary_mon_grouping_storage,2},.positive_sign=tsc(""),.negative_sign=tsc("-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc("."),.thousands_sep=tsc(","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc("ಐ"),tsc("ಸೋ"),tsc("ಅಂ"),tsc("ಬು"),tsc("ಗು"),tsc("ಶು"),tsc("ಶ")},.day={tsc("ಐಥಾರ"),tsc("ಸೋಮಾರ"),tsc("ಅಂಗರೆ"),tsc("ಬುಧಾರ"),tsc("ಗುರುವಾರ"),tsc("ಶುಕ್ರರ"),tsc("ಶನಿವಾರ")},.abmon={tsc("ಜ"),tsc("ಫೆ"),tsc("ಮಾ"),tsc("ಏ"),tsc("ಮೇ"),tsc("ಜೂ"),tsc("ಜು"),tsc("ಆ"),tsc("ಸೆ"),tsc("ಅ"),tsc("ನ"),tsc("ಡಿ")},.mon={tsc("ಜನವರಿ"),tsc("ಫೆಬ್ರುವರಿ"),tsc("ಮಾರ್ಚ್"),tsc("ಏಪ್ರಿಲ್‌‌"),tsc("ಮೇ"),tsc("ಜೂನ್"),tsc("ಜುಲೈ"),tsc("ಆಗಸ್ಟ್"),tsc("ಸೆಪ್ಟೆಂಬರ್‌"),tsc("ಅಕ್ಟೋಬರ್"),tsc("ನವೆಂಬರ್"),tsc("ಡಿಸೆಂಬರ್")},.d_t_fmt=tsc("%A %d %b %Y %I:%M:%S %p"),.d_fmt=tsc("%-d//%-m//%y"),.t_fmt=tsc("%I:%M:%S %p %Z"),.t_fmt_ampm=tsc("%I:%M:%S %p %Z"),.date_fmt=tsc("%A %d %b %Y %I:%M:%S %p %Z"),.am_pm={tsc("ಕಾಂಡೆ"),tsc("ಬಯ್ಯ")},.week={7,19971130,1}},.messages={.yesexpr=tsc("^[+1yY]"),.noexpr=tsc("^[-0nN]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc("+%c ;%a ;%l"),.int_select=tsc("00"),.int_prefix=tsc("91")},.name={.name_fmt=tsc("%p%t%f%t%g"),.name_gen=tsc(""),.name_miss=tsc("ಕುಮಾರಿ"),.name_mr=tsc("ಶ್ರೀ"),.name_mrs=tsc("ಶ್ರೀಮತಿ"),.name_ms=tsc("ಕುಮಾರ")},.address={.postal_fmt=tsc("%z%c%T%s%b%e%r"),.country_name=tsc("ಭಾರತ"),.country_ab2=tsc("IN"),.country_ab3=tsc("IND"),.country_num=356,.country_car=tsc("IND"),.lang_name=tsc("ತುಳು"),.lang_ab=tsc(""),.lang_term=tsc("tcy"),.lang_lib=tsc("tcy")},.measurement={.measurement=1}};

inline constexpr wlc_all wlc_all_global{.identification={.name=tsc(L"tcy_IN"),.encoding=tsc(FAST_IO_LOCALE_LENCODING),.title=tsc(L"Tulu language locale for India"),.source=tsc(L"IndLinux.org, Samsung Electronics Co., Ltd.\t\t;\t\tfast_io"),.address=tsc(L"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(L"fast_io"),.email=tsc(L"alexey.merzlyakov@samsung.com;euloanty@live.com"),.tel=tsc(L""),.fax=tsc(L""),.language=tsc(L"Tulu"),.territory=tsc(L"India"),.revision=tsc(L"0.1"),.date=tsc(L"2014-09-30")},.monetary={.int_curr_symbol=tsc(L"INR "),.currency_symbol=tsc(L"₹"),.mon_decimal_point=tsc(L"."),.mon_thousands_sep=tsc(L","),.mon_grouping={monetary_mon_grouping_storage,2},.positive_sign=tsc(L""),.negative_sign=tsc(L"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(L"."),.thousands_sep=tsc(L","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(L"ಐ"),tsc(L"ಸೋ"),tsc(L"ಅಂ"),tsc(L"ಬು"),tsc(L"ಗು"),tsc(L"ಶು"),tsc(L"ಶ")},.day={tsc(L"ಐಥಾರ"),tsc(L"ಸೋಮಾರ"),tsc(L"ಅಂಗರೆ"),tsc(L"ಬುಧಾರ"),tsc(L"ಗುರುವಾರ"),tsc(L"ಶುಕ್ರರ"),tsc(L"ಶನಿವಾರ")},.abmon={tsc(L"ಜ"),tsc(L"ಫೆ"),tsc(L"ಮಾ"),tsc(L"ಏ"),tsc(L"ಮೇ"),tsc(L"ಜೂ"),tsc(L"ಜು"),tsc(L"ಆ"),tsc(L"ಸೆ"),tsc(L"ಅ"),tsc(L"ನ"),tsc(L"ಡಿ")},.mon={tsc(L"ಜನವರಿ"),tsc(L"ಫೆಬ್ರುವರಿ"),tsc(L"ಮಾರ್ಚ್"),tsc(L"ಏಪ್ರಿಲ್‌‌"),tsc(L"ಮೇ"),tsc(L"ಜೂನ್"),tsc(L"ಜುಲೈ"),tsc(L"ಆಗಸ್ಟ್"),tsc(L"ಸೆಪ್ಟೆಂಬರ್‌"),tsc(L"ಅಕ್ಟೋಬರ್"),tsc(L"ನವೆಂಬರ್"),tsc(L"ಡಿಸೆಂಬರ್")},.d_t_fmt=tsc(L"%A %d %b %Y %I:%M:%S %p"),.d_fmt=tsc(L"%-d//%-m//%y"),.t_fmt=tsc(L"%I:%M:%S %p %Z"),.t_fmt_ampm=tsc(L"%I:%M:%S %p %Z"),.date_fmt=tsc(L"%A %d %b %Y %I:%M:%S %p %Z"),.am_pm={tsc(L"ಕಾಂಡೆ"),tsc(L"ಬಯ್ಯ")},.week={7,19971130,1}},.messages={.yesexpr=tsc(L"^[+1yY]"),.noexpr=tsc(L"^[-0nN]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(L"+%c ;%a ;%l"),.int_select=tsc(L"00"),.int_prefix=tsc(L"91")},.name={.name_fmt=tsc(L"%p%t%f%t%g"),.name_gen=tsc(L""),.name_miss=tsc(L"ಕುಮಾರಿ"),.name_mr=tsc(L"ಶ್ರೀ"),.name_mrs=tsc(L"ಶ್ರೀಮತಿ"),.name_ms=tsc(L"ಕುಮಾರ")},.address={.postal_fmt=tsc(L"%z%c%T%s%b%e%r"),.country_name=tsc(L"ಭಾರತ"),.country_ab2=tsc(L"IN"),.country_ab3=tsc(L"IND"),.country_num=356,.country_car=tsc(L"IND"),.lang_name=tsc(L"ತುಳು"),.lang_ab=tsc(L""),.lang_term=tsc(L"tcy"),.lang_lib=tsc(L"tcy")},.measurement={.measurement=1}};

inline constexpr u8lc_all u8lc_all_global{.identification={.name=tsc(u8"tcy_IN"),.encoding=tsc(FAST_IO_LOCALE_u8ENCODING),.title=tsc(u8"Tulu language locale for India"),.source=tsc(u8"IndLinux.org, Samsung Electronics Co., Ltd.\t\t;\t\tfast_io"),.address=tsc(u8"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u8"fast_io"),.email=tsc(u8"alexey.merzlyakov@samsung.com;euloanty@live.com"),.tel=tsc(u8""),.fax=tsc(u8""),.language=tsc(u8"Tulu"),.territory=tsc(u8"India"),.revision=tsc(u8"0.1"),.date=tsc(u8"2014-09-30")},.monetary={.int_curr_symbol=tsc(u8"INR "),.currency_symbol=tsc(u8"₹"),.mon_decimal_point=tsc(u8"."),.mon_thousands_sep=tsc(u8","),.mon_grouping={monetary_mon_grouping_storage,2},.positive_sign=tsc(u8""),.negative_sign=tsc(u8"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(u8"."),.thousands_sep=tsc(u8","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u8"ಐ"),tsc(u8"ಸೋ"),tsc(u8"ಅಂ"),tsc(u8"ಬು"),tsc(u8"ಗು"),tsc(u8"ಶು"),tsc(u8"ಶ")},.day={tsc(u8"ಐಥಾರ"),tsc(u8"ಸೋಮಾರ"),tsc(u8"ಅಂಗರೆ"),tsc(u8"ಬುಧಾರ"),tsc(u8"ಗುರುವಾರ"),tsc(u8"ಶುಕ್ರರ"),tsc(u8"ಶನಿವಾರ")},.abmon={tsc(u8"ಜ"),tsc(u8"ಫೆ"),tsc(u8"ಮಾ"),tsc(u8"ಏ"),tsc(u8"ಮೇ"),tsc(u8"ಜೂ"),tsc(u8"ಜು"),tsc(u8"ಆ"),tsc(u8"ಸೆ"),tsc(u8"ಅ"),tsc(u8"ನ"),tsc(u8"ಡಿ")},.mon={tsc(u8"ಜನವರಿ"),tsc(u8"ಫೆಬ್ರುವರಿ"),tsc(u8"ಮಾರ್ಚ್"),tsc(u8"ಏಪ್ರಿಲ್‌‌"),tsc(u8"ಮೇ"),tsc(u8"ಜೂನ್"),tsc(u8"ಜುಲೈ"),tsc(u8"ಆಗಸ್ಟ್"),tsc(u8"ಸೆಪ್ಟೆಂಬರ್‌"),tsc(u8"ಅಕ್ಟೋಬರ್"),tsc(u8"ನವೆಂಬರ್"),tsc(u8"ಡಿಸೆಂಬರ್")},.d_t_fmt=tsc(u8"%A %d %b %Y %I:%M:%S %p"),.d_fmt=tsc(u8"%-d//%-m//%y"),.t_fmt=tsc(u8"%I:%M:%S %p %Z"),.t_fmt_ampm=tsc(u8"%I:%M:%S %p %Z"),.date_fmt=tsc(u8"%A %d %b %Y %I:%M:%S %p %Z"),.am_pm={tsc(u8"ಕಾಂಡೆ"),tsc(u8"ಬಯ್ಯ")},.week={7,19971130,1}},.messages={.yesexpr=tsc(u8"^[+1yY]"),.noexpr=tsc(u8"^[-0nN]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u8"+%c ;%a ;%l"),.int_select=tsc(u8"00"),.int_prefix=tsc(u8"91")},.name={.name_fmt=tsc(u8"%p%t%f%t%g"),.name_gen=tsc(u8""),.name_miss=tsc(u8"ಕುಮಾರಿ"),.name_mr=tsc(u8"ಶ್ರೀ"),.name_mrs=tsc(u8"ಶ್ರೀಮತಿ"),.name_ms=tsc(u8"ಕುಮಾರ")},.address={.postal_fmt=tsc(u8"%z%c%T%s%b%e%r"),.country_name=tsc(u8"ಭಾರತ"),.country_ab2=tsc(u8"IN"),.country_ab3=tsc(u8"IND"),.country_num=356,.country_car=tsc(u8"IND"),.lang_name=tsc(u8"ತುಳು"),.lang_ab=tsc(u8""),.lang_term=tsc(u8"tcy"),.lang_lib=tsc(u8"tcy")},.measurement={.measurement=1}};

inline constexpr u16lc_all u16lc_all_global{.identification={.name=tsc(u"tcy_IN"),.encoding=tsc(FAST_IO_LOCALE_uENCODING),.title=tsc(u"Tulu language locale for India"),.source=tsc(u"IndLinux.org, Samsung Electronics Co., Ltd.\t\t;\t\tfast_io"),.address=tsc(u"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u"fast_io"),.email=tsc(u"alexey.merzlyakov@samsung.com;euloanty@live.com"),.tel=tsc(u""),.fax=tsc(u""),.language=tsc(u"Tulu"),.territory=tsc(u"India"),.revision=tsc(u"0.1"),.date=tsc(u"2014-09-30")},.monetary={.int_curr_symbol=tsc(u"INR "),.currency_symbol=tsc(u"₹"),.mon_decimal_point=tsc(u"."),.mon_thousands_sep=tsc(u","),.mon_grouping={monetary_mon_grouping_storage,2},.positive_sign=tsc(u""),.negative_sign=tsc(u"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(u"."),.thousands_sep=tsc(u","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u"ಐ"),tsc(u"ಸೋ"),tsc(u"ಅಂ"),tsc(u"ಬು"),tsc(u"ಗು"),tsc(u"ಶು"),tsc(u"ಶ")},.day={tsc(u"ಐಥಾರ"),tsc(u"ಸೋಮಾರ"),tsc(u"ಅಂಗರೆ"),tsc(u"ಬುಧಾರ"),tsc(u"ಗುರುವಾರ"),tsc(u"ಶುಕ್ರರ"),tsc(u"ಶನಿವಾರ")},.abmon={tsc(u"ಜ"),tsc(u"ಫೆ"),tsc(u"ಮಾ"),tsc(u"ಏ"),tsc(u"ಮೇ"),tsc(u"ಜೂ"),tsc(u"ಜು"),tsc(u"ಆ"),tsc(u"ಸೆ"),tsc(u"ಅ"),tsc(u"ನ"),tsc(u"ಡಿ")},.mon={tsc(u"ಜನವರಿ"),tsc(u"ಫೆಬ್ರುವರಿ"),tsc(u"ಮಾರ್ಚ್"),tsc(u"ಏಪ್ರಿಲ್‌‌"),tsc(u"ಮೇ"),tsc(u"ಜೂನ್"),tsc(u"ಜುಲೈ"),tsc(u"ಆಗಸ್ಟ್"),tsc(u"ಸೆಪ್ಟೆಂಬರ್‌"),tsc(u"ಅಕ್ಟೋಬರ್"),tsc(u"ನವೆಂಬರ್"),tsc(u"ಡಿಸೆಂಬರ್")},.d_t_fmt=tsc(u"%A %d %b %Y %I:%M:%S %p"),.d_fmt=tsc(u"%-d//%-m//%y"),.t_fmt=tsc(u"%I:%M:%S %p %Z"),.t_fmt_ampm=tsc(u"%I:%M:%S %p %Z"),.date_fmt=tsc(u"%A %d %b %Y %I:%M:%S %p %Z"),.am_pm={tsc(u"ಕಾಂಡೆ"),tsc(u"ಬಯ್ಯ")},.week={7,19971130,1}},.messages={.yesexpr=tsc(u"^[+1yY]"),.noexpr=tsc(u"^[-0nN]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u"+%c ;%a ;%l"),.int_select=tsc(u"00"),.int_prefix=tsc(u"91")},.name={.name_fmt=tsc(u"%p%t%f%t%g"),.name_gen=tsc(u""),.name_miss=tsc(u"ಕುಮಾರಿ"),.name_mr=tsc(u"ಶ್ರೀ"),.name_mrs=tsc(u"ಶ್ರೀಮತಿ"),.name_ms=tsc(u"ಕುಮಾರ")},.address={.postal_fmt=tsc(u"%z%c%T%s%b%e%r"),.country_name=tsc(u"ಭಾರತ"),.country_ab2=tsc(u"IN"),.country_ab3=tsc(u"IND"),.country_num=356,.country_car=tsc(u"IND"),.lang_name=tsc(u"ತುಳು"),.lang_ab=tsc(u""),.lang_term=tsc(u"tcy"),.lang_lib=tsc(u"tcy")},.measurement={.measurement=1}};

inline constexpr u32lc_all u32lc_all_global{.identification={.name=tsc(U"tcy_IN"),.encoding=tsc(FAST_IO_LOCALE_UENCODING),.title=tsc(U"Tulu language locale for India"),.source=tsc(U"IndLinux.org, Samsung Electronics Co., Ltd.\t\t;\t\tfast_io"),.address=tsc(U"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(U"fast_io"),.email=tsc(U"alexey.merzlyakov@samsung.com;euloanty@live.com"),.tel=tsc(U""),.fax=tsc(U""),.language=tsc(U"Tulu"),.territory=tsc(U"India"),.revision=tsc(U"0.1"),.date=tsc(U"2014-09-30")},.monetary={.int_curr_symbol=tsc(U"INR "),.currency_symbol=tsc(U"₹"),.mon_decimal_point=tsc(U"."),.mon_thousands_sep=tsc(U","),.mon_grouping={monetary_mon_grouping_storage,2},.positive_sign=tsc(U""),.negative_sign=tsc(U"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(U"."),.thousands_sep=tsc(U","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(U"ಐ"),tsc(U"ಸೋ"),tsc(U"ಅಂ"),tsc(U"ಬು"),tsc(U"ಗು"),tsc(U"ಶು"),tsc(U"ಶ")},.day={tsc(U"ಐಥಾರ"),tsc(U"ಸೋಮಾರ"),tsc(U"ಅಂಗರೆ"),tsc(U"ಬುಧಾರ"),tsc(U"ಗುರುವಾರ"),tsc(U"ಶುಕ್ರರ"),tsc(U"ಶನಿವಾರ")},.abmon={tsc(U"ಜ"),tsc(U"ಫೆ"),tsc(U"ಮಾ"),tsc(U"ಏ"),tsc(U"ಮೇ"),tsc(U"ಜೂ"),tsc(U"ಜು"),tsc(U"ಆ"),tsc(U"ಸೆ"),tsc(U"ಅ"),tsc(U"ನ"),tsc(U"ಡಿ")},.mon={tsc(U"ಜನವರಿ"),tsc(U"ಫೆಬ್ರುವರಿ"),tsc(U"ಮಾರ್ಚ್"),tsc(U"ಏಪ್ರಿಲ್‌‌"),tsc(U"ಮೇ"),tsc(U"ಜೂನ್"),tsc(U"ಜುಲೈ"),tsc(U"ಆಗಸ್ಟ್"),tsc(U"ಸೆಪ್ಟೆಂಬರ್‌"),tsc(U"ಅಕ್ಟೋಬರ್"),tsc(U"ನವೆಂಬರ್"),tsc(U"ಡಿಸೆಂಬರ್")},.d_t_fmt=tsc(U"%A %d %b %Y %I:%M:%S %p"),.d_fmt=tsc(U"%-d//%-m//%y"),.t_fmt=tsc(U"%I:%M:%S %p %Z"),.t_fmt_ampm=tsc(U"%I:%M:%S %p %Z"),.date_fmt=tsc(U"%A %d %b %Y %I:%M:%S %p %Z"),.am_pm={tsc(U"ಕಾಂಡೆ"),tsc(U"ಬಯ್ಯ")},.week={7,19971130,1}},.messages={.yesexpr=tsc(U"^[+1yY]"),.noexpr=tsc(U"^[-0nN]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(U"+%c ;%a ;%l"),.int_select=tsc(U"00"),.int_prefix=tsc(U"91")},.name={.name_fmt=tsc(U"%p%t%f%t%g"),.name_gen=tsc(U""),.name_miss=tsc(U"ಕುಮಾರಿ"),.name_mr=tsc(U"ಶ್ರೀ"),.name_mrs=tsc(U"ಶ್ರೀಮತಿ"),.name_ms=tsc(U"ಕುಮಾರ")},.address={.postal_fmt=tsc(U"%z%c%T%s%b%e%r"),.country_name=tsc(U"ಭಾರತ"),.country_ab2=tsc(U"IN"),.country_ab3=tsc(U"IND"),.country_num=356,.country_car=tsc(U"IND"),.lang_name=tsc(U"ತುಳು"),.lang_ab=tsc(U""),.lang_term=tsc(U"tcy"),.lang_lib=tsc(U"tcy")},.measurement={.measurement=1}};


}
}

#include"../main.h"