﻿#include"../localedef.h"

namespace fast_io_i18n
{
namespace
{

inline constexpr std::size_t numeric_grouping_storage[]{3};

inline constexpr basic_io_scatter_t<char> time_alt_digits_storage[]{tsc("႐႐"),tsc("႐႑"),tsc("႐႒"),tsc("႐႓"),tsc("႐႔"),tsc("႐႕"),tsc("႐႖"),tsc("႐႗"),tsc("႐႘"),tsc("႐႙"),tsc("႑႐"),tsc("႑႑"),tsc("႑႒"),tsc("႑႓"),tsc("႑႔"),tsc("႑႕"),tsc("႑႖"),tsc("႑႗"),tsc("႑႘"),tsc("႑႙"),tsc("႒႐"),tsc("႒႑"),tsc("႒႒"),tsc("႒႓"),tsc("႒႔"),tsc("႒႕"),tsc("႒႖"),tsc("႒႗"),tsc("႒႘"),tsc("႒႙"),tsc("႓႐"),tsc("႓႑"),tsc("႓႒"),tsc("႓႓"),tsc("႓႔"),tsc("႓႕"),tsc("႓႖"),tsc("႓႗"),tsc("႓႘"),tsc("႓႙"),tsc("႔႐"),tsc("႔႑"),tsc("႔႒"),tsc("႔႓"),tsc("႔႔"),tsc("႔႕"),tsc("႔႖"),tsc("႔႗"),tsc("႔႘"),tsc("႔႙"),tsc("႕႐"),tsc("႕႑"),tsc("႕႒"),tsc("႕႓"),tsc("႕႔"),tsc("႕႕"),tsc("႕႖"),tsc("႕႗"),tsc("႕႘"),tsc("႕႙"),tsc("႖႐"),tsc("႖႑"),tsc("႖႒"),tsc("႖႓"),tsc("႖႔"),tsc("႖႕"),tsc("႖႖"),tsc("႖႗"),tsc("႖႘"),tsc("႖႙"),tsc("႗႐"),tsc("႗႑"),tsc("႗႒"),tsc("႗႓"),tsc("႗႔"),tsc("႗႕"),tsc("႗႖"),tsc("႗႗"),tsc("႗႘"),tsc("႗႙"),tsc("႘႐"),tsc("႘႑"),tsc("႘႒"),tsc("႘႓"),tsc("႘႔"),tsc("႘႕"),tsc("႘႖"),tsc("႘႗"),tsc("႘႘"),tsc("႘႙"),tsc("႙႐"),tsc("႙႑"),tsc("႙႒"),tsc("႙႓"),tsc("႙႔"),tsc("႙႕"),tsc("႙႖"),tsc("႙႗"),tsc("႙႘"),tsc("႙႙")};

inline constexpr lc_all lc_all_global{.identification={.name=tsc("shn_MM"),.encoding=tsc(FAST_IO_LOCALE_ENCODING),.title=tsc("Shan language locale for Myanmar"),.source=tsc("ubuntu Myanmar LoCo Team http://www.ubuntu-mm.net\t\t;\t\tfast_io"),.address=tsc("Yangon, Myanmar\t\t;\t\thttps://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc("Bone Pyae Sone\t\t;\t\tfast_io"),.email=tsc("bone.burma@mail.com;euloanty@live.com"),.tel=tsc(""),.fax=tsc(""),.language=tsc("Shan"),.territory=tsc("Myanmar"),.revision=tsc("1.3"),.date=tsc("2012-07-01")},.monetary={.int_curr_symbol=tsc("MMK "),.currency_symbol=tsc("Ks"),.mon_decimal_point=tsc("."),.mon_thousands_sep=tsc(","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(""),.negative_sign=tsc("-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=0,.p_sep_by_space=0,.n_cs_precedes=0,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc("."),.thousands_sep=tsc(","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc("တိတ်ႉ"),tsc("ၸၼ်"),tsc("ၵၢၼ်း"),tsc("ပုတ်ႉ"),tsc("ၽတ်း"),tsc("သုၵ်း"),tsc("သဝ်")},.day={tsc("ဝၼ်းဢႃးတိတ်ႉ"),tsc("ဝၼ်းၸၼ်"),tsc("ဝၼ်းဢၢင်းၵၢၼ်း"),tsc("ဝၼ်းပုတ်ႉ"),tsc("ဝၼ်းၽတ်း"),tsc("ဝၼ်းသုၵ်း"),tsc("ဝၼ်းသဝ်")},.abmon={tsc("လိူၼ်ၵမ်"),tsc("လိူၼ်သၢမ်"),tsc("လိူၼ်သီႇ"),tsc("လိူၼ်ႁႃႈ"),tsc("လိူၼ်ႁူၵ်း"),tsc("လိူၼ်ၸဵတ်း"),tsc("လိူၼ်ပႅတ်ႇ"),tsc("လိူၼ်ၵဝ်ႈ"),tsc("လိူၼ်သိပ်း"),tsc("လိူၼ်သိပ်းဢဵတ်း"),tsc("လိူၼ်သိပ်းသွင်"),tsc("လိူၼ်ၸဵင်")},.mon={tsc("လိူၼ်ၵမ်"),tsc("လိူၼ်သၢမ်"),tsc("လိူၼ်သီႇ"),tsc("လိူၼ်ႁႃႈ"),tsc("လိူၼ်ႁူၵ်း"),tsc("လိူၼ်ၸဵတ်း"),tsc("လိူၼ်ပႅတ်ႇ"),tsc("လိူၼ်ၵဝ်ႈ"),tsc("လိူၼ်သိပ်း"),tsc("လိူၼ်သိပ်းဢဵတ်း"),tsc("လိူၼ်သိပ်းသွင်"),tsc("လိူၼ်ၸဵင်")},.d_t_fmt=tsc("%OC%Oy %b %Od %A %OI:%OM:%OS %Op %Z"),.d_fmt=tsc("%OC%Oy %b %Od %A"),.t_fmt=tsc("%OH:%OM:%OS %p"),.t_fmt_ampm=tsc("%OI:%OM:%OS %p"),.am_pm={tsc("ပွတ်းၼႂ်"),tsc("ဝၢႆးဝၼ်း")},.alt_digits={time_alt_digits_storage,100}},.messages={.yesexpr=tsc("^[+1yYမ]"),.noexpr=tsc("^[-0nNဢ]"),.yesstr=tsc("မႅၼ်ႈ"),.nostr=tsc("ဢမ်ႇမႅၼ်ႈ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc("+%c %a %l"),.tel_dom_fmt=tsc("%a %l"),.int_select=tsc("0"),.int_prefix=tsc("95")},.name={.name_fmt=tsc("%p%t%g%t%m%t%f"),.name_gen=tsc("")},.address={.postal_fmt=tsc("%a%N%d%N%f%N%b%N%h%t%r%t%e%t%s%N%T%t%z%N%c%N"),.country_name=tsc("မၢၼ်ႈ"),.country_post=tsc("Myanmar"),.country_ab2=tsc("MM"),.country_num=104,.country_car=tsc("MYA"),.lang_name=tsc("လိၵ်ႈတႆး"),.lang_term=tsc("shn"),.lang_lib=tsc("shn")},.measurement={.measurement=1}};

inline constexpr basic_io_scatter_t<wchar_t> wtime_alt_digits_storage[]{tsc(L"႐႐"),tsc(L"႐႑"),tsc(L"႐႒"),tsc(L"႐႓"),tsc(L"႐႔"),tsc(L"႐႕"),tsc(L"႐႖"),tsc(L"႐႗"),tsc(L"႐႘"),tsc(L"႐႙"),tsc(L"႑႐"),tsc(L"႑႑"),tsc(L"႑႒"),tsc(L"႑႓"),tsc(L"႑႔"),tsc(L"႑႕"),tsc(L"႑႖"),tsc(L"႑႗"),tsc(L"႑႘"),tsc(L"႑႙"),tsc(L"႒႐"),tsc(L"႒႑"),tsc(L"႒႒"),tsc(L"႒႓"),tsc(L"႒႔"),tsc(L"႒႕"),tsc(L"႒႖"),tsc(L"႒႗"),tsc(L"႒႘"),tsc(L"႒႙"),tsc(L"႓႐"),tsc(L"႓႑"),tsc(L"႓႒"),tsc(L"႓႓"),tsc(L"႓႔"),tsc(L"႓႕"),tsc(L"႓႖"),tsc(L"႓႗"),tsc(L"႓႘"),tsc(L"႓႙"),tsc(L"႔႐"),tsc(L"႔႑"),tsc(L"႔႒"),tsc(L"႔႓"),tsc(L"႔႔"),tsc(L"႔႕"),tsc(L"႔႖"),tsc(L"႔႗"),tsc(L"႔႘"),tsc(L"႔႙"),tsc(L"႕႐"),tsc(L"႕႑"),tsc(L"႕႒"),tsc(L"႕႓"),tsc(L"႕႔"),tsc(L"႕႕"),tsc(L"႕႖"),tsc(L"႕႗"),tsc(L"႕႘"),tsc(L"႕႙"),tsc(L"႖႐"),tsc(L"႖႑"),tsc(L"႖႒"),tsc(L"႖႓"),tsc(L"႖႔"),tsc(L"႖႕"),tsc(L"႖႖"),tsc(L"႖႗"),tsc(L"႖႘"),tsc(L"႖႙"),tsc(L"႗႐"),tsc(L"႗႑"),tsc(L"႗႒"),tsc(L"႗႓"),tsc(L"႗႔"),tsc(L"႗႕"),tsc(L"႗႖"),tsc(L"႗႗"),tsc(L"႗႘"),tsc(L"႗႙"),tsc(L"႘႐"),tsc(L"႘႑"),tsc(L"႘႒"),tsc(L"႘႓"),tsc(L"႘႔"),tsc(L"႘႕"),tsc(L"႘႖"),tsc(L"႘႗"),tsc(L"႘႘"),tsc(L"႘႙"),tsc(L"႙႐"),tsc(L"႙႑"),tsc(L"႙႒"),tsc(L"႙႓"),tsc(L"႙႔"),tsc(L"႙႕"),tsc(L"႙႖"),tsc(L"႙႗"),tsc(L"႙႘"),tsc(L"႙႙")};

inline constexpr wlc_all wlc_all_global{.identification={.name=tsc(L"shn_MM"),.encoding=tsc(FAST_IO_LOCALE_LENCODING),.title=tsc(L"Shan language locale for Myanmar"),.source=tsc(L"ubuntu Myanmar LoCo Team http://www.ubuntu-mm.net\t\t;\t\tfast_io"),.address=tsc(L"Yangon, Myanmar\t\t;\t\thttps://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(L"Bone Pyae Sone\t\t;\t\tfast_io"),.email=tsc(L"bone.burma@mail.com;euloanty@live.com"),.tel=tsc(L""),.fax=tsc(L""),.language=tsc(L"Shan"),.territory=tsc(L"Myanmar"),.revision=tsc(L"1.3"),.date=tsc(L"2012-07-01")},.monetary={.int_curr_symbol=tsc(L"MMK "),.currency_symbol=tsc(L"Ks"),.mon_decimal_point=tsc(L"."),.mon_thousands_sep=tsc(L","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(L""),.negative_sign=tsc(L"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=0,.p_sep_by_space=0,.n_cs_precedes=0,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(L"."),.thousands_sep=tsc(L","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(L"တိတ်ႉ"),tsc(L"ၸၼ်"),tsc(L"ၵၢၼ်း"),tsc(L"ပုတ်ႉ"),tsc(L"ၽတ်း"),tsc(L"သုၵ်း"),tsc(L"သဝ်")},.day={tsc(L"ဝၼ်းဢႃးတိတ်ႉ"),tsc(L"ဝၼ်းၸၼ်"),tsc(L"ဝၼ်းဢၢင်းၵၢၼ်း"),tsc(L"ဝၼ်းပုတ်ႉ"),tsc(L"ဝၼ်းၽတ်း"),tsc(L"ဝၼ်းသုၵ်း"),tsc(L"ဝၼ်းသဝ်")},.abmon={tsc(L"လိူၼ်ၵမ်"),tsc(L"လိူၼ်သၢမ်"),tsc(L"လိူၼ်သီႇ"),tsc(L"လိူၼ်ႁႃႈ"),tsc(L"လိူၼ်ႁူၵ်း"),tsc(L"လိူၼ်ၸဵတ်း"),tsc(L"လိူၼ်ပႅတ်ႇ"),tsc(L"လိူၼ်ၵဝ်ႈ"),tsc(L"လိူၼ်သိပ်း"),tsc(L"လိူၼ်သိပ်းဢဵတ်း"),tsc(L"လိူၼ်သိပ်းသွင်"),tsc(L"လိူၼ်ၸဵင်")},.mon={tsc(L"လိူၼ်ၵမ်"),tsc(L"လိူၼ်သၢမ်"),tsc(L"လိူၼ်သီႇ"),tsc(L"လိူၼ်ႁႃႈ"),tsc(L"လိူၼ်ႁူၵ်း"),tsc(L"လိူၼ်ၸဵတ်း"),tsc(L"လိူၼ်ပႅတ်ႇ"),tsc(L"လိူၼ်ၵဝ်ႈ"),tsc(L"လိူၼ်သိပ်း"),tsc(L"လိူၼ်သိပ်းဢဵတ်း"),tsc(L"လိူၼ်သိပ်းသွင်"),tsc(L"လိူၼ်ၸဵင်")},.d_t_fmt=tsc(L"%OC%Oy %b %Od %A %OI:%OM:%OS %Op %Z"),.d_fmt=tsc(L"%OC%Oy %b %Od %A"),.t_fmt=tsc(L"%OH:%OM:%OS %p"),.t_fmt_ampm=tsc(L"%OI:%OM:%OS %p"),.am_pm={tsc(L"ပွတ်းၼႂ်"),tsc(L"ဝၢႆးဝၼ်း")},.alt_digits={wtime_alt_digits_storage,100}},.messages={.yesexpr=tsc(L"^[+1yYမ]"),.noexpr=tsc(L"^[-0nNဢ]"),.yesstr=tsc(L"မႅၼ်ႈ"),.nostr=tsc(L"ဢမ်ႇမႅၼ်ႈ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(L"+%c %a %l"),.tel_dom_fmt=tsc(L"%a %l"),.int_select=tsc(L"0"),.int_prefix=tsc(L"95")},.name={.name_fmt=tsc(L"%p%t%g%t%m%t%f"),.name_gen=tsc(L"")},.address={.postal_fmt=tsc(L"%a%N%d%N%f%N%b%N%h%t%r%t%e%t%s%N%T%t%z%N%c%N"),.country_name=tsc(L"မၢၼ်ႈ"),.country_post=tsc(L"Myanmar"),.country_ab2=tsc(L"MM"),.country_num=104,.country_car=tsc(L"MYA"),.lang_name=tsc(L"လိၵ်ႈတႆး"),.lang_term=tsc(L"shn"),.lang_lib=tsc(L"shn")},.measurement={.measurement=1}};

inline constexpr basic_io_scatter_t<char8_t> u8time_alt_digits_storage[]{tsc(u8"႐႐"),tsc(u8"႐႑"),tsc(u8"႐႒"),tsc(u8"႐႓"),tsc(u8"႐႔"),tsc(u8"႐႕"),tsc(u8"႐႖"),tsc(u8"႐႗"),tsc(u8"႐႘"),tsc(u8"႐႙"),tsc(u8"႑႐"),tsc(u8"႑႑"),tsc(u8"႑႒"),tsc(u8"႑႓"),tsc(u8"႑႔"),tsc(u8"႑႕"),tsc(u8"႑႖"),tsc(u8"႑႗"),tsc(u8"႑႘"),tsc(u8"႑႙"),tsc(u8"႒႐"),tsc(u8"႒႑"),tsc(u8"႒႒"),tsc(u8"႒႓"),tsc(u8"႒႔"),tsc(u8"႒႕"),tsc(u8"႒႖"),tsc(u8"႒႗"),tsc(u8"႒႘"),tsc(u8"႒႙"),tsc(u8"႓႐"),tsc(u8"႓႑"),tsc(u8"႓႒"),tsc(u8"႓႓"),tsc(u8"႓႔"),tsc(u8"႓႕"),tsc(u8"႓႖"),tsc(u8"႓႗"),tsc(u8"႓႘"),tsc(u8"႓႙"),tsc(u8"႔႐"),tsc(u8"႔႑"),tsc(u8"႔႒"),tsc(u8"႔႓"),tsc(u8"႔႔"),tsc(u8"႔႕"),tsc(u8"႔႖"),tsc(u8"႔႗"),tsc(u8"႔႘"),tsc(u8"႔႙"),tsc(u8"႕႐"),tsc(u8"႕႑"),tsc(u8"႕႒"),tsc(u8"႕႓"),tsc(u8"႕႔"),tsc(u8"႕႕"),tsc(u8"႕႖"),tsc(u8"႕႗"),tsc(u8"႕႘"),tsc(u8"႕႙"),tsc(u8"႖႐"),tsc(u8"႖႑"),tsc(u8"႖႒"),tsc(u8"႖႓"),tsc(u8"႖႔"),tsc(u8"႖႕"),tsc(u8"႖႖"),tsc(u8"႖႗"),tsc(u8"႖႘"),tsc(u8"႖႙"),tsc(u8"႗႐"),tsc(u8"႗႑"),tsc(u8"႗႒"),tsc(u8"႗႓"),tsc(u8"႗႔"),tsc(u8"႗႕"),tsc(u8"႗႖"),tsc(u8"႗႗"),tsc(u8"႗႘"),tsc(u8"႗႙"),tsc(u8"႘႐"),tsc(u8"႘႑"),tsc(u8"႘႒"),tsc(u8"႘႓"),tsc(u8"႘႔"),tsc(u8"႘႕"),tsc(u8"႘႖"),tsc(u8"႘႗"),tsc(u8"႘႘"),tsc(u8"႘႙"),tsc(u8"႙႐"),tsc(u8"႙႑"),tsc(u8"႙႒"),tsc(u8"႙႓"),tsc(u8"႙႔"),tsc(u8"႙႕"),tsc(u8"႙႖"),tsc(u8"႙႗"),tsc(u8"႙႘"),tsc(u8"႙႙")};

inline constexpr u8lc_all u8lc_all_global{.identification={.name=tsc(u8"shn_MM"),.encoding=tsc(FAST_IO_LOCALE_u8ENCODING),.title=tsc(u8"Shan language locale for Myanmar"),.source=tsc(u8"ubuntu Myanmar LoCo Team http://www.ubuntu-mm.net\t\t;\t\tfast_io"),.address=tsc(u8"Yangon, Myanmar\t\t;\t\thttps://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u8"Bone Pyae Sone\t\t;\t\tfast_io"),.email=tsc(u8"bone.burma@mail.com;euloanty@live.com"),.tel=tsc(u8""),.fax=tsc(u8""),.language=tsc(u8"Shan"),.territory=tsc(u8"Myanmar"),.revision=tsc(u8"1.3"),.date=tsc(u8"2012-07-01")},.monetary={.int_curr_symbol=tsc(u8"MMK "),.currency_symbol=tsc(u8"Ks"),.mon_decimal_point=tsc(u8"."),.mon_thousands_sep=tsc(u8","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u8""),.negative_sign=tsc(u8"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=0,.p_sep_by_space=0,.n_cs_precedes=0,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(u8"."),.thousands_sep=tsc(u8","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u8"တိတ်ႉ"),tsc(u8"ၸၼ်"),tsc(u8"ၵၢၼ်း"),tsc(u8"ပုတ်ႉ"),tsc(u8"ၽတ်း"),tsc(u8"သုၵ်း"),tsc(u8"သဝ်")},.day={tsc(u8"ဝၼ်းဢႃးတိတ်ႉ"),tsc(u8"ဝၼ်းၸၼ်"),tsc(u8"ဝၼ်းဢၢင်းၵၢၼ်း"),tsc(u8"ဝၼ်းပုတ်ႉ"),tsc(u8"ဝၼ်းၽတ်း"),tsc(u8"ဝၼ်းသုၵ်း"),tsc(u8"ဝၼ်းသဝ်")},.abmon={tsc(u8"လိူၼ်ၵမ်"),tsc(u8"လိူၼ်သၢမ်"),tsc(u8"လိူၼ်သီႇ"),tsc(u8"လိူၼ်ႁႃႈ"),tsc(u8"လိူၼ်ႁူၵ်း"),tsc(u8"လိူၼ်ၸဵတ်း"),tsc(u8"လိူၼ်ပႅတ်ႇ"),tsc(u8"လိူၼ်ၵဝ်ႈ"),tsc(u8"လိူၼ်သိပ်း"),tsc(u8"လိူၼ်သိပ်းဢဵတ်း"),tsc(u8"လိူၼ်သိပ်းသွင်"),tsc(u8"လိူၼ်ၸဵင်")},.mon={tsc(u8"လိူၼ်ၵမ်"),tsc(u8"လိူၼ်သၢမ်"),tsc(u8"လိူၼ်သီႇ"),tsc(u8"လိူၼ်ႁႃႈ"),tsc(u8"လိူၼ်ႁူၵ်း"),tsc(u8"လိူၼ်ၸဵတ်း"),tsc(u8"လိူၼ်ပႅတ်ႇ"),tsc(u8"လိူၼ်ၵဝ်ႈ"),tsc(u8"လိူၼ်သိပ်း"),tsc(u8"လိူၼ်သိပ်းဢဵတ်း"),tsc(u8"လိူၼ်သိပ်းသွင်"),tsc(u8"လိူၼ်ၸဵင်")},.d_t_fmt=tsc(u8"%OC%Oy %b %Od %A %OI:%OM:%OS %Op %Z"),.d_fmt=tsc(u8"%OC%Oy %b %Od %A"),.t_fmt=tsc(u8"%OH:%OM:%OS %p"),.t_fmt_ampm=tsc(u8"%OI:%OM:%OS %p"),.am_pm={tsc(u8"ပွတ်းၼႂ်"),tsc(u8"ဝၢႆးဝၼ်း")},.alt_digits={u8time_alt_digits_storage,100}},.messages={.yesexpr=tsc(u8"^[+1yYမ]"),.noexpr=tsc(u8"^[-0nNဢ]"),.yesstr=tsc(u8"မႅၼ်ႈ"),.nostr=tsc(u8"ဢမ်ႇမႅၼ်ႈ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u8"+%c %a %l"),.tel_dom_fmt=tsc(u8"%a %l"),.int_select=tsc(u8"0"),.int_prefix=tsc(u8"95")},.name={.name_fmt=tsc(u8"%p%t%g%t%m%t%f"),.name_gen=tsc(u8"")},.address={.postal_fmt=tsc(u8"%a%N%d%N%f%N%b%N%h%t%r%t%e%t%s%N%T%t%z%N%c%N"),.country_name=tsc(u8"မၢၼ်ႈ"),.country_post=tsc(u8"Myanmar"),.country_ab2=tsc(u8"MM"),.country_num=104,.country_car=tsc(u8"MYA"),.lang_name=tsc(u8"လိၵ်ႈတႆး"),.lang_term=tsc(u8"shn"),.lang_lib=tsc(u8"shn")},.measurement={.measurement=1}};

inline constexpr basic_io_scatter_t<char16_t> u16time_alt_digits_storage[]{tsc(u"႐႐"),tsc(u"႐႑"),tsc(u"႐႒"),tsc(u"႐႓"),tsc(u"႐႔"),tsc(u"႐႕"),tsc(u"႐႖"),tsc(u"႐႗"),tsc(u"႐႘"),tsc(u"႐႙"),tsc(u"႑႐"),tsc(u"႑႑"),tsc(u"႑႒"),tsc(u"႑႓"),tsc(u"႑႔"),tsc(u"႑႕"),tsc(u"႑႖"),tsc(u"႑႗"),tsc(u"႑႘"),tsc(u"႑႙"),tsc(u"႒႐"),tsc(u"႒႑"),tsc(u"႒႒"),tsc(u"႒႓"),tsc(u"႒႔"),tsc(u"႒႕"),tsc(u"႒႖"),tsc(u"႒႗"),tsc(u"႒႘"),tsc(u"႒႙"),tsc(u"႓႐"),tsc(u"႓႑"),tsc(u"႓႒"),tsc(u"႓႓"),tsc(u"႓႔"),tsc(u"႓႕"),tsc(u"႓႖"),tsc(u"႓႗"),tsc(u"႓႘"),tsc(u"႓႙"),tsc(u"႔႐"),tsc(u"႔႑"),tsc(u"႔႒"),tsc(u"႔႓"),tsc(u"႔႔"),tsc(u"႔႕"),tsc(u"႔႖"),tsc(u"႔႗"),tsc(u"႔႘"),tsc(u"႔႙"),tsc(u"႕႐"),tsc(u"႕႑"),tsc(u"႕႒"),tsc(u"႕႓"),tsc(u"႕႔"),tsc(u"႕႕"),tsc(u"႕႖"),tsc(u"႕႗"),tsc(u"႕႘"),tsc(u"႕႙"),tsc(u"႖႐"),tsc(u"႖႑"),tsc(u"႖႒"),tsc(u"႖႓"),tsc(u"႖႔"),tsc(u"႖႕"),tsc(u"႖႖"),tsc(u"႖႗"),tsc(u"႖႘"),tsc(u"႖႙"),tsc(u"႗႐"),tsc(u"႗႑"),tsc(u"႗႒"),tsc(u"႗႓"),tsc(u"႗႔"),tsc(u"႗႕"),tsc(u"႗႖"),tsc(u"႗႗"),tsc(u"႗႘"),tsc(u"႗႙"),tsc(u"႘႐"),tsc(u"႘႑"),tsc(u"႘႒"),tsc(u"႘႓"),tsc(u"႘႔"),tsc(u"႘႕"),tsc(u"႘႖"),tsc(u"႘႗"),tsc(u"႘႘"),tsc(u"႘႙"),tsc(u"႙႐"),tsc(u"႙႑"),tsc(u"႙႒"),tsc(u"႙႓"),tsc(u"႙႔"),tsc(u"႙႕"),tsc(u"႙႖"),tsc(u"႙႗"),tsc(u"႙႘"),tsc(u"႙႙")};

inline constexpr u16lc_all u16lc_all_global{.identification={.name=tsc(u"shn_MM"),.encoding=tsc(FAST_IO_LOCALE_uENCODING),.title=tsc(u"Shan language locale for Myanmar"),.source=tsc(u"ubuntu Myanmar LoCo Team http://www.ubuntu-mm.net\t\t;\t\tfast_io"),.address=tsc(u"Yangon, Myanmar\t\t;\t\thttps://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u"Bone Pyae Sone\t\t;\t\tfast_io"),.email=tsc(u"bone.burma@mail.com;euloanty@live.com"),.tel=tsc(u""),.fax=tsc(u""),.language=tsc(u"Shan"),.territory=tsc(u"Myanmar"),.revision=tsc(u"1.3"),.date=tsc(u"2012-07-01")},.monetary={.int_curr_symbol=tsc(u"MMK "),.currency_symbol=tsc(u"Ks"),.mon_decimal_point=tsc(u"."),.mon_thousands_sep=tsc(u","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u""),.negative_sign=tsc(u"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=0,.p_sep_by_space=0,.n_cs_precedes=0,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(u"."),.thousands_sep=tsc(u","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u"တိတ်ႉ"),tsc(u"ၸၼ်"),tsc(u"ၵၢၼ်း"),tsc(u"ပုတ်ႉ"),tsc(u"ၽတ်း"),tsc(u"သုၵ်း"),tsc(u"သဝ်")},.day={tsc(u"ဝၼ်းဢႃးတိတ်ႉ"),tsc(u"ဝၼ်းၸၼ်"),tsc(u"ဝၼ်းဢၢင်းၵၢၼ်း"),tsc(u"ဝၼ်းပုတ်ႉ"),tsc(u"ဝၼ်းၽတ်း"),tsc(u"ဝၼ်းသုၵ်း"),tsc(u"ဝၼ်းသဝ်")},.abmon={tsc(u"လိူၼ်ၵမ်"),tsc(u"လိူၼ်သၢမ်"),tsc(u"လိူၼ်သီႇ"),tsc(u"လိူၼ်ႁႃႈ"),tsc(u"လိူၼ်ႁူၵ်း"),tsc(u"လိူၼ်ၸဵတ်း"),tsc(u"လိူၼ်ပႅတ်ႇ"),tsc(u"လိူၼ်ၵဝ်ႈ"),tsc(u"လိူၼ်သိပ်း"),tsc(u"လိူၼ်သိပ်းဢဵတ်း"),tsc(u"လိူၼ်သိပ်းသွင်"),tsc(u"လိူၼ်ၸဵင်")},.mon={tsc(u"လိူၼ်ၵမ်"),tsc(u"လိူၼ်သၢမ်"),tsc(u"လိူၼ်သီႇ"),tsc(u"လိူၼ်ႁႃႈ"),tsc(u"လိူၼ်ႁူၵ်း"),tsc(u"လိူၼ်ၸဵတ်း"),tsc(u"လိူၼ်ပႅတ်ႇ"),tsc(u"လိူၼ်ၵဝ်ႈ"),tsc(u"လိူၼ်သိပ်း"),tsc(u"လိူၼ်သိပ်းဢဵတ်း"),tsc(u"လိူၼ်သိပ်းသွင်"),tsc(u"လိူၼ်ၸဵင်")},.d_t_fmt=tsc(u"%OC%Oy %b %Od %A %OI:%OM:%OS %Op %Z"),.d_fmt=tsc(u"%OC%Oy %b %Od %A"),.t_fmt=tsc(u"%OH:%OM:%OS %p"),.t_fmt_ampm=tsc(u"%OI:%OM:%OS %p"),.am_pm={tsc(u"ပွတ်းၼႂ်"),tsc(u"ဝၢႆးဝၼ်း")},.alt_digits={u16time_alt_digits_storage,100}},.messages={.yesexpr=tsc(u"^[+1yYမ]"),.noexpr=tsc(u"^[-0nNဢ]"),.yesstr=tsc(u"မႅၼ်ႈ"),.nostr=tsc(u"ဢမ်ႇမႅၼ်ႈ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u"+%c %a %l"),.tel_dom_fmt=tsc(u"%a %l"),.int_select=tsc(u"0"),.int_prefix=tsc(u"95")},.name={.name_fmt=tsc(u"%p%t%g%t%m%t%f"),.name_gen=tsc(u"")},.address={.postal_fmt=tsc(u"%a%N%d%N%f%N%b%N%h%t%r%t%e%t%s%N%T%t%z%N%c%N"),.country_name=tsc(u"မၢၼ်ႈ"),.country_post=tsc(u"Myanmar"),.country_ab2=tsc(u"MM"),.country_num=104,.country_car=tsc(u"MYA"),.lang_name=tsc(u"လိၵ်ႈတႆး"),.lang_term=tsc(u"shn"),.lang_lib=tsc(u"shn")},.measurement={.measurement=1}};

inline constexpr basic_io_scatter_t<char32_t> u32time_alt_digits_storage[]{tsc(U"႐႐"),tsc(U"႐႑"),tsc(U"႐႒"),tsc(U"႐႓"),tsc(U"႐႔"),tsc(U"႐႕"),tsc(U"႐႖"),tsc(U"႐႗"),tsc(U"႐႘"),tsc(U"႐႙"),tsc(U"႑႐"),tsc(U"႑႑"),tsc(U"႑႒"),tsc(U"႑႓"),tsc(U"႑႔"),tsc(U"႑႕"),tsc(U"႑႖"),tsc(U"႑႗"),tsc(U"႑႘"),tsc(U"႑႙"),tsc(U"႒႐"),tsc(U"႒႑"),tsc(U"႒႒"),tsc(U"႒႓"),tsc(U"႒႔"),tsc(U"႒႕"),tsc(U"႒႖"),tsc(U"႒႗"),tsc(U"႒႘"),tsc(U"႒႙"),tsc(U"႓႐"),tsc(U"႓႑"),tsc(U"႓႒"),tsc(U"႓႓"),tsc(U"႓႔"),tsc(U"႓႕"),tsc(U"႓႖"),tsc(U"႓႗"),tsc(U"႓႘"),tsc(U"႓႙"),tsc(U"႔႐"),tsc(U"႔႑"),tsc(U"႔႒"),tsc(U"႔႓"),tsc(U"႔႔"),tsc(U"႔႕"),tsc(U"႔႖"),tsc(U"႔႗"),tsc(U"႔႘"),tsc(U"႔႙"),tsc(U"႕႐"),tsc(U"႕႑"),tsc(U"႕႒"),tsc(U"႕႓"),tsc(U"႕႔"),tsc(U"႕႕"),tsc(U"႕႖"),tsc(U"႕႗"),tsc(U"႕႘"),tsc(U"႕႙"),tsc(U"႖႐"),tsc(U"႖႑"),tsc(U"႖႒"),tsc(U"႖႓"),tsc(U"႖႔"),tsc(U"႖႕"),tsc(U"႖႖"),tsc(U"႖႗"),tsc(U"႖႘"),tsc(U"႖႙"),tsc(U"႗႐"),tsc(U"႗႑"),tsc(U"႗႒"),tsc(U"႗႓"),tsc(U"႗႔"),tsc(U"႗႕"),tsc(U"႗႖"),tsc(U"႗႗"),tsc(U"႗႘"),tsc(U"႗႙"),tsc(U"႘႐"),tsc(U"႘႑"),tsc(U"႘႒"),tsc(U"႘႓"),tsc(U"႘႔"),tsc(U"႘႕"),tsc(U"႘႖"),tsc(U"႘႗"),tsc(U"႘႘"),tsc(U"႘႙"),tsc(U"႙႐"),tsc(U"႙႑"),tsc(U"႙႒"),tsc(U"႙႓"),tsc(U"႙႔"),tsc(U"႙႕"),tsc(U"႙႖"),tsc(U"႙႗"),tsc(U"႙႘"),tsc(U"႙႙")};

inline constexpr u32lc_all u32lc_all_global{.identification={.name=tsc(U"shn_MM"),.encoding=tsc(FAST_IO_LOCALE_UENCODING),.title=tsc(U"Shan language locale for Myanmar"),.source=tsc(U"ubuntu Myanmar LoCo Team http://www.ubuntu-mm.net\t\t;\t\tfast_io"),.address=tsc(U"Yangon, Myanmar\t\t;\t\thttps://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(U"Bone Pyae Sone\t\t;\t\tfast_io"),.email=tsc(U"bone.burma@mail.com;euloanty@live.com"),.tel=tsc(U""),.fax=tsc(U""),.language=tsc(U"Shan"),.territory=tsc(U"Myanmar"),.revision=tsc(U"1.3"),.date=tsc(U"2012-07-01")},.monetary={.int_curr_symbol=tsc(U"MMK "),.currency_symbol=tsc(U"Ks"),.mon_decimal_point=tsc(U"."),.mon_thousands_sep=tsc(U","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(U""),.negative_sign=tsc(U"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=0,.p_sep_by_space=0,.n_cs_precedes=0,.n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1},.numeric={.decimal_point=tsc(U"."),.thousands_sep=tsc(U","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(U"တိတ်ႉ"),tsc(U"ၸၼ်"),tsc(U"ၵၢၼ်း"),tsc(U"ပုတ်ႉ"),tsc(U"ၽတ်း"),tsc(U"သုၵ်း"),tsc(U"သဝ်")},.day={tsc(U"ဝၼ်းဢႃးတိတ်ႉ"),tsc(U"ဝၼ်းၸၼ်"),tsc(U"ဝၼ်းဢၢင်းၵၢၼ်း"),tsc(U"ဝၼ်းပုတ်ႉ"),tsc(U"ဝၼ်းၽတ်း"),tsc(U"ဝၼ်းသုၵ်း"),tsc(U"ဝၼ်းသဝ်")},.abmon={tsc(U"လိူၼ်ၵမ်"),tsc(U"လိူၼ်သၢမ်"),tsc(U"လိူၼ်သီႇ"),tsc(U"လိူၼ်ႁႃႈ"),tsc(U"လိူၼ်ႁူၵ်း"),tsc(U"လိူၼ်ၸဵတ်း"),tsc(U"လိူၼ်ပႅတ်ႇ"),tsc(U"လိူၼ်ၵဝ်ႈ"),tsc(U"လိူၼ်သိပ်း"),tsc(U"လိူၼ်သိပ်းဢဵတ်း"),tsc(U"လိူၼ်သိပ်းသွင်"),tsc(U"လိူၼ်ၸဵင်")},.mon={tsc(U"လိူၼ်ၵမ်"),tsc(U"လိူၼ်သၢမ်"),tsc(U"လိူၼ်သီႇ"),tsc(U"လိူၼ်ႁႃႈ"),tsc(U"လိူၼ်ႁူၵ်း"),tsc(U"လိူၼ်ၸဵတ်း"),tsc(U"လိူၼ်ပႅတ်ႇ"),tsc(U"လိူၼ်ၵဝ်ႈ"),tsc(U"လိူၼ်သိပ်း"),tsc(U"လိူၼ်သိပ်းဢဵတ်း"),tsc(U"လိူၼ်သိပ်းသွင်"),tsc(U"လိူၼ်ၸဵင်")},.d_t_fmt=tsc(U"%OC%Oy %b %Od %A %OI:%OM:%OS %Op %Z"),.d_fmt=tsc(U"%OC%Oy %b %Od %A"),.t_fmt=tsc(U"%OH:%OM:%OS %p"),.t_fmt_ampm=tsc(U"%OI:%OM:%OS %p"),.am_pm={tsc(U"ပွတ်းၼႂ်"),tsc(U"ဝၢႆးဝၼ်း")},.alt_digits={u32time_alt_digits_storage,100}},.messages={.yesexpr=tsc(U"^[+1yYမ]"),.noexpr=tsc(U"^[-0nNဢ]"),.yesstr=tsc(U"မႅၼ်ႈ"),.nostr=tsc(U"ဢမ်ႇမႅၼ်ႈ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(U"+%c %a %l"),.tel_dom_fmt=tsc(U"%a %l"),.int_select=tsc(U"0"),.int_prefix=tsc(U"95")},.name={.name_fmt=tsc(U"%p%t%g%t%m%t%f"),.name_gen=tsc(U"")},.address={.postal_fmt=tsc(U"%a%N%d%N%f%N%b%N%h%t%r%t%e%t%s%N%T%t%z%N%c%N"),.country_name=tsc(U"မၢၼ်ႈ"),.country_post=tsc(U"Myanmar"),.country_ab2=tsc(U"MM"),.country_num=104,.country_car=tsc(U"MYA"),.lang_name=tsc(U"လိၵ်ႈတႆး"),.lang_term=tsc(U"shn"),.lang_lib=tsc(U"shn")},.measurement={.measurement=1}};


}
}

#include"../main.h"