﻿#include"../localedef.h"

namespace fast_io_i18n
{
namespace
{

inline constexpr std::size_t numeric_grouping_storage[]{4};

inline constexpr basic_lc_time_era<char> time_era_storage[]{{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc("民國"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:2:1913//01//01:+*:民國:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc("民國"),.era_format=tsc("%EC元年"),.era=tsc("+:1:1912//01//01:1912//12//31:民國:%EC元年")},{.direction=true,.offset=1,.start_date_year=1911,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc("民前"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:1:1911//12//31:-*:民前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char> time_alt_digits_storage[]{tsc("〇"),tsc("一"),tsc("二"),tsc("三"),tsc("四"),tsc("五"),tsc("六"),tsc("七"),tsc("八"),tsc("九"),tsc("十"),tsc("十一"),tsc("十二"),tsc("十三"),tsc("十四"),tsc("十五"),tsc("十六"),tsc("十七"),tsc("十八"),tsc("十九"),tsc("廿"),tsc("廿一"),tsc("廿二"),tsc("廿三"),tsc("廿四"),tsc("廿五"),tsc("廿六"),tsc("廿七"),tsc("廿八"),tsc("廿九"),tsc("卅"),tsc("卅一")};

inline constexpr lc_all lc_all_global{.identification={.name=tsc("lzh_TW"),.encoding=tsc(FAST_IO_LOCALE_ENCODING),.title=tsc("Literary Chinese locale for the Republic of China"),.source=tsc("fast_io"),.address=tsc("https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc("fast_io"),.email=tsc("bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(""),.fax=tsc(""),.language=tsc("Literary Chinese"),.territory=tsc("Taiwan"),.revision=tsc("0.1"),.date=tsc("2013-06-02")},.monetary={.int_curr_symbol=tsc("TWD "),.currency_symbol=tsc("NT$"),.mon_decimal_point=tsc("."),.mon_thousands_sep=tsc(","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(""),.negative_sign=tsc("-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_cs_precedes=1,.int_p_sep_by_space=0,.int_n_cs_precedes=1,.int_n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1,.int_p_sign_posn=1,.int_n_sign_posn=1},.numeric={.decimal_point=tsc("."),.thousands_sep=tsc(","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc("日"),tsc("一"),tsc("二"),tsc("三"),tsc("四"),tsc("五"),tsc("六")},.day={tsc("週日"),tsc("週一"),tsc("週二"),tsc("週三"),tsc("週四"),tsc("週五"),tsc("週六")},.abmon={tsc(" 一 "),tsc(" 二 "),tsc(" 三 "),tsc(" 四 "),tsc(" 五 "),tsc(" 六 "),tsc(" 七 "),tsc(" 八 "),tsc(" 九 "),tsc(" 十 "),tsc("十一"),tsc("十二")},.mon={tsc("一月"),tsc("二月"),tsc("三月"),tsc("四月"),tsc("五月"),tsc("六月"),tsc("七月"),tsc("八月"),tsc("九月"),tsc("十月"),tsc("十一月"),tsc("十二月")},.d_t_fmt=tsc("%OC%Oy年%B%Od日 (%A) %OH時%OM分%OS秒"),.d_fmt=tsc("%OC%Oy年%B%Od日"),.t_fmt=tsc("%OH時%OM分%OS秒"),.t_fmt_ampm=tsc("%p %OI時%OM分%OS秒"),.date_fmt=tsc("公曆 %C%Oy年 %B %Oe日 %A %OH時%OM分%OS秒"),.am_pm={tsc("朝"),tsc("暮")},.era={time_era_storage,3},.alt_digits={time_alt_digits_storage,32},.week={7,19971130,1}},.messages={.yesexpr=tsc("^[+1yYｙＹ是]"),.noexpr=tsc("^[-0nNｎＮ非]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc("+%c-%a-%l"),.tel_dom_fmt=tsc("%A-%l"),.int_select=tsc("00"),.int_prefix=tsc("886")},.name={.name_fmt=tsc("%f%d%t%g"),.name_gen=tsc("君"),.name_miss=tsc("女"),.name_mr=tsc("子"),.name_mrs=tsc("氏"),.name_ms=tsc("娘")},.address={.postal_fmt=tsc("%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"),.country_name=tsc("中華民國"),.country_post=tsc("TW"),.country_ab2=tsc("TW"),.country_ab3=tsc("TWN"),.country_num=158,.country_car=tsc("RC"),.country_isbn=tsc("957"),.lang_name=tsc("漢語文言"),.lang_term=tsc("lzh"),.lang_lib=tsc("lzh")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<wchar_t> wtime_era_storage[]{{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(L"民國"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:2:1913//01//01:+*:民國:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"民國"),.era_format=tsc(L"%EC元年"),.era=tsc(L"+:1:1912//01//01:1912//12//31:民國:%EC元年")},{.direction=true,.offset=1,.start_date_year=1911,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(L"民前"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:1:1911//12//31:-*:民前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<wchar_t> wtime_alt_digits_storage[]{tsc(L"〇"),tsc(L"一"),tsc(L"二"),tsc(L"三"),tsc(L"四"),tsc(L"五"),tsc(L"六"),tsc(L"七"),tsc(L"八"),tsc(L"九"),tsc(L"十"),tsc(L"十一"),tsc(L"十二"),tsc(L"十三"),tsc(L"十四"),tsc(L"十五"),tsc(L"十六"),tsc(L"十七"),tsc(L"十八"),tsc(L"十九"),tsc(L"廿"),tsc(L"廿一"),tsc(L"廿二"),tsc(L"廿三"),tsc(L"廿四"),tsc(L"廿五"),tsc(L"廿六"),tsc(L"廿七"),tsc(L"廿八"),tsc(L"廿九"),tsc(L"卅"),tsc(L"卅一")};

inline constexpr wlc_all wlc_all_global{.identification={.name=tsc(L"lzh_TW"),.encoding=tsc(FAST_IO_LOCALE_LENCODING),.title=tsc(L"Literary Chinese locale for the Republic of China"),.source=tsc(L"fast_io"),.address=tsc(L"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(L"fast_io"),.email=tsc(L"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(L""),.fax=tsc(L""),.language=tsc(L"Literary Chinese"),.territory=tsc(L"Taiwan"),.revision=tsc(L"0.1"),.date=tsc(L"2013-06-02")},.monetary={.int_curr_symbol=tsc(L"TWD "),.currency_symbol=tsc(L"NT$"),.mon_decimal_point=tsc(L"."),.mon_thousands_sep=tsc(L","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(L""),.negative_sign=tsc(L"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_cs_precedes=1,.int_p_sep_by_space=0,.int_n_cs_precedes=1,.int_n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1,.int_p_sign_posn=1,.int_n_sign_posn=1},.numeric={.decimal_point=tsc(L"."),.thousands_sep=tsc(L","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(L"日"),tsc(L"一"),tsc(L"二"),tsc(L"三"),tsc(L"四"),tsc(L"五"),tsc(L"六")},.day={tsc(L"週日"),tsc(L"週一"),tsc(L"週二"),tsc(L"週三"),tsc(L"週四"),tsc(L"週五"),tsc(L"週六")},.abmon={tsc(L" 一 "),tsc(L" 二 "),tsc(L" 三 "),tsc(L" 四 "),tsc(L" 五 "),tsc(L" 六 "),tsc(L" 七 "),tsc(L" 八 "),tsc(L" 九 "),tsc(L" 十 "),tsc(L"十一"),tsc(L"十二")},.mon={tsc(L"一月"),tsc(L"二月"),tsc(L"三月"),tsc(L"四月"),tsc(L"五月"),tsc(L"六月"),tsc(L"七月"),tsc(L"八月"),tsc(L"九月"),tsc(L"十月"),tsc(L"十一月"),tsc(L"十二月")},.d_t_fmt=tsc(L"%OC%Oy年%B%Od日 (%A) %OH時%OM分%OS秒"),.d_fmt=tsc(L"%OC%Oy年%B%Od日"),.t_fmt=tsc(L"%OH時%OM分%OS秒"),.t_fmt_ampm=tsc(L"%p %OI時%OM分%OS秒"),.date_fmt=tsc(L"公曆 %C%Oy年 %B %Oe日 %A %OH時%OM分%OS秒"),.am_pm={tsc(L"朝"),tsc(L"暮")},.era={wtime_era_storage,3},.alt_digits={wtime_alt_digits_storage,32},.week={7,19971130,1}},.messages={.yesexpr=tsc(L"^[+1yYｙＹ是]"),.noexpr=tsc(L"^[-0nNｎＮ非]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(L"+%c-%a-%l"),.tel_dom_fmt=tsc(L"%A-%l"),.int_select=tsc(L"00"),.int_prefix=tsc(L"886")},.name={.name_fmt=tsc(L"%f%d%t%g"),.name_gen=tsc(L"君"),.name_miss=tsc(L"女"),.name_mr=tsc(L"子"),.name_mrs=tsc(L"氏"),.name_ms=tsc(L"娘")},.address={.postal_fmt=tsc(L"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"),.country_name=tsc(L"中華民國"),.country_post=tsc(L"TW"),.country_ab2=tsc(L"TW"),.country_ab3=tsc(L"TWN"),.country_num=158,.country_car=tsc(L"RC"),.country_isbn=tsc(L"957"),.lang_name=tsc(L"漢語文言"),.lang_term=tsc(L"lzh"),.lang_lib=tsc(L"lzh")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char8_t> u8time_era_storage[]{{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(u8"民國"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:2:1913//01//01:+*:民國:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"民國"),.era_format=tsc(u8"%EC元年"),.era=tsc(u8"+:1:1912//01//01:1912//12//31:民國:%EC元年")},{.direction=true,.offset=1,.start_date_year=1911,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(u8"民前"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:1:1911//12//31:-*:民前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char8_t> u8time_alt_digits_storage[]{tsc(u8"〇"),tsc(u8"一"),tsc(u8"二"),tsc(u8"三"),tsc(u8"四"),tsc(u8"五"),tsc(u8"六"),tsc(u8"七"),tsc(u8"八"),tsc(u8"九"),tsc(u8"十"),tsc(u8"十一"),tsc(u8"十二"),tsc(u8"十三"),tsc(u8"十四"),tsc(u8"十五"),tsc(u8"十六"),tsc(u8"十七"),tsc(u8"十八"),tsc(u8"十九"),tsc(u8"廿"),tsc(u8"廿一"),tsc(u8"廿二"),tsc(u8"廿三"),tsc(u8"廿四"),tsc(u8"廿五"),tsc(u8"廿六"),tsc(u8"廿七"),tsc(u8"廿八"),tsc(u8"廿九"),tsc(u8"卅"),tsc(u8"卅一")};

inline constexpr u8lc_all u8lc_all_global{.identification={.name=tsc(u8"lzh_TW"),.encoding=tsc(FAST_IO_LOCALE_u8ENCODING),.title=tsc(u8"Literary Chinese locale for the Republic of China"),.source=tsc(u8"fast_io"),.address=tsc(u8"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u8"fast_io"),.email=tsc(u8"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(u8""),.fax=tsc(u8""),.language=tsc(u8"Literary Chinese"),.territory=tsc(u8"Taiwan"),.revision=tsc(u8"0.1"),.date=tsc(u8"2013-06-02")},.monetary={.int_curr_symbol=tsc(u8"TWD "),.currency_symbol=tsc(u8"NT$"),.mon_decimal_point=tsc(u8"."),.mon_thousands_sep=tsc(u8","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u8""),.negative_sign=tsc(u8"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_cs_precedes=1,.int_p_sep_by_space=0,.int_n_cs_precedes=1,.int_n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1,.int_p_sign_posn=1,.int_n_sign_posn=1},.numeric={.decimal_point=tsc(u8"."),.thousands_sep=tsc(u8","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u8"日"),tsc(u8"一"),tsc(u8"二"),tsc(u8"三"),tsc(u8"四"),tsc(u8"五"),tsc(u8"六")},.day={tsc(u8"週日"),tsc(u8"週一"),tsc(u8"週二"),tsc(u8"週三"),tsc(u8"週四"),tsc(u8"週五"),tsc(u8"週六")},.abmon={tsc(u8" 一 "),tsc(u8" 二 "),tsc(u8" 三 "),tsc(u8" 四 "),tsc(u8" 五 "),tsc(u8" 六 "),tsc(u8" 七 "),tsc(u8" 八 "),tsc(u8" 九 "),tsc(u8" 十 "),tsc(u8"十一"),tsc(u8"十二")},.mon={tsc(u8"一月"),tsc(u8"二月"),tsc(u8"三月"),tsc(u8"四月"),tsc(u8"五月"),tsc(u8"六月"),tsc(u8"七月"),tsc(u8"八月"),tsc(u8"九月"),tsc(u8"十月"),tsc(u8"十一月"),tsc(u8"十二月")},.d_t_fmt=tsc(u8"%OC%Oy年%B%Od日 (%A) %OH時%OM分%OS秒"),.d_fmt=tsc(u8"%OC%Oy年%B%Od日"),.t_fmt=tsc(u8"%OH時%OM分%OS秒"),.t_fmt_ampm=tsc(u8"%p %OI時%OM分%OS秒"),.date_fmt=tsc(u8"公曆 %C%Oy年 %B %Oe日 %A %OH時%OM分%OS秒"),.am_pm={tsc(u8"朝"),tsc(u8"暮")},.era={u8time_era_storage,3},.alt_digits={u8time_alt_digits_storage,32},.week={7,19971130,1}},.messages={.yesexpr=tsc(u8"^[+1yYｙＹ是]"),.noexpr=tsc(u8"^[-0nNｎＮ非]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u8"+%c-%a-%l"),.tel_dom_fmt=tsc(u8"%A-%l"),.int_select=tsc(u8"00"),.int_prefix=tsc(u8"886")},.name={.name_fmt=tsc(u8"%f%d%t%g"),.name_gen=tsc(u8"君"),.name_miss=tsc(u8"女"),.name_mr=tsc(u8"子"),.name_mrs=tsc(u8"氏"),.name_ms=tsc(u8"娘")},.address={.postal_fmt=tsc(u8"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"),.country_name=tsc(u8"中華民國"),.country_post=tsc(u8"TW"),.country_ab2=tsc(u8"TW"),.country_ab3=tsc(u8"TWN"),.country_num=158,.country_car=tsc(u8"RC"),.country_isbn=tsc(u8"957"),.lang_name=tsc(u8"漢語文言"),.lang_term=tsc(u8"lzh"),.lang_lib=tsc(u8"lzh")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char16_t> u16time_era_storage[]{{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(u"民國"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:2:1913//01//01:+*:民國:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"民國"),.era_format=tsc(u"%EC元年"),.era=tsc(u"+:1:1912//01//01:1912//12//31:民國:%EC元年")},{.direction=true,.offset=1,.start_date_year=1911,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(u"民前"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:1:1911//12//31:-*:民前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char16_t> u16time_alt_digits_storage[]{tsc(u"〇"),tsc(u"一"),tsc(u"二"),tsc(u"三"),tsc(u"四"),tsc(u"五"),tsc(u"六"),tsc(u"七"),tsc(u"八"),tsc(u"九"),tsc(u"十"),tsc(u"十一"),tsc(u"十二"),tsc(u"十三"),tsc(u"十四"),tsc(u"十五"),tsc(u"十六"),tsc(u"十七"),tsc(u"十八"),tsc(u"十九"),tsc(u"廿"),tsc(u"廿一"),tsc(u"廿二"),tsc(u"廿三"),tsc(u"廿四"),tsc(u"廿五"),tsc(u"廿六"),tsc(u"廿七"),tsc(u"廿八"),tsc(u"廿九"),tsc(u"卅"),tsc(u"卅一")};

inline constexpr u16lc_all u16lc_all_global{.identification={.name=tsc(u"lzh_TW"),.encoding=tsc(FAST_IO_LOCALE_uENCODING),.title=tsc(u"Literary Chinese locale for the Republic of China"),.source=tsc(u"fast_io"),.address=tsc(u"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u"fast_io"),.email=tsc(u"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(u""),.fax=tsc(u""),.language=tsc(u"Literary Chinese"),.territory=tsc(u"Taiwan"),.revision=tsc(u"0.1"),.date=tsc(u"2013-06-02")},.monetary={.int_curr_symbol=tsc(u"TWD "),.currency_symbol=tsc(u"NT$"),.mon_decimal_point=tsc(u"."),.mon_thousands_sep=tsc(u","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u""),.negative_sign=tsc(u"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_cs_precedes=1,.int_p_sep_by_space=0,.int_n_cs_precedes=1,.int_n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1,.int_p_sign_posn=1,.int_n_sign_posn=1},.numeric={.decimal_point=tsc(u"."),.thousands_sep=tsc(u","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u"日"),tsc(u"一"),tsc(u"二"),tsc(u"三"),tsc(u"四"),tsc(u"五"),tsc(u"六")},.day={tsc(u"週日"),tsc(u"週一"),tsc(u"週二"),tsc(u"週三"),tsc(u"週四"),tsc(u"週五"),tsc(u"週六")},.abmon={tsc(u" 一 "),tsc(u" 二 "),tsc(u" 三 "),tsc(u" 四 "),tsc(u" 五 "),tsc(u" 六 "),tsc(u" 七 "),tsc(u" 八 "),tsc(u" 九 "),tsc(u" 十 "),tsc(u"十一"),tsc(u"十二")},.mon={tsc(u"一月"),tsc(u"二月"),tsc(u"三月"),tsc(u"四月"),tsc(u"五月"),tsc(u"六月"),tsc(u"七月"),tsc(u"八月"),tsc(u"九月"),tsc(u"十月"),tsc(u"十一月"),tsc(u"十二月")},.d_t_fmt=tsc(u"%OC%Oy年%B%Od日 (%A) %OH時%OM分%OS秒"),.d_fmt=tsc(u"%OC%Oy年%B%Od日"),.t_fmt=tsc(u"%OH時%OM分%OS秒"),.t_fmt_ampm=tsc(u"%p %OI時%OM分%OS秒"),.date_fmt=tsc(u"公曆 %C%Oy年 %B %Oe日 %A %OH時%OM分%OS秒"),.am_pm={tsc(u"朝"),tsc(u"暮")},.era={u16time_era_storage,3},.alt_digits={u16time_alt_digits_storage,32},.week={7,19971130,1}},.messages={.yesexpr=tsc(u"^[+1yYｙＹ是]"),.noexpr=tsc(u"^[-0nNｎＮ非]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u"+%c-%a-%l"),.tel_dom_fmt=tsc(u"%A-%l"),.int_select=tsc(u"00"),.int_prefix=tsc(u"886")},.name={.name_fmt=tsc(u"%f%d%t%g"),.name_gen=tsc(u"君"),.name_miss=tsc(u"女"),.name_mr=tsc(u"子"),.name_mrs=tsc(u"氏"),.name_ms=tsc(u"娘")},.address={.postal_fmt=tsc(u"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"),.country_name=tsc(u"中華民國"),.country_post=tsc(u"TW"),.country_ab2=tsc(u"TW"),.country_ab3=tsc(u"TWN"),.country_num=158,.country_car=tsc(u"RC"),.country_isbn=tsc(u"957"),.lang_name=tsc(u"漢語文言"),.lang_term=tsc(u"lzh"),.lang_lib=tsc(u"lzh")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char32_t> u32time_era_storage[]{{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(U"民國"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:2:1913//01//01:+*:民國:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"民國"),.era_format=tsc(U"%EC元年"),.era=tsc(U"+:1:1912//01//01:1912//12//31:民國:%EC元年")},{.direction=true,.offset=1,.start_date_year=1911,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(U"民前"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:1:1911//12//31:-*:民前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char32_t> u32time_alt_digits_storage[]{tsc(U"〇"),tsc(U"一"),tsc(U"二"),tsc(U"三"),tsc(U"四"),tsc(U"五"),tsc(U"六"),tsc(U"七"),tsc(U"八"),tsc(U"九"),tsc(U"十"),tsc(U"十一"),tsc(U"十二"),tsc(U"十三"),tsc(U"十四"),tsc(U"十五"),tsc(U"十六"),tsc(U"十七"),tsc(U"十八"),tsc(U"十九"),tsc(U"廿"),tsc(U"廿一"),tsc(U"廿二"),tsc(U"廿三"),tsc(U"廿四"),tsc(U"廿五"),tsc(U"廿六"),tsc(U"廿七"),tsc(U"廿八"),tsc(U"廿九"),tsc(U"卅"),tsc(U"卅一")};

inline constexpr u32lc_all u32lc_all_global{.identification={.name=tsc(U"lzh_TW"),.encoding=tsc(FAST_IO_LOCALE_UENCODING),.title=tsc(U"Literary Chinese locale for the Republic of China"),.source=tsc(U"fast_io"),.address=tsc(U"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(U"fast_io"),.email=tsc(U"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(U""),.fax=tsc(U""),.language=tsc(U"Literary Chinese"),.territory=tsc(U"Taiwan"),.revision=tsc(U"0.1"),.date=tsc(U"2013-06-02")},.monetary={.int_curr_symbol=tsc(U"TWD "),.currency_symbol=tsc(U"NT$"),.mon_decimal_point=tsc(U"."),.mon_thousands_sep=tsc(U","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(U""),.negative_sign=tsc(U"-"),.int_frac_digits=2,.frac_digits=2,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_cs_precedes=1,.int_p_sep_by_space=0,.int_n_cs_precedes=1,.int_n_sep_by_space=0,.p_sign_posn=1,.n_sign_posn=1,.int_p_sign_posn=1,.int_n_sign_posn=1},.numeric={.decimal_point=tsc(U"."),.thousands_sep=tsc(U","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(U"日"),tsc(U"一"),tsc(U"二"),tsc(U"三"),tsc(U"四"),tsc(U"五"),tsc(U"六")},.day={tsc(U"週日"),tsc(U"週一"),tsc(U"週二"),tsc(U"週三"),tsc(U"週四"),tsc(U"週五"),tsc(U"週六")},.abmon={tsc(U" 一 "),tsc(U" 二 "),tsc(U" 三 "),tsc(U" 四 "),tsc(U" 五 "),tsc(U" 六 "),tsc(U" 七 "),tsc(U" 八 "),tsc(U" 九 "),tsc(U" 十 "),tsc(U"十一"),tsc(U"十二")},.mon={tsc(U"一月"),tsc(U"二月"),tsc(U"三月"),tsc(U"四月"),tsc(U"五月"),tsc(U"六月"),tsc(U"七月"),tsc(U"八月"),tsc(U"九月"),tsc(U"十月"),tsc(U"十一月"),tsc(U"十二月")},.d_t_fmt=tsc(U"%OC%Oy年%B%Od日 (%A) %OH時%OM分%OS秒"),.d_fmt=tsc(U"%OC%Oy年%B%Od日"),.t_fmt=tsc(U"%OH時%OM分%OS秒"),.t_fmt_ampm=tsc(U"%p %OI時%OM分%OS秒"),.date_fmt=tsc(U"公曆 %C%Oy年 %B %Oe日 %A %OH時%OM分%OS秒"),.am_pm={tsc(U"朝"),tsc(U"暮")},.era={u32time_era_storage,3},.alt_digits={u32time_alt_digits_storage,32},.week={7,19971130,1}},.messages={.yesexpr=tsc(U"^[+1yYｙＹ是]"),.noexpr=tsc(U"^[-0nNｎＮ非]")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(U"+%c-%a-%l"),.tel_dom_fmt=tsc(U"%A-%l"),.int_select=tsc(U"00"),.int_prefix=tsc(U"886")},.name={.name_fmt=tsc(U"%f%d%t%g"),.name_gen=tsc(U"君"),.name_miss=tsc(U"女"),.name_mr=tsc(U"子"),.name_mrs=tsc(U"氏"),.name_ms=tsc(U"娘")},.address={.postal_fmt=tsc(U"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"),.country_name=tsc(U"中華民國"),.country_post=tsc(U"TW"),.country_ab2=tsc(U"TW"),.country_ab3=tsc(U"TWN"),.country_num=158,.country_car=tsc(U"RC"),.country_isbn=tsc(U"957"),.lang_name=tsc(U"漢語文言"),.lang_term=tsc(U"lzh"),.lang_lib=tsc(U"lzh")},.measurement={.measurement=1}};


}
}

#include"../main.h"