﻿#include"../localedef.h"

namespace fast_io_i18n
{
namespace
{

inline constexpr std::size_t numeric_grouping_storage[]{3};

inline constexpr basic_lc_time_era<char> time_era_storage[]{{.direction=true,.offset=2,.start_date_year=2020,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc("令和"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:2:2020//01//01:+*:令和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=2019,.start_date_month=5,.start_date_day=1,.end_date_year=2019,.end_date_month=12,.end_date_day=31,.era_name=tsc("令和"),.era_format=tsc("%EC元年"),.era=tsc("+:1:2019//05//01:2019//12//31:令和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1990,.start_date_month=1,.start_date_day=1,.end_date_year=2019,.end_date_month=4,.end_date_day=30,.era_name=tsc("平成"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:2:1990//01//01:2019//04//30:平成:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1989,.start_date_month=1,.start_date_day=8,.end_date_year=1989,.end_date_month=12,.end_date_day=31,.era_name=tsc("平成"),.era_format=tsc("%EC元年"),.era=tsc("+:1:1989//01//08:1989//12//31:平成:%EC元年")},{.direction=true,.offset=2,.start_date_year=1927,.start_date_month=1,.start_date_day=1,.end_date_year=1989,.end_date_month=1,.end_date_day=7,.era_name=tsc("昭和"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:2:1927//01//01:1989//01//07:昭和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1926,.start_date_month=12,.start_date_day=25,.end_date_year=1926,.end_date_month=12,.end_date_day=31,.era_name=tsc("昭和"),.era_format=tsc("%EC元年"),.era=tsc("+:1:1926//12//25:1926//12//31:昭和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_year=1926,.end_date_month=12,.end_date_day=24,.era_name=tsc("大正"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:2:1913//01//01:1926//12//24:大正:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=7,.start_date_day=30,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc("大正"),.era_format=tsc("%EC元年"),.era=tsc("+:1:1912//07//30:1912//12//31:大正:%EC元年")},{.direction=true,.offset=6,.start_date_year=1873,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=7,.end_date_day=29,.era_name=tsc("明治"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:6:1873//01//01:1912//07//29:明治:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1,.start_date_month=1,.start_date_day=1,.end_date_year=1872,.end_date_month=12,.end_date_day=31,.era_name=tsc("西暦"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:1:0001//01//01:1872//12//31:西暦:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=-1,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc("紀元前"),.era_format=tsc("%EC%Ey年"),.era=tsc("+:1:-0001//12//31:-*:紀元前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char> time_alt_digits_storage[]{tsc("〇"),tsc("一"),tsc("二"),tsc("三"),tsc("四"),tsc("五"),tsc("六"),tsc("七"),tsc("八"),tsc("九"),tsc("十"),tsc("十一"),tsc("十二"),tsc("十三"),tsc("十四"),tsc("十五"),tsc("十六"),tsc("十七"),tsc("十八"),tsc("十九"),tsc("二十"),tsc("二十一"),tsc("二十二"),tsc("二十三"),tsc("二十四"),tsc("二十五"),tsc("二十六"),tsc("二十七"),tsc("二十八"),tsc("二十九"),tsc("三十"),tsc("三十一"),tsc("三十二"),tsc("三十三"),tsc("三十四"),tsc("三十五"),tsc("三十六"),tsc("三十七"),tsc("三十八"),tsc("三十九"),tsc("四十"),tsc("四十一"),tsc("四十二"),tsc("四十三"),tsc("四十四"),tsc("四十五"),tsc("四十六"),tsc("四十七"),tsc("四十八"),tsc("四十九"),tsc("五十"),tsc("五十一"),tsc("五十二"),tsc("五十三"),tsc("五十四"),tsc("五十五"),tsc("五十六"),tsc("五十七"),tsc("五十八"),tsc("五十九"),tsc("六十"),tsc("六十一"),tsc("六十二"),tsc("六十三"),tsc("六十四"),tsc("六十五"),tsc("六十六"),tsc("六十七"),tsc("六十八"),tsc("六十九"),tsc("七十"),tsc("七十一"),tsc("七十二"),tsc("七十三"),tsc("七十四"),tsc("七十五"),tsc("七十六"),tsc("七十七"),tsc("七十八"),tsc("七十九"),tsc("八十"),tsc("八十一"),tsc("八十二"),tsc("八十三"),tsc("八十四"),tsc("八十五"),tsc("八十六"),tsc("八十七"),tsc("八十八"),tsc("八十九"),tsc("九十"),tsc("九十一"),tsc("九十二"),tsc("九十三"),tsc("九十四"),tsc("九十五"),tsc("九十六"),tsc("九十七"),tsc("九十八"),tsc("九十九")};

inline constexpr lc_all lc_all_global{.identification={.name=tsc("ja_JP"),.encoding=tsc(FAST_IO_LOCALE_ENCODING),.title=tsc("Japanese language locale for Japan"),.source=tsc("HANATAKA, Shinya, hanataka@abyss.rim.or.jp\t\t;\t\tfast_io"),.address=tsc("https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc("fast_io"),.email=tsc("bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(""),.fax=tsc(""),.language=tsc("Japanese"),.territory=tsc("Japan"),.revision=tsc("1.0"),.date=tsc("2000-07-20")},.monetary={.int_curr_symbol=tsc("JPY "),.currency_symbol=tsc("￥"),.mon_decimal_point=tsc("."),.mon_thousands_sep=tsc(","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(""),.negative_sign=tsc("-"),.int_frac_digits=0,.frac_digits=0,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_sep_by_space=2,.int_n_sep_by_space=2,.p_sign_posn=4,.n_sign_posn=4},.numeric={.decimal_point=tsc("."),.thousands_sep=tsc(","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc("日"),tsc("月"),tsc("火"),tsc("水"),tsc("木"),tsc("金"),tsc("土")},.day={tsc("日曜日"),tsc("月曜日"),tsc("火曜日"),tsc("水曜日"),tsc("木曜日"),tsc("金曜日"),tsc("土曜日")},.abmon={tsc(" 1月"),tsc(" 2月"),tsc(" 3月"),tsc(" 4月"),tsc(" 5月"),tsc(" 6月"),tsc(" 7月"),tsc(" 8月"),tsc(" 9月"),tsc("10月"),tsc("11月"),tsc("12月")},.mon={tsc("1月"),tsc("2月"),tsc("3月"),tsc("4月"),tsc("5月"),tsc("6月"),tsc("7月"),tsc("8月"),tsc("9月"),tsc("10月"),tsc("11月"),tsc("12月")},.d_t_fmt=tsc("%Y年%m月%d日 %H時%M分%S秒"),.d_fmt=tsc("%Y年%m月%d日"),.t_fmt=tsc("%H時%M分%S秒"),.t_fmt_ampm=tsc("%p%I時%M分%S秒"),.date_fmt=tsc("%Y年 %b %e日 %A %H:%M:%S %Z"),.am_pm={tsc("午前"),tsc("午後")},.era={time_era_storage,11},.era_d_fmt=tsc("%EY%m月%d日"),.era_d_t_fmt=tsc("%EY%m月%d日 %H時%M分%S秒"),.alt_digits={time_alt_digits_storage,100},.week={7,19971130,1}},.messages={.yesexpr=tsc("^([+1yYｙＹ]|はい|ハイ)"),.noexpr=tsc("^([-0nNｎＮ]|いいえ|イイエ)"),.yesstr=tsc("はい"),.nostr=tsc("いいえ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc("+%c ;%a ;%l"),.int_select=tsc("010"),.int_prefix=tsc("81")},.name={.name_fmt=tsc("%p%t%f%t%g"),.name_gen=tsc("様"),.name_miss=tsc("Miss."),.name_mr=tsc("Mr."),.name_mrs=tsc("Mrs."),.name_ms=tsc("Ms.")},.address={.postal_fmt=tsc("%z%c%T%s%b%e%r"),.country_name=tsc("日本"),.country_ab2=tsc("JP"),.country_ab3=tsc("JPN"),.country_num=392,.country_car=tsc("J"),.lang_name=tsc("日本語"),.lang_ab=tsc("ja"),.lang_term=tsc("jpn"),.lang_lib=tsc("jpn")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<wchar_t> wtime_era_storage[]{{.direction=true,.offset=2,.start_date_year=2020,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(L"令和"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:2:2020//01//01:+*:令和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=2019,.start_date_month=5,.start_date_day=1,.end_date_year=2019,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"令和"),.era_format=tsc(L"%EC元年"),.era=tsc(L"+:1:2019//05//01:2019//12//31:令和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1990,.start_date_month=1,.start_date_day=1,.end_date_year=2019,.end_date_month=4,.end_date_day=30,.era_name=tsc(L"平成"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:2:1990//01//01:2019//04//30:平成:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1989,.start_date_month=1,.start_date_day=8,.end_date_year=1989,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"平成"),.era_format=tsc(L"%EC元年"),.era=tsc(L"+:1:1989//01//08:1989//12//31:平成:%EC元年")},{.direction=true,.offset=2,.start_date_year=1927,.start_date_month=1,.start_date_day=1,.end_date_year=1989,.end_date_month=1,.end_date_day=7,.era_name=tsc(L"昭和"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:2:1927//01//01:1989//01//07:昭和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1926,.start_date_month=12,.start_date_day=25,.end_date_year=1926,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"昭和"),.era_format=tsc(L"%EC元年"),.era=tsc(L"+:1:1926//12//25:1926//12//31:昭和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_year=1926,.end_date_month=12,.end_date_day=24,.era_name=tsc(L"大正"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:2:1913//01//01:1926//12//24:大正:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=7,.start_date_day=30,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"大正"),.era_format=tsc(L"%EC元年"),.era=tsc(L"+:1:1912//07//30:1912//12//31:大正:%EC元年")},{.direction=true,.offset=6,.start_date_year=1873,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=7,.end_date_day=29,.era_name=tsc(L"明治"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:6:1873//01//01:1912//07//29:明治:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1,.start_date_month=1,.start_date_day=1,.end_date_year=1872,.end_date_month=12,.end_date_day=31,.era_name=tsc(L"西暦"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:1:0001//01//01:1872//12//31:西暦:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=-1,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(L"紀元前"),.era_format=tsc(L"%EC%Ey年"),.era=tsc(L"+:1:-0001//12//31:-*:紀元前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<wchar_t> wtime_alt_digits_storage[]{tsc(L"〇"),tsc(L"一"),tsc(L"二"),tsc(L"三"),tsc(L"四"),tsc(L"五"),tsc(L"六"),tsc(L"七"),tsc(L"八"),tsc(L"九"),tsc(L"十"),tsc(L"十一"),tsc(L"十二"),tsc(L"十三"),tsc(L"十四"),tsc(L"十五"),tsc(L"十六"),tsc(L"十七"),tsc(L"十八"),tsc(L"十九"),tsc(L"二十"),tsc(L"二十一"),tsc(L"二十二"),tsc(L"二十三"),tsc(L"二十四"),tsc(L"二十五"),tsc(L"二十六"),tsc(L"二十七"),tsc(L"二十八"),tsc(L"二十九"),tsc(L"三十"),tsc(L"三十一"),tsc(L"三十二"),tsc(L"三十三"),tsc(L"三十四"),tsc(L"三十五"),tsc(L"三十六"),tsc(L"三十七"),tsc(L"三十八"),tsc(L"三十九"),tsc(L"四十"),tsc(L"四十一"),tsc(L"四十二"),tsc(L"四十三"),tsc(L"四十四"),tsc(L"四十五"),tsc(L"四十六"),tsc(L"四十七"),tsc(L"四十八"),tsc(L"四十九"),tsc(L"五十"),tsc(L"五十一"),tsc(L"五十二"),tsc(L"五十三"),tsc(L"五十四"),tsc(L"五十五"),tsc(L"五十六"),tsc(L"五十七"),tsc(L"五十八"),tsc(L"五十九"),tsc(L"六十"),tsc(L"六十一"),tsc(L"六十二"),tsc(L"六十三"),tsc(L"六十四"),tsc(L"六十五"),tsc(L"六十六"),tsc(L"六十七"),tsc(L"六十八"),tsc(L"六十九"),tsc(L"七十"),tsc(L"七十一"),tsc(L"七十二"),tsc(L"七十三"),tsc(L"七十四"),tsc(L"七十五"),tsc(L"七十六"),tsc(L"七十七"),tsc(L"七十八"),tsc(L"七十九"),tsc(L"八十"),tsc(L"八十一"),tsc(L"八十二"),tsc(L"八十三"),tsc(L"八十四"),tsc(L"八十五"),tsc(L"八十六"),tsc(L"八十七"),tsc(L"八十八"),tsc(L"八十九"),tsc(L"九十"),tsc(L"九十一"),tsc(L"九十二"),tsc(L"九十三"),tsc(L"九十四"),tsc(L"九十五"),tsc(L"九十六"),tsc(L"九十七"),tsc(L"九十八"),tsc(L"九十九")};

inline constexpr wlc_all wlc_all_global{.identification={.name=tsc(L"ja_JP"),.encoding=tsc(FAST_IO_LOCALE_LENCODING),.title=tsc(L"Japanese language locale for Japan"),.source=tsc(L"HANATAKA, Shinya, hanataka@abyss.rim.or.jp\t\t;\t\tfast_io"),.address=tsc(L"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(L"fast_io"),.email=tsc(L"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(L""),.fax=tsc(L""),.language=tsc(L"Japanese"),.territory=tsc(L"Japan"),.revision=tsc(L"1.0"),.date=tsc(L"2000-07-20")},.monetary={.int_curr_symbol=tsc(L"JPY "),.currency_symbol=tsc(L"￥"),.mon_decimal_point=tsc(L"."),.mon_thousands_sep=tsc(L","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(L""),.negative_sign=tsc(L"-"),.int_frac_digits=0,.frac_digits=0,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_sep_by_space=2,.int_n_sep_by_space=2,.p_sign_posn=4,.n_sign_posn=4},.numeric={.decimal_point=tsc(L"."),.thousands_sep=tsc(L","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(L"日"),tsc(L"月"),tsc(L"火"),tsc(L"水"),tsc(L"木"),tsc(L"金"),tsc(L"土")},.day={tsc(L"日曜日"),tsc(L"月曜日"),tsc(L"火曜日"),tsc(L"水曜日"),tsc(L"木曜日"),tsc(L"金曜日"),tsc(L"土曜日")},.abmon={tsc(L" 1月"),tsc(L" 2月"),tsc(L" 3月"),tsc(L" 4月"),tsc(L" 5月"),tsc(L" 6月"),tsc(L" 7月"),tsc(L" 8月"),tsc(L" 9月"),tsc(L"10月"),tsc(L"11月"),tsc(L"12月")},.mon={tsc(L"1月"),tsc(L"2月"),tsc(L"3月"),tsc(L"4月"),tsc(L"5月"),tsc(L"6月"),tsc(L"7月"),tsc(L"8月"),tsc(L"9月"),tsc(L"10月"),tsc(L"11月"),tsc(L"12月")},.d_t_fmt=tsc(L"%Y年%m月%d日 %H時%M分%S秒"),.d_fmt=tsc(L"%Y年%m月%d日"),.t_fmt=tsc(L"%H時%M分%S秒"),.t_fmt_ampm=tsc(L"%p%I時%M分%S秒"),.date_fmt=tsc(L"%Y年 %b %e日 %A %H:%M:%S %Z"),.am_pm={tsc(L"午前"),tsc(L"午後")},.era={wtime_era_storage,11},.era_d_fmt=tsc(L"%EY%m月%d日"),.era_d_t_fmt=tsc(L"%EY%m月%d日 %H時%M分%S秒"),.alt_digits={wtime_alt_digits_storage,100},.week={7,19971130,1}},.messages={.yesexpr=tsc(L"^([+1yYｙＹ]|はい|ハイ)"),.noexpr=tsc(L"^([-0nNｎＮ]|いいえ|イイエ)"),.yesstr=tsc(L"はい"),.nostr=tsc(L"いいえ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(L"+%c ;%a ;%l"),.int_select=tsc(L"010"),.int_prefix=tsc(L"81")},.name={.name_fmt=tsc(L"%p%t%f%t%g"),.name_gen=tsc(L"様"),.name_miss=tsc(L"Miss."),.name_mr=tsc(L"Mr."),.name_mrs=tsc(L"Mrs."),.name_ms=tsc(L"Ms.")},.address={.postal_fmt=tsc(L"%z%c%T%s%b%e%r"),.country_name=tsc(L"日本"),.country_ab2=tsc(L"JP"),.country_ab3=tsc(L"JPN"),.country_num=392,.country_car=tsc(L"J"),.lang_name=tsc(L"日本語"),.lang_ab=tsc(L"ja"),.lang_term=tsc(L"jpn"),.lang_lib=tsc(L"jpn")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char8_t> u8time_era_storage[]{{.direction=true,.offset=2,.start_date_year=2020,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(u8"令和"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:2:2020//01//01:+*:令和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=2019,.start_date_month=5,.start_date_day=1,.end_date_year=2019,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"令和"),.era_format=tsc(u8"%EC元年"),.era=tsc(u8"+:1:2019//05//01:2019//12//31:令和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1990,.start_date_month=1,.start_date_day=1,.end_date_year=2019,.end_date_month=4,.end_date_day=30,.era_name=tsc(u8"平成"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:2:1990//01//01:2019//04//30:平成:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1989,.start_date_month=1,.start_date_day=8,.end_date_year=1989,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"平成"),.era_format=tsc(u8"%EC元年"),.era=tsc(u8"+:1:1989//01//08:1989//12//31:平成:%EC元年")},{.direction=true,.offset=2,.start_date_year=1927,.start_date_month=1,.start_date_day=1,.end_date_year=1989,.end_date_month=1,.end_date_day=7,.era_name=tsc(u8"昭和"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:2:1927//01//01:1989//01//07:昭和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1926,.start_date_month=12,.start_date_day=25,.end_date_year=1926,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"昭和"),.era_format=tsc(u8"%EC元年"),.era=tsc(u8"+:1:1926//12//25:1926//12//31:昭和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_year=1926,.end_date_month=12,.end_date_day=24,.era_name=tsc(u8"大正"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:2:1913//01//01:1926//12//24:大正:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=7,.start_date_day=30,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"大正"),.era_format=tsc(u8"%EC元年"),.era=tsc(u8"+:1:1912//07//30:1912//12//31:大正:%EC元年")},{.direction=true,.offset=6,.start_date_year=1873,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=7,.end_date_day=29,.era_name=tsc(u8"明治"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:6:1873//01//01:1912//07//29:明治:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1,.start_date_month=1,.start_date_day=1,.end_date_year=1872,.end_date_month=12,.end_date_day=31,.era_name=tsc(u8"西暦"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:1:0001//01//01:1872//12//31:西暦:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=-1,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(u8"紀元前"),.era_format=tsc(u8"%EC%Ey年"),.era=tsc(u8"+:1:-0001//12//31:-*:紀元前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char8_t> u8time_alt_digits_storage[]{tsc(u8"〇"),tsc(u8"一"),tsc(u8"二"),tsc(u8"三"),tsc(u8"四"),tsc(u8"五"),tsc(u8"六"),tsc(u8"七"),tsc(u8"八"),tsc(u8"九"),tsc(u8"十"),tsc(u8"十一"),tsc(u8"十二"),tsc(u8"十三"),tsc(u8"十四"),tsc(u8"十五"),tsc(u8"十六"),tsc(u8"十七"),tsc(u8"十八"),tsc(u8"十九"),tsc(u8"二十"),tsc(u8"二十一"),tsc(u8"二十二"),tsc(u8"二十三"),tsc(u8"二十四"),tsc(u8"二十五"),tsc(u8"二十六"),tsc(u8"二十七"),tsc(u8"二十八"),tsc(u8"二十九"),tsc(u8"三十"),tsc(u8"三十一"),tsc(u8"三十二"),tsc(u8"三十三"),tsc(u8"三十四"),tsc(u8"三十五"),tsc(u8"三十六"),tsc(u8"三十七"),tsc(u8"三十八"),tsc(u8"三十九"),tsc(u8"四十"),tsc(u8"四十一"),tsc(u8"四十二"),tsc(u8"四十三"),tsc(u8"四十四"),tsc(u8"四十五"),tsc(u8"四十六"),tsc(u8"四十七"),tsc(u8"四十八"),tsc(u8"四十九"),tsc(u8"五十"),tsc(u8"五十一"),tsc(u8"五十二"),tsc(u8"五十三"),tsc(u8"五十四"),tsc(u8"五十五"),tsc(u8"五十六"),tsc(u8"五十七"),tsc(u8"五十八"),tsc(u8"五十九"),tsc(u8"六十"),tsc(u8"六十一"),tsc(u8"六十二"),tsc(u8"六十三"),tsc(u8"六十四"),tsc(u8"六十五"),tsc(u8"六十六"),tsc(u8"六十七"),tsc(u8"六十八"),tsc(u8"六十九"),tsc(u8"七十"),tsc(u8"七十一"),tsc(u8"七十二"),tsc(u8"七十三"),tsc(u8"七十四"),tsc(u8"七十五"),tsc(u8"七十六"),tsc(u8"七十七"),tsc(u8"七十八"),tsc(u8"七十九"),tsc(u8"八十"),tsc(u8"八十一"),tsc(u8"八十二"),tsc(u8"八十三"),tsc(u8"八十四"),tsc(u8"八十五"),tsc(u8"八十六"),tsc(u8"八十七"),tsc(u8"八十八"),tsc(u8"八十九"),tsc(u8"九十"),tsc(u8"九十一"),tsc(u8"九十二"),tsc(u8"九十三"),tsc(u8"九十四"),tsc(u8"九十五"),tsc(u8"九十六"),tsc(u8"九十七"),tsc(u8"九十八"),tsc(u8"九十九")};

inline constexpr u8lc_all u8lc_all_global{.identification={.name=tsc(u8"ja_JP"),.encoding=tsc(FAST_IO_LOCALE_u8ENCODING),.title=tsc(u8"Japanese language locale for Japan"),.source=tsc(u8"HANATAKA, Shinya, hanataka@abyss.rim.or.jp\t\t;\t\tfast_io"),.address=tsc(u8"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u8"fast_io"),.email=tsc(u8"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(u8""),.fax=tsc(u8""),.language=tsc(u8"Japanese"),.territory=tsc(u8"Japan"),.revision=tsc(u8"1.0"),.date=tsc(u8"2000-07-20")},.monetary={.int_curr_symbol=tsc(u8"JPY "),.currency_symbol=tsc(u8"￥"),.mon_decimal_point=tsc(u8"."),.mon_thousands_sep=tsc(u8","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u8""),.negative_sign=tsc(u8"-"),.int_frac_digits=0,.frac_digits=0,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_sep_by_space=2,.int_n_sep_by_space=2,.p_sign_posn=4,.n_sign_posn=4},.numeric={.decimal_point=tsc(u8"."),.thousands_sep=tsc(u8","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u8"日"),tsc(u8"月"),tsc(u8"火"),tsc(u8"水"),tsc(u8"木"),tsc(u8"金"),tsc(u8"土")},.day={tsc(u8"日曜日"),tsc(u8"月曜日"),tsc(u8"火曜日"),tsc(u8"水曜日"),tsc(u8"木曜日"),tsc(u8"金曜日"),tsc(u8"土曜日")},.abmon={tsc(u8" 1月"),tsc(u8" 2月"),tsc(u8" 3月"),tsc(u8" 4月"),tsc(u8" 5月"),tsc(u8" 6月"),tsc(u8" 7月"),tsc(u8" 8月"),tsc(u8" 9月"),tsc(u8"10月"),tsc(u8"11月"),tsc(u8"12月")},.mon={tsc(u8"1月"),tsc(u8"2月"),tsc(u8"3月"),tsc(u8"4月"),tsc(u8"5月"),tsc(u8"6月"),tsc(u8"7月"),tsc(u8"8月"),tsc(u8"9月"),tsc(u8"10月"),tsc(u8"11月"),tsc(u8"12月")},.d_t_fmt=tsc(u8"%Y年%m月%d日 %H時%M分%S秒"),.d_fmt=tsc(u8"%Y年%m月%d日"),.t_fmt=tsc(u8"%H時%M分%S秒"),.t_fmt_ampm=tsc(u8"%p%I時%M分%S秒"),.date_fmt=tsc(u8"%Y年 %b %e日 %A %H:%M:%S %Z"),.am_pm={tsc(u8"午前"),tsc(u8"午後")},.era={u8time_era_storage,11},.era_d_fmt=tsc(u8"%EY%m月%d日"),.era_d_t_fmt=tsc(u8"%EY%m月%d日 %H時%M分%S秒"),.alt_digits={u8time_alt_digits_storage,100},.week={7,19971130,1}},.messages={.yesexpr=tsc(u8"^([+1yYｙＹ]|はい|ハイ)"),.noexpr=tsc(u8"^([-0nNｎＮ]|いいえ|イイエ)"),.yesstr=tsc(u8"はい"),.nostr=tsc(u8"いいえ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u8"+%c ;%a ;%l"),.int_select=tsc(u8"010"),.int_prefix=tsc(u8"81")},.name={.name_fmt=tsc(u8"%p%t%f%t%g"),.name_gen=tsc(u8"様"),.name_miss=tsc(u8"Miss."),.name_mr=tsc(u8"Mr."),.name_mrs=tsc(u8"Mrs."),.name_ms=tsc(u8"Ms.")},.address={.postal_fmt=tsc(u8"%z%c%T%s%b%e%r"),.country_name=tsc(u8"日本"),.country_ab2=tsc(u8"JP"),.country_ab3=tsc(u8"JPN"),.country_num=392,.country_car=tsc(u8"J"),.lang_name=tsc(u8"日本語"),.lang_ab=tsc(u8"ja"),.lang_term=tsc(u8"jpn"),.lang_lib=tsc(u8"jpn")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char16_t> u16time_era_storage[]{{.direction=true,.offset=2,.start_date_year=2020,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(u"令和"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:2:2020//01//01:+*:令和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=2019,.start_date_month=5,.start_date_day=1,.end_date_year=2019,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"令和"),.era_format=tsc(u"%EC元年"),.era=tsc(u"+:1:2019//05//01:2019//12//31:令和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1990,.start_date_month=1,.start_date_day=1,.end_date_year=2019,.end_date_month=4,.end_date_day=30,.era_name=tsc(u"平成"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:2:1990//01//01:2019//04//30:平成:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1989,.start_date_month=1,.start_date_day=8,.end_date_year=1989,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"平成"),.era_format=tsc(u"%EC元年"),.era=tsc(u"+:1:1989//01//08:1989//12//31:平成:%EC元年")},{.direction=true,.offset=2,.start_date_year=1927,.start_date_month=1,.start_date_day=1,.end_date_year=1989,.end_date_month=1,.end_date_day=7,.era_name=tsc(u"昭和"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:2:1927//01//01:1989//01//07:昭和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1926,.start_date_month=12,.start_date_day=25,.end_date_year=1926,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"昭和"),.era_format=tsc(u"%EC元年"),.era=tsc(u"+:1:1926//12//25:1926//12//31:昭和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_year=1926,.end_date_month=12,.end_date_day=24,.era_name=tsc(u"大正"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:2:1913//01//01:1926//12//24:大正:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=7,.start_date_day=30,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"大正"),.era_format=tsc(u"%EC元年"),.era=tsc(u"+:1:1912//07//30:1912//12//31:大正:%EC元年")},{.direction=true,.offset=6,.start_date_year=1873,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=7,.end_date_day=29,.era_name=tsc(u"明治"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:6:1873//01//01:1912//07//29:明治:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1,.start_date_month=1,.start_date_day=1,.end_date_year=1872,.end_date_month=12,.end_date_day=31,.era_name=tsc(u"西暦"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:1:0001//01//01:1872//12//31:西暦:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=-1,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(u"紀元前"),.era_format=tsc(u"%EC%Ey年"),.era=tsc(u"+:1:-0001//12//31:-*:紀元前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char16_t> u16time_alt_digits_storage[]{tsc(u"〇"),tsc(u"一"),tsc(u"二"),tsc(u"三"),tsc(u"四"),tsc(u"五"),tsc(u"六"),tsc(u"七"),tsc(u"八"),tsc(u"九"),tsc(u"十"),tsc(u"十一"),tsc(u"十二"),tsc(u"十三"),tsc(u"十四"),tsc(u"十五"),tsc(u"十六"),tsc(u"十七"),tsc(u"十八"),tsc(u"十九"),tsc(u"二十"),tsc(u"二十一"),tsc(u"二十二"),tsc(u"二十三"),tsc(u"二十四"),tsc(u"二十五"),tsc(u"二十六"),tsc(u"二十七"),tsc(u"二十八"),tsc(u"二十九"),tsc(u"三十"),tsc(u"三十一"),tsc(u"三十二"),tsc(u"三十三"),tsc(u"三十四"),tsc(u"三十五"),tsc(u"三十六"),tsc(u"三十七"),tsc(u"三十八"),tsc(u"三十九"),tsc(u"四十"),tsc(u"四十一"),tsc(u"四十二"),tsc(u"四十三"),tsc(u"四十四"),tsc(u"四十五"),tsc(u"四十六"),tsc(u"四十七"),tsc(u"四十八"),tsc(u"四十九"),tsc(u"五十"),tsc(u"五十一"),tsc(u"五十二"),tsc(u"五十三"),tsc(u"五十四"),tsc(u"五十五"),tsc(u"五十六"),tsc(u"五十七"),tsc(u"五十八"),tsc(u"五十九"),tsc(u"六十"),tsc(u"六十一"),tsc(u"六十二"),tsc(u"六十三"),tsc(u"六十四"),tsc(u"六十五"),tsc(u"六十六"),tsc(u"六十七"),tsc(u"六十八"),tsc(u"六十九"),tsc(u"七十"),tsc(u"七十一"),tsc(u"七十二"),tsc(u"七十三"),tsc(u"七十四"),tsc(u"七十五"),tsc(u"七十六"),tsc(u"七十七"),tsc(u"七十八"),tsc(u"七十九"),tsc(u"八十"),tsc(u"八十一"),tsc(u"八十二"),tsc(u"八十三"),tsc(u"八十四"),tsc(u"八十五"),tsc(u"八十六"),tsc(u"八十七"),tsc(u"八十八"),tsc(u"八十九"),tsc(u"九十"),tsc(u"九十一"),tsc(u"九十二"),tsc(u"九十三"),tsc(u"九十四"),tsc(u"九十五"),tsc(u"九十六"),tsc(u"九十七"),tsc(u"九十八"),tsc(u"九十九")};

inline constexpr u16lc_all u16lc_all_global{.identification={.name=tsc(u"ja_JP"),.encoding=tsc(FAST_IO_LOCALE_uENCODING),.title=tsc(u"Japanese language locale for Japan"),.source=tsc(u"HANATAKA, Shinya, hanataka@abyss.rim.or.jp\t\t;\t\tfast_io"),.address=tsc(u"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(u"fast_io"),.email=tsc(u"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(u""),.fax=tsc(u""),.language=tsc(u"Japanese"),.territory=tsc(u"Japan"),.revision=tsc(u"1.0"),.date=tsc(u"2000-07-20")},.monetary={.int_curr_symbol=tsc(u"JPY "),.currency_symbol=tsc(u"￥"),.mon_decimal_point=tsc(u"."),.mon_thousands_sep=tsc(u","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(u""),.negative_sign=tsc(u"-"),.int_frac_digits=0,.frac_digits=0,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_sep_by_space=2,.int_n_sep_by_space=2,.p_sign_posn=4,.n_sign_posn=4},.numeric={.decimal_point=tsc(u"."),.thousands_sep=tsc(u","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(u"日"),tsc(u"月"),tsc(u"火"),tsc(u"水"),tsc(u"木"),tsc(u"金"),tsc(u"土")},.day={tsc(u"日曜日"),tsc(u"月曜日"),tsc(u"火曜日"),tsc(u"水曜日"),tsc(u"木曜日"),tsc(u"金曜日"),tsc(u"土曜日")},.abmon={tsc(u" 1月"),tsc(u" 2月"),tsc(u" 3月"),tsc(u" 4月"),tsc(u" 5月"),tsc(u" 6月"),tsc(u" 7月"),tsc(u" 8月"),tsc(u" 9月"),tsc(u"10月"),tsc(u"11月"),tsc(u"12月")},.mon={tsc(u"1月"),tsc(u"2月"),tsc(u"3月"),tsc(u"4月"),tsc(u"5月"),tsc(u"6月"),tsc(u"7月"),tsc(u"8月"),tsc(u"9月"),tsc(u"10月"),tsc(u"11月"),tsc(u"12月")},.d_t_fmt=tsc(u"%Y年%m月%d日 %H時%M分%S秒"),.d_fmt=tsc(u"%Y年%m月%d日"),.t_fmt=tsc(u"%H時%M分%S秒"),.t_fmt_ampm=tsc(u"%p%I時%M分%S秒"),.date_fmt=tsc(u"%Y年 %b %e日 %A %H:%M:%S %Z"),.am_pm={tsc(u"午前"),tsc(u"午後")},.era={u16time_era_storage,11},.era_d_fmt=tsc(u"%EY%m月%d日"),.era_d_t_fmt=tsc(u"%EY%m月%d日 %H時%M分%S秒"),.alt_digits={u16time_alt_digits_storage,100},.week={7,19971130,1}},.messages={.yesexpr=tsc(u"^([+1yYｙＹ]|はい|ハイ)"),.noexpr=tsc(u"^([-0nNｎＮ]|いいえ|イイエ)"),.yesstr=tsc(u"はい"),.nostr=tsc(u"いいえ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(u"+%c ;%a ;%l"),.int_select=tsc(u"010"),.int_prefix=tsc(u"81")},.name={.name_fmt=tsc(u"%p%t%f%t%g"),.name_gen=tsc(u"様"),.name_miss=tsc(u"Miss."),.name_mr=tsc(u"Mr."),.name_mrs=tsc(u"Mrs."),.name_ms=tsc(u"Ms.")},.address={.postal_fmt=tsc(u"%z%c%T%s%b%e%r"),.country_name=tsc(u"日本"),.country_ab2=tsc(u"JP"),.country_ab3=tsc(u"JPN"),.country_num=392,.country_car=tsc(u"J"),.lang_name=tsc(u"日本語"),.lang_ab=tsc(u"ja"),.lang_term=tsc(u"jpn"),.lang_lib=tsc(u"jpn")},.measurement={.measurement=1}};

inline constexpr basic_lc_time_era<char32_t> u32time_era_storage[]{{.direction=true,.offset=2,.start_date_year=2020,.start_date_month=1,.start_date_day=1,.end_date_special=1,.era_name=tsc(U"令和"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:2:2020//01//01:+*:令和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=2019,.start_date_month=5,.start_date_day=1,.end_date_year=2019,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"令和"),.era_format=tsc(U"%EC元年"),.era=tsc(U"+:1:2019//05//01:2019//12//31:令和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1990,.start_date_month=1,.start_date_day=1,.end_date_year=2019,.end_date_month=4,.end_date_day=30,.era_name=tsc(U"平成"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:2:1990//01//01:2019//04//30:平成:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1989,.start_date_month=1,.start_date_day=8,.end_date_year=1989,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"平成"),.era_format=tsc(U"%EC元年"),.era=tsc(U"+:1:1989//01//08:1989//12//31:平成:%EC元年")},{.direction=true,.offset=2,.start_date_year=1927,.start_date_month=1,.start_date_day=1,.end_date_year=1989,.end_date_month=1,.end_date_day=7,.era_name=tsc(U"昭和"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:2:1927//01//01:1989//01//07:昭和:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1926,.start_date_month=12,.start_date_day=25,.end_date_year=1926,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"昭和"),.era_format=tsc(U"%EC元年"),.era=tsc(U"+:1:1926//12//25:1926//12//31:昭和:%EC元年")},{.direction=true,.offset=2,.start_date_year=1913,.start_date_month=1,.start_date_day=1,.end_date_year=1926,.end_date_month=12,.end_date_day=24,.era_name=tsc(U"大正"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:2:1913//01//01:1926//12//24:大正:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1912,.start_date_month=7,.start_date_day=30,.end_date_year=1912,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"大正"),.era_format=tsc(U"%EC元年"),.era=tsc(U"+:1:1912//07//30:1912//12//31:大正:%EC元年")},{.direction=true,.offset=6,.start_date_year=1873,.start_date_month=1,.start_date_day=1,.end_date_year=1912,.end_date_month=7,.end_date_day=29,.era_name=tsc(U"明治"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:6:1873//01//01:1912//07//29:明治:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=1,.start_date_month=1,.start_date_day=1,.end_date_year=1872,.end_date_month=12,.end_date_day=31,.era_name=tsc(U"西暦"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:1:0001//01//01:1872//12//31:西暦:%EC%Ey年")},{.direction=true,.offset=1,.start_date_year=-1,.start_date_month=12,.start_date_day=31,.end_date_special=-1,.era_name=tsc(U"紀元前"),.era_format=tsc(U"%EC%Ey年"),.era=tsc(U"+:1:-0001//12//31:-*:紀元前:%EC%Ey年")}};

inline constexpr basic_io_scatter_t<char32_t> u32time_alt_digits_storage[]{tsc(U"〇"),tsc(U"一"),tsc(U"二"),tsc(U"三"),tsc(U"四"),tsc(U"五"),tsc(U"六"),tsc(U"七"),tsc(U"八"),tsc(U"九"),tsc(U"十"),tsc(U"十一"),tsc(U"十二"),tsc(U"十三"),tsc(U"十四"),tsc(U"十五"),tsc(U"十六"),tsc(U"十七"),tsc(U"十八"),tsc(U"十九"),tsc(U"二十"),tsc(U"二十一"),tsc(U"二十二"),tsc(U"二十三"),tsc(U"二十四"),tsc(U"二十五"),tsc(U"二十六"),tsc(U"二十七"),tsc(U"二十八"),tsc(U"二十九"),tsc(U"三十"),tsc(U"三十一"),tsc(U"三十二"),tsc(U"三十三"),tsc(U"三十四"),tsc(U"三十五"),tsc(U"三十六"),tsc(U"三十七"),tsc(U"三十八"),tsc(U"三十九"),tsc(U"四十"),tsc(U"四十一"),tsc(U"四十二"),tsc(U"四十三"),tsc(U"四十四"),tsc(U"四十五"),tsc(U"四十六"),tsc(U"四十七"),tsc(U"四十八"),tsc(U"四十九"),tsc(U"五十"),tsc(U"五十一"),tsc(U"五十二"),tsc(U"五十三"),tsc(U"五十四"),tsc(U"五十五"),tsc(U"五十六"),tsc(U"五十七"),tsc(U"五十八"),tsc(U"五十九"),tsc(U"六十"),tsc(U"六十一"),tsc(U"六十二"),tsc(U"六十三"),tsc(U"六十四"),tsc(U"六十五"),tsc(U"六十六"),tsc(U"六十七"),tsc(U"六十八"),tsc(U"六十九"),tsc(U"七十"),tsc(U"七十一"),tsc(U"七十二"),tsc(U"七十三"),tsc(U"七十四"),tsc(U"七十五"),tsc(U"七十六"),tsc(U"七十七"),tsc(U"七十八"),tsc(U"七十九"),tsc(U"八十"),tsc(U"八十一"),tsc(U"八十二"),tsc(U"八十三"),tsc(U"八十四"),tsc(U"八十五"),tsc(U"八十六"),tsc(U"八十七"),tsc(U"八十八"),tsc(U"八十九"),tsc(U"九十"),tsc(U"九十一"),tsc(U"九十二"),tsc(U"九十三"),tsc(U"九十四"),tsc(U"九十五"),tsc(U"九十六"),tsc(U"九十七"),tsc(U"九十八"),tsc(U"九十九")};

inline constexpr u32lc_all u32lc_all_global{.identification={.name=tsc(U"ja_JP"),.encoding=tsc(FAST_IO_LOCALE_UENCODING),.title=tsc(U"Japanese language locale for Japan"),.source=tsc(U"HANATAKA, Shinya, hanataka@abyss.rim.or.jp\t\t;\t\tfast_io"),.address=tsc(U"https://gitee.com/qabeowjbtkwb/fast_io\t\t;\t\thttps://github.com/cppfastio/fast_io"),.contact=tsc(U"fast_io"),.email=tsc(U"bug-glibc-locales@gnu.org;euloanty@live.com"),.tel=tsc(U""),.fax=tsc(U""),.language=tsc(U"Japanese"),.territory=tsc(U"Japan"),.revision=tsc(U"1.0"),.date=tsc(U"2000-07-20")},.monetary={.int_curr_symbol=tsc(U"JPY "),.currency_symbol=tsc(U"￥"),.mon_decimal_point=tsc(U"."),.mon_thousands_sep=tsc(U","),.mon_grouping={numeric_grouping_storage,1},.positive_sign=tsc(U""),.negative_sign=tsc(U"-"),.int_frac_digits=0,.frac_digits=0,.p_cs_precedes=1,.p_sep_by_space=0,.n_cs_precedes=1,.n_sep_by_space=0,.int_p_sep_by_space=2,.int_n_sep_by_space=2,.p_sign_posn=4,.n_sign_posn=4},.numeric={.decimal_point=tsc(U"."),.thousands_sep=tsc(U","),.grouping={numeric_grouping_storage,1}},.time={.abday={tsc(U"日"),tsc(U"月"),tsc(U"火"),tsc(U"水"),tsc(U"木"),tsc(U"金"),tsc(U"土")},.day={tsc(U"日曜日"),tsc(U"月曜日"),tsc(U"火曜日"),tsc(U"水曜日"),tsc(U"木曜日"),tsc(U"金曜日"),tsc(U"土曜日")},.abmon={tsc(U" 1月"),tsc(U" 2月"),tsc(U" 3月"),tsc(U" 4月"),tsc(U" 5月"),tsc(U" 6月"),tsc(U" 7月"),tsc(U" 8月"),tsc(U" 9月"),tsc(U"10月"),tsc(U"11月"),tsc(U"12月")},.mon={tsc(U"1月"),tsc(U"2月"),tsc(U"3月"),tsc(U"4月"),tsc(U"5月"),tsc(U"6月"),tsc(U"7月"),tsc(U"8月"),tsc(U"9月"),tsc(U"10月"),tsc(U"11月"),tsc(U"12月")},.d_t_fmt=tsc(U"%Y年%m月%d日 %H時%M分%S秒"),.d_fmt=tsc(U"%Y年%m月%d日"),.t_fmt=tsc(U"%H時%M分%S秒"),.t_fmt_ampm=tsc(U"%p%I時%M分%S秒"),.date_fmt=tsc(U"%Y年 %b %e日 %A %H:%M:%S %Z"),.am_pm={tsc(U"午前"),tsc(U"午後")},.era={u32time_era_storage,11},.era_d_fmt=tsc(U"%EY%m月%d日"),.era_d_t_fmt=tsc(U"%EY%m月%d日 %H時%M分%S秒"),.alt_digits={u32time_alt_digits_storage,100},.week={7,19971130,1}},.messages={.yesexpr=tsc(U"^([+1yYｙＹ]|はい|ハイ)"),.noexpr=tsc(U"^([-0nNｎＮ]|いいえ|イイエ)"),.yesstr=tsc(U"はい"),.nostr=tsc(U"いいえ")},.paper={.width=210,.height=297},.telephone={.tel_int_fmt=tsc(U"+%c ;%a ;%l"),.int_select=tsc(U"010"),.int_prefix=tsc(U"81")},.name={.name_fmt=tsc(U"%p%t%f%t%g"),.name_gen=tsc(U"様"),.name_miss=tsc(U"Miss."),.name_mr=tsc(U"Mr."),.name_mrs=tsc(U"Mrs."),.name_ms=tsc(U"Ms.")},.address={.postal_fmt=tsc(U"%z%c%T%s%b%e%r"),.country_name=tsc(U"日本"),.country_ab2=tsc(U"JP"),.country_ab3=tsc(U"JPN"),.country_num=392,.country_car=tsc(U"J"),.lang_name=tsc(U"日本語"),.lang_ab=tsc(U"ja"),.lang_term=tsc(U"jpn"),.lang_lib=tsc(U"jpn")},.measurement={.measurement=1}};


}
}

#include"../main.h"