﻿#pragma once
/*
Algorithm: Dragonbox
Author: Jk Jeon
Reference: Abolz
*/
namespace fast_io::details
{

struct uint32x2
{
std::uint_least32_t hi;
std::uint_least32_t lo;
};

struct uint64x2
{
std::uint_least64_t hi;
std::uint_least64_t lo;
};

inline constexpr std::uint_least64_t pow10_float32_tb[]
{
0x81ceb32c4b43fcf5, 0xa2425ff75e14fc32, 0xcad2f7f5359a3b3f, 0xfd87b5f28300ca0e,
0x9e74d1b791e07e49, 0xc612062576589ddb, 0xf79687aed3eec552, 0x9abe14cd44753b53,
0xc16d9a0095928a28, 0xf1c90080baf72cb2, 0x971da05074da7bef, 0xbce5086492111aeb,
0xec1e4a7db69561a6, 0x9392ee8e921d5d08, 0xb877aa3236a4b44a, 0xe69594bec44de15c,
0x901d7cf73ab0acda, 0xb424dc35095cd810, 0xe12e13424bb40e14, 0x8cbccc096f5088cc,
0xafebff0bcb24aaff, 0xdbe6fecebdedd5bf, 0x89705f4136b4a598, 0xabcc77118461cefd,
0xd6bf94d5e57a42bd, 0x8637bd05af6c69b6, 0xa7c5ac471b478424, 0xd1b71758e219652c,
0x83126e978d4fdf3c, 0xa3d70a3d70a3d70b, 0xcccccccccccccccd, 0x8000000000000000,
0xa000000000000000, 0xc800000000000000, 0xfa00000000000000, 0x9c40000000000000,
0xc350000000000000, 0xf424000000000000, 0x9896800000000000, 0xbebc200000000000,
0xee6b280000000000, 0x9502f90000000000, 0xba43b74000000000, 0xe8d4a51000000000,
0x9184e72a00000000, 0xb5e620f480000000, 0xe35fa931a0000000, 0x8e1bc9bf04000000,
0xb1a2bc2ec5000000, 0xde0b6b3a76400000, 0x8ac7230489e80000, 0xad78ebc5ac620000,
0xd8d726b7177a8000, 0x878678326eac9000, 0xa968163f0a57b400, 0xd3c21bcecceda100,
0x84595161401484a0, 0xa56fa5b99019a5c8, 0xcecb8f27f4200f3a, 0x813f3978f8940984,
0xa18f07d736b90be5, 0xc9f2c9cd04674ede, 0xfc6f7c4045812296, 0x9dc5ada82b70b59d,
0xc5371912364ce305, 0xf684df56c3e01bc6, 0x9a130b963a6c115c, 0xc097ce7bc90715b3,
0xf0bdc21abb48db20, 0x96769950b50d88f4, 0xbc143fa4e250eb31, 0xeb194f8e1ae525fd,
0x92efd1b8d0cf37be, 0xb7abc627050305ad, 0xe596b7b0c643c719, 0x8f7e32ce7bea5c6f,
0xb35dbf821ae4f38b, 0xe0352f62a19e306e
};

inline constexpr uint32x2 float_mod5_tb[]
{
{0x00000001u,0xFFFFFFFFu},
{0xCCCCCCCDu,0x33333333u},
{0xC28F5C29u,0x0A3D70A3u},
{0x26E978D5u,0x020C49BAu},
{0x3AFB7E91u,0x0068DB8Bu},
{0x0BCBE61Du,0x0014F8B5u},
{0x68C26139u,0x000431BDu},
{0xAE8D46A5u,0x0000D6BFu},
{0x22E90E21u,0x00002AF3u},
{0x3A2E9C6Du,0x00000897u},
{0x3ED61F49u,0x000001B7u}
};

inline constexpr auto compute_pow10_float32{pow10_float32_tb+31};

inline constexpr uint64x2 pow10_float64_tb[]
{
{0xFF77B1FCBEBCDC4F, 0x25E8E89C13BB0F7B},
{0x9FAACF3DF73609B1, 0x77B191618C54E9AD},
{0xC795830D75038C1D, 0xD59DF5B9EF6A2418},
{0xF97AE3D0D2446F25, 0x4B0573286B44AD1E},
{0x9BECCE62836AC577, 0x4EE367F9430AEC33},
{0xC2E801FB244576D5, 0x229C41F793CDA740},
{0xF3A20279ED56D48A, 0x6B43527578C11110},
{0x9845418C345644D6, 0x830A13896B78AAAA},
{0xBE5691EF416BD60C, 0x23CC986BC656D554},
{0xEDEC366B11C6CB8F, 0x2CBFBE86B7EC8AA9},
{0x94B3A202EB1C3F39, 0x7BF7D71432F3D6AA},
{0xB9E08A83A5E34F07, 0xDAF5CCD93FB0CC54},
{0xE858AD248F5C22C9, 0xD1B3400F8F9CFF69},
{0x91376C36D99995BE, 0x23100809B9C21FA2},
{0xB58547448FFFFB2D, 0xABD40A0C2832A78B},
{0xE2E69915B3FFF9F9, 0x16C90C8F323F516D},
{0x8DD01FAD907FFC3B, 0xAE3DA7D97F6792E4},
{0xB1442798F49FFB4A, 0x99CD11CFDF41779D},
{0xDD95317F31C7FA1D, 0x40405643D711D584},
{0x8A7D3EEF7F1CFC52, 0x482835EA666B2573},
{0xAD1C8EAB5EE43B66, 0xDA3243650005EED0},
{0xD863B256369D4A40, 0x90BED43E40076A83},
{0x873E4F75E2224E68, 0x5A7744A6E804A292},
{0xA90DE3535AAAE202, 0x711515D0A205CB37},
{0xD3515C2831559A83, 0x0D5A5B44CA873E04},
{0x8412D9991ED58091, 0xE858790AFE9486C3},
{0xA5178FFF668AE0B6, 0x626E974DBE39A873},
{0xCE5D73FF402D98E3, 0xFB0A3D212DC81290},
{0x80FA687F881C7F8E, 0x7CE66634BC9D0B9A},
{0xA139029F6A239F72, 0x1C1FFFC1EBC44E81},
{0xC987434744AC874E, 0xA327FFB266B56221},
{0xFBE9141915D7A922, 0x4BF1FF9F0062BAA9},
{0x9D71AC8FADA6C9B5, 0x6F773FC3603DB4AA},
{0xC4CE17B399107C22, 0xCB550FB4384D21D4},
{0xF6019DA07F549B2B, 0x7E2A53A146606A49},
{0x99C102844F94E0FB, 0x2EDA7444CBFC426E},
{0xC0314325637A1939, 0xFA911155FEFB5309},
{0xF03D93EEBC589F88, 0x793555AB7EBA27CB},
{0x96267C7535B763B5, 0x4BC1558B2F3458DF},
{0xBBB01B9283253CA2, 0x9EB1AAEDFB016F17},
{0xEA9C227723EE8BCB, 0x465E15A979C1CADD},
{0x92A1958A7675175F, 0x0BFACD89EC191ECA},
{0xB749FAED14125D36, 0xCEF980EC671F667C},
{0xE51C79A85916F484, 0x82B7E12780E7401B},
{0x8F31CC0937AE58D2, 0xD1B2ECB8B0908811},
{0xB2FE3F0B8599EF07, 0x861FA7E6DCB4AA16},
{0xDFBDCECE67006AC9, 0x67A791E093E1D49B},
{0x8BD6A141006042BD, 0xE0C8BB2C5C6D24E1},
{0xAECC49914078536D, 0x58FAE9F773886E19},
{0xDA7F5BF590966848, 0xAF39A475506A899F},
{0x888F99797A5E012D, 0x6D8406C952429604},
{0xAAB37FD7D8F58178, 0xC8E5087BA6D33B84},
{0xD5605FCDCF32E1D6, 0xFB1E4A9A90880A65},
{0x855C3BE0A17FCD26, 0x5CF2EEA09A550680},
{0xA6B34AD8C9DFC06F, 0xF42FAA48C0EA481F},
{0xD0601D8EFC57B08B, 0xF13B94DAF124DA27},
{0x823C12795DB6CE57, 0x76C53D08D6B70859},
{0xA2CB1717B52481ED, 0x54768C4B0C64CA6F},
{0xCB7DDCDDA26DA268, 0xA9942F5DCF7DFD0A},
{0xFE5D54150B090B02, 0xD3F93B35435D7C4D},
{0x9EFA548D26E5A6E1, 0xC47BC5014A1A6DB0},
{0xC6B8E9B0709F109A, 0x359AB6419CA1091C},
{0xF867241C8CC6D4C0, 0xC30163D203C94B63},
{0x9B407691D7FC44F8, 0x79E0DE63425DCF1E},
{0xC21094364DFB5636, 0x985915FC12F542E5},
{0xF294B943E17A2BC4, 0x3E6F5B7B17B2939E},
{0x979CF3CA6CEC5B5A, 0xA705992CEECF9C43},
{0xBD8430BD08277231, 0x50C6FF782A838354},
{0xECE53CEC4A314EBD, 0xA4F8BF5635246429},
{0x940F4613AE5ED136, 0x871B7795E136BE9A},
{0xB913179899F68584, 0x28E2557B59846E40},
{0xE757DD7EC07426E5, 0x331AEADA2FE589D0},
{0x9096EA6F3848984F, 0x3FF0D2C85DEF7622},
{0xB4BCA50B065ABE63, 0x0FED077A756B53AA},
{0xE1EBCE4DC7F16DFB, 0xD3E8495912C62895},
{0x8D3360F09CF6E4BD, 0x64712DD7ABBBD95D},
{0xB080392CC4349DEC, 0xBD8D794D96AACFB4},
{0xDCA04777F541C567, 0xECF0D7A0FC5583A1},
{0x89E42CAAF9491B60, 0xF41686C49DB57245},
{0xAC5D37D5B79B6239, 0x311C2875C522CED6},
{0xD77485CB25823AC7, 0x7D633293366B828C},
{0x86A8D39EF77164BC, 0xAE5DFF9C02033198},
{0xA8530886B54DBDEB, 0xD9F57F830283FDFD},
{0xD267CAA862A12D66, 0xD072DF63C324FD7C},
{0x8380DEA93DA4BC60, 0x4247CB9E59F71E6E},
{0xA46116538D0DEB78, 0x52D9BE85F074E609},
{0xCD795BE870516656, 0x67902E276C921F8C},
{0x806BD9714632DFF6, 0x00BA1CD8A3DB53B7},
{0xA086CFCD97BF97F3, 0x80E8A40ECCD228A5},
{0xC8A883C0FDAF7DF0, 0x6122CD128006B2CE},
{0xFAD2A4B13D1B5D6C, 0x796B805720085F82},
{0x9CC3A6EEC6311A63, 0xCBE3303674053BB1},
{0xC3F490AA77BD60FC, 0xBEDBFC4411068A9D},
{0xF4F1B4D515ACB93B, 0xEE92FB5515482D45},
{0x991711052D8BF3C5, 0x751BDD152D4D1C4B},
{0xBF5CD54678EEF0B6, 0xD262D45A78A0635E},
{0xEF340A98172AACE4, 0x86FB897116C87C35},
{0x9580869F0E7AAC0E, 0xD45D35E6AE3D4DA1},
{0xBAE0A846D2195712, 0x8974836059CCA10A},
{0xE998D258869FACD7, 0x2BD1A438703FC94C},
{0x91FF83775423CC06, 0x7B6306A34627DDD0},
{0xB67F6455292CBF08, 0x1A3BC84C17B1D543},
{0xE41F3D6A7377EECA, 0x20CABA5F1D9E4A94},
{0x8E938662882AF53E, 0x547EB47B7282EE9D},
{0xB23867FB2A35B28D, 0xE99E619A4F23AA44},
{0xDEC681F9F4C31F31, 0x6405FA00E2EC94D5},
{0x8B3C113C38F9F37E, 0xDE83BC408DD3DD05},
{0xAE0B158B4738705E, 0x9624AB50B148D446},
{0xD98DDAEE19068C76, 0x3BADD624DD9B0958},
{0x87F8A8D4CFA417C9, 0xE54CA5D70A80E5D7},
{0xA9F6D30A038D1DBC, 0x5E9FCF4CCD211F4D},
{0xD47487CC8470652B, 0x7647C32000696720},
{0x84C8D4DFD2C63F3B, 0x29ECD9F40041E074},
{0xA5FB0A17C777CF09, 0xF468107100525891},
{0xCF79CC9DB955C2CC, 0x7182148D4066EEB5},
{0x81AC1FE293D599BF, 0xC6F14CD848405531},
{0xA21727DB38CB002F, 0xB8ADA00E5A506A7D},
{0xCA9CF1D206FDC03B, 0xA6D90811F0E4851D},
{0xFD442E4688BD304A, 0x908F4A166D1DA664},
{0x9E4A9CEC15763E2E, 0x9A598E4E043287FF},
{0xC5DD44271AD3CDBA, 0x40EFF1E1853F29FE},
{0xF7549530E188C128, 0xD12BEE59E68EF47D},
{0x9A94DD3E8CF578B9, 0x82BB74F8301958CF},
{0xC13A148E3032D6E7, 0xE36A52363C1FAF02},
{0xF18899B1BC3F8CA1, 0xDC44E6C3CB279AC2},
{0x96F5600F15A7B7E5, 0x29AB103A5EF8C0BA},
{0xBCB2B812DB11A5DE, 0x7415D448F6B6F0E8},
{0xEBDF661791D60F56, 0x111B495B3464AD22},
{0x936B9FCEBB25C995, 0xCAB10DD900BEEC35},
{0xB84687C269EF3BFB, 0x3D5D514F40EEA743},
{0xE65829B3046B0AFA, 0x0CB4A5A3112A5113},
{0x8FF71A0FE2C2E6DC, 0x47F0E785EABA72AC},
{0xB3F4E093DB73A093, 0x59ED216765690F57},
{0xE0F218B8D25088B8, 0x306869C13EC3532D},
{0x8C974F7383725573, 0x1E414218C73A13FC},
{0xAFBD2350644EEACF, 0xE5D1929EF90898FB},
{0xDBAC6C247D62A583, 0xDF45F746B74ABF3A},
{0x894BC396CE5DA772, 0x6B8BBA8C328EB784},
{0xAB9EB47C81F5114F, 0x066EA92F3F326565},
{0xD686619BA27255A2, 0xC80A537B0EFEFEBE},
{0x8613FD0145877585, 0xBD06742CE95F5F37},
{0xA798FC4196E952E7, 0x2C48113823B73705},
{0xD17F3B51FCA3A7A0, 0xF75A15862CA504C6},
{0x82EF85133DE648C4, 0x9A984D73DBE722FC},
{0xA3AB66580D5FDAF5, 0xC13E60D0D2E0EBBB},
{0xCC963FEE10B7D1B3, 0x318DF905079926A9},
{0xFFBBCFE994E5C61F, 0xFDF17746497F7053},
{0x9FD561F1FD0F9BD3, 0xFEB6EA8BEDEFA634},
{0xC7CABA6E7C5382C8, 0xFE64A52EE96B8FC1},
{0xF9BD690A1B68637B, 0x3DFDCE7AA3C673B1},
{0x9C1661A651213E2D, 0x06BEA10CA65C084F},
{0xC31BFA0FE5698DB8, 0x486E494FCFF30A63},
{0xF3E2F893DEC3F126, 0x5A89DBA3C3EFCCFB},
{0x986DDB5C6B3A76B7, 0xF89629465A75E01D},
{0xBE89523386091465, 0xF6BBB397F1135824},
{0xEE2BA6C0678B597F, 0x746AA07DED582E2D},
{0x94DB483840B717EF, 0xA8C2A44EB4571CDD},
{0xBA121A4650E4DDEB, 0x92F34D62616CE414},
{0xE896A0D7E51E1566, 0x77B020BAF9C81D18},
{0x915E2486EF32CD60, 0x0ACE1474DC1D122F},
{0xB5B5ADA8AAFF80B8, 0x0D819992132456BB},
{0xE3231912D5BF60E6, 0x10E1FFF697ED6C6A},
{0x8DF5EFABC5979C8F, 0xCA8D3FFA1EF463C2},
{0xB1736B96B6FD83B3, 0xBD308FF8A6B17CB3},
{0xDDD0467C64BCE4A0, 0xAC7CB3F6D05DDBDF},
{0x8AA22C0DBEF60EE4, 0x6BCDF07A423AA96C},
{0xAD4AB7112EB3929D, 0x86C16C98D2C953C7},
{0xD89D64D57A607744, 0xE871C7BF077BA8B8},
{0x87625F056C7C4A8B, 0x11471CD764AD4973},
{0xA93AF6C6C79B5D2D, 0xD598E40D3DD89BD0},
{0xD389B47879823479, 0x4AFF1D108D4EC2C4},
{0x843610CB4BF160CB, 0xCEDF722A585139BB},
{0xA54394FE1EEDB8FE, 0xC2974EB4EE658829},
{0xCE947A3DA6A9273E, 0x733D226229FEEA33},
{0x811CCC668829B887, 0x0806357D5A3F5260},
{0xA163FF802A3426A8, 0xCA07C2DCB0CF26F8},
{0xC9BCFF6034C13052, 0xFC89B393DD02F0B6},
{0xFC2C3F3841F17C67, 0xBBAC2078D443ACE3},
{0x9D9BA7832936EDC0, 0xD54B944B84AA4C0E},
{0xC5029163F384A931, 0x0A9E795E65D4DF12},
{0xF64335BCF065D37D, 0x4D4617B5FF4A16D6},
{0x99EA0196163FA42E, 0x504BCED1BF8E4E46},
{0xC06481FB9BCF8D39, 0xE45EC2862F71E1D7},
{0xF07DA27A82C37088, 0x5D767327BB4E5A4D},
{0x964E858C91BA2655, 0x3A6A07F8D510F870},
{0xBBE226EFB628AFEA, 0x890489F70A55368C},
{0xEADAB0ABA3B2DBE5, 0x2B45AC74CCEA842F},
{0x92C8AE6B464FC96F, 0x3B0B8BC90012929E},
{0xB77ADA0617E3BBCB, 0x09CE6EBB40173745},
{0xE55990879DDCAABD, 0xCC420A6A101D0516},
{0x8F57FA54C2A9EAB6, 0x9FA946824A12232E},
{0xB32DF8E9F3546564, 0x47939822DC96ABFA},
{0xDFF9772470297EBD, 0x59787E2B93BC56F8},
{0x8BFBEA76C619EF36, 0x57EB4EDB3C55B65B},
{0xAEFAE51477A06B03, 0xEDE622920B6B23F2},
{0xDAB99E59958885C4, 0xE95FAB368E45ECEE},
{0x88B402F7FD75539B, 0x11DBCB0218EBB415},
{0xAAE103B5FCD2A881, 0xD652BDC29F26A11A},
{0xD59944A37C0752A2, 0x4BE76D3346F04960},
{0x857FCAE62D8493A5, 0x6F70A4400C562DDC},
{0xA6DFBD9FB8E5B88E, 0xCB4CCD500F6BB953},
{0xD097AD07A71F26B2, 0x7E2000A41346A7A8},
{0x825ECC24C873782F, 0x8ED400668C0C28C9},
{0xA2F67F2DFA90563B, 0x728900802F0F32FB},
{0xCBB41EF979346BCA, 0x4F2B40A03AD2FFBA},
{0xFEA126B7D78186BC, 0xE2F610C84987BFA9},
{0x9F24B832E6B0F436, 0x0DD9CA7D2DF4D7CA},
{0xC6EDE63FA05D3143, 0x91503D1C79720DBC},
{0xF8A95FCF88747D94, 0x75A44C6397CE912B},
{0x9B69DBE1B548CE7C, 0xC986AFBE3EE11ABB},
{0xC24452DA229B021B, 0xFBE85BADCE996169},
{0xF2D56790AB41C2A2, 0xFAE27299423FB9C4},
{0x97C560BA6B0919A5, 0xDCCD879FC967D41B},
{0xBDB6B8E905CB600F, 0x5400E987BBC1C921},
{0xED246723473E3813, 0x290123E9AAB23B69},
{0x9436C0760C86E30B, 0xF9A0B6720AAF6522},
{0xB94470938FA89BCE, 0xF808E40E8D5B3E6A},
{0xE7958CB87392C2C2, 0xB60B1D1230B20E05},
{0x90BD77F3483BB9B9, 0xB1C6F22B5E6F48C3},
{0xB4ECD5F01A4AA828, 0x1E38AEB6360B1AF4},
{0xE2280B6C20DD5232, 0x25C6DA63C38DE1B1},
{0x8D590723948A535F, 0x579C487E5A38AD0F},
{0xB0AF48EC79ACE837, 0x2D835A9DF0C6D852},
{0xDCDB1B2798182244, 0xF8E431456CF88E66},
{0x8A08F0F8BF0F156B, 0x1B8E9ECB641B5900},
{0xAC8B2D36EED2DAC5, 0xE272467E3D222F40},
{0xD7ADF884AA879177, 0x5B0ED81DCC6ABB10},
{0x86CCBB52EA94BAEA, 0x98E947129FC2B4EA},
{0xA87FEA27A539E9A5, 0x3F2398D747B36225},
{0xD29FE4B18E88640E, 0x8EEC7F0D19A03AAE},
{0x83A3EEEEF9153E89, 0x1953CF68300424AD},
{0xA48CEAAAB75A8E2B, 0x5FA8C3423C052DD8},
{0xCDB02555653131B6, 0x3792F412CB06794E},
{0x808E17555F3EBF11, 0xE2BBD88BBEE40BD1},
{0xA0B19D2AB70E6ED6, 0x5B6ACEAEAE9D0EC5},
{0xC8DE047564D20A8B, 0xF245825A5A445276},
{0xFB158592BE068D2E, 0xEED6E2F0F0D56713},
{0x9CED737BB6C4183D, 0x55464DD69685606C},
{0xC428D05AA4751E4C, 0xAA97E14C3C26B887},
{0xF53304714D9265DF, 0xD53DD99F4B3066A9},
{0x993FE2C6D07B7FAB, 0xE546A8038EFE402A},
{0xBF8FDB78849A5F96, 0xDE98520472BDD034},
{0xEF73D256A5C0F77C, 0x963E66858F6D4441},
{0x95A8637627989AAD, 0xDDE7001379A44AA9},
{0xBB127C53B17EC159, 0x5560C018580D5D53},
{0xE9D71B689DDE71AF, 0xAAB8F01E6E10B4A7},
{0x9226712162AB070D, 0xCAB3961304CA70E9},
{0xB6B00D69BB55C8D1, 0x3D607B97C5FD0D23},
{0xE45C10C42A2B3B05, 0x8CB89A7DB77C506B},
{0x8EB98A7A9A5B04E3, 0x77F3608E92ADB243},
{0xB267ED1940F1C61C, 0x55F038B237591ED4},
{0xDF01E85F912E37A3, 0x6B6C46DEC52F6689},
{0x8B61313BBABCE2C6, 0x2323AC4B3B3DA016},
{0xAE397D8AA96C1B77, 0xABEC975E0A0D081B},
{0xD9C7DCED53C72255, 0x96E7BD358C904A22},
{0x881CEA14545C7575, 0x7E50D64177DA2E55},
{0xAA242499697392D2, 0xDDE50BD1D5D0B9EA},
{0xD4AD2DBFC3D07787, 0x955E4EC64B44E865},
{0x84EC3C97DA624AB4, 0xBD5AF13BEF0B113F},
{0xA6274BBDD0FADD61, 0xECB1AD8AEACDD58F},
{0xCFB11EAD453994BA, 0x67DE18EDA5814AF3},
{0x81CEB32C4B43FCF4, 0x80EACF948770CED8},
{0xA2425FF75E14FC31, 0xA1258379A94D028E},
{0xCAD2F7F5359A3B3E, 0x096EE45813A04331},
{0xFD87B5F28300CA0D, 0x8BCA9D6E188853FD},
{0x9E74D1B791E07E48, 0x775EA264CF55347E},
{0xC612062576589DDA, 0x95364AFE032A819E},
{0xF79687AED3EEC551, 0x3A83DDBD83F52205},
{0x9ABE14CD44753B52, 0xC4926A9672793543},
{0xC16D9A0095928A27, 0x75B7053C0F178294},
{0xF1C90080BAF72CB1, 0x5324C68B12DD6339},
{0x971DA05074DA7BEE, 0xD3F6FC16EBCA5E04},
{0xBCE5086492111AEA, 0x88F4BB1CA6BCF585},
{0xEC1E4A7DB69561A5, 0x2B31E9E3D06C32E6},
{0x9392EE8E921D5D07, 0x3AFF322E62439FD0},
{0xB877AA3236A4B449, 0x09BEFEB9FAD487C3},
{0xE69594BEC44DE15B, 0x4C2EBE687989A9B4},
{0x901D7CF73AB0ACD9, 0x0F9D37014BF60A11},
{0xB424DC35095CD80F, 0x538484C19EF38C95},
{0xE12E13424BB40E13, 0x2865A5F206B06FBA},
{0x8CBCCC096F5088CB, 0xF93F87B7442E45D4},
{0xAFEBFF0BCB24AAFE, 0xF78F69A51539D749},
{0xDBE6FECEBDEDD5BE, 0xB573440E5A884D1C},
{0x89705F4136B4A597, 0x31680A88F8953031},
{0xABCC77118461CEFC, 0xFDC20D2B36BA7C3E},
{0xD6BF94D5E57A42BC, 0x3D32907604691B4D},
{0x8637BD05AF6C69B5, 0xA63F9A49C2C1B110},
{0xA7C5AC471B478423, 0x0FCF80DC33721D54},
{0xD1B71758E219652B, 0xD3C36113404EA4A9},
{0x83126E978D4FDF3B, 0x645A1CAC083126EA},
{0xA3D70A3D70A3D70A, 0x3D70A3D70A3D70A4},
{0xCCCCCCCCCCCCCCCC, 0xCCCCCCCCCCCCCCCD},
{0x8000000000000000, 0x0000000000000000},
{0xA000000000000000, 0x0000000000000000},
{0xC800000000000000, 0x0000000000000000},
{0xFA00000000000000, 0x0000000000000000},
{0x9C40000000000000, 0x0000000000000000},
{0xC350000000000000, 0x0000000000000000},
{0xF424000000000000, 0x0000000000000000},
{0x9896800000000000, 0x0000000000000000},
{0xBEBC200000000000, 0x0000000000000000},
{0xEE6B280000000000, 0x0000000000000000},
{0x9502F90000000000, 0x0000000000000000},
{0xBA43B74000000000, 0x0000000000000000},
{0xE8D4A51000000000, 0x0000000000000000},
{0x9184E72A00000000, 0x0000000000000000},
{0xB5E620F480000000, 0x0000000000000000},
{0xE35FA931A0000000, 0x0000000000000000},
{0x8E1BC9BF04000000, 0x0000000000000000},
{0xB1A2BC2EC5000000, 0x0000000000000000},
{0xDE0B6B3A76400000, 0x0000000000000000},
{0x8AC7230489E80000, 0x0000000000000000},
{0xAD78EBC5AC620000, 0x0000000000000000},
{0xD8D726B7177A8000, 0x0000000000000000},
{0x878678326EAC9000, 0x0000000000000000},
{0xA968163F0A57B400, 0x0000000000000000},
{0xD3C21BCECCEDA100, 0x0000000000000000},
{0x84595161401484A0, 0x0000000000000000},
{0xA56FA5B99019A5C8, 0x0000000000000000},
{0xCECB8F27F4200F3A, 0x0000000000000000},
{0x813F3978F8940984, 0x4000000000000000},
{0xA18F07D736B90BE5, 0x5000000000000000},
{0xC9F2C9CD04674EDE, 0xA400000000000000},
{0xFC6F7C4045812296, 0x4D00000000000000},
{0x9DC5ADA82B70B59D, 0xF020000000000000},
{0xC5371912364CE305, 0x6C28000000000000},
{0xF684DF56C3E01BC6, 0xC732000000000000},
{0x9A130B963A6C115C, 0x3C7F400000000000},
{0xC097CE7BC90715B3, 0x4B9F100000000000},
{0xF0BDC21ABB48DB20, 0x1E86D40000000000},
{0x96769950B50D88F4, 0x1314448000000000},
{0xBC143FA4E250EB31, 0x17D955A000000000},
{0xEB194F8E1AE525FD, 0x5DCFAB0800000000},
{0x92EFD1B8D0CF37BE, 0x5AA1CAE500000000},
{0xB7ABC627050305AD, 0xF14A3D9E40000000},
{0xE596B7B0C643C719, 0x6D9CCD05D0000000},
{0x8F7E32CE7BEA5C6F, 0xE4820023A2000000},
{0xB35DBF821AE4F38B, 0xDDA2802C8A800000},
{0xE0352F62A19E306E, 0xD50B2037AD200000},
{0x8C213D9DA502DE45, 0x4526F422CC340000},
{0xAF298D050E4395D6, 0x9670B12B7F410000},
{0xDAF3F04651D47B4C, 0x3C0CDD765F114000},
{0x88D8762BF324CD0F, 0xA5880A69FB6AC800},
{0xAB0E93B6EFEE0053, 0x8EEA0D047A457A00},
{0xD5D238A4ABE98068, 0x72A4904598D6D880},
{0x85A36366EB71F041, 0x47A6DA2B7F864750},
{0xA70C3C40A64E6C51, 0x999090B65F67D924},
{0xD0CF4B50CFE20765, 0xFFF4B4E3F741CF6D},
{0x82818F1281ED449F, 0xBFF8F10E7A8921A4},
{0xA321F2D7226895C7, 0xAFF72D52192B6A0D},
{0xCBEA6F8CEB02BB39, 0x9BF4F8A69F764490},
{0xFEE50B7025C36A08, 0x02F236D04753D5B4},
{0x9F4F2726179A2245, 0x01D762422C946590},
{0xC722F0EF9D80AAD6, 0x424D3AD2B7B97EF5},
{0xF8EBAD2B84E0D58B, 0xD2E0898765A7DEB2},
{0x9B934C3B330C8577, 0x63CC55F49F88EB2F},
{0xC2781F49FFCFA6D5, 0x3CBF6B71C76B25FB},
{0xF316271C7FC3908A, 0x8BEF464E3945EF7A},
{0x97EDD871CFDA3A56, 0x97758BF0E3CBB5AC},
{0xBDE94E8E43D0C8EC, 0x3D52EEED1CBEA317},
{0xED63A231D4C4FB27, 0x4CA7AAA863EE4BDD},
{0x945E455F24FB1CF8, 0x8FE8CAA93E74EF6A},
{0xB975D6B6EE39E436, 0xB3E2FD538E122B44},
{0xE7D34C64A9C85D44, 0x60DBBCA87196B616},
{0x90E40FBEEA1D3A4A, 0xBC8955E946FE31CD},
{0xB51D13AEA4A488DD, 0x6BABAB6398BDBE41},
{0xE264589A4DCDAB14, 0xC696963C7EED2DD1},
{0x8D7EB76070A08AEC, 0xFC1E1DE5CF543CA2},
{0xB0DE65388CC8ADA8, 0x3B25A55F43294BCB},
{0xDD15FE86AFFAD912, 0x49EF0EB713F39EBE},
{0x8A2DBF142DFCC7AB, 0x6E3569326C784337},
{0xACB92ED9397BF996, 0x49C2C37F07965404},
{0xD7E77A8F87DAF7FB, 0xDC33745EC97BE906},
{0x86F0AC99B4E8DAFD, 0x69A028BB3DED71A3},
{0xA8ACD7C0222311BC, 0xC40832EA0D68CE0C},
{0xD2D80DB02AABD62B, 0xF50A3FA490C30190},
{0x83C7088E1AAB65DB, 0x792667C6DA79E0FA},
{0xA4B8CAB1A1563F52, 0x577001B891185938},
{0xCDE6FD5E09ABCF26, 0xED4C0226B55E6F86},
{0x80B05E5AC60B6178, 0x544F8158315B05B4},
{0xA0DC75F1778E39D6, 0x696361AE3DB1C721},
{0xC913936DD571C84C, 0x03BC3A19CD1E38E9},
{0xFB5878494ACE3A5F, 0x04AB48A04065C723},
{0x9D174B2DCEC0E47B, 0x62EB0D64283F9C76},
{0xC45D1DF942711D9A, 0x3BA5D0BD324F8394},
{0xF5746577930D6500, 0xCA8F44EC7EE36479},
{0x9968BF6ABBE85F20, 0x7E998B13CF4E1ECB},
{0xBFC2EF456AE276E8, 0x9E3FEDD8C321A67E},
{0xEFB3AB16C59B14A2, 0xC5CFE94EF3EA101E},
{0x95D04AEE3B80ECE5, 0xBBA1F1D158724A12},
{0xBB445DA9CA61281F, 0x2A8A6E45AE8EDC97},
{0xEA1575143CF97226, 0xF52D09D71A3293BD},
{0x924D692CA61BE758, 0x593C2626705F9C56},
{0xB6E0C377CFA2E12E, 0x6F8B2FB00C77836C},
{0xE498F455C38B997A, 0x0B6DFB9C0F956447},
{0x8EDF98B59A373FEC, 0x4724BD4189BD5EAC},
{0xB2977EE300C50FE7, 0x58EDEC91EC2CB657},
{0xDF3D5E9BC0F653E1, 0x2F2967B66737E3ED},
{0x8B865B215899F46C, 0xBD79E0D20082EE74},
{0xAE67F1E9AEC07187, 0xECD8590680A3AA11},
{0xDA01EE641A708DE9, 0xE80E6F4820CC9495},
{0x884134FE908658B2, 0x3109058D147FDCDD},
{0xAA51823E34A7EEDE, 0xBD4B46F0599FD415},
{0xD4E5E2CDC1D1EA96, 0x6C9E18AC7007C91A},
{0x850FADC09923329E, 0x03E2CF6BC604DDB0},
{0xA6539930BF6BFF45, 0x84DB8346B786151C},
{0xCFE87F7CEF46FF16, 0xE612641865679A63},
{0x81F14FAE158C5F6E, 0x4FCB7E8F3F60C07E},
{0xA26DA3999AEF7749, 0xE3BE5E330F38F09D},
{0xCB090C8001AB551C, 0x5CADF5BFD3072CC5},
{0xFDCB4FA002162A63, 0x73D9732FC7C8F7F6},
{0x9E9F11C4014DDA7E, 0x2867E7FDDCDD9AFA},
{0xC646D63501A1511D, 0xB281E1FD541501B8},
{0xF7D88BC24209A565, 0x1F225A7CA91A4226},
{0x9AE757596946075F, 0x3375788DE9B06958},
{0xC1A12D2FC3978937, 0x0052D6B1641C83AE},
{0xF209787BB47D6B84, 0xC0678C5DBD23A49A},
{0x9745EB4D50CE6332, 0xF840B7BA963646E0},
{0xBD176620A501FBFF, 0xB650E5A93BC3D898},
{0xEC5D3FA8CE427AFF, 0xA3E51F138AB4CEBE},
{0x93BA47C980E98CDF, 0xC66F336C36B10137},
{0xB8A8D9BBE123F017, 0xB80B0047445D4184},
{0xE6D3102AD96CEC1D, 0xA60DC059157491E5},
{0x9043EA1AC7E41392, 0x87C89837AD68DB2F},
{0xB454E4A179DD1877, 0x29BABE4598C311FB},
{0xE16A1DC9D8545E94, 0xF4296DD6FEF3D67A},
{0x8CE2529E2734BB1D, 0x1899E4A65F58660C},
{0xB01AE745B101E9E4, 0x5EC05DCFF72E7F8F},
{0xDC21A1171D42645D, 0x76707543F4FA1F73},
{0x899504AE72497EBA, 0x6A06494A791C53A8},
{0xABFA45DA0EDBDE69, 0x0487DB9D17636892},
{0xD6F8D7509292D603, 0x45A9D2845D3C42B6},
{0x865B86925B9BC5C2, 0x0B8A2392BA45A9B2},
{0xA7F26836F282B732, 0x8E6CAC7768D7141E},
{0xD1EF0244AF2364FF, 0x3207D795430CD926},
{0x8335616AED761F1F, 0x7F44E6BD49E807B8},
{0xA402B9C5A8D3A6E7, 0x5F16206C9C6209A6},
{0xCD036837130890A1, 0x36DBA887C37A8C0F},
{0x802221226BE55A64, 0xC2494954DA2C9789},
{0xA02AA96B06DEB0FD, 0xF2DB9BAA10B7BD6C},
{0xC83553C5C8965D3D, 0x6F92829494E5ACC7},
{0xFA42A8B73ABBF48C, 0xCB772339BA1F17F9},
{0x9C69A97284B578D7, 0xFF2A760414536EFB},
{0xC38413CF25E2D70D, 0xFEF5138519684ABA},
{0xF46518C2EF5B8CD1, 0x7EB258665FC25D69},
{0x98BF2F79D5993802, 0xEF2F773FFBD97A61},
{0xBEEEFB584AFF8603, 0xAAFB550FFACFD8FA},
{0xEEAABA2E5DBF6784, 0x95BA2A53F983CF38},
{0x952AB45CFA97A0B2, 0xDD945A747BF26183},
{0xBA756174393D88DF, 0x94F971119AEEF9E4},
{0xE912B9D1478CEB17, 0x7A37CD5601AAB85D},
{0x91ABB422CCB812EE, 0xAC62E055C10AB33A},
{0xB616A12B7FE617AA, 0x577B986B314D6009},
{0xE39C49765FDF9D94, 0xED5A7E85FDA0B80B},
{0x8E41ADE9FBEBC27D, 0x14588F13BE847307},
{0xB1D219647AE6B31C, 0x596EB2D8AE258FC8},
{0xDE469FBD99A05FE3, 0x6FCA5F8ED9AEF3BB},
{0x8AEC23D680043BEE, 0x25DE7BB9480D5854},
{0xADA72CCC20054AE9, 0xAF561AA79A10AE6A},
{0xD910F7FF28069DA4, 0x1B2BA1518094DA04},
{0x87AA9AFF79042286, 0x90FB44D2F05D0842},
{0xA99541BF57452B28, 0x353A1607AC744A53},
{0xD3FA922F2D1675F2, 0x42889B8997915CE8},
{0x847C9B5D7C2E09B7, 0x69956135FEBADA11},
{0xA59BC234DB398C25, 0x43FAB9837E699095},
{0xCF02B2C21207EF2E, 0x94F967E45E03F4BB},
{0x8161AFB94B44F57D, 0x1D1BE0EEBAC278F5},
{0xA1BA1BA79E1632DC, 0x6462D92A69731732},
{0xCA28A291859BBF93, 0x7D7B8F7503CFDCFE},
{0xFCB2CB35E702AF78, 0x5CDA735244C3D43E},
{0x9DEFBF01B061ADAB, 0x3A0888136AFA64A7},
{0xC56BAEC21C7A1916, 0x088AAA1845B8FDD0},
{0xF6C69A72A3989F5B, 0x8AAD549E57273D45},
{0x9A3C2087A63F6399, 0x36AC54E2F678864B},
{0xC0CB28A98FCF3C7F, 0x84576A1BB416A7DD},
{0xF0FDF2D3F3C30B9F, 0x656D44A2A11C51D5},
{0x969EB7C47859E743, 0x9F644AE5A4B1B325},
{0xBC4665B596706114, 0x873D5D9F0DDE1FEE},
{0xEB57FF22FC0C7959, 0xA90CB506D155A7EA},
{0x9316FF75DD87CBD8, 0x09A7F12442D588F2},
{0xB7DCBF5354E9BECE, 0x0C11ED6D538AEB2F},
{0xE5D3EF282A242E81, 0x8F1668C8A86DA5FA},
{0x8FA475791A569D10, 0xF96E017D694487BC},
{0xB38D92D760EC4455, 0x37C981DCC395A9AC},
{0xE070F78D3927556A, 0x85BBE253F47B1417},
{0x8C469AB843B89562, 0x93956D7478CCEC8E},
{0xAF58416654A6BABB, 0x387AC8D1970027B2},
{0xDB2E51BFE9D0696A, 0x06997B05FCC0319E},
{0x88FCF317F22241E2, 0x441FECE3BDF81F03},
{0xAB3C2FDDEEAAD25A, 0xD527E81CAD7626C3},
{0xD60B3BD56A5586F1, 0x8A71E223D8D3B074},
{0x85C7056562757456, 0xF6872D5667844E49},
{0xA738C6BEBB12D16C, 0xB428F8AC016561DB},
{0xD106F86E69D785C7, 0xE13336D701BEBA52},
{0x82A45B450226B39C, 0xECC0024661173473},
{0xA34D721642B06084, 0x27F002D7F95D0190},
{0xCC20CE9BD35C78A5, 0x31EC038DF7B441F4},
{0xFF290242C83396CE, 0x7E67047175A15271},
{0x9F79A169BD203E41, 0x0F0062C6E984D386},
{0xC75809C42C684DD1, 0x52C07B78A3E60868},
{0xF92E0C3537826145, 0xA7709A56CCDF8A82},
{0x9BBCC7A142B17CCB, 0x88A66076400BB691},
{0xC2ABF989935DDBFE, 0x6ACFF893D00EA435},
{0xF356F7EBF83552FE, 0x0583F6B8C4124D43},
{0x98165AF37B2153DE, 0xC3727A337A8B704A},
{0xBE1BF1B059E9A8D6, 0x744F18C0592E4C5C},
{0xEDA2EE1C7064130C, 0x1162DEF06F79DF73},
{0x9485D4D1C63E8BE7, 0x8ADDCB5645AC2BA8},
{0xB9A74A0637CE2EE1, 0x6D953E2BD7173692},
{0xE8111C87C5C1BA99, 0xC8FA8DB6CCDD0437},
{0x910AB1D4DB9914A0, 0x1D9C9892400A22A2},
{0xB54D5E4A127F59C8, 0x2503BEB6D00CAB4B},
{0xE2A0B5DC971F303A, 0x2E44AE64840FD61D},
{0x8DA471A9DE737E24, 0x5CEAECFED289E5D2},
{0xB10D8E1456105DAD, 0x7425A83E872C5F47},
{0xDD50F1996B947518, 0xD12F124E28F77719},
{0x8A5296FFE33CC92F, 0x82BD6B70D99AAA6F},
{0xACE73CBFDC0BFB7B, 0x636CC64D1001550B},
{0xD8210BEFD30EFA5A, 0x3C47F7E05401AA4E},
{0x8714A775E3E95C78, 0x65ACFAEC34810A71},
{0xA8D9D1535CE3B396, 0x7F1839A741A14D0D},
{0xD31045A8341CA07C, 0x1EDE48111209A050},
{0x83EA2B892091E44D, 0x934AED0AAB460432},
{0xA4E4B66B68B65D60, 0xF81DA84D5617853F},
{0xCE1DE40642E3F4B9, 0x36251260AB9D668E},
{0x80D2AE83E9CE78F3, 0xC1D72B7C6B426019},
{0xA1075A24E4421730, 0xB24CF65B8612F81F},
{0xC94930AE1D529CFC, 0xDEE033F26797B627},
{0xFB9B7CD9A4A7443C, 0x169840EF017DA3B1},
{0x9D412E0806E88AA5, 0x8E1F289560EE864E},
{0xC491798A08A2AD4E, 0xF1A6F2BAB92A27E2},
{0xF5B5D7EC8ACB58A2, 0xAE10AF696774B1DB},
{0x9991A6F3D6BF1765, 0xACCA6DA1E0A8EF29},
{0xBFF610B0CC6EDD3F, 0x17FD090A58D32AF3},
{0xEFF394DCFF8A948E, 0xDDFC4B4CEF07F5B0},
{0x95F83D0A1FB69CD9, 0x4ABDAF101564F98E},
{0xBB764C4CA7A4440F, 0x9D6D1AD41ABE37F1},
{0xEA53DF5FD18D5513, 0x84C86189216DC5ED},
{0x92746B9BE2F8552C, 0x32FD3CF5B4E49BB4},
{0xB7118682DBB66A77, 0x3FBC8C33221DC2A1},
{0xE4D5E82392A40515, 0x0FABAF3FEAA5334A},
{0x8F05B1163BA6832D, 0x29CB4D87F2A7400E},
{0xB2C71D5BCA9023F8, 0x743E20E9EF511012},
{0xDF78E4B2BD342CF6, 0x914DA9246B255416},
{0x8BAB8EEFB6409C1A, 0x1AD089B6C2F7548E},
{0xAE9672ABA3D0C320, 0xA184AC2473B529B1},
{0xDA3C0F568CC4F3E8, 0xC9E5D72D90A2741E},
{0x8865899617FB1871, 0x7E2FA67C7A658892},
{0xAA7EEBFB9DF9DE8D, 0xDDBB901B98FEEAB7},
{0xD51EA6FA85785631, 0x552A74227F3EA565},
{0x8533285C936B35DE, 0xD53A88958F87275F},
{0xA67FF273B8460356, 0x8A892ABAF368F137},
{0xD01FEF10A657842C, 0x2D2B7569B0432D85},
{0x8213F56A67F6B29B, 0x9C3B29620E29FC73},
{0xA298F2C501F45F42, 0x8349F3BA91B47B8F},
{0xCB3F2F7642717713, 0x241C70A936219A73},
{0xFE0EFB53D30DD4D7, 0xED238CD383AA0110},
{0x9EC95D1463E8A506, 0xF4363804324A40AA},
{0xC67BB4597CE2CE48, 0xB143C6053EDCD0D5},
{0xF81AA16FDC1B81DA, 0xDD94B7868E94050A},
{0x9B10A4E5E9913128, 0xCA7CF2B4191C8326},
{0xC1D4CE1F63F57D72, 0xFD1C2F611F63A3F0},
{0xF24A01A73CF2DCCF, 0xBC633B39673C8CEC},
{0x976E41088617CA01, 0xD5BE0503E085D813},
{0xBD49D14AA79DBC82, 0x4B2D8644D8A74E18},
{0xEC9C459D51852BA2, 0xDDF8E7D60ED1219E},
{0x93E1AB8252F33B45, 0xCABB90E5C942B503},
{0xB8DA1662E7B00A17, 0x3D6A751F3B936243},
{0xE7109BFBA19C0C9D, 0x0CC512670A783AD4},
{0x906A617D450187E2, 0x27FB2B80668B24C5},
{0xB484F9DC9641E9DA, 0xB1F9F660802DEDF6},
{0xE1A63853BBD26451, 0x5E7873F8A0396973},
{0x8D07E33455637EB2, 0xDB0B487B6423E1E8},
{0xB049DC016ABC5E5F, 0x91CE1A9A3D2CDA62},
{0xDC5C5301C56B75F7, 0x7641A140CC7810FB},
{0x89B9B3E11B6329BA, 0xA9E904C87FCB0A9D},
{0xAC2820D9623BF429, 0x546345FA9FBDCD44},
{0xD732290FBACAF133, 0xA97C177947AD4095},
{0x867F59A9D4BED6C0, 0x49ED8EABCCCC485D},
{0xA81F301449EE8C70, 0x5C68F256BFFF5A74},
{0xD226FC195C6A2F8C, 0x73832EEC6FFF3111},
{0x83585D8FD9C25DB7, 0xC831FD53C5FF7EAB},
{0xA42E74F3D032F525, 0xBA3E7CA8B77F5E55},
{0xCD3A1230C43FB26F, 0x28CE1BD2E55F35EB},
{0x80444B5E7AA7CF85, 0x7980D163CF5B81B3},
{0xA0555E361951C366, 0xD7E105BCC332621F},
{0xC86AB5C39FA63440, 0x8DD9472BF3FEFAA7},
{0xFA856334878FC150, 0xB14F98F6F0FEB951},
{0x9C935E00D4B9D8D2, 0x6ED1BF9A569F33D3},
{0xC3B8358109E84F07, 0x0A862F80EC4700C8},
{0xF4A642E14C6262C8, 0xCD27BB612758C0FA},
{0x98E7E9CCCFBD7DBD, 0x8038D51CB897789C},
{0xBF21E44003ACDD2C, 0xE0470A63E6BD56C3},
{0xEEEA5D5004981478, 0x1858CCFCE06CAC74},
{0x95527A5202DF0CCB, 0x0F37801E0C43EBC8},
{0xBAA718E68396CFFD, 0xD30560258F54E6BA},
{0xE950DF20247C83FD, 0x47C6B82EF32A2069},
{0x91D28B7416CDD27E, 0x4CDC331D57FA5441},
{0xB6472E511C81471D, 0xE0133FE4ADF8E952},
{0xE3D8F9E563A198E5, 0x58180FDDD97723A6},
{0x8E679C2F5E44FF8F, 0x570F09EAA7EA7648},
{0xB201833B35D63F73, 0x2CD2CC6551E513DA},
{0xDE81E40A034BCF4F, 0xF8077F7EA65E58D1},
{0x8B112E86420F6191, 0xFB04AFAF27FAF782},
{0xADD57A27D29339F6, 0x79C5DB9AF1F9B563},
{0xD94AD8B1C7380874, 0x18375281AE7822BC},
{0x87CEC76F1C830548, 0x8F2293910D0B15B5},
{0xA9C2794AE3A3C69A, 0xB2EB3875504DDB22},
{0xD433179D9C8CB841, 0x5FA60692A46151EB},
{0x849FEEC281D7F328, 0xDBC7C41BA6BCD333},
{0xA5C7EA73224DEFF3, 0x12B9B522906C0800},
{0xCF39E50FEAE16BEF, 0xD768226B34870A00},
{0x81842F29F2CCE375, 0xE6A1158300D46640},
{0xA1E53AF46F801C53, 0x60495AE3C1097FD0},
{0xCA5E89B18B602368, 0x385BB19CB14BDFC4},
{0xFCF62C1DEE382C42, 0x46729E03DD9ED7B5},
{0x9E19DB92B4E31BA9, 0x6C07A2C26A8346D1},
{0xC5A05277621BE293, 0xC7098B7305241885},
{0xF70867153AA2DB38, 0xB8CBEE4FC66D1EA7}
};

inline constexpr uint64x2 float64_mod5_tb[]
{
{0x0000000000000001u, 0xFFFFFFFFFFFFFFFFu}, // 5^0
{0xCCCCCCCCCCCCCCCDu, 0x3333333333333333u}, // 5^1
{0x8F5C28F5C28F5C29u, 0x0A3D70A3D70A3D70u}, // 5^2
{0x1CAC083126E978D5u, 0x020C49BA5E353F7Cu}, // 5^3
{0xD288CE703AFB7E91u, 0x0068DB8BAC710CB2u}, // 5^4
{0x5D4E8FB00BCBE61Du, 0x0014F8B588E368F0u}, // 5^5
{0x790FB65668C26139u, 0x000431BDE82D7B63u}, // 5^6
{0xE5032477AE8D46A5u, 0x0000D6BF94D5E57Au}, // 5^7
{0xC767074B22E90E21u, 0x00002AF31DC46118u}, // 5^8
{0x8E47CE423A2E9C6Du, 0x0000089705F4136Bu}, // 5^9
{0x4FA7F60D3ED61F49u, 0x000001B7CDFD9D7Bu}, // 5^10
{0x0FEE64690C913975u, 0x00000057F5FF85E5u}, // 5^11
{0x3662E0E1CF503EB1u, 0x000000119799812Du}, // 5^12
{0xA47A2CF9F6433FBDu, 0x0000000384B84D09u}, // 5^13
{0x54186F653140A659u, 0x00000000B424DC35u}, // 5^14
{0x7738164770402145u, 0x0000000024075F3Du}, // 5^15
{0xE4A4D1417CD9A041u, 0x000000000734ACA5u}, // 5^16
{0xC75429D9E5C5200Du, 0x000000000170EF54u}, // 5^17
{0xC1773B91FAC10669u, 0x000000000049C977u}, // 5^18
{0x26B172506559CE15u, 0x00000000000EC1E4u}, // 5^19
{0xD489E3A9ADDEC2D1u, 0x000000000002F394u}, // 5^20
{0x90E860BB892C8D5Du, 0x000000000000971Du}, // 5^21
{0x502E79BF1B6F4F79u, 0x0000000000001E39u}, // 5^22
{0xDCD618596BE30FE5u, 0x000000000000060Bu} // 5^23
};

inline constexpr auto compute_pow10_float64{pow10_float64_tb+292};

template<typename mantissa_type>
struct m10_result
{
	mantissa_type m10;
	std::int_least32_t e10;
};

inline constexpr std::int_least32_t mul_ln2_div_ln10_floor(std::int_least32_t e) noexcept
{
	return (e*1262611)>>22;
}

inline constexpr std::int_least32_t mul_ln10_div_ln2_floor(std::int_least32_t e) noexcept
{
	return (e*1741647)>>19;
}

inline constexpr std::uint_least64_t mulshift_float64(std::uint_least64_t x,std::uint_least64_t ylow,std::uint_least64_t yhigh) noexcept
{
	std::uint_least64_t p0high{intrinsics::umul_least64_high(x,ylow)};
	std::uint_least64_t p1high;
	std::uint_least64_t p1low{intrinsics::umul(x,yhigh,p1high)};
	constexpr std::uint_least64_t zero{};
	intrinsics::add_carry(intrinsics::add_carry(false,p1low,p0high,p1low),p1high,zero,p1high);
	return p1high;
}

inline constexpr std::uint_least32_t mulshift_float32(std::uint_least32_t x,std::uint_least64_t y) noexcept
{
	return static_cast<std::uint_least32_t>(intrinsics::umul_least64_high(x,y));
}

inline constexpr bool mul_parity_float64(std::uint_least64_t two_f,std::uint_least64_t pow10_low,std::uint_least64_t pow10_high,std::int_least32_t beta_minus_1) noexcept
{
	std::uint_least64_t const p01{two_f * pow10_high};
	std::uint_least64_t const p10{intrinsics::umul_least64_high(two_f,pow10_low)};
	std::uint_least64_t const mid{p01 + p10};
	constexpr std::uint_least64_t one{1};
	return (mid & (one << (64 - beta_minus_1)));
}

inline constexpr bool mul_parity_float32(std::uint_least64_t two_f,std::uint_least64_t pow10,std::int_least32_t beta_minus_1) noexcept
{
	std::uint_least64_t const p01{two_f * pow10};
	constexpr std::uint_least64_t one{1};
	return (p01 & (one << (64 - beta_minus_1)));
}

template<my_unsigned_integral value_type>
inline constexpr bool multiple_of_pow2_unchecked(value_type value,std::uint_least32_t e2) noexcept
{
	constexpr value_type one{1};
	return !(value & ((one << e2) - 1));
}

template<my_unsigned_integral value_type>
inline constexpr bool multiple_of_pow2(value_type value,std::int_least32_t e2) noexcept
{
	constexpr std::int_least32_t e2max_bits{static_cast<std::int_least32_t>(sizeof(value_type)*8)};
	return e2 < e2max_bits && multiple_of_pow2_unchecked(value,static_cast<std::uint_least32_t>(e2));
}

inline constexpr bool multiple_of_pow5(std::uint_least64_t value,std::uint_least32_t e5) noexcept
{
	auto m5{float64_mod5_tb[e5]};
	return value*m5.hi <= m5.lo;
}

inline constexpr bool is_integral_end_point(std::uint_least64_t two_f,std::int_least32_t e2,std::int_least32_t minus_k) noexcept
{
	if(e2<-2)
		return false;
	if(e2<=9)
		return true;
	if(e2<=86)
		return multiple_of_pow5(two_f, static_cast<std::uint_least32_t>(minus_k));
	return false;
}

inline constexpr bool is_integral_mid_point(std::uint_least64_t two_f,std::int_least32_t e2,std::int_least32_t minus_k) noexcept
{
	if(e2<-4)
		return multiple_of_pow2(two_f,minus_k-e2+1);
	if(e2<=9)
		return true;
	if(e2<=86)
		return multiple_of_pow5(two_f,static_cast<std::uint_least32_t>(minus_k));
	return false;
}

inline constexpr bool multiple_of_pow5_float32(std::uint_least32_t value,std::uint_least32_t e5) noexcept
{
	auto m5{float_mod5_tb[e5]};
	return value*m5.hi <= m5.lo;
}

inline constexpr bool is_integral_end_point_float32(std::uint_least32_t two_f,std::int_least32_t e2,std::int_least32_t minus_k) noexcept
{
	if(e2<-1)
		return false;
	if(e2<=6)
		return true;
	if(e2<=39)
		return multiple_of_pow5_float32(two_f, static_cast<std::uint_least32_t>(minus_k));
	return false;
}

inline constexpr bool is_integral_mid_point_float32(std::uint_least32_t two_f,std::int_least32_t e2,std::int_least32_t minus_k) noexcept
{
	if(e2<-2)
		return multiple_of_pow2(two_f,minus_k-e2+1);
	if(e2<=6)
		return true;
	if(e2<=39)
		return multiple_of_pow5_float32(two_f,static_cast<std::uint_least32_t>(minus_k));
	return false;
}

template<typename flt>
#if __has_cpp_attribute(__gnu__::__cold__)
[[__gnu__::__cold__]]
#endif
inline constexpr m10_result<typename iec559_traits<flt>::mantissa_type> schubfach_asymmetric_interval(std::int_least32_t e2) noexcept
{
	using trait = iec559_traits<flt>;

	constexpr std::int_least32_t mbits{trait::mbits};
	std::int_least32_t const minus_k{(e2 * 1262611 - 524031)>>22};
	std::int_least32_t const plus_k{-minus_k};
	std::int_least32_t const beta_minus_1{e2 + mul_ln10_div_ln2_floor(plus_k)};
	std::uint_least32_t const rshift{static_cast<std::uint_least32_t>(64-mbits-beta_minus_1)};
	if constexpr(sizeof(flt)==sizeof(::std::uint_least64_t))
	{
		uint64x2 const pw{compute_pow10_float64[plus_k]};
		std::uint_least64_t const pw_lo{pw.lo},pw_hi{pw.hi};
		std::uint_least64_t const lower_endpoint{(pw_hi-(pw_hi>>(mbits+1)))>>rshift};
		std::uint_least64_t q{(pw_lo+(pw_hi>>mbits))>>rshift};
		bool const lower_endpoint_is_not_integer((2!=e2)&(3!=e2));
		std::uint_least64_t const xi{lower_endpoint+lower_endpoint_is_not_integer};
		q/=10;
		if(q*10>=xi)
			return {q,minus_k+1};
		q=((pw_hi>>(rshift-1))+1)>>1;
		if(e2==-77)
			q-=(q&1);
		else
			q+=(q<xi);

		return {q,minus_k};
	}
	else
	{
		std::uint_least64_t const pw{compute_pow10_float32[plus_k]};
		std::uint_least64_t const lower_endpoint{(pw-(pw>>(mbits+1)))>>rshift};
		std::uint_least64_t q{(pw>>mbits)>>rshift};
		bool const lower_endpoint_is_not_integer((2!=e2)&(3!=e2));
		std::uint_least64_t const xi{lower_endpoint+lower_endpoint_is_not_integer};
		q/=10;
		if(q*10>=xi)
			return {static_cast<std::uint_least32_t>(q),minus_k+1};
		q=((pw>>(rshift-1))+1)>>1;
		if(e2==-35)
			q-=(q&1);
		else
			q+=(q<xi);
		return {static_cast<std::uint_least32_t>(q),minus_k};
	}
}

template<typename flt>
#if __has_cpp_attribute(__gnu__::__pure__)
[[__gnu__::__pure__]]
#endif
#if __has_cpp_attribute(__gnu__::__hot__)
[[__gnu__::__hot__]]
#endif
inline constexpr m10_result<typename iec559_traits<flt>::mantissa_type> dragonbox_main(typename iec559_traits<flt>::mantissa_type m2,std::int_least32_t e2) noexcept
{
	using trait = iec559_traits<flt>;
	using mantissa_type = typename trait::mantissa_type;

	constexpr std::size_t mbits{trait::mbits};
	constexpr std::size_t ebits{trait::ebits};
	constexpr std::uint_least32_t bias{(static_cast<std::uint_least32_t>(1<<ebits)>>1)-1};
	constexpr std::int_least32_t exponent_bias{bias+mbits};
	constexpr mantissa_type mflags{static_cast<mantissa_type>(static_cast<mantissa_type>(1)<<mbits)};
	constexpr std::int_least32_t kappa{(sizeof(flt)==sizeof(std::uint_least32_t))?1:2};
	constexpr std::uint_least32_t big_divisor{kappa==2?1000:100};
	constexpr std::uint_least32_t small_divisor{big_divisor/10};
	constexpr std::uint_least32_t small_divisor_div2{small_divisor/2};

	if(e2==0)[[unlikely]]
	{
		constexpr std::int_least32_t e2bias{1-static_cast<std::int_least32_t>(exponent_bias)};
		e2=e2bias;
	}
	else
	{
		auto e2_temp{e2};
		e2-=exponent_bias;
		m2|=mflags;
		std::uint_least32_t pos_e2{static_cast<std::uint_least32_t>(-e2)};
		if(pos_e2<mbits && multiple_of_pow2_unchecked(m2,pos_e2))[[unlikely]]
			return {m2>>pos_e2, 0};
		if(m2==0&&e2_temp>1)[[unlikely]]
			return schubfach_asymmetric_interval<flt>(e2);
	}
	bool const is_even{(m2&1u)==0u};
	std::int_least32_t const minus_k{mul_ln2_div_ln10_floor(e2)-kappa};
	std::int_least32_t const plus_k{-minus_k};
	std::int_least32_t const beta_minus_1{e2+mul_ln10_div_ln2_floor(plus_k)};
	if constexpr(sizeof(flt)==sizeof(::std::uint_least64_t))
	{
		uint64x2 const pow10{compute_pow10_float64[plus_k]};
		std::uint_least64_t const pow10_lo{pow10.lo};
		std::uint_least64_t const pow10_hi{pow10.hi};
		std::uint_least32_t const delta{static_cast<std::uint_least32_t>(pow10_hi>>(63-beta_minus_1))};
		std::uint_least64_t const two_fc{m2<<1},two_fl{two_fc-1},two_fr{two_fc+1};
		std::uint_least64_t const zi{mulshift_float64(two_fr<<beta_minus_1,pow10_lo,pow10_hi)};
		std::uint_least64_t q;
		std::uint_least32_t r;
		q=zi/big_divisor;
		r=static_cast<std::uint_least32_t>(zi%big_divisor);
		if(r<delta)
		{
			if(r||is_even||!is_integral_end_point(two_fr,e2,minus_k))
				return {q,minus_k+kappa+1};
			--q;
			r=big_divisor;
		}
		else if(r==delta)
		{
			if((is_even&&is_integral_end_point(two_fl, e2, minus_k))||mul_parity_float64(two_fl,pow10_lo,pow10_hi,beta_minus_1))
				return {q,minus_k+kappa+1};
		}
		q *= 10;
		std::uint_least32_t const dist{static_cast<std::uint_least32_t>(r-delta/2+small_divisor_div2)};
		constexpr std::uint_least32_t distq_divisor_divisor{100};
		std::uint_least32_t const dist_q{dist / distq_divisor_divisor};
		std::uint_least32_t const dist_q_mul100{dist_q * distq_divisor_divisor};
		q+=dist_q;
		if(dist==dist_q_mul100)
		{
			bool const approx_y_parity{(dist & 1u)!=0u};
			if((mul_parity_float64(two_fc,pow10_lo,pow10_hi,beta_minus_1)!=approx_y_parity)||((q&1)&&is_integral_mid_point(two_fc, e2, minus_k)))
				--q;
		}
		return {q,minus_k+kappa};
	}
	else if constexpr(sizeof(flt)==sizeof(::std::uint_least32_t))
	{
		std::uint_least64_t const pow10{compute_pow10_float32[plus_k]};
		std::uint_least32_t const two_fc{m2<<1},two_fl{two_fc-1},two_fr{two_fc+1};
		std::uint_least32_t const zi{mulshift_float32(two_fr<<beta_minus_1,pow10)};
		std::uint_least32_t q{zi/big_divisor};
		std::uint_least32_t r{zi%big_divisor};
		std::uint_least32_t const delta{static_cast<std::uint_least32_t>(pow10>>(63-beta_minus_1))};
		if(r<delta)
		{
			if(r||is_even||!is_integral_end_point_float32(two_fr,e2,minus_k))
				return {q,minus_k+kappa+1};
			--q;
			r=big_divisor;
		}
		else if(r==delta)
		{
			if((is_even&&is_integral_end_point_float32(two_fl, e2, minus_k))||mul_parity_float32(two_fl,pow10,beta_minus_1))
				return {q,minus_k+kappa+1};
		}
		q *= 10;
		std::uint_least32_t const dist{static_cast<std::uint_least32_t>(r-delta/2+small_divisor_div2)};
		std::uint_least32_t const dist_q{dist / small_divisor};
		std::uint_least32_t const dist_q_mul100{dist_q * small_divisor};
		q+=dist_q;
		if(dist==dist_q_mul100)
		{
			bool const approx_y_parity{(dist & 1u)!=0u};
			if((mul_parity_float32(two_fc,pow10,beta_minus_1)!=approx_y_parity)||((q&1)&&is_integral_mid_point_float32(two_fc, e2, minus_k)))
				--q;
		}
		return {q,minus_k+kappa};
	}
}

template<typename flt>
#if __has_cpp_attribute(__gnu__::__pure__)
[[__gnu__::__pure__]]
#endif
#if __has_cpp_attribute(__gnu__::__hot__)
[[__gnu__::__hot__]]
#endif
inline constexpr m10_result<typename iec559_traits<flt>::mantissa_type> dragonbox_impl(typename iec559_traits<flt>::mantissa_type m2,std::int_least32_t e2) noexcept
{
	using mantissa_type = typename iec559_traits<flt>::mantissa_type;
	auto [m10,e10]=dragonbox_main<flt>(m2,e2);
//m10 should not ==0
	if constexpr(sizeof(std::size_t)>=sizeof(std::uint_least64_t)||
		sizeof(mantissa_type)<sizeof(std::uint_least64_t))
	{
		if constexpr(sizeof(std::uint_least64_t)<=sizeof(mantissa_type))
		{
			auto tmp_div100000000(m10/100000000u);
			auto tmp_mod100000000(m10%100000000u);
			if(tmp_mod100000000==0u)[[unlikely]]
			{
				m10=tmp_div100000000;
				e10+=8;
			}
		}
		for(;;)
		{
			auto tmp_div100(m10/100u);
			auto tmp_mod100(m10%100u);
			if(tmp_mod100)
				break;
			m10=tmp_div100;
			e10+=2;
		}
		auto tmp_div10{m10/10u};
		auto tmp_mod10{m10%10u};
		if(!tmp_mod10)
		{
			m10=tmp_div10;
			++e10;
		}
		return {m10,e10};
	}
	else
	{
		auto tmp_div100000000(m10/100000000u);
		auto tmp_mod100000000(m10%100000000u);
		if(tmp_mod100000000==0u)[[unlikely]]
		{
			m10=tmp_div100000000;
			e10+=8;
		}
		//4294967296
		while(m10>=1000000000u)
		{
			auto tmp_div100(m10/100u);
			auto tmp_mod100(m10%100u);
			if(tmp_mod100)
			{
				auto tmp_div10{m10/10u};
				auto tmp_mod10{m10%10u};
				if(!tmp_mod10)
				{
					m10=tmp_div10;
					++e10;
				}
				return {m10,e10};
			}
			m10=tmp_div100;
			e10+=2;
		}
		std::uint_least32_t m10ul32{static_cast<std::uint_least32_t>(m10)};
		for(;;)
		{
			auto tmp_div100{m10ul32/100u};
			auto tmp_mod100{m10ul32%100u};
			if(tmp_mod100)
				break;
			m10ul32=tmp_div100;
			e10+=2;
		}
		return {static_cast<mantissa_type>(m10ul32),e10};
	}
}

template<bool comma,::std::integral char_type,my_unsigned_integral U>
inline constexpr char_type* print_rsv_fp_decimal_scientific_common_impl(char_type* iter,U m10,std::uint_least32_t m10len) noexcept
{
	auto itp1{iter+1};
	::fast_io::details::jeaiii::jeaiii_main_len<true>(itp1,m10,m10len);
	*iter=*itp1;
	*itp1=char_literal_v<comma?u8',':u8'.',char_type>;
	return itp1+m10len;
}

template<bool comma,::std::integral char_type,my_unsigned_integral U>
inline constexpr char_type* print_rsv_fp_decimal_common_impl(char_type* iter,U m10,std::uint_least32_t m10len) noexcept
{
	if(m10len==1)[[unlikely]]
	{
		*iter=::fast_io::char_literal_add<char_type>(m10);
		++iter;
		return iter;
	}
	else
		return print_rsv_fp_decimal_scientific_common_impl<comma>(iter,m10,m10len);
}

template<typename flt,bool uppercase_e,::std::integral char_type>
inline constexpr char_type* print_rsv_fp_e_impl(char_type* iter,std::int_least32_t e10) noexcept
{
	*iter=char_literal_v<uppercase_e?u8'E':u8'e',char_type>;
	++iter;
	std::uint_least32_t ue10{static_cast<std::uint_least32_t>(e10)};
	if(e10<0)
	{
		ue10=0u-ue10;
		*iter=char_literal_v<u8'-',char_type>;
	}
	else
		*iter=char_literal_v<u8'+',char_type>;
	++iter;
	return prt_rsv_exponent_impl<iec559_traits<flt>::e10digits,true>(iter,ue10);
}

template<::std::integral char_type>
inline constexpr char_type* fill_zeros_impl(char_type* iter,std::size_t n) noexcept
{
	for(std::size_t i{};i!=n;++i)
	{
		*iter=char_literal_v<u8'0',char_type>;
		++iter;
	}
	return iter;
}

template<bool comma,::std::integral char_type>
inline constexpr char_type* fill_zero_point_impl(char_type* iter) noexcept
{
	if constexpr(comma)
	{
	if constexpr(std::same_as<char_type,char>)
		return copy_string_literal("0,",iter);
	else if constexpr(std::same_as<char_type,wchar_t>)
		return copy_string_literal(L"0,",iter);
	else if constexpr(std::same_as<char_type,char16_t>)
		return copy_string_literal(u"0,",iter);
	else if constexpr(std::same_as<char_type,char32_t>)
		return copy_string_literal(U"0,",iter);
	else
		return copy_string_literal(u8"0,",iter);
	}
	else
	{
	if constexpr(std::same_as<char_type,char>)
		return copy_string_literal("0.",iter);
	else if constexpr(std::same_as<char_type,wchar_t>)
		return copy_string_literal(L"0.",iter);
	else if constexpr(std::same_as<char_type,char16_t>)
		return copy_string_literal(u"0.",iter);
	else if constexpr(std::same_as<char_type,char32_t>)
		return copy_string_literal(U"0.",iter);
	else
		return copy_string_literal(u8"0.",iter);
	}
}

template<typename flt,::std::integral char_type>
inline constexpr char_type* fixed_case0_full_integer(char_type* iter,typename iec559_traits<flt>::mantissa_type m10,std::int_least32_t olength,std::int_least32_t real_exp) noexcept
{
	::fast_io::details::jeaiii::jeaiii_main_len<true>(iter,m10,static_cast<std::uint_least32_t>(olength));
	iter+=olength;
	return fill_zeros_impl(iter,static_cast<std::uint_least32_t>(real_exp+1-olength));
}

template<typename flt,bool comma,::std::integral char_type>
inline constexpr char_type* fixed_case1_integer_and_point(char_type* iter,typename iec559_traits<flt>::mantissa_type m10,std::int_least32_t olength,std::int_least32_t real_exp) noexcept
{
	auto eposition(real_exp+1);
	if(olength==eposition)
	{
		::fast_io::details::jeaiii::jeaiii_main_len<true>(iter,m10,static_cast<std::uint_least32_t>(olength));
		iter+=olength;
	}
	else
	{
		auto tmp{iter};
		::fast_io::details::jeaiii::jeaiii_main_len<true>(iter+1,m10,static_cast<std::uint_least32_t>(olength));
		iter+=olength+1;
		my_copy_n(tmp+1,static_cast<std::uint_least32_t>(eposition),tmp);
		tmp[eposition]=char_literal_v<(comma?u8',':u8'.'),char_type>;
	}
	return iter;
}

template<typename flt,bool comma,::std::integral char_type>
inline constexpr char_type* fixed_case2_all_point(char_type* iter,typename iec559_traits<flt>::mantissa_type m10,std::int_least32_t olength,std::int_least32_t real_exp) noexcept
{
	iter=fill_zero_point_impl<comma>(iter);
	iter=fill_zeros_impl(iter,static_cast<std::uint_least32_t>(-real_exp-1));
	::fast_io::details::jeaiii::jeaiii_main_len<true>(iter,m10,static_cast<std::uint_least32_t>(olength));
	iter+=olength;
	return iter;
}

template<typename flt,bool comma,::std::integral char_type>
inline constexpr char_type* print_rsv_fp_fixed_decision_impl(char_type* iter,typename iec559_traits<flt>::mantissa_type m10,std::int_least32_t e10) noexcept
{
	std::int_least32_t olength(static_cast<std::int_least32_t>(chars_len<10,true>(m10)));	
	std::int_least32_t const real_exp(static_cast<std::int_least32_t>(e10 + olength - 1));
	if(olength<=real_exp)
	{
		return fixed_case0_full_integer<flt>(iter,m10,olength,real_exp);
	}
	else if(0<=real_exp&&real_exp<olength)
	{
		return fixed_case1_integer_and_point<flt,comma>(iter,m10,olength,real_exp);
	}
	else
	{
		return fixed_case2_all_point<flt,comma>(iter,m10,olength,real_exp);
	}
}

template<
typename flt,
bool comma,
bool uppercase_e,
::fast_io::manipulators::floating_format mt,
::std::integral char_type>
inline constexpr char_type* print_rsv_fp_decision_impl(char_type* iter,typename iec559_traits<flt>::mantissa_type m10,std::int_least32_t e10) noexcept
{
	if constexpr(mt==::fast_io::manipulators::floating_format::general)
	{
		if(-5<e10&&e10<7)
		{
			return print_rsv_fp_fixed_decision_impl<flt,comma>(iter,m10,e10);
		}
		return print_rsv_fp_decision_impl<flt,comma,uppercase_e,::fast_io::manipulators::floating_format::scientific>(iter,m10,e10);
	}
	else if constexpr(mt==::fast_io::manipulators::floating_format::scientific)
	{
		if(m10<10u)[[unlikely]]
		{
			*iter=::fast_io::char_literal_add<char_type>(m10);
			++iter;
		}
		else
		{
			auto iterp1{iter};
			++iterp1;
			auto new_iter{::fast_io::details::jeaiii::jeaiii_main<false>(iterp1,m10)};
			e10+=static_cast<std::int_least32_t>(static_cast<std::uint_least32_t>(new_iter-iterp1)-1u);
			*iter=*iterp1;
			*iterp1=char_literal_v<comma?u8',':u8'.',char_type>;
			iter=new_iter;
		}
		return print_rsv_fp_e_impl<flt,uppercase_e>(iter,e10);
	}
	else	//decimal
	{
		std::int_least32_t olength{static_cast<std::int_least32_t>(chars_len<10,true>(m10))};
		std::int_least32_t const real_exp{static_cast<std::int_least32_t>(e10 + olength - 1)};
		std::uint_least32_t fixed_length{},this_case{};
		if(olength<=real_exp)
		{
			fixed_length=static_cast<std::uint_least32_t>(real_exp+1);
			this_case=1;
		}
		else if(0<=real_exp&&real_exp<olength)
		{
			fixed_length=static_cast<std::uint_least32_t>(olength+2);
			if(olength==real_exp+1)
				--fixed_length;
			this_case=2;
		}
		else
			fixed_length=static_cast<std::uint_least32_t>(static_cast<std::uint_least32_t>(-real_exp)+static_cast<std::uint_least32_t>(olength)+1u);
		std::uint_least32_t scientific_length{static_cast<std::uint_least32_t>(olength==1?olength+3:olength+5)};
		if(scientific_length<fixed_length)
		{
			//scientific decision
			iter=print_rsv_fp_decimal_common_impl<comma>(iter,m10,static_cast<std::uint_least32_t>(olength));
			return print_rsv_fp_e_impl<flt,uppercase_e>(iter,real_exp);
		}
		//fixed decision
		switch(this_case)
		{
		case 1:
			return fixed_case0_full_integer<flt>(iter,m10,olength,real_exp);
		case 2:
		{
			return fixed_case1_integer_and_point<flt,comma>(iter,m10,olength,real_exp);
		}
		default:
		{
			return fixed_case2_all_point<flt,comma>(iter,m10,olength,real_exp);
		}
		}
	}
}

template<
bool showpos,
bool uppercase,
bool uppercase_e,
bool comma,
::fast_io::manipulators::floating_format mt,
typename flt,::std::integral char_type>
inline constexpr char_type* print_rsvflt_define_impl(char_type* iter,flt f) noexcept
{
	if constexpr(::fast_io::manipulators::floating_format::fixed==mt&&uppercase_e)
	{
		return print_rsvflt_define_impl<showpos,uppercase,false,comma,mt>(iter,f);
	}
	else
	{
		using trait = iec559_traits<flt>;
		using mantissa_type = typename trait::mantissa_type;
		constexpr std::size_t ebits{trait::ebits};
		constexpr mantissa_type exponent_mask{(static_cast<mantissa_type>(1)<<ebits)-1};
		constexpr std::uint_least32_t exponent_mask_u32{static_cast<std::uint_least32_t>(exponent_mask)};
		auto [mantissa,exponent,sign] = get_punned_result(f);
		iter=print_rsv_fp_sign_impl<showpos>(iter,sign);
		if(exponent==exponent_mask_u32)
			return prsv_fp_nan_impl<uppercase>(iter,mantissa!=0u);
		if(!mantissa&&!exponent)
		{
			if constexpr(mt!=::fast_io::manipulators::floating_format::scientific)
			{
				*iter=char_literal_v<u8'0',char_type>;
				++iter;
				return iter;
			}
			else
				return prsv_fp_dece0<uppercase>(iter);
		}
		auto [m10,e10] = dragonbox_impl<flt>(mantissa,static_cast<std::int_least32_t>(exponent));
		if constexpr(mt==::fast_io::manipulators::floating_format::fixed)
			return print_rsv_fp_fixed_decision_impl<flt,comma>(iter,m10,e10);
		else
			return print_rsv_fp_decision_impl<flt,comma,uppercase_e,mt>(iter,m10,e10);
	}
}

template<typename flt,::fast_io::manipulators::floating_format mf>
inline constexpr std::size_t print_rsvflt_size_impl() noexcept
{
	using trait = iec559_traits<flt>;
	if constexpr(mf==::fast_io::manipulators::floating_format::fixed)
	{
		//general's max length is equal to scientific's max length
//(+/-)(significants+sep)
		std::size_t sum{1};//sign(+/-)
		sum+=2;//0./,
		sum+=trait::e10max;
		sum+=trait::m10digits;
		return sum;
	}
	else
	{
		//decimal and general's max lengths are equal to scientific's max length
//(+/-)(significants+sep)(E/e)(+/-)e
		std::size_t sum{1};//sign(+/-)
		sum+=trait::m10digits;
		++sum;//./,
		sum+=2;//(E/e)(+/-)
		sum+=trait::e10digits;
		return sum;
	}
}

template<typename flt,::fast_io::manipulators::floating_format mt>
inline constexpr std::size_t print_rsv_cache{print_rsvflt_size_impl<flt,mt>()};

}
