#pragma once

inline constexpr basic_io_scatter_t<char8_t> win32_registry_timezone_9xa[]
{
{u8"AUS Central Standard Time",25},
{u8"AUS Eastern Standard Time",25},
{u8"Afghanistan Standard Time",25},
{u8"Alaskan Standard Time",21},
{u8"Aleutian Standard Time",22},
{u8"Altai Standard Time",19},
{u8"Arab Standard Time",18},
{u8"Arabian Standard Time",21},
{u8"Arabic Standard Time",20},
{u8"Argentina Standard Time",23},
{u8"Astrakhan Standard Time",23},
{u8"Atlantic Standard Time",22},
{u8"Aus Central W. Standard Time",28},
{u8"Azerbaijan Standard Time",24},
{u8"Azores Standard Time",20},
{u8"Bahia Standard Time",19},
{u8"Bangladesh Standard Time",24},
{u8"Belarus Standard Time",21},
{u8"Bougainville Standard Time",26},
{u8"Canada Central Standard Time",28},
{u8"Cape Verde Standard Time",24},
{u8"Caucasus Standard Time",22},
{u8"Cen. Australia Standard Time",28},
{u8"Central America Standard Time",29},
{u8"Central Asia Standard Time",26},
{u8"Central Brazilian Standard Time",31},
{u8"Central Europe Standard Time",28},
{u8"Central European Standard Time",30},
{u8"Central Pacific Standard Time",29},
{u8"Central Standard Time",21},
{u8"Central Standard Time (Mexico)",30},
{u8"Chatham Islands Standard Time",29},
{u8"China Standard Time",19},
{u8"Cuba Standard Time",18},
{u8"Dateline Standard Time",22},
{u8"E. Africa Standard Time",23},
{u8"E. Australia Standard Time",26},
{u8"E. Europe Standard Time",23},
{u8"E. South America Standard Time",30},
{u8"Easter Island Standard Time",27},
{u8"Eastern Standard Time",21},
{u8"Eastern Standard Time (Mexico)",30},
{u8"Egypt Standard Time",19},
{u8"Ekaterinburg Standard Time",26},
{u8"FLE Standard Time",17},
{u8"Fiji Standard Time",18},
{u8"GMT Standard Time",17},
{u8"GTB Standard Time",17},
{u8"Georgian Standard Time",22},
{u8"Greenland Standard Time",23},
{u8"Greenwich Standard Time",23},
{u8"Haiti Standard Time",19},
{u8"Hawaiian Standard Time",22},
{u8"India Standard Time",19},
{u8"Iran Standard Time",18},
{u8"Israel Standard Time",20},
{u8"Jordan Standard Time",20},
{u8"Kaliningrad Standard Time",25},
{u8"Korea Standard Time",19},
{u8"Libya Standard Time",19},
{u8"Line Islands Standard Time",26},
{u8"Lord Howe Standard Time",23},
{u8"Magadan Standard Time",21},
{u8"Magallanes Standard Time",24},
{u8"Marquesas Standard Time",23},
{u8"Mauritius Standard Time",23},
{u8"Middle East Standard Time",25},
{u8"Montevideo Standard Time",24},
{u8"Morocco Standard Time",21},
{u8"Mountain Standard Time",22},
{u8"Mountain Standard Time (Mexico)",31},
{u8"Myanmar Standard Time",21},
{u8"N. Central Asia Standard Time",29},
{u8"Namibia Standard Time",21},
{u8"Nepal Standard Time",19},
{u8"New Zealand Standard Time",25},
{u8"Newfoundland Standard Time",26},
{u8"Norfolk Standard Time",21},
{u8"North Asia East Standard Time",29},
{u8"North Asia Standard Time",24},
{u8"North Korea Standard Time",25},
{u8"Omsk Standard Time",18},
{u8"Pacific SA Standard Time",24},
{u8"Pacific Standard Time",21},
{u8"Pacific Standard Time (Mexico)",30},
{u8"Pakistan Standard Time",22},
{u8"Paraguay Standard Time",22},
{u8"Qyzylorda Standard Time",23},
{u8"Romance Standard Time",21},
{u8"Russia Time Zone 10",19},
{u8"Russia Time Zone 11",19},
{u8"Russia Time Zone 3",18},
{u8"Russian Standard Time",21},
{u8"SA Eastern Standard Time",24},
{u8"SA Pacific Standard Time",24},
{u8"SA Western Standard Time",24},
{u8"SE Asia Standard Time",21},
{u8"Saint Pierre Standard Time",26},
{u8"Sakhalin Standard Time",22},
{u8"Samoa Standard Time",19},
{u8"Sao Tome Standard Time",22},
{u8"Saratov Standard Time",21},
{u8"Singapore Standard Time",23},
{u8"South Africa Standard Time",26},
{u8"Sri Lanka Standard Time",23},
{u8"Sudan Standard Time",19},
{u8"Syria Standard Time",19},
{u8"Taipei Standard Time",20},
{u8"Tasmania Standard Time",22},
{u8"Tocantins Standard Time",23},
{u8"Tokyo Standard Time",19},
{u8"Tomsk Standard Time",19},
{u8"Tonga Standard Time",19},
{u8"Transbaikal Standard Time",25},
{u8"Turkey Standard Time",20},
{u8"Turks And Caicos Standard Time",30},
{u8"US Eastern Standard Time",24},
{u8"US Mountain Standard Time",25},
{u8"UTC",3},
{u8"UTC+12",6},
{u8"UTC+13",6},
{u8"UTC-02",6},
{u8"UTC-08",6},
{u8"UTC-09",6},
{u8"UTC-11",6},
{u8"Ulaanbaatar Standard Time",25},
{u8"Venezuela Standard Time",23},
{u8"Vladivostok Standard Time",25},
{u8"Volgograd Standard Time",23},
{u8"W. Australia Standard Time",26},
{u8"W. Central Africa Standard Time",31},
{u8"W. Europe Standard Time",23},
{u8"W. Mongolia Standard Time",25},
{u8"West Asia Standard Time",23},
{u8"West Bank Standard Time",23},
{u8"West Pacific Standard Time",26},
{u8"Yakutsk Standard Time",21}
};

inline constexpr basic_io_scatter_t<char16_t> win32_registry_timezone_ntw[]
{
{u"AUS Central Standard Time",25},
{u"AUS Eastern Standard Time",25},
{u"Afghanistan Standard Time",25},
{u"Alaskan Standard Time",21},
{u"Aleutian Standard Time",22},
{u"Altai Standard Time",19},
{u"Arab Standard Time",18},
{u"Arabian Standard Time",21},
{u"Arabic Standard Time",20},
{u"Argentina Standard Time",23},
{u"Astrakhan Standard Time",23},
{u"Atlantic Standard Time",22},
{u"Aus Central W. Standard Time",28},
{u"Azerbaijan Standard Time",24},
{u"Azores Standard Time",20},
{u"Bahia Standard Time",19},
{u"Bangladesh Standard Time",24},
{u"Belarus Standard Time",21},
{u"Bougainville Standard Time",26},
{u"Canada Central Standard Time",28},
{u"Cape Verde Standard Time",24},
{u"Caucasus Standard Time",22},
{u"Cen. Australia Standard Time",28},
{u"Central America Standard Time",29},
{u"Central Asia Standard Time",26},
{u"Central Brazilian Standard Time",31},
{u"Central Europe Standard Time",28},
{u"Central European Standard Time",30},
{u"Central Pacific Standard Time",29},
{u"Central Standard Time",21},
{u"Central Standard Time (Mexico)",30},
{u"Chatham Islands Standard Time",29},
{u"China Standard Time",19},
{u"Cuba Standard Time",18},
{u"Dateline Standard Time",22},
{u"E. Africa Standard Time",23},
{u"E. Australia Standard Time",26},
{u"E. Europe Standard Time",23},
{u"E. South America Standard Time",30},
{u"Easter Island Standard Time",27},
{u"Eastern Standard Time",21},
{u"Eastern Standard Time (Mexico)",30},
{u"Egypt Standard Time",19},
{u"Ekaterinburg Standard Time",26},
{u"FLE Standard Time",17},
{u"Fiji Standard Time",18},
{u"GMT Standard Time",17},
{u"GTB Standard Time",17},
{u"Georgian Standard Time",22},
{u"Greenland Standard Time",23},
{u"Greenwich Standard Time",23},
{u"Haiti Standard Time",19},
{u"Hawaiian Standard Time",22},
{u"India Standard Time",19},
{u"Iran Standard Time",18},
{u"Israel Standard Time",20},
{u"Jordan Standard Time",20},
{u"Kaliningrad Standard Time",25},
{u"Korea Standard Time",19},
{u"Libya Standard Time",19},
{u"Line Islands Standard Time",26},
{u"Lord Howe Standard Time",23},
{u"Magadan Standard Time",21},
{u"Magallanes Standard Time",24},
{u"Marquesas Standard Time",23},
{u"Mauritius Standard Time",23},
{u"Middle East Standard Time",25},
{u"Montevideo Standard Time",24},
{u"Morocco Standard Time",21},
{u"Mountain Standard Time",22},
{u"Mountain Standard Time (Mexico)",31},
{u"Myanmar Standard Time",21},
{u"N. Central Asia Standard Time",29},
{u"Namibia Standard Time",21},
{u"Nepal Standard Time",19},
{u"New Zealand Standard Time",25},
{u"Newfoundland Standard Time",26},
{u"Norfolk Standard Time",21},
{u"North Asia East Standard Time",29},
{u"North Asia Standard Time",24},
{u"North Korea Standard Time",25},
{u"Omsk Standard Time",18},
{u"Pacific SA Standard Time",24},
{u"Pacific Standard Time",21},
{u"Pacific Standard Time (Mexico)",30},
{u"Pakistan Standard Time",22},
{u"Paraguay Standard Time",22},
{u"Qyzylorda Standard Time",23},
{u"Romance Standard Time",21},
{u"Russia Time Zone 10",19},
{u"Russia Time Zone 11",19},
{u"Russia Time Zone 3",18},
{u"Russian Standard Time",21},
{u"SA Eastern Standard Time",24},
{u"SA Pacific Standard Time",24},
{u"SA Western Standard Time",24},
{u"SE Asia Standard Time",21},
{u"Saint Pierre Standard Time",26},
{u"Sakhalin Standard Time",22},
{u"Samoa Standard Time",19},
{u"Sao Tome Standard Time",22},
{u"Saratov Standard Time",21},
{u"Singapore Standard Time",23},
{u"South Africa Standard Time",26},
{u"Sri Lanka Standard Time",23},
{u"Sudan Standard Time",19},
{u"Syria Standard Time",19},
{u"Taipei Standard Time",20},
{u"Tasmania Standard Time",22},
{u"Tocantins Standard Time",23},
{u"Tokyo Standard Time",19},
{u"Tomsk Standard Time",19},
{u"Tonga Standard Time",19},
{u"Transbaikal Standard Time",25},
{u"Turkey Standard Time",20},
{u"Turks And Caicos Standard Time",30},
{u"US Eastern Standard Time",24},
{u"US Mountain Standard Time",25},
{u"UTC",3},
{u"UTC+12",6},
{u"UTC+13",6},
{u"UTC-02",6},
{u"UTC-08",6},
{u"UTC-09",6},
{u"UTC-11",6},
{u"Ulaanbaatar Standard Time",25},
{u"Venezuela Standard Time",23},
{u"Vladivostok Standard Time",25},
{u"Volgograd Standard Time",23},
{u"W. Australia Standard Time",26},
{u"W. Central Africa Standard Time",31},
{u"W. Europe Standard Time",23},
{u"W. Mongolia Standard Time",25},
{u"West Asia Standard Time",23},
{u"West Bank Standard Time",23},
{u"West Pacific Standard Time",26},
{u"Yakutsk Standard Time",21}
};

inline constexpr basic_io_scatter_t<char> iana_db_timezone[]
{
{"Australia/Darwin",16},
{"Australia/Sydney",16},
{"Asia/Kabul",10},
{"America/Anchorage",17},
{"America/Adak",12},
{"Asia/Barnaul",12},
{"Asia/Riyadh",11},
{"Asia/Dubai",10},
{"Asia/Baghdad",12},
{"America/Buenos_Aires",20},
{"Europe/Astrakhan",16},
{"America/Halifax",15},
{"Australia/Eucla",15},
{"Asia/Baku",9},
{"Atlantic/Azores",15},
{"America/Bahia",13},
{"Asia/Dhaka",10},
{"Europe/Minsk",12},
{"Pacific/Bougainville",20},
{"America/Regina",14},
{"Atlantic/Cape_Verde",19},
{"Asia/Yerevan",12},
{"Australia/Adelaide",18},
{"America/Guatemala",17},
{"Asia/Almaty",11},
{"America/Cuiaba",14},
{"Europe/Budapest",15},
{"Europe/Warsaw",13},
{"Pacific/Guadalcanal",19},
{"America/Chicago",15},
{"America/Mexico_City",19},
{"Pacific/Chatham",15},
{"Asia/Shanghai",13},
{"America/Havana",14},
{"Etc/GMT+12",10},
{"Africa/Nairobi",14},
{"Australia/Brisbane",18},
{"Europe/Chisinau",15},
{"America/Sao_Paulo",17},
{"Pacific/Easter",14},
{"America/New_York",16},
{"America/Cancun",14},
{"Africa/Cairo",12},
{"Asia/Yekaterinburg",18},
{"Europe/Kiev",11},
{"Pacific/Fiji",12},
{"Europe/London",13},
{"Europe/Bucharest",16},
{"Asia/Tbilisi",12},
{"America/Godthab",15},
{"Atlantic/Reykjavik",18},
{"America/Port-au-Prince",22},
{"Pacific/Honolulu",16},
{"Asia/Calcutta",13},
{"Asia/Tehran",11},
{"Asia/Jerusalem",14},
{"Asia/Amman",10},
{"Europe/Kaliningrad",18},
{"Asia/Seoul",10},
{"Africa/Tripoli",14},
{"Pacific/Kiritimati",18},
{"Australia/Lord_Howe",19},
{"Asia/Magadan",12},
{"America/Punta_Arenas",20},
{"Pacific/Marquesas",17},
{"Indian/Mauritius",16},
{"Asia/Beirut",11},
{"America/Montevideo",18},
{"Africa/Casablanca",17},
{"America/Denver",14},
{"America/Chihuahua",17},
{"Asia/Rangoon",12},
{"Asia/Novosibirsk",16},
{"Africa/Windhoek",15},
{"Asia/Katmandu",13},
{"Pacific/Auckland",16},
{"America/St_Johns",16},
{"Pacific/Norfolk",15},
{"Asia/Irkutsk",12},
{"Asia/Krasnoyarsk",16},
{"Asia/Pyongyang",14},
{"Asia/Omsk",9},
{"America/Santiago",16},
{"America/Los_Angeles",19},
{"America/Tijuana",15},
{"Asia/Karachi",12},
{"America/Asuncion",16},
{"Asia/Qyzylorda",14},
{"Europe/Paris",12},
{"Asia/Srednekolymsk",18},
{"Asia/Kamchatka",14},
{"Europe/Samara",13},
{"Europe/Moscow",13},
{"America/Cayenne",15},
{"America/Bogota",14},
{"America/La_Paz",14},
{"Asia/Bangkok",12},
{"America/Miquelon",16},
{"Asia/Sakhalin",13},
{"Pacific/Apia",12},
{"Africa/Sao_Tome",15},
{"Europe/Saratov",14},
{"Asia/Singapore",14},
{"Africa/Johannesburg",19},
{"Asia/Colombo",12},
{"Africa/Khartoum",15},
{"Asia/Damascus",13},
{"Asia/Taipei",11},
{"Australia/Hobart",16},
{"America/Araguaina",17},
{"Asia/Tokyo",10},
{"Asia/Tomsk",10},
{"Pacific/Tongatapu",17},
{"Asia/Chita",10},
{"Europe/Istanbul",15},
{"America/Grand_Turk",18},
{"America/Indianapolis",20},
{"America/Phoenix",15},
{"Etc/GMT",7},
{"Etc/GMT-12",10},
{"Etc/GMT-13",10},
{"Etc/GMT+2",9},
{"Etc/GMT+8",9},
{"Etc/GMT+9",9},
{"Etc/GMT+11",10},
{"Asia/Ulaanbaatar",16},
{"America/Caracas",15},
{"Asia/Vladivostok",16},
{"Europe/Volgograd",16},
{"Australia/Perth",15},
{"Africa/Lagos",12},
{"Europe/Berlin",13},
{"Asia/Hovd",9},
{"Asia/Tashkent",13},
{"Asia/Hebron",11},
{"Pacific/Port_Moresby",20},
{"Asia/Yakutsk",12}
};

inline constexpr basic_io_scatter_t<wchar_t> wiana_db_timezone[]
{
{L"Australia/Darwin",16},
{L"Australia/Sydney",16},
{L"Asia/Kabul",10},
{L"America/Anchorage",17},
{L"America/Adak",12},
{L"Asia/Barnaul",12},
{L"Asia/Riyadh",11},
{L"Asia/Dubai",10},
{L"Asia/Baghdad",12},
{L"America/Buenos_Aires",20},
{L"Europe/Astrakhan",16},
{L"America/Halifax",15},
{L"Australia/Eucla",15},
{L"Asia/Baku",9},
{L"Atlantic/Azores",15},
{L"America/Bahia",13},
{L"Asia/Dhaka",10},
{L"Europe/Minsk",12},
{L"Pacific/Bougainville",20},
{L"America/Regina",14},
{L"Atlantic/Cape_Verde",19},
{L"Asia/Yerevan",12},
{L"Australia/Adelaide",18},
{L"America/Guatemala",17},
{L"Asia/Almaty",11},
{L"America/Cuiaba",14},
{L"Europe/Budapest",15},
{L"Europe/Warsaw",13},
{L"Pacific/Guadalcanal",19},
{L"America/Chicago",15},
{L"America/Mexico_City",19},
{L"Pacific/Chatham",15},
{L"Asia/Shanghai",13},
{L"America/Havana",14},
{L"Etc/GMT+12",10},
{L"Africa/Nairobi",14},
{L"Australia/Brisbane",18},
{L"Europe/Chisinau",15},
{L"America/Sao_Paulo",17},
{L"Pacific/Easter",14},
{L"America/New_York",16},
{L"America/Cancun",14},
{L"Africa/Cairo",12},
{L"Asia/Yekaterinburg",18},
{L"Europe/Kiev",11},
{L"Pacific/Fiji",12},
{L"Europe/London",13},
{L"Europe/Bucharest",16},
{L"Asia/Tbilisi",12},
{L"America/Godthab",15},
{L"Atlantic/Reykjavik",18},
{L"America/Port-au-Prince",22},
{L"Pacific/Honolulu",16},
{L"Asia/Calcutta",13},
{L"Asia/Tehran",11},
{L"Asia/Jerusalem",14},
{L"Asia/Amman",10},
{L"Europe/Kaliningrad",18},
{L"Asia/Seoul",10},
{L"Africa/Tripoli",14},
{L"Pacific/Kiritimati",18},
{L"Australia/Lord_Howe",19},
{L"Asia/Magadan",12},
{L"America/Punta_Arenas",20},
{L"Pacific/Marquesas",17},
{L"Indian/Mauritius",16},
{L"Asia/Beirut",11},
{L"America/Montevideo",18},
{L"Africa/Casablanca",17},
{L"America/Denver",14},
{L"America/Chihuahua",17},
{L"Asia/Rangoon",12},
{L"Asia/Novosibirsk",16},
{L"Africa/Windhoek",15},
{L"Asia/Katmandu",13},
{L"Pacific/Auckland",16},
{L"America/St_Johns",16},
{L"Pacific/Norfolk",15},
{L"Asia/Irkutsk",12},
{L"Asia/Krasnoyarsk",16},
{L"Asia/Pyongyang",14},
{L"Asia/Omsk",9},
{L"America/Santiago",16},
{L"America/Los_Angeles",19},
{L"America/Tijuana",15},
{L"Asia/Karachi",12},
{L"America/Asuncion",16},
{L"Asia/Qyzylorda",14},
{L"Europe/Paris",12},
{L"Asia/Srednekolymsk",18},
{L"Asia/Kamchatka",14},
{L"Europe/Samara",13},
{L"Europe/Moscow",13},
{L"America/Cayenne",15},
{L"America/Bogota",14},
{L"America/La_Paz",14},
{L"Asia/Bangkok",12},
{L"America/Miquelon",16},
{L"Asia/Sakhalin",13},
{L"Pacific/Apia",12},
{L"Africa/Sao_Tome",15},
{L"Europe/Saratov",14},
{L"Asia/Singapore",14},
{L"Africa/Johannesburg",19},
{L"Asia/Colombo",12},
{L"Africa/Khartoum",15},
{L"Asia/Damascus",13},
{L"Asia/Taipei",11},
{L"Australia/Hobart",16},
{L"America/Araguaina",17},
{L"Asia/Tokyo",10},
{L"Asia/Tomsk",10},
{L"Pacific/Tongatapu",17},
{L"Asia/Chita",10},
{L"Europe/Istanbul",15},
{L"America/Grand_Turk",18},
{L"America/Indianapolis",20},
{L"America/Phoenix",15},
{L"Etc/GMT",7},
{L"Etc/GMT-12",10},
{L"Etc/GMT-13",10},
{L"Etc/GMT+2",9},
{L"Etc/GMT+8",9},
{L"Etc/GMT+9",9},
{L"Etc/GMT+11",10},
{L"Asia/Ulaanbaatar",16},
{L"America/Caracas",15},
{L"Asia/Vladivostok",16},
{L"Europe/Volgograd",16},
{L"Australia/Perth",15},
{L"Africa/Lagos",12},
{L"Europe/Berlin",13},
{L"Asia/Hovd",9},
{L"Asia/Tashkent",13},
{L"Asia/Hebron",11},
{L"Pacific/Port_Moresby",20},
{L"Asia/Yakutsk",12}
};

inline constexpr basic_io_scatter_t<char8_t> u8iana_db_timezone[]
{
{u8"Australia/Darwin",16},
{u8"Australia/Sydney",16},
{u8"Asia/Kabul",10},
{u8"America/Anchorage",17},
{u8"America/Adak",12},
{u8"Asia/Barnaul",12},
{u8"Asia/Riyadh",11},
{u8"Asia/Dubai",10},
{u8"Asia/Baghdad",12},
{u8"America/Buenos_Aires",20},
{u8"Europe/Astrakhan",16},
{u8"America/Halifax",15},
{u8"Australia/Eucla",15},
{u8"Asia/Baku",9},
{u8"Atlantic/Azores",15},
{u8"America/Bahia",13},
{u8"Asia/Dhaka",10},
{u8"Europe/Minsk",12},
{u8"Pacific/Bougainville",20},
{u8"America/Regina",14},
{u8"Atlantic/Cape_Verde",19},
{u8"Asia/Yerevan",12},
{u8"Australia/Adelaide",18},
{u8"America/Guatemala",17},
{u8"Asia/Almaty",11},
{u8"America/Cuiaba",14},
{u8"Europe/Budapest",15},
{u8"Europe/Warsaw",13},
{u8"Pacific/Guadalcanal",19},
{u8"America/Chicago",15},
{u8"America/Mexico_City",19},
{u8"Pacific/Chatham",15},
{u8"Asia/Shanghai",13},
{u8"America/Havana",14},
{u8"Etc/GMT+12",10},
{u8"Africa/Nairobi",14},
{u8"Australia/Brisbane",18},
{u8"Europe/Chisinau",15},
{u8"America/Sao_Paulo",17},
{u8"Pacific/Easter",14},
{u8"America/New_York",16},
{u8"America/Cancun",14},
{u8"Africa/Cairo",12},
{u8"Asia/Yekaterinburg",18},
{u8"Europe/Kiev",11},
{u8"Pacific/Fiji",12},
{u8"Europe/London",13},
{u8"Europe/Bucharest",16},
{u8"Asia/Tbilisi",12},
{u8"America/Godthab",15},
{u8"Atlantic/Reykjavik",18},
{u8"America/Port-au-Prince",22},
{u8"Pacific/Honolulu",16},
{u8"Asia/Calcutta",13},
{u8"Asia/Tehran",11},
{u8"Asia/Jerusalem",14},
{u8"Asia/Amman",10},
{u8"Europe/Kaliningrad",18},
{u8"Asia/Seoul",10},
{u8"Africa/Tripoli",14},
{u8"Pacific/Kiritimati",18},
{u8"Australia/Lord_Howe",19},
{u8"Asia/Magadan",12},
{u8"America/Punta_Arenas",20},
{u8"Pacific/Marquesas",17},
{u8"Indian/Mauritius",16},
{u8"Asia/Beirut",11},
{u8"America/Montevideo",18},
{u8"Africa/Casablanca",17},
{u8"America/Denver",14},
{u8"America/Chihuahua",17},
{u8"Asia/Rangoon",12},
{u8"Asia/Novosibirsk",16},
{u8"Africa/Windhoek",15},
{u8"Asia/Katmandu",13},
{u8"Pacific/Auckland",16},
{u8"America/St_Johns",16},
{u8"Pacific/Norfolk",15},
{u8"Asia/Irkutsk",12},
{u8"Asia/Krasnoyarsk",16},
{u8"Asia/Pyongyang",14},
{u8"Asia/Omsk",9},
{u8"America/Santiago",16},
{u8"America/Los_Angeles",19},
{u8"America/Tijuana",15},
{u8"Asia/Karachi",12},
{u8"America/Asuncion",16},
{u8"Asia/Qyzylorda",14},
{u8"Europe/Paris",12},
{u8"Asia/Srednekolymsk",18},
{u8"Asia/Kamchatka",14},
{u8"Europe/Samara",13},
{u8"Europe/Moscow",13},
{u8"America/Cayenne",15},
{u8"America/Bogota",14},
{u8"America/La_Paz",14},
{u8"Asia/Bangkok",12},
{u8"America/Miquelon",16},
{u8"Asia/Sakhalin",13},
{u8"Pacific/Apia",12},
{u8"Africa/Sao_Tome",15},
{u8"Europe/Saratov",14},
{u8"Asia/Singapore",14},
{u8"Africa/Johannesburg",19},
{u8"Asia/Colombo",12},
{u8"Africa/Khartoum",15},
{u8"Asia/Damascus",13},
{u8"Asia/Taipei",11},
{u8"Australia/Hobart",16},
{u8"America/Araguaina",17},
{u8"Asia/Tokyo",10},
{u8"Asia/Tomsk",10},
{u8"Pacific/Tongatapu",17},
{u8"Asia/Chita",10},
{u8"Europe/Istanbul",15},
{u8"America/Grand_Turk",18},
{u8"America/Indianapolis",20},
{u8"America/Phoenix",15},
{u8"Etc/GMT",7},
{u8"Etc/GMT-12",10},
{u8"Etc/GMT-13",10},
{u8"Etc/GMT+2",9},
{u8"Etc/GMT+8",9},
{u8"Etc/GMT+9",9},
{u8"Etc/GMT+11",10},
{u8"Asia/Ulaanbaatar",16},
{u8"America/Caracas",15},
{u8"Asia/Vladivostok",16},
{u8"Europe/Volgograd",16},
{u8"Australia/Perth",15},
{u8"Africa/Lagos",12},
{u8"Europe/Berlin",13},
{u8"Asia/Hovd",9},
{u8"Asia/Tashkent",13},
{u8"Asia/Hebron",11},
{u8"Pacific/Port_Moresby",20},
{u8"Asia/Yakutsk",12}
};

inline constexpr basic_io_scatter_t<char16_t> u16iana_db_timezone[]
{
{u"Australia/Darwin",16},
{u"Australia/Sydney",16},
{u"Asia/Kabul",10},
{u"America/Anchorage",17},
{u"America/Adak",12},
{u"Asia/Barnaul",12},
{u"Asia/Riyadh",11},
{u"Asia/Dubai",10},
{u"Asia/Baghdad",12},
{u"America/Buenos_Aires",20},
{u"Europe/Astrakhan",16},
{u"America/Halifax",15},
{u"Australia/Eucla",15},
{u"Asia/Baku",9},
{u"Atlantic/Azores",15},
{u"America/Bahia",13},
{u"Asia/Dhaka",10},
{u"Europe/Minsk",12},
{u"Pacific/Bougainville",20},
{u"America/Regina",14},
{u"Atlantic/Cape_Verde",19},
{u"Asia/Yerevan",12},
{u"Australia/Adelaide",18},
{u"America/Guatemala",17},
{u"Asia/Almaty",11},
{u"America/Cuiaba",14},
{u"Europe/Budapest",15},
{u"Europe/Warsaw",13},
{u"Pacific/Guadalcanal",19},
{u"America/Chicago",15},
{u"America/Mexico_City",19},
{u"Pacific/Chatham",15},
{u"Asia/Shanghai",13},
{u"America/Havana",14},
{u"Etc/GMT+12",10},
{u"Africa/Nairobi",14},
{u"Australia/Brisbane",18},
{u"Europe/Chisinau",15},
{u"America/Sao_Paulo",17},
{u"Pacific/Easter",14},
{u"America/New_York",16},
{u"America/Cancun",14},
{u"Africa/Cairo",12},
{u"Asia/Yekaterinburg",18},
{u"Europe/Kiev",11},
{u"Pacific/Fiji",12},
{u"Europe/London",13},
{u"Europe/Bucharest",16},
{u"Asia/Tbilisi",12},
{u"America/Godthab",15},
{u"Atlantic/Reykjavik",18},
{u"America/Port-au-Prince",22},
{u"Pacific/Honolulu",16},
{u"Asia/Calcutta",13},
{u"Asia/Tehran",11},
{u"Asia/Jerusalem",14},
{u"Asia/Amman",10},
{u"Europe/Kaliningrad",18},
{u"Asia/Seoul",10},
{u"Africa/Tripoli",14},
{u"Pacific/Kiritimati",18},
{u"Australia/Lord_Howe",19},
{u"Asia/Magadan",12},
{u"America/Punta_Arenas",20},
{u"Pacific/Marquesas",17},
{u"Indian/Mauritius",16},
{u"Asia/Beirut",11},
{u"America/Montevideo",18},
{u"Africa/Casablanca",17},
{u"America/Denver",14},
{u"America/Chihuahua",17},
{u"Asia/Rangoon",12},
{u"Asia/Novosibirsk",16},
{u"Africa/Windhoek",15},
{u"Asia/Katmandu",13},
{u"Pacific/Auckland",16},
{u"America/St_Johns",16},
{u"Pacific/Norfolk",15},
{u"Asia/Irkutsk",12},
{u"Asia/Krasnoyarsk",16},
{u"Asia/Pyongyang",14},
{u"Asia/Omsk",9},
{u"America/Santiago",16},
{u"America/Los_Angeles",19},
{u"America/Tijuana",15},
{u"Asia/Karachi",12},
{u"America/Asuncion",16},
{u"Asia/Qyzylorda",14},
{u"Europe/Paris",12},
{u"Asia/Srednekolymsk",18},
{u"Asia/Kamchatka",14},
{u"Europe/Samara",13},
{u"Europe/Moscow",13},
{u"America/Cayenne",15},
{u"America/Bogota",14},
{u"America/La_Paz",14},
{u"Asia/Bangkok",12},
{u"America/Miquelon",16},
{u"Asia/Sakhalin",13},
{u"Pacific/Apia",12},
{u"Africa/Sao_Tome",15},
{u"Europe/Saratov",14},
{u"Asia/Singapore",14},
{u"Africa/Johannesburg",19},
{u"Asia/Colombo",12},
{u"Africa/Khartoum",15},
{u"Asia/Damascus",13},
{u"Asia/Taipei",11},
{u"Australia/Hobart",16},
{u"America/Araguaina",17},
{u"Asia/Tokyo",10},
{u"Asia/Tomsk",10},
{u"Pacific/Tongatapu",17},
{u"Asia/Chita",10},
{u"Europe/Istanbul",15},
{u"America/Grand_Turk",18},
{u"America/Indianapolis",20},
{u"America/Phoenix",15},
{u"Etc/GMT",7},
{u"Etc/GMT-12",10},
{u"Etc/GMT-13",10},
{u"Etc/GMT+2",9},
{u"Etc/GMT+8",9},
{u"Etc/GMT+9",9},
{u"Etc/GMT+11",10},
{u"Asia/Ulaanbaatar",16},
{u"America/Caracas",15},
{u"Asia/Vladivostok",16},
{u"Europe/Volgograd",16},
{u"Australia/Perth",15},
{u"Africa/Lagos",12},
{u"Europe/Berlin",13},
{u"Asia/Hovd",9},
{u"Asia/Tashkent",13},
{u"Asia/Hebron",11},
{u"Pacific/Port_Moresby",20},
{u"Asia/Yakutsk",12}
};

inline constexpr basic_io_scatter_t<char32_t> u32iana_db_timezone[]
{
{U"Australia/Darwin",16},
{U"Australia/Sydney",16},
{U"Asia/Kabul",10},
{U"America/Anchorage",17},
{U"America/Adak",12},
{U"Asia/Barnaul",12},
{U"Asia/Riyadh",11},
{U"Asia/Dubai",10},
{U"Asia/Baghdad",12},
{U"America/Buenos_Aires",20},
{U"Europe/Astrakhan",16},
{U"America/Halifax",15},
{U"Australia/Eucla",15},
{U"Asia/Baku",9},
{U"Atlantic/Azores",15},
{U"America/Bahia",13},
{U"Asia/Dhaka",10},
{U"Europe/Minsk",12},
{U"Pacific/Bougainville",20},
{U"America/Regina",14},
{U"Atlantic/Cape_Verde",19},
{U"Asia/Yerevan",12},
{U"Australia/Adelaide",18},
{U"America/Guatemala",17},
{U"Asia/Almaty",11},
{U"America/Cuiaba",14},
{U"Europe/Budapest",15},
{U"Europe/Warsaw",13},
{U"Pacific/Guadalcanal",19},
{U"America/Chicago",15},
{U"America/Mexico_City",19},
{U"Pacific/Chatham",15},
{U"Asia/Shanghai",13},
{U"America/Havana",14},
{U"Etc/GMT+12",10},
{U"Africa/Nairobi",14},
{U"Australia/Brisbane",18},
{U"Europe/Chisinau",15},
{U"America/Sao_Paulo",17},
{U"Pacific/Easter",14},
{U"America/New_York",16},
{U"America/Cancun",14},
{U"Africa/Cairo",12},
{U"Asia/Yekaterinburg",18},
{U"Europe/Kiev",11},
{U"Pacific/Fiji",12},
{U"Europe/London",13},
{U"Europe/Bucharest",16},
{U"Asia/Tbilisi",12},
{U"America/Godthab",15},
{U"Atlantic/Reykjavik",18},
{U"America/Port-au-Prince",22},
{U"Pacific/Honolulu",16},
{U"Asia/Calcutta",13},
{U"Asia/Tehran",11},
{U"Asia/Jerusalem",14},
{U"Asia/Amman",10},
{U"Europe/Kaliningrad",18},
{U"Asia/Seoul",10},
{U"Africa/Tripoli",14},
{U"Pacific/Kiritimati",18},
{U"Australia/Lord_Howe",19},
{U"Asia/Magadan",12},
{U"America/Punta_Arenas",20},
{U"Pacific/Marquesas",17},
{U"Indian/Mauritius",16},
{U"Asia/Beirut",11},
{U"America/Montevideo",18},
{U"Africa/Casablanca",17},
{U"America/Denver",14},
{U"America/Chihuahua",17},
{U"Asia/Rangoon",12},
{U"Asia/Novosibirsk",16},
{U"Africa/Windhoek",15},
{U"Asia/Katmandu",13},
{U"Pacific/Auckland",16},
{U"America/St_Johns",16},
{U"Pacific/Norfolk",15},
{U"Asia/Irkutsk",12},
{U"Asia/Krasnoyarsk",16},
{U"Asia/Pyongyang",14},
{U"Asia/Omsk",9},
{U"America/Santiago",16},
{U"America/Los_Angeles",19},
{U"America/Tijuana",15},
{U"Asia/Karachi",12},
{U"America/Asuncion",16},
{U"Asia/Qyzylorda",14},
{U"Europe/Paris",12},
{U"Asia/Srednekolymsk",18},
{U"Asia/Kamchatka",14},
{U"Europe/Samara",13},
{U"Europe/Moscow",13},
{U"America/Cayenne",15},
{U"America/Bogota",14},
{U"America/La_Paz",14},
{U"Asia/Bangkok",12},
{U"America/Miquelon",16},
{U"Asia/Sakhalin",13},
{U"Pacific/Apia",12},
{U"Africa/Sao_Tome",15},
{U"Europe/Saratov",14},
{U"Asia/Singapore",14},
{U"Africa/Johannesburg",19},
{U"Asia/Colombo",12},
{U"Africa/Khartoum",15},
{U"Asia/Damascus",13},
{U"Asia/Taipei",11},
{U"Australia/Hobart",16},
{U"America/Araguaina",17},
{U"Asia/Tokyo",10},
{U"Asia/Tomsk",10},
{U"Pacific/Tongatapu",17},
{U"Asia/Chita",10},
{U"Europe/Istanbul",15},
{U"America/Grand_Turk",18},
{U"America/Indianapolis",20},
{U"America/Phoenix",15},
{U"Etc/GMT",7},
{U"Etc/GMT-12",10},
{U"Etc/GMT-13",10},
{U"Etc/GMT+2",9},
{U"Etc/GMT+8",9},
{U"Etc/GMT+9",9},
{U"Etc/GMT+11",10},
{U"Asia/Ulaanbaatar",16},
{U"America/Caracas",15},
{U"Asia/Vladivostok",16},
{U"Europe/Volgograd",16},
{U"Australia/Perth",15},
{U"Africa/Lagos",12},
{U"Europe/Berlin",13},
{U"Asia/Hovd",9},
{U"Asia/Tashkent",13},
{U"Asia/Hebron",11},
{U"Pacific/Port_Moresby",20},
{U"Asia/Yakutsk",12}
};
