# -*- coding: utf-8 -*-
#
# Coqui STT documentation build configuration file, created by
# sphinx-quickstart on Thu Feb  2 21:20:39 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#

# pylint: skip-file

import os
import sys

sys.path.insert(0, os.path.abspath("../"))

autodoc_mock_imports = ["stt", "native_client.ctcdecode.swigwrapper"]
autodoc_member_order = "bysource"

# This is in fact only relevant on ReadTheDocs, but we want to run the same way
# on our CI as in RTD to avoid regressions on RTD that we would not catch on CI
import subprocess

parent = subprocess.check_output("cd ../ && pwd", shell=True).decode().strip()
os.environ["PATH"] = (
    os.path.join(parent, "node_modules", ".bin") + ":" + os.environ["PATH"]
)
subprocess.check_call(
    "cd ../ && npm install typedoc@0.17.4 typescript@3.8.3 @types/node@13.9.x",
    shell=True,
)
subprocess.check_call("env", shell=True)
subprocess.check_call("which typedoc", shell=True)
subprocess.check_call("cd ../ && doxygen doc/doxygen-c.conf", shell=True)
subprocess.check_call("cd ../ && doxygen doc/doxygen-java.conf", shell=True)
subprocess.check_call("cd ../ && doxygen doc/doxygen-dotnet.conf", shell=True)

# -- General configuration ------------------------------------------------

import semver

# -- Project information -----------------------------------------------------

project = "Coqui STT"
copyright = "2021 Coqui GmbH, 2020 DeepSpeech authors, 2019-2020 Mozilla Corporation"
author = "Coqui GmbH"

with open("../VERSION", "r") as ver:
    v = ver.read().strip()
vv = semver.parse(v)

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
# The short X.Y version
version = "{}.{}".format(vv["major"], vv["minor"])
# The full version, including alpha/beta/rc tags
release = v

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "sphinx_js",
    "sphinx_csharp",
    "breathe",
    "recommonmark",
]


breathe_projects = {
    "stt-c": "xml-c/",
    "stt-java": "xml-java/",
    "stt-dotnet": "xml-dotnet/",
}

js_source_path = "../native_client/javascript/index.ts"
js_language = "typescript"
jsdoc_config_path = "../native_client/javascript/tsconfig.json"

# Add any paths that contain templates here, relative to this directory.
templates_path = [".templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The main toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = [".build", "Thumbs.db", ".DS_Store", "node_modules", "examples"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

add_module_names = False

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

html_theme_options = {
    "light_logo": "coqui-STT-circle.png",
    "dark_logo": "coqui-STT-circle.png",
    "sidebar_hide_name": True,
}

html_css_files = [
    "custom.css",
]

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["static"]


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "STTdoc"


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "STT.tex", "Coqui STT Documentation", "Coqui GmbH", "manual"),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "stt", "Coqui STT Documentation", [author], 1)]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "STT",
        "Coqui STT Documentation",
        author,
        "STT",
        "One line description of project.",
        "Miscellaneous",
    ),
]


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {"https://docs.python.org/": None}

extlinks = {
    "github": ("https://github.com/coqui-ai/STT/blob/v{}/%s".format(release), "%s")
}
