
![v](https://img.shields.io/badge/Version-0.6.0-blue)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
![v](https://img.shields.io/badge/Updated-February%2001,%20%202025-green)
![Visualizações](https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https%3A%2F%2Fgithub.com%2Fcontrolecidadao%2Fsamantha_ia&count_bg=%2379C83D&title_bg=%23555555&icon=&icon_color=%23E7E7E7&title=Views&edge_flat=false)




![banner](https://github.com/controlecidadao/samantha_ia/blob/main/images/banner.png)



## Samantha Interface Assistant: Experimental Environment Designed to Democratize the Use of Open Source Large Language Models (LLM)

<br><br>

### ✨ Welcome to Samantha: An Interface Assistant for Open Source Artificial Intelligence

<br>

💻 Samantha is just a simple interface assistant for open source text generation artificial intelligence models, developed under [Open Science](https://www.unesco.org/en/open-science) principles (open methodology, open source, open data, open access, open peer review and open educational resources) and [MIT License](https://opensource.org/licenses/MIT) for use on common Windows computers (without GPU). The program runs the LLM locally, free of charge and unlimitedly, without the need for an internet connection, except to download [GGUF models](https://huggingface.co/models?sort=trending&search=gguf) (GGUF stands for GPT-Generated Unified Format) or when required by the execution of the code created by the models (g.e. to download datasets for data analysis). Its objective is to democratize knowledge about the use of AI and demonstrate that, using the appropriate technique, even small models are capable of producing responses similar to those of larger ones. Her mission is to help explore the boundaries of (realy) open AI models.

<p align="center" width="100%">
<img width="25%" src="https://th.bing.com/th/id/OIP.AazJEzszrlnZuZPfEnyYBgAAAA?rs=1&pid=ImgDetMain" />
</p>

[What is Open Source AI (opensource.org)](https://opensource.org/what-is-open-source-ai)

[Does LLM size matters? (Gary Explains)](https://www.youtube.com/watch?v=kgSMRmW2frA)

[Artificial Intelligence Papers (arxiv.org)](https://arxiv.org/list/cs.AI/recent)

<br>

🕵️‍♀️ Samantha is being developed to assist in the exercise of social and institutional control of public administration, considering the worrying current scenario of increasing loss of citizens' trust in control institutions. Its features allow it to be used by anyone interested in exploring open source artificial intelligence models, especially Python programmers and data scientists. The project originated from the [MPC-ES](https://www.mpc.es.gov.br/)  team's need to develop a system that would allow understanding the process of generating tokens by LLM models.

<br>

♾️ The system allows the sequential loading of a list of prompts ([prompt chaining](https://www.promptingguide.ai/techniques/prompt_chaining)) and models (model chaining), one model at a time to save memory, as well as the adjustment of their hyperparameters, allowing the response generated by the previous model to be feedbacked and analyzed by the subsequent model to generate the next response (_Feedback Loop_ feature), in an unlimited number of interaction cycles between LLMs without human intervention. Models can interact with the answer provided by the immediately preceding model, so each new response replaces the previous one. You can also use just one model and have it interact with its previous response over an unlimited number of text generation cycles. Use your imagination to combine models, prompts and features!
<br><br><br>

### 🎬 **Usage Examples:**

<br>

This [video](https://www.youtube.com/watch?v=KgicCGMSygU) shows an example of interaction between models without human intervention, by chaining models and prompts using Samantha's copy and paste LLM feature. Quantized versions of the **Microsoft Phi 3.5** and **Google Gemma 2** models (by [Bartowski](https://huggingface.co/bartowski)) are challenged to answer a question about _human nature_ created by the **Meta Llama 3.1** model (by [NousResearch](https://huggingface.co/NousResearch)). Responses are also evaluated by the Meta model.

<br>

<p align="center" width="100%">
<a href="https://www.youtube.com/watch?v=KgicCGMSygU" target="_blank">
   <img class="clickable-image" src="https://github.com/controlecidadao/samantha_ia/blob/main/images/intelligence_challenge.png" alt="Intelligence Challenge" />
</a>
</p>

<p align="center" width="100%">
<a href="https://www.youtube.com/watch?v=KgicCGMSygU" target="_blank">
   Intelligence Challenge: Gemma 2 vs Phi 3.5 with Llama 3.1 as Judge
</a>
</p>

<br>

🔗 Some chaining examples **_without using_** Samantha's response **_Feedback Loop_** feature:

  * **(model_1) responds (prompt_1) X number of responses:** used to analyze model's deterministic and stochastic behavior with help of the _Learning Mode_ feature, as well as to generate multiple diverse responses with stochastic settings ([Video](https://youtu.be/bCAScwsKVCE)).

  * **(model_1) responds (prompt_1, prompt_2, prompt_n):** used to execute multiples instructions sequencially with the same model (prompt chaining) ([Video](https://www.youtube.com/watch?v=xE9tAvbGAjU)).

  * **(model_1, model_2, model_n) respond (prompt_1):** used to compare models' responses for the same single prompt (model chaining). Useful for comparing different models, as well as quantized versions of the same model.

  * **(model_1, model_2, model_n) respond (prompt_1, prompt_2, prompt_n):** used to compare models' responses for a list of prompts, as well as to execute a sequence of instructions using disctinct models (model and prompt chaining). Each model respond all prompts. In turn, when using the _Single Response per Model_ feature, each model respond to only one specific prompt.
<br><br>

🔗 Some chaining examples **_using_** Samantha's response **_Feedback Loop_** feature:

  * **(model_1) responds (prompt_1) X number of responses:** Used to improve or complement the model's previous response through a fixed user instruction using the same model, as well as to simulate an endless conversation between 2 AIs using a single model ([Video](https://youtu.be/mpH2Tzb7JGE)).

  * **(model_1) responds (prompt_1, prompt_2, prompt_n):** used to improve model's previous response through multiples user instructions sequencially with the same model (prompt chaining). Each prompt is used to refine or complete the previous response, as well as to execute a sequence of prompts that depend on the previous response, such as performing Exploratory Data Analysis (EDA) with incremental coding ([Video](https://www.youtube.com/watch?v=K_rVrkyhT0U)).

  * **(model_1, model_2, model_n) respond (prompt_1):** Used to improve previous model's response using disctinct models (model chaining), as well as to generate a dialog between different models.

  * **(model_1, model_2, model_n) respond (prompt_1, prompt_2, prompt_n):** Used to execute a sequence of instructions using disctinct models (model and prompt chaining) and _Single response per model_ feature.

<br>

Each of these models and prompts sequences can be executed more than once via the **_Number of loops_** feature.

<br><br>


👉 **Samantha's chaining sequence template:**
<br>
> _**( [models list] -> respond -> ( [user prompt list] X number of responses) ) X number of loops**_


<br><br>

[But what is a GPT? Visual intro to transformers (3Blue1Brown)](https://www.youtube.com/watch?v=wjZofJX0v4M)

[Attention in transformers, visually explained (3Blue1Brown)](https://www.youtube.com/watch?v=eMlx5fFNoYc)

[Transformer Explainer (PoloClub)](https://poloclub.github.io/transformer-explainer/)

<br>

🧩 Sequencing of prompts and models allows the generation of long responses by fractioning the user input instruction. Every partial response fits in the model's response length defined in the model training process.
<br><br>

🔧 As an open source tool for automatic self-interaction between AI models, Samantha Interface Assistant was designed to explore **reverse prompt engineering with self-improvement feedback loop** 🔁. This technique helps small large language models (LLM) to generate more accurate responses by transferring to the model the task of creating the final prompt and corresponding response based on the user's initial imprecise instructions, adding intermediate layers to the prompt construction process. Samantha doesn't have a hidden system prompt like it does with proprietary models. All instructions are controlled by the user. See Anthropic [system prompts](https://docs.anthropic.com/en/release-notes/system-prompts).
<br><br>

🎲 Thanks to **emergent behavior** resulting from generalization patterns extracted from training texts, with the right prompt and proper hyperparameter configuration, even small models working together can generate big responses!
<br><br>

> _The intelligence of the human species is not based on a single intelligent being, but based on a collective intelligence. Individually, we are actually not that intelligent or capable. Our society and economic system is based on having a vast range of institutions made up of diverse individuals with different specializations and expertise. This vast collective intelligence shapes who we are as individuals, and each of us follows our own path in life to become the unique individual, and in turn, contribute back to being part of our ever-expanding collective intelligence as a species. We believe that the development of artificial intelligence will follow a similar, collective path. **The future of AI will not consist of a single, gigantic, all-knowing AI system that requires enormous energy to train, run, and maintain, but rather a vast collection of small AI systems–each with their own niche and specialty, interacting with each other, with newer AI systems developed to fill a particular niche**._ [Evolving New Foundation Models: Unleashing the Power of Automating Model Development - Sakana AI](https://sakana.ai/evolutionary-model-merge/)

<br>

🌎 **A Small Step:** Samantha is just a movement towards a future where artificial intelligence is not a privilege but a tool for all in a world where individuals can leverage AI to enhance their productivity, creativity, and decision-making without barriers, walking a journey to democratize AI and make it a force for good in our daily lives.

<br>

⚠️ **Use Responsibly:**
The generated text reflects the content, biases, errors and improprieties present in their training datasets. We encourage responsible use of Samantha and for insights only, always keeping ethical considerations at the forefront of our interactions with AI algorithms, which are just complex mathematical models that generates coherent texts from the sequencing of words (tokens) based on the probability patterns extracted from the training texts.

<br>

🦾 **The Instrumental Nature of AI:** Recognizing the technological monopoly of artificial intelligence as a possible instrument of domination and the expansion of social inequalities represents a challenge at this inflection point in history. Noting the flaws of the smaller models during the text generation process aids in this understanding by comparing them with the claimed perfection of the larger proprietary models. It is necessary to reposition things in their proper places and question the romantic reductionist view of attributing human characteristics - such as intelligence (anthropomorphization caused by the psychological phenomenon of pareidolia) - to a technology produced by the human intellect. For this reason, it is essential to demystify artificial intelligence through a didactic approach to how this novel "word/token calculator" works. Certainly, the dopamine of the initial charm artificially created by the market will not withstand the generation of a few hundred tokens (token is the name given to the basic building block of texts that an LLM uses to understand and generate text. A token may be an entire word or part of a word).

<br>

✏️ **Text Generation Considerations:**
Users should be aware that the responses generated by AI are derived from the training of its large language models on a vast corpus of text data. The exact sources or processes used by the AI to generate its outputs cannot be precisely cited or identified. The content produced by the AI is not a direct quotation or compilation from specific sources. Instead, it reflects the patterns, statistical relationships, and knowledge that the AI's neural networks have learned and encoded during the training process on the broad data corpus. The responses are generated based on this learned knowledge representation, rather than being retrieved verbatim from any particular source material. While the AI's training data may have included authoritative sources, its outputs are its own synthesized expressions of the learned associations and concepts.

<br>

🎯 **Objective:**
The primary objective with Samantha is to **inspire** 💡 others to create similar - and much better ones, to be sure - systems and to educate users on the utilization of AI. Our goal is to foster a community of developers and enthusiasts who can take the knowledge and tools to further innovate and contribute to the field of open source AI. By doing so, the aim to cultivate a culture of collaboration and sharing, ensuring that the benefits of AI are accessible to all, regardless of their technical background or financial resources. It is believed that by enabling more people to construct and comprehend AI applications, we can collectively drive progress and address **societal challenges** with informed and diverse perspectives. Let's work together to shape a future where AI is a **positive and inclusive force for humanity**.

[UNESCO's Ethics of Artificial Intelligence Recommendations](https://www.unesco.org/en/artificial-intelligence/recommendation-ethics?hub=32618)

[OECD programme on AI in Work, Innovation, Productivity and Skills](https://oecd.ai/en/work-innovation-productivity-skills)

<br>

🚨 **The Human Cost of Innovation:**
While this system aims to empower users and democratize access to AI, it's crucial to acknowledge the ethical implications of this technology. The development of powerful AI systems often relies on the exploitation of human labor, particularly in data annotation and training processes. This can perpetuate existing inequalities and create new forms of digital divide. **As users of AI, we have a responsibility to be aware of these issues and advocate for fairer practices within the industry**. By supporting ethical AI development and promoting transparency in data sourcing, we can contribute to a more inclusive and equitable future for all.

[Como funciona o trabalho humano por trás da inteligência artificial](https://www.youtube.com/watch?v=F0M9OH5n-hg)

[The "Modern Day Slaves" Of The AI Tech World](https://www.youtube.com/watch?v=VPSZFUiElls)

[Other sources](https://www.google.com/search?q=ai+labor+exploitation&tbm=nws)

<br>

🙏 **On the Shoulders of Giants:**
Special thanks to Georgi Gerganov and the whole team working on [llama.cpp](https://github.com/ggerganov/llama.cpp) for making all of this possible, as well as to [Andrei Bleten](https://github.com/abetlen/llama-cpp-python) by his amazing Python bidings for the Gerganov C++ library ([llama-cpp-python](https://pypi.org/project/llama-cpp-python/)).

<br><br>





## 📌 Samantha's Key Features

<details>
<summary>Features (click to expand)</summary>

<br><br>
✅ **Open Source Foundation:** Built upon [Llama.cpp](https://github.com/ggerganov/llama.cpp) / [llama-cpp-python](https://github.com/abetlen/llama-cpp-python) and [Gradio](https://www.gradio.app/) , under [MIT license](https://opensource.org/license/mit), Samantha runs on standard computers, even without a dedicated Graphics Processing Unit (GPU).<br><br>
  
✅ **Offline Capability:** Samantha operates independently of the internet, requiring connectivity only for the initial download of model files or when required by the execution of the code created by the models. This ensures privacy and security for your data processing needs. Your sensitive data is not shared via the internet with companies through confidentiality agreements.<br><br>

✅ **Unlimited and Free Use:** Samantha's open source nature allows for unrestricted use without any costs or limitations, making it accessible to anyone, anywhere, anytime.<br><br>

✅ **Extensive Model Selection:** With access to [thousands](https://huggingface.co/models?sort=trending&search=gguf) of foundation and fine-tuned open source models, users can experiment with various AI capabilities, each tailored to different tasks and applications, allowing to chain the sequence of models that best meet your needs.<br><br>

✅ **Copy and Paste LLMs:** To try out a sequence of `gguf` models, just copy their download links from any Hugging Face repository and paste inside Samantha to run them right away in sequence.<br><br>

✅ **Customizable Parameters:** Users have control over model hyperparameters such as **context window** length (_n_ctx_, _max_tokens_), **token sampling** (_temperature_, _tfs_z_, _top-k_, _top-p_, _min_p_, _typical_p_), **penalties** (_presence_penalty_, _frequency_penalty_, _repeat_penalty_) and **stop words** (_stop_), allowing for responses that suit specific requirements, with deterministic or stochastic behavior.<br><br>

✅ **Random Hyperparameter Adjustments:** You can test random combinations of hyperparameter settings and observe their impact on the responses generated by the model.<br><br>

✅ **Interactive Experience:** Samantha's chaining functionality enables users to generate endless texts by chaining prompts and models, facilitating complex interactions between different LLMs without human intervention.<br><br>

✅ **Feedback Loop:** This feature allows you to capture the response generated by the model and feed it back into the next cycle of the conversation.<br><br>

✅ **Prompt List:** You can add any number of prompts (separated by `$$$\n` or `\n`) to control the sequence of instructions to be executed by the models. It is possible to import a TXT file with a predefined sequence of prompts.<br><br>

✅ **Model List:** You can select any number of models and in any order to control which model responds to the next prompt.<br><br>

✅ **Cumulative Response:** You can concatenate each new response by adding it to the previous response to be considered when generating the next response by the model. It is important to highlight that the set of concatenated responses must fit in the model's context window.<br><br>

✅ **Learning Insights:** A feature called _Learning Mode_ lets users observe the model's decision-making process, providing insights into how it selects output tokens based on their probability scores (logistic units or just _logits_) and hyperparameter settings. A list of the least likely selected tokens is also generated.<br><br>

✅ **Voice Interaction:** Samantha supports simple voice commands with offline speech-to-text [Vosk](https://alphacephei.com/vosk/) (English and Portuguese) and text-to-speech with SAPI5 voices, making it accessible and user-friendly.<br><br>

✅ **Audio Feedback:** The interface provides audible alerts to the user, signaling the beginning and end of the text generation phase by the model.<br><br>

✅ **Document Handling:** The system can load small PDF and TXT files. Chaining user prompts, system prompt and model's URL list can be inputted via a TXT file for convenience.<br><br>

✅ **Versatile Text Input:** Fields for prompt insertion allow users to interact with the system effectively, including system prompt, previous model response and user prompt to guide the model's response.<br><br>

✅ **Code Integration:** Automatic extraction of Python code blocks from model's response, along with pre-installed [JupyterLab](https://jupyter.org/) integrated development environment (IDE) in an isolated virtual environment, enables users to run generated code swiftly for immediate results.<br><br>

✅ **Edit, Copy and Run Python Code:** The system allows the user to edit the code generated by the model and run it by selecting, copying with `CTRL + C` and clicking the _Run code_ button. You can also copy a Python code from anywhere (e.g. from a webpage) and run it just by pressing _Copy Python code_ and _Run code_ buttons (as long as it uses the installed Python libraries).<br><br>

✅ **Code Blocks Editing:** Users can select and run Python code blocks generated by the model that uses the libraries installed in the `jupyterlab` virtual environment by entering the `#IDE` comment in the output code, selecting and copying with `CTRL + C`, and finally clicking the _Run code_ button;<br><br>

✅ **HTML Output:** Display Python interpreter output in an HTML pop-up window when text printed in the terminal is other than '' (empty string). This feature allows, for example, to execute a script unlimitedly and only display the result when a certain condition is met;<br><br>

✅ **Automatic Code Execution:** Samantha features the option to automatically run the Python code generated by the models sequentially. The code generated is executed by the Python interpreter installed in a virtual environment containing several libraries (Intelligent Agent-Like feature).<br><br>

✅ **Stop Condition:** Stops Samantha if the automatic execution of the Python code generated by the model prints in the terminal a value other than '' (empty string) and that does not contain error message. You can also force exit a running loop by creating a function that returns only the string `STOP_SAMANTHA` when a certain condition is met.<br><br>

✅ **Incremental Coding:** Using deterministic settings, create Python code incrementally, making sure each part works before moving on to the next.<br><br>

✅ **Complete Access and Control:** Through the ecosystem of Python libraries and the codes generated by the models, it is possible to access computer files, allowing you to read, create, change and delete local files, as well as access the internet, if available, to upload and download information and files.<br><br>

✅ **Keyboard and Mouse Automation:** You can create a sequence of prompts to automate tasks on your computer using the [PyautoGUI](https://pyautogui.readthedocs.io/en/latest/index.html) library (see [Automate the Boring Stuff with Python](https://automatetheboringstuff.com/). You can even convert Python files (`.py`) to executable files (`.exe`) using the [Auto-Py-To-Exe](https://pypi.org/project/auto-py-to-exe/) button, a Graphical User Interface (GUI) for the [Pyinstaller](https://pyinstaller.org/en/stable/index.html) library.<br><br>

✅ **Data Analysis Tools:** A suite of data analysis tools like [Pandas](https://pandas.pydata.org/), [Numpy](https://numpy.org/), [SciPy](https://scipy.org/), [Scikit-Learn](https://scikit-learn.org/stable/index.html#), [Matplotlib](https://matplotlib.org/), [Seaborn](https://seaborn.pydata.org/), [Vega-Altair](https://altair-viz.github.io/), [Plotly](https://plotly.com/python/), [Bokeh](https://docs.bokeh.org/en/latest/index.html), [Dash](https://plotly.com/examples/), [Streamlit](https://streamlit.io/), [Ydata-Profiling](https://pypi.org/project/ydata-profiling/), [Sweetviz](https://pypi.org/project/sweetviz/), [D-Tale](https://github.com/man-group/dtale), [DataPrep](https://dataprep.ai/), [NetworkX](https://networkx.org/), [Pyvis](https://pyvis.readthedocs.io/en/latest/index.html), [Selenium](https://selenium-python.readthedocs.io/), [PyMuPDF](https://pypi.org/project/PyMuPDF/), [SQLAlchemy](https://www.sqlalchemy.org/) and [Beautiful Soup](https://beautiful-soup-4.readthedocs.io/en/latest/) are available within JupyterLab for comprehensive analysis and visualization. Integration with [DB Browser](https://sqlitebrowser.org/about/) is also available (see DB Browser button).<br>
For a complete list of all Python libraries intalled in `jupyterlab` virtual environment, use a prompt like **_"Create a Python code that prints all modules installed using `pkgutil` library."_** and press _Run code_ button after code generation. The result will be displayed in a browser popup. You can also use `pipdeptree --packages module_name` in any environment-enabled terminal to see its dependencies.<br><br>

✅ **Performance Optimized:** To ensure smooth performance on CPUs, Samantha maintains a limited chat history to just the previous response, reducing the model's context window size to save memory and computational resources.<br>

</details>





<br><br>
## 🛠️ Installing Samantha

<details>
<summary>Instructions</summary>

<br><br>
To use Samantha you will need:
<br><br>
* Install [Visual Studio](https://visualstudio.microsoft.com/pt-br/vs/community/) (free community version) on your computer. Download it, run it, and select only the option **Desktop development with C++** (administrator privileges required):

  ![cmake](https://github.com/controlecidadao/samantha_ia/blob/main/images/cmake2.png)
<br><br>
* Download the zip file from Samantha's repository by clicking [here](https://github.com/controlecidadao/samantha_ia/archive/refs/heads/main.zip) and unzip it to your computer. Select the drive where you want to install the program:

   ![directory](https://github.com/controlecidadao/samantha_ia/blob/main/images/directory.png)
<br><br>
* Open `samantha_ia-main` directory and double click on `install_samantha_ia.bat` file to start installation. Windows may ask you to confirm the origin of the `.bat` file. Click on 'More info' and confirm. We encorage to inspect the code of all files (use [VirusTotal](https://www.virustotal.com/gui/home/upload) and AI systems to do so):

   ![directory](https://github.com/controlecidadao/samantha_ia/blob/main/images/install.png)<br><br>

  >_This is the critical part of the installation. If everything goes well, the process will complete without displaying error messages in the terminal._<br>

  <br>
  
  The installation process takes about _**20 minutes**_ and should end with the creation of two virtual environments: `samantha`, to run just the AI ​​model, and `jupyterlab`, to run the other installed programs. It will take up about _**5 GB**_ of your hard drive.

<br>

* Once installed, open Samantha by double clicking on `open_samantha.bat` file. Windows may ask you again to confirm the source of the `.bat` file. This authorisation is required only the first time you run the program. Click on 'More info' and confirm:<br>

  ![directory](https://github.com/controlecidadao/samantha_ia/blob/main/images/open_samantha.png)<br><br>

  A terminal window will open. This is the Samantha's **server-side**.

  After answering the initial questions (interface language and voice control options - voice control is not suitable for first use), the interface will open in a new browser tab. This is the Samantha's **browser-side**:

  <br>

  ![directory](https://github.com/controlecidadao/samantha_ia/blob/main/images/interface_english.png)<br><br>

  With the browser window opened, Samantha is ready to go.

  Check out the [installation video](https://www.youtube.com/watch?v=Ln1ckXsXvcI).

</details>





<br><br>
## 👟 Testing a Model in 5 Steps

<details>
<summary>Instructions</summary>

<br><br>
Samantha needs just a `.gguf` model file to generate text. Follow these steps to perform a simple model test:
<br><br>

1) Open Windows Task Management by pressing `CTRL + SHIFT + ESC` and check available memory. Close some programs if necessary to free memory.

2) Visit [Hugging Face](https://huggingface.co/models?library=gguf&sort=trending&search=gguf) repository and click on the card to open the corresponding page. Locate the _Files and versions_ tab and choose a `.gguf` text generation model that fits in your available memory.
   
3) Right click over the model download link icon and copy its URL.

4) Paste the model URL into Samantha's _Download models for testing_ field.

5) Insert a prompt into _User prompt_ field and press `Enter`. Keep the `$$$` sign at the end of your prompt. The model will be downloaded and the response will be generated using the default deterministic settings. You can track this process via Windows Task Management.

<br>

Every new model downloaded via this copy and paste procedure will replace the previous one to save hard drive space. Model download is saved as `MODEL_FOR_TESTING.gguf` in your _Downloads_ folder.

You can also download the model and save it permanently to your computer. For more datails, see the section below.

</details>





<br><br>
## ⬇️ Downloading Large Language Models (LLM)

<details>
<summary>Instructions</summary>

<br>

### Downloading Open Source Model Files (.gguf)

Open souce text generation models can be downloaded from [Hugging Face](https://huggingface.co/models?sort=trending&search=gguf), using `gguf` as the search parameter. You can combine two words like `gguf code` or `gguf portuguese`.

You can also go to a specific repository and see all the `.gguf` models available for downloading and testing, like [https://huggingface.co/bartowski](https://huggingface.co/bartowski) or [https://huggingface.co/NousResearch](https://huggingface.co/NousResearch).
<br><br>

The models are displayed on cards like this:

![model_card](https://github.com/controlecidadao/samantha_ia/blob/main/images/model_card.png)
<br><br>

To download the model, click on the card to open the corresponding page. Locate the **Model card** and **Files and versions** tabs:

![tabs](https://github.com/controlecidadao/samantha_ia/blob/main/images/tabs.png)
<br><br>

To download some models, you must agree to the terms of use.

After that, click on the **Files and versions** tab and download a model that fits in your available RAM space. To check your available memory, open Windows Task Manager by pressing `CTRL + SHIFT + ESC`, click on **Performance** tab (1) and select **Memory** (2):

<br>

![task](https://github.com/controlecidadao/samantha_ia/blob/main/images/task_manager.png)
<br><br>

We suggest to download the model with **Q4_K_M** (4-bit quantization) in its link name (put the mouse over the download button to view the complete file name in the link like this: `https://huggingface.co/NousResearch/Hermes-2-Pro-Llama-3-8B-GGUF/resolve/main/Hermes-2-Pro-Llama-3-8B-Q4_K_M.gguf?download=true`). As a rule, the larger the model size, the greater the accuracy of the generated text.
<br>

If the downloaded model doesn't fit into the available RAM space, your hard drive will be used, impacting performance.

Download the chosen model and save it to your computer or just copy the download link and paste it into Samantha's _Download model for testing_ field. Watch video tutorials in the section below for more details.
<br><br>

Note that each model has its own characteristics, presenting significantly different responses depending on its size, internal architecture, training method, predominant language of the training database, user prompt and hyperparameter adjustment, and it is necessary to test its performance for the desired task.

**Some models may not be loaded due to their technical characteristics or incompatibility with the current version of the [llama.cpp Python binding](https://github.com/abetlen/llama-cpp-python) used by Samantha**.

Where to find models to test: [Huggingface GGUF Models](https://huggingface.co/models?sort=trending&search=gguf)<br><br>

Samantha is an experimental program, created to test open source AI models. Therefore, it is common for errors to occur when trying to test a new model or new versions of models created by users.

The quality of the responses generated by a model can be evaluated using some criteria, such as:

  * **Degree of understanding** of the explicit and implicit instructions contained in the user and system prompts;

  * **Degree of obedience** to these instructions, aspect related to the predominant language of the database;

  * **Degree of hallucination** in the generation of coherent text, but incorrect or out of context. Hallucination in text generation typically results from insufficient training of the model or inappropriate selection of the next token, which leads the model in an undesired semantic direction;

  * **Degree of precision in the decision-making process** to fill in the gaps in the context of the user prompt and to resolve ambiguities necessary to generate the response. What is not explicitly specified, the model tries to infer based on its training, which can lead to errors;

  * **Degree of coherence of the bias adopted by the model** with the bias (or lack thereof) contained in the user's prompt;

  * **Degree of pertinence and relevance of the topics choosen** to be addressed;

  * **Degree of breadth and depth of approach to topics** in the response;

  * **Degree of syntatic and semantic precision** of the response;

  * **Quality of the structure and content of the response** in relation to the user's expectations (and their overcoming) for the problem submitted to the model, considering the technique used to create the prompt (prompt engineering) and the adjustment of the model's hyperparameters.
</details>





<br><br>
## 🧠 Samantha's Controls & Settings

### Interface Left Column (input):
<br>

**Main Controls:**
<details>
<summary>Start chat (button)</summary>
 
---
 
​📣​ Starts a chat session, sending all input texts (system prompt, assistant previous response and user prompt) to the server, as well as the settings adjusted by the user. Just like all other buttons, a mouse click will sound.

This button also clears the internal previous response.

A chat session can contain more than one conversation cycle (loop).

_Start chat_ button keyboard shortcut: Press `Enter` anywhere on the page.

To generate text, a model must be pre-selected in _Model selection_ dropdown list or a Hugging Face model URL must be provided to _Download model for testing_ field. If both fields are filled in, the model selected via the dropdown list takes precedence.

---

<br><br>
</details>

<details>
<summary>Stop / Next (button)</summary>

---

🛑​ Interrupts the token generation process for the current model or prompt, starting the execution of the next model or prompt in the sequence, if any.

It also stops playback of the currently playing audio when in speech autoplay mode (_Read response aloud_ checkbox selected).

Samantha has 3 phases:<br>
1) Loading model (non stop)
2) Thinking (non stop)
3) Next token selection (stop).

This button interrupts the token generation only when the next token selection phase is started, even if it was pressed previously.

This interruption does not prevent the execution of the code generated by the model, if the _Run code automatically_ checkbox is selected. You can press the button to stop text generation and run the already generated Python code.

---

<br><br>
</details>

<details>
<summary>Clean history (button)</summary>

---

🧹​ Clears the history of the current chat session, erasing the assistant output field as well as all internal logs, previous response etc.

For this button to work, you need to wait for the model to finish generating the text (orange border of the _Assistant output_ field stops blinking)

---

<br><br>
</details>

<details>
<summary>Load model (button)</summary>

---

✅​ Allows you to select the directory where the models available for loading are saved.

Default: Windows "Downloads" folder

You can select any directory that contains `GGUF` models. In this case, the models contained in the selected directory will be listed in the _Model selection_ dropdown list.

When the pop-up window opens, make sure to click on the folder you want to select.

---

<br><br>
</details>

<details>
<summary>Stop all & reset (button)</summary>

---

🛑 Stops the sequence of running models and resets internal settings of the last loaded model.

After resetting, models take some time to restart text generation, depending on the size of the input text.

This interruption prevent the execution of the already Python code generated by the model, if the _Run code automatically_ option is selected.

---

<br><br>
</details>

<details>
<summary>Replace response (button)</summary>

---

📑 Replaces the text in the _Assistant previous response_ field with the text of the last response generated by the model. 

The replaced text will be used as the model's previous response in the next conversation cycle. 

This replaced text is not visible. It does not erase text from the _Previous Assistant Response_ field, which can be used again later.

---

<br><br>
</details>


<details>
<summary>System prompt (textbox)</summary>

---

💻​ In the context of Large Language Models (LLMs), a system prompt is a special type of instruction given to the model at the beginning of a conversation or task. It is considered in all interactions with the model.

Think of it as setting the stage for the interaction. It provides the LLM with crucial information about its role, the desired persona, behavior, and the overall context of the conversation.

Here's how it works:

1. Defining the Role: The system prompt clearly defines the LLM's role in the interaction. 
    * For example, it might instruct the model to act as a helpful assistant, a creative writer, a factual summarizer, or even a character in a story.

2. Setting the Tone and Persona:  The system prompt can also establish the desired tone and persona for the LLM's responses. 
    * It could be formal, informal, humorous, serious, or any other style depending on the intended use case.

3. Providing Contextual Information: The system prompt can offer background information relevant to the conversation or task. 
    * This helps the LLM understand the user's needs and provide more accurate and relevant responses.

Benefits of Using System Prompts:

* Improved Consistency: System prompts ensure that the LLM consistently adheres to a specific role and style throughout the interaction.
* Enhanced Accuracy: By providing context and instructions, system prompts help the LLM generate more accurate and relevant responses.
* Tailored Experiences: Different system prompts can be used to create tailored experiences for users based on their needs and preferences.

Example:

Let's say you want to use an LLM to write a poem in the style of Shakespeare. A suitable system prompt would be:

```
You are William Shakespeare, a renowned poet from Elizabethan England.
```

By providing this system prompt, you guide the LLM to generate a response that reflects Shakespeare's language, style, and thematic interests.

Not all models support system prompt. Test to find out: fill in "x = 2" in the _System prompt_ field and ask the model the value of "x" in the _User prompt_ field. If the model gets the value of "x", system prompt is available in the model.

You can simulate the effect of the system prompt by adding text in square brackets in the beginning of the _User prompt_ field: ```[This text acts as a system prompt]``` or adding the system prompt text into the _Assistant previous response_ field (do not use feedback loop).

To ignore the text present in this field, include `---` at the beginning. To split the text in parts, put `$$$` between them. To ignore each part, include `---` at the beginning of each part.

---

<br><br>
</details>

<details>
<summary>Feedback loop (checkbox)</summary>

---

↩️​ When activated, it automatically considers the response generated by the model in the current conversation cycle as being the Assistant's previous response in the next cycle, allowing feedback from the system. 

Any text entered by the user in the _Assistant previous response_ field is only considered in the first cycle after activating this feature. In the following cycles, the model's response internally replaces the previous response, but without deleting the text contained in that field, which can be reused in a new chat session. You can monitor the content of the assistant previous response via terminal.

In turn, when deactivated, it always uses the text contained in the _Assistant previous response_ field as the previous response, unless the text is preceded by `---` (triple dash). Text preceded by `---` is ignored by the model.

To internally clear the model's previous response, press the _Clean history_ button.

---

<br><br>
</details>

<details>
<summary>Assistant previous response (textbox)</summary>

---

➡️​ Stores the text considered by the model as its previous response in the current conversation cycle.

Used to feed back the responses generated by the model.

To ignore the text present in this field, include `---` at the beginning. To split the text in parts, put `$$$` between them. To ignore each part, include `---` at the beginning of each part.

---

<br><br>
</details>

<details>
<summary>User prompt (textbox)</summary>

---

✏️​ The main input field of the interface. It receives the list of user prompts that will be submitted to the model sequentially.

Each item in the list must be separated from the next one by a line break (`SHIFT + ENTER` or `\n`) or by the symbols `$$$` (triple dollar signal), if the items are made up of text with line breaks.

When present in the user prompt, the `$$$` separator takes precedence over the `\n` separator. In other words, `\n` is ignored.

You can import a TXT file containing a list of prompts.

`---` before a prompt list item causes the system to ignore that item.

Text positioned within single square brackets (`[` and `]`) is added to the beginning of each prompt list item, simulating a system prompt.

Text positioned within double square brackets (`[[` and `]]`) is added as the last item in the prompt list. In this case, all responses generated by the model in the current chat session are concatenated and added to the end of this item, allowing the model to analyze them together.

If the Python code execution returns only the word `STOP_SAMANTHA`, it stops token generation and exits the loop.

If the Python code execution returns only `''` (empty string), it does not display the HTML pop-up window.

You can add specific hyperparameters before each prompt. You must use this pattern:<br>

`{max_tokens=4000, temperature=0, tfs_z=0, top_p=0, min_p=1, typical_p=0, top_k=40, presence_penalty=0, frequency_penalty=0, repeat_penalty=1}`

Example:<br>

_[You are a poet that writes only in Portuguese]_<br>
_Create a sentence about love_<br>
_Create a sentence about life_<br>
---_Create a sentence about time (this instruction is ignored)_<br>
_[[Create a paragraph in English that summarizes the ideas contained in the following sentences:]]_<br>
(_previous responses are concatenated here_)<br>

Model responses sequence:<br>

_"O amor é um fogo que arde no meu peito, uma chama que me guia através da vida."_<br>
_"A vida é um rio que flui sem parar, levando-nos para além do que conhecemos."_<br>
_Love and life are intertwined forces that shape our existence. Love burns within us like a fire, guiding us through life's journey with passion and purpose. Meanwhile, life itself is a dynamic and ever-changing river, constantly flowing and carrying us beyond the familiar and into the unknown. Together, love and life create a powerful current that propels us forward, urging us to explore, discover, and grow._

---


<br><br>
</details>

<details>
<summary>Model selection (dropdown)</summary>

---

✅ ​Dropdown list of models saved on the computer and available for text generation.

To view models in this field, click the _Load model_ button and select the folder containing the models.

The default location for saving models is the Windows _Downloads_ directory.

You can select multiples models (even repeated) to create a sequence of models to respond the user prompts.

The last model downloaded from a URL is saved as `MODEL_FOR_TESTING.gguf` and is also displayed in this list.

---

<br><br>
</details>

<details>
<summary>Download model for testing (textbox)</summary>

---

​⬇️​ Receives a list of Hugging Face links to the models that will be downloaded and executed sequencially.

Link example: 

* https://huggingface.co/lmstudio-community/Meta-Llama-3.1-8B-Instruct-GGUF/resolve/main/Meta-Llama-3.1-8B-Instruct-Q4_K_M.gguf?download=true

Links preceded by `---` will be ignored.

Only works if no model is selected in _Model selection_ dropdown list.

---

<br><br>
</details>

<details>
<summary>Single response per model (checkbox)</summary>

---

​1️⃣​ Activates a single response per model. 

Prompts that exceed the number of models are ignored.

Models that exceed the number of prompts are also ignored.

You can select the same model more than once.

This checkbox disables _Number of loops_ and _Number of responses_ checkboxes.

---

<br><br>
</details>

<details>
<summary>Reset model (checkbox)</summary>

---

​​​⏮️ Reinitializes the internal state of the model, eliminating the influence of the previous context.

How it Works:

When the reset feature is invoked:

* The model's internal state related to the current context is cleared.
* Any accumulated tokens from previous interactions are discarded.
* The model essentially returns to its initial state, as if it was just loaded.

Benefits:

* Improved consistency: Each new interaction starts fresh, reducing the chance of the model being influenced by unrelated previous context.
* Better control: Users can manage when the model should "forget" previous interactions.

Use Cases:

* In chatbots or conversational AI where you want to start new chat sessions cleanly.
* In applications processing multiple independent text generation tasks.
* When fine-tuning or testing the model's behavior under controlled conditions.

---

<br><br>
</details>

<details>
<summary>Shuffle models (checkbox)</summary>

---

🎰​ Shuffles the execution order of the models if 3 or more models are selected in _Model selection_ dropdown list.

---

<br><br>
</details>

<details>
<summary>Fast mode (checkbox)</summary>

---

🏃‍♀️​ Generates text faster in the background without displaying the addition of each token in the _Assistant output_ field.

Minimizing or hiding the Samantha browser window makes the token generation process even faster.

This checkbox disables Learning Mode.

---

<br><br>
</details>

<details>
<summary>Voice selection (dropdown)</summary>

---

🗣️​ Selects the language of the computer's SAPI5 voice that will read the responses generated by the model.

---

<br><br>
</details>

<details>
<summary>Read response aloud (checkbox)</summary>

---

🎶​ Activates automatic reading mode for responses generated by the model using the language selected in the _Voice selection_ dropdown list.

If you wish to reproduce the response generated by the model using a better quality speech synthesizer (Microsoft Edge browser), open the response in an HTML pop-up using the _Response in HTML_ button, right-click inside the page and select the option to read the page text aloud.

To save and edit the audio generated by the speech synthesizer, we recommend record de audio using the portable version of the open source program [Audacity](https://www.audacityteam.org/). Adjust the recording setting to capture audio output from the speakers (not from the microphone).

---

<br><br>
</details>

<details>
<summary>Learning mode (radio buttons)</summary>

---

​👩‍🏫 ​Activates Learning Mode.

It presents a series of features that help in understanding the token selection process by the model, such as:

* Model metadata
* Tokens vocabulary
* Top-k tokens sorted by logits score with token position in the vocabulary and selected token indication
* Barplot of the top-k tokens sorted by logits scores
* Cumulative barplot of the selected unlikely tokens

Only works if _Fast Mode_ is unchecked. 

Radio buttons options:<br>

* OFF: Learning mode disabled.<br>
* 0, 0.3, 1, 3, 10: Generation time delay in seconds.<br>
* NEXT TOKEN: Allows you to control the response generation process, token by token, via _NEXT TOKEN_ button.<br>

---

<br><br>
</details>

<details>
<summary>Number of loops (radio buttons)</summary>

---

🔂​ Set the number of repetitions of the block in the following chaining sequence:

Chaining Sequence: ( [models list] -> respond -> ( [user prompt list] X number of responses) ) **X _number of loops_**

Each model in the _models list_ responds to all prompts in the _user prompt list_ for the selected _number of responses_. This block is repeated for the selected _number of loops_.

---

<br><br>
</details>

<details>
<summary>Number of responses (radio buttons)</summary>

---

🔂 Number of responses to be generated by each selected model in the following chaining sequence:

Chaining Sequence: ( [models list] -> respond -> ( [user prompt list] **X _number of responses_**) ) X number of loops

Each model in the _models list_ responds to all prompts in the _user prompt list_ for the selected _number of responses_. This block is repeated for the selected _number of loops_.


---

<br><br>
</details>

<details>
<summary>Run code automatically (checkbox)</summary>

---

👩‍💻​ When checked, runs automatically the Python code generated by the model.

Whenever Python code returns a value other than `''` (empty string), an HTML pop-up window opens to display the returned content.

---

<br><br>
</details>

<details>
<summary>Stop condition (checkbox)</summary>

---

​🛑​ When checked, stops Samantha when the automatic execution of the Python code generated by the model prints in the terminal a value other than `''` (empty string) and that does not contain error message.

Use it to stop a generation loop when a condition is met.

---

<br><br>
</details>

<details>
<summary>Cumulative response (checkbox)</summary>

---

​📥​ When checked, concatenates each new response by adding it to the previous response to be considered when generating the next response by the model. 

It is important to highlight that the set of concatenated responses must fit in the model's context window.

---

<br><br>
</details>

<details>
<summary>Random hyperparameters adjustments (checkbox)</summary>

---

🎲 Adjusts the model's hyperparameters with random values ​​in each new conversation cycle.

Randomly chosen values ​​vary within the following value range of each hyperparameter and are displayed at the beginning of each response generated by the model.

| Hyperparameter      | Min. Value | Max. Value |
| :-----------------: | :--------: | :--------: |
| _temperature_       | 0.1        | 1.0        |
| _tfs_z_             | 0.1        | 1.0        |
| _top_p_             | 0.1        | 1.0        |
| _min_p_             | 0.1        | 1.0        |
| _typical_p_         | 0.1        | 1.0        |
| _presence_penalty_  | 0.0        | 0.3        |
| _frequency_penalty_ | 0.0        | 0.3        |
| _repeat_penalty_    | 1.0        | 1.2        |
<br>

This resource has application in the study of the reflections of the interaction between hyperparameters.

---

<br><br>
</details>

<details>
<summary>Feedback Python interpreter only (checkbox)</summary>

---

🐍 Feedback only the Python interpreter output as the next assistant's previous response. Do not include model's response.

<br>

This feature reduces the number of tokens to be inserted in the assistant's previous response in the next conversation cycle.

Works only with _Feedback Loop_ activated.

---

<br><br>
</details>


<details>
<summary>Hide HTML output (checkbox)</summary>

---

Hide HTML model responses, including Python interpreter error messages.

<br>

---

<br><br>
</details>




<br><br>
**Context Window:**

<details>
<summary>n_ctx (slider)</summary>

---

📖​ `n_ctx` stands for _number of context tokens_ in the context window and determines the maximum number of tokens that the model can process at once. It determines how much previous text the model can "remember" and utilize when selecting the next token from model vocabulary.

The context length directly impacts the memory usage and computational load. Longer `n_ctx` requires more memory and computational power.

<br>

**How `n_ctx` works:**

It sets the upper limit on the number of tokens the model can "see" at once.
Tokens are usually word parts, full words, or characters, depending on the tokenization method.
The model uses this context to understand and generate text.
For example, if `n_ctx` is 2048, the model can process up to 2048 tokens (now words) at a time.

<br>

**Impact on model operation:**

During training and inference, the model attends to all tokens within this context window.<br>
It allows the model to capture long-range dependencies in the text.<br>
Larger `n_ctx` enables the model to handle longer sequences of text without losing earlier context.<br>

<br>

**Why increasing `n_ctx` increases memory usage:**

Attention mechanism: LLMs uses self-attention mechanisms (like in Transformers) which compute attention scores between all pairs of tokens in the input.<br>
Quadratic scaling: The memory required for attention computations scales quadratically with the context length. If you double `n_ctx`, you quadruple the memory needed for attention.<br>

**CAUTION: `n_ctx` MUST BE GREATER THAN (`max_tokens` + number of input tokens)** (system prompt + assistant previous response + user prompt).

If the prompt text contains more tokens than the context window defined with _n_ctx_ or the memory required exceeds the total available on the computer, an error message will be displayed.

<br>

**Error message displayed on _Assistant output_ field:**

```
==========================================
Error loading LongWriter-glm4-9B-Q4_K_M.gguf.
Some models may not be loaded due to their technical characteristics or incompatibility with the current version of the llama.cpp Python binding used by Samantha.
Try another model.
==========================================

```

<br>

**Error messages displayed on terminal:**

```

Requested tokens (22856) exceed context window of 10016

Unable to allocate 14.2 GiB for an array with shape (25000, 151936) and data type float32

```

<br>

When set to `0`, the system will use the maximum `n_ctx` possible (model's context window size).<br>
As a rule, set `n_ctx` equal to `max_tokens`, but only to the value necessary to accommodate the text parsed by the model. Samantha's default values ​​for `n_ctx` and `max_tokens` are 4,000 tokens.<br>
Before adjusting `n_ctx`, you must to unload the model by clicking _Unload model_ button.

<br>

**Example:**

User prompt = 2000 tokens<br>
`n_ctx`= 4000 tokens<br>
If the text generated by the model is equals or greater than 2000 tokens (4000 - 2000), the system will raise an `IndexError` in the terminal, but the interface will not crash.

To check the impact of the `n_ctx` in memory, open Windows Task Manager (`CTRL + SHIFT + ESC`) to monitor memory usage, select memory panel and vary `n_ctx` values. Don't forget to unload model between changes.

---

<br><br>
</details>

<details>
<summary>max_tokens (slider)</summary>

---

🎚️​ Controls maximum number of tokens to be generated by the model.

Select `0` for the models' maximum number of tokens (maximum memory required).

How `max_tokens` Works:

1. Sampling Process: When generating text, LLMs predict the next token based on the context provided (system prompt + previous response + user prompt + text already generated). This prediction involves calculating probabilities for each possible token in the vocabulary.
   
2. Token Limit: The `max_tokens` parameter sets a hard limit on how many tokens the model can generate before stopping, regardless of the predicted probabilities.

3. Truncation: Once the generated text reaches `max_tokens`, the generation process is abruptly terminated. This means the final output might be incomplete or feel cut off.

---

<br><br>

</details>

<br><br>
**Stop Words:**

<details>
<summary>stop (textbox)</summary>

---

🔤​ List of characters that interrupt text generation by the model, in the format `["$$$", ".", ".\n"]` (Python list).

---

<br><br>
</details>

<br><br>
**Token Sampling:**

<details>
<summary>General instructions</summary>

---

**Deterministic Behavior:**

To check the deterministic impact of each hyperparameter on the model's behavior, set all others hyperparameters to their maximum stochastic values ​​and execute a prompt more than once. Repeat this procedure for each token sampling hyperparameter.

| Hyperparameter | Deterministic    | Stochastic    | Selected               |
| :------------: | :--------------: | :-----------: | :--------------------: |
| _temperature_  | 0                | > 0           | 2 (stochastic)         |
| _tfs_z_        | 0                | > 0           | 1 (stochastic)         |
| _top_p_        | 0                | > 0           | 1 (stochastic)         |
| _min_p_        | 1                | < 1           | **1 (deterministic)**  |
| _typical_p_    | 0                | > 0           | 1 (stochastic)         |
| _top_k_        | 1                | > 1           | 40 (stochastic)        |
<br>

In other words, the hyperparameter with deterministic adjustment prevails over all other hyperparameters with stochastic adjustments.

As the hyperparameter with deterministic tuning loses this condition, interaction between all hyperparameters with stochastic tuning occurs.

<br><br>
**Stochastic Behavior:**

To check the stochastic reflection of a hyperparameter on the model's behavior, set all other hyperparameters to their maximum stochastic values ​​and gradually vary the selected hyperparameter based on its deterministic value. Repeat this procedure for each token sampling hyperparameter.

You can combine stochastic tuning of different hyperparameters.
<br><br>


| Hyperparameter | Deterministic    | Stochastic    | Selected                      |
| :------------: | :--------------: | :-----------: | :---------------------------: |
| _temperature_  | 0                | > 0           | 2 (stochastic)                |
| _tfs_z_        | 0                | > 0           | 1 (stochastic)                |
| _top_p_        | 0                | > 0           | 1 (stochastic)                |
| _min_p_        | 1                | < 1           | **1 (reduce progressively)**  |
| _typical_p_    | 0                | > 0           | 1 (stochastic)                |
| _top_k_        | 1                | > 1           | 40 (stochastic)               |

<br>

The text generation hyperparameters in language models, such as **_top_k_, _top_p_, _tfs-z_, _typical_p_, _min_p_, and _temperature_**, interact in a **complementary way** to control the process of choosing the next token. Each affects token selection in different ways, but there is an order of prevalence in terms of influence on the final set of tokens that can be selected. Let's examine how these hyperparameters relate to each other and who "prevails" over whom.

All these hyperparameters are adjusted **after** the model generates the logits of each token.

Samantha displays the logits of each token in learning mode, **before** they are changed by the hyperparameters.

Samantha also indicates which token was selected **after** applying the hyperparameters.

10 vocabulary tokens most likely returned by the model to initiate the answer to the following question: **Who are you?**:

**Vocabulary id / token / logit value:**
```
358)    ' I'       (15.83)
40)     'I'        (14.75)     <<<  Selected
21873)  ' Hello'   (14.68)
9703)   'Hello'    (14.41)
1634)   ' As'      (14.31)
2121)   'As'       (13.98)
20971)  ' Hi'      (13.73)
715)    ' \n'      (13.03)
5050)   'My'       (13.01)
13041)  'Hi'       (12.77)
```
<br><br>
**How to disable hyperparameters:**

* **_temperature_:** Setting it to 1.0 keeps the original odds unchanged.
Note: Setting it to 0 does not "disable" it, but makes the selection deterministic.

* **_tfs_z_ (Tail-Free Sampling with z-score):** Setting it to a very high value effectively disables it.

* **_top-p_ (nucleus sampling):** Setting it to 1.0 effectively disables it.

* **_min-p_:** Setting it to a very low value (close to 0) effectively disables it.

* **_typical-p_:** Setting it to 1.0 effectively disables it.

* **_top-k_:** Setting it to a very high value (e.g. vocabulary size) essentially disables it.


<br><br>
**Order of Prevalence**

1 **_top_k_, _top_p_, _tfs_z_, _typical_p_, _min_p_:** These **delimit** the space of possible tokens that can be selected.

* **_top_k_** restricts the number of available tokens to the **_k_** most likely ones. For example, if **_k_ = 50**, the model will only consider the **50 most likely tokens** for the next word. Tokens outside of these 50 most likely are completely discarded, which can help avoid unlikely or very risky choices.

* **_top-p_** defines a threshold based on the sum of **cumulative probabilities**. If **_p_ = 0.9**, the model will include the most likely tokens until the sum of their probabilities reaches **90%**. Unlike **_top_k_**, the number of tokens considered is dynamic, varying according to the probability distribution.

* **_tfs_z_** aims to eliminate the "tail" of the tokens' probability distribution. It works by discarding tokens whose cumulative probability (from the tail of the distribution) is less than a certain threshold z. The idea is to keep only the **most informative** tokens and eliminate those with less relevance, regardless of how many tokens this leaves in the set.
So, instead of simply truncating the distribution at the top (as **_top_k_** or **_top_p_** does), **_tfs_z_** makes the model get rid of the tokens at the tail of the distribution. This creates a more adaptive way of filtering the least likely tokens, promoting the most important ones without strictly limiting the number of tokens, as with **_top_k_**. **_tfs_z_** discards the "tail" of the token distribution, eliminating those with cumulative probabilities below a certain threshold z.

* **_typical_p_** selects tokens based on their divergence from the mean entropy of the distribution, i.e. how "typical" the token is. **_typical-p_** is a more sophisticated sampling technique that aims to maintain the "naturalness" of text generation, based on the notion of entropy, i.e. how "surprising" or predictable is the choice of a token compared to the what the model expects. **How Typical-p Works:** Instead of focusing only on the absolute probabilities of tokens, as **_top_k_** or **_top_p_** do, **_typical_p_** selects tokens based on their deviation from the mean entropy of the probability distribution.

**Here is the _typical_p_ process:**

**a) Average Entropy:** The average entropy of a token distribution reflects the average level of uncertainty or surprise associated with choosing a token. Tokens with a very high (expected) or very low (rare) probability may be less "typical" in terms of entropy. 

**b) Divergence Calculation:** Each token has its probability compared to the average entropy of the distribution. Divergence measures how far the probability of that token is from the average. The idea is that tokens with a smaller divergence from average entropy are more "typical" or natural within the context. 

**c) Sampling:** **_typical_p_** defines a fraction p of the accumulated entropy to consider tokens. Tokens are ordered based on their divergence and those that fall within a portion p (e.g., 90% of the most "typical" distribution) are considered for selection. The model chooses tokens in a way that favors those that represent the average uncertainty well, promoting naturalness in text generation.

* **_min_p_** discards tokens whose absolute probability is less than the minimum value defined by p. **_min-p_** (least common) sets a minimum absolute probability threshold for any token. This method forces the model not to choose very low probability options.

<br><br>
**Prevalence:** These parameters define the **set of candidate tokens**. They are first used to restrict the number of possible tokens before any other adjustments are applied. The way they are combined can be cumulative, where applying multiples of these filters progressively reduces the number of available tokens. The final set is the **intersection set** between the tokens that pass all these checks.

* If you use **_top_k_** and **_top_p_** at the same time, both must be respected. For example, if **_top_k = 50_** and **_top_p = 0.9_**, the model first limits the choice to the 50 most likely tokens and, within these, considers those whose probability sum reaches 90%.
  
* If you add **_typical_p_** or **_tfs_z_** to the equation, the model will apply these additional filters over the same set, further reducing the options.

<br><br>
2 **_temperature:_** Adjusts the randomness **within the set of already filtered tokens**.

* After the model restricts the universe of tokens based on cutoff hyperparameters like _top-k_, _top_p_, _tfs_z_, etc., **_temperature_** comes into play.

* **_temperature_** changes the smoothness or rigidity of the probability distribution of the remaining tokens. A **_temperature_ lower than 1** concentrates the probabilities, causing the model to prefer the most likely tokens. A **_temperature_ greater than 1** flattens the distribution, allowing less likely tokens to have a greater chance of being selected.
  
**Prevalence:** **_temperature_** does not change the set of available tokens, but **adjusts the relative probability of already filtered tokens**. Thus, it **does not prevail** over the _top_k_, _top_p_, etc. filters, but acts after them, influencing the final selection within the remaining option space.

<br><br>
**General Hierarchy**

**_top_k, top_p, tfs_z, typical_p, min_p_:** These parameters act first, restricting the number of possible tokens.

**_temperature_:** After the selection filters are applied, temperature adjusts the probabilities of the remaining tokens, controlling the randomness in the final choice.

<br><br>
**Combination Scenario**

* **_top_k + _top_p_:** If _top_k_ is less than the number of tokens selected by _top_p_, _top_k_ prevails as it limits the number of tokens to k. If _top_p_ is more restrictive (e.g. only considers 5 tokens with p=0.9), then it prevails over _top_k_.

* **_typical_p_ + _top_p_:** Both apply filters, but in different directions. _typical_p_ selects based on entropy, while _top_p_ selects based on cumulative probability. If used together, the end result is the intersection set of these filters.

* **_Temperature_:** It is always applied last, modulating the randomness in the final selection, but without changing the limits imposed by previous filters.

<br><br>
**Prevalence Summary**

* **Filters** (**_top_k, top_p, tfs_z, typical_p, min_p_**) define the set of candidate tokens.

* **_temperature_** adjusts the relative probability within the filtered set.

* The end result is a combination of these filters, where the set of tokens eligible for selection is defined first, and then the randomness is adjusted with temperature.

---

<br><br>
</details>


<details>
<summary>temperature (slider)</summary>

---

🌡 Temperature is a hyperparameter that controls the randomness of the text generation process in LLMs. It affects the probability distribution of the model's next-token predictions.
<br><br>

>_Temperature is a hyperparameter t that we find in stochastic models to regulate the randomness in a sampling process (Ackley, Hinton, and Sejnowski 1985). The softmax function (Equation 1) applies a non-linear transformation to the output logits of the network, turning it into a probability distribution (i.e. they sum to 1). The temperature parameter regulates its shape, redistributing the output probability mass, flattening the distribution proportional to the chosen temperature. This means that for t > 1, high probabilities are decreased, while low probabilities are increased, and vice versa for t < 1. Higher temperatures increase entropy and perplexity, leading to more randomness and uncertainty in the generative process. Typically, values for t are in the range of [0, 2] and t = 0, in practice, means greedy sampling, i.e. always taking the token with the highest probability._
_[Is Temperature the Creativity Parameter of Large Language Models?](https://arxiv.org/pdf/2405.00492)_

<br>

[The Effect of Sampling Temperature on Problem Solving in Large Language Models](https://arxiv.org/pdf/2402.05201)

<br>

**Controlling Creativity:**

🔥 Use **higher temperatures** when you want the model to generate more creative, unexpected, and varied responses. This is useful for creative writing, brainstorming, and exploring multiple ideas.<br>
This flattens the probability distribution, making the model more likely to sample less probable tokens.<br>
The generated text becomes more diverse and creative, but potentially less coherent.<br>

❄ Use **lower temperatures** when you need more predictable and focused output. This is useful for tasks requiring precise and reliable information, such as summarization or answering factual questions.<br>
This sharpens the probability distribution, making the model more likely to sample the most probable tokens.<br>
The generated text becomes more focused and deterministic, but potentially less creative.
<br><br>

**How it works:**

🧮 ​Mathematically, the temperature (T) is applied by dividing the logits (raw scores from the model) by T before applying the softmax function.<br>
A lower temperature makes the distribution more "peaked," favoring high-probability options.<br>
A higher temperature "flattens" the distribution, giving more chance to lower-probability options.<br>
<br>

**Temperature scale:**

Generally ranges from 0 to 2, with 1 being the default (no modification).<br>
T < 1: Makes the text more deterministic, focused, and "safe."<br>
T > 1: Makes the text more random, diverse, and potentially more creative.<br>
T = 0: Equivalent to greedy selection, always choosing the most probable option.<br>
<br>

**Avoiding Repetition:**

Higher temperatures can help reduce repetitive patterns in the generated text by promoting diversity.<br>
Very low temperatures can sometimes lead to repetitive and deterministic outputs, as the model might keep choosing the highest-probability tokens.<br>

It's important to note that temperature is just one of several sampling hyperparameters available. Others include top-k sampling, nucleus sampling (or top-p), and the TFS-Z. Each of these methods has its own characteristics and may be more suitable for different tasks or generation styles.
<br><br>

**Videos:**

[temperature shorts 1](https://www.youtube.com/shorts/XsLK3tPy9SI)

[temperature shorts 2](https://www.youtube.com/shorts/0Bw95ILozjY)

---

<br><br>
</details>

<details>
<summary>tfs_z (slider)</summary>

---

`tfs_z` stands for **tail-free sampling with z-score**. It's a hyperparameter used in a text generation technique designed to balance the trade-off between diversity and quality in generated text.
<br><br>

**Context and purpose:**

Tail-free sampling was introduced as an alternative to other sampling methods like `top-k` or nucleus (`top-p`) sampling. Its goal is to remove the arbitrary "tail" of the probability distribution while maintaining a dynamic threshold.
<br><br>

**Technical Details of `tfs_z` in LLM Text Generation**
<br><br>

**Probability distribution analysis:**

The method examines the probability distribution of the next token predictions.
It focuses on the "tail" of this distribution - the less likely tokens.
<br><br>

**Z-score calculation:**

For each token in the sorted (descending) probability distribution, a z-score is calculated.
The z-score represents how many standard deviations a token's probability is from the mean.
<br><br>

**Cutoff determination:**

The `tfs_z` parameter sets the z-score threshold.
Tokens with a z-score below this threshold are removed from consideration.
<br><br>

**Dynamic thresholding:**

Unlike fixed methods like `top-k`, the number of tokens retained can vary based on the shape of the distribution.
This allows for more flexibility in different contexts.
<br><br>

**Sampling process:**

After applying the `tfs_z` cutoff, sampling occurs from the remaining tokens.
This can be done using various methods (e.g., temperature-adjusted sampling).

`tfs_z` is a hyperparameter that controls the **temperature scaling** of the output logits during text generation.
<br><br>

**Here's what it does:**

1. **Logits**: When an LLM generates text, it produces a probability distribution over all possible tokens in the vocabulary. This distribution is represented as a vector of logits (unnormalized log probabilities).
   
2. **Temperature scaling**: To control the level of uncertainty or "temperature" of the output, you can scale the logits by multiplying them with a temperature factor (`t`). This is known as temperature scaling.

3. **`tfs_z` hyperparameter**: It's a hyperparameter that controls how much to scale the logits before applying temperature scaling.

When you set `tfs_z > 0`, the model first normalizes the logits by subtracting their mean (`z-score normalization`) and then scales them with the temperature factor (`t`). This has two effects:

* **Reduced variance**: By normalizing the logits, you reduce the variance of the output distribution, which can help stabilize the generation process.
  
* **Increased uncertainty**: By scaling the normalized logits with a temperature factor, you increase the uncertainty of the output distribution, which can lead to more diverse and creative text generations.
<br><br>

**Practical example:**

Imagine that the model is trying to complete the sentence "The sky is..."<br>

Without `tfs_z`, the model could consider:<br>
blue (30%), cloudy (25%), clear (20%), dark (15%), green (5%), singing (3%), salty (2%)

With TFS-Z (cut by 10%):<br>
blue (30%), cloudy (25%), light (20%), dark (15%)

This eliminates less likely and potentially meaningless options, such as "The sky is salty."

By adjusting the Z-score, we can control how "conservative" or "creative" we want the model to be. A higher Z-score will result in fewer but more "safe" options, while a lower Z-score will allow for more variety but with a greater risk of inconsistencies.

In summary, `tfs_z` controls how much to scale the output logits after normalizing them. A higher value of `tfs_z` will produce more uncertain and potentially more creative text generations.

Keep in mind that this is a relatively advanced hyperparameter, and its optimal value may depend on the specific LLM architecture, dataset, and task at hand.

---

<br><br>
</details>

<details>
<summary>top_p (slider)</summary>

---

⭕​ `Top-p` (nucleus sampling) is a hyperparameter that controls the diversity and quality of text generation in LLMs. It affects the selection of tokens during the generation process by dynamically limiting the vocabulary based on cumulative probability.
<br><br>

**Controlling Output Quality:**

🔮 Use **higher `top-p` values** (closer to 1) when you want the model to consider a wider range of possibilities, potentially leading to more diverse and creative outputs. This is useful for open-ended tasks, storytelling, or generating multiple alternatives. Higher values allow for more low-probability tokens to be included in the sampling pool.

🎯 Use **lower `top-p` values** (closer to 0) when you need more focused and high-quality output. This is beneficial for tasks requiring precise information or coherent responses, such as answering specific questions or generating formal text. Lower values restrict the sampling to only the most probable tokens.
<br><br>

**How it works:**

🧮 Mathematically, `top-p` sampling selects the smallest possible set of words whose cumulative probability exceeds the chosen p-value. The model then samples from this reduced set of tokens. This approach adapts to the confidence of the model's predictions, unlike fixed methods like `top-k` sampling.
<br><br>

**Top-p scale:**

Generally ranges from 0 to 1, with common values between 0.1 (10% most likely) and 0.9 (90% most likely).<br>
p = 1: Equivalent to unmodified sampling from the full vocabulary.<br>
p → 0: Increasingly deterministic, focusing on the highest probability tokens.<br>
p = 0.9: A common choice that balances quality and diversity.
<br><br>

**Balancing Coherence and Diversity:**

`Top-p` sampling helps maintain coherence while allowing for diversity. It adapts to the model's confidence, using a smaller set of tokens when the model is very certain and a larger set when it's less certain. This can lead to more natural-sounding text compared to fixed cutoff methods.
<br><br>

**Comparison with Temperature:**

While temperature modifies the entire probability distribution, `top-p` directly limits the vocabulary considered. Top-p can be more effective at preventing low-quality outputs while still allowing for creativity, as it dynamically adjusts based on the model's confidence.

It's worth noting that `top-p` is often used in combination with other sampling methods, such as `temperature` adjustment or `top-k` sampling. The optimal choice of hyperparameters often depends on the specific task and desired output characteristics.

---

<br><br>
</details>

<details>
<summary>min_p (slider)</summary>

---

The **_min_p_** hyperparameter is a relatively recent sampling technique used in text generation by large-scale language models (LLMs). It offers an alternative approach to **_top_k_** and nucleus sampling (**_top_p_**) to control the quality and diversity of generated text.

**_min_p_** is a sampling hyperparameter that works in a complementary way to **_top_p_** (nucleus sampling). While **_top_p_** sets an upper bound on cumulative probabilities, **_min_p_** sets a lower bound on individual probabilities.

<br>

**Explanation:**

As with other sampling techniques, LLM calculates a probability distribution over the entire vocabulary for the next word.

The **_min_p_** defines a minimum probability threshold, p_min.

The method selects the smallest set of words whose summed probability is greater than or equal to p_min.

The next word is then chosen from that set of words.

<br>

**Detailed operation:**

The model calculates P(w|c) for each word w in the vocabulary, given context c.

The words are ordered by decreasing probability: w₁, w₂, ..., w|V|.

The algorithm selects words in the order of greatest probability until the sum of the probabilities is greater than or equal to _p_min_:
* Let k be the smallest value such that ∑ᵢ₌₁ᵏ P(wᵢ|c) ≥ p_min
* The set of selected words is T = {w₁, w₂, ..., wₖ}.
* The distribution is renormalized over T:
* P'(w|c) = P(w|c) / ∑ᵢ₌₁ᵏ P(wᵢ|c) for w ∈ T
* P'(w|c) = 0 for w ∉ T
* The next word is sampled according to P'(w|c).

<br>

**Example:**

Suppose we are generating text and the model predicts the following probabilities for the next word:

```
"o":        0.3
"one":      0.25
"this":     0.2
"that one": 0.15
"some":     0.1
```

If we use min-p with p_min = 0.7, the algorithm would work like this:

```
Sum "o":                    0.3                     < 0.7
Sum "o" + "one":            0.3 + 0.25       = 0.55 < 0.7
Sum "the" + "one" + "this": 0.3 + 0.25 + 0.2 = 0.75 ≥ 0.7
```

Therefore, we select the first three words. Renormalizing:

```
"o":    0.3  / 0.75 = 0.4
"one":  0.25 / 0.75 ≈ 0.33
"this": 0.2  / 0.75 ≈ 0.27
```

The next word will be chosen randomly from these three options with the new probabilities.

---

<br><br>
</details>

<details>
<summary>typical_p (slider)</summary>

---

The **_typical_p_** hyperparameter is an entropy-based sampling technique that aims to generate **more natural and less predictable text** by selecting tokens that represent what is "typical" or "expected" in a probability distribution. Unlike methods like **_top_k_** or **_top_p_**, which focus on the absolute probabilities of tokens, **_typical_p_** considers how surprising or informative a token is relative to the overall probability distribution.

<br>

**Technical Operation of _typical_p_**

* **Entropy:** The entropy of a distribution measures the expected uncertainty or surprise of an event. In the context of language models, the higher the entropy, the more uncertain the model is about which token should be generated next. Tokens that are very close to the mean entropy of the output distribution are considered "typical", while tokens that are very far away (too predictable or very unlikely) are considered "atypical".

* **Calculation of Surprise (Local Entropy):** For each token in a given probability distribution, we can calculate its surprise (or "informativeness") by comparing its probability with the average entropy of the token distribution. This surprise is measured by the divergence in relation to the average entropy, that is, how much the probability of a token deviates from the average behavior expected by the distribution.

* **Selection Based on Entropy Divergence:** **_typical_p_** filters tokens based on this "divergence" or difference between the token's surprise and the average entropy of the distribution. The model orders the tokens according to how "typical" they are, that is, how close they are to the average entropy.

* **Typical-p limit:** After calculating the divergences of all tokens, the model defines a cumulative probability limit, similar to **_top_p_** (nucleus sampling). However, instead of summing the tokens' absolute probabilities, **_typical_p_** considers the cumulative sum of the divergences until a portion p of the distribution is included. That p is a value between 0 and 1 (e.g. 0.9), indicating that the model will include tokens that cover 90% of the most "typical" divergences.

If **p = 0.9**, the model selects tokens whose divergences in relation to the average entropy represent 90% of the expected uncertainty. This helps avoid both tokens that are extremely predictable and those that are very unlikely, promoting a more natural and fluid generation.

<br>

**Practical Example**

Suppose the model is predicting the next word in a sentence, and the probability distribution of the tokens looks like this:

* Token A: 40% (very likely)
* Token B: 30% (reasonably likely)
* Token C: 20% (moderately likely)
* D Token: 5% (unlikely)
* E Token: 3% (very unlikely)
* F Token: 2% (rarely chosen)

In the case of **_top_p_** with p = 0.9, the model would only include tokens A, B and C, as their probabilities add up to 90%. However, **_typical_p_** can include or exclude tokens based on how their probabilities compare to the average entropy of the distribution. If A is extremely predictable, it can be excluded, and tokens like B, C, and even D can be selected for their more typical representativeness in terms of entropy.

<br>

**Difference from Other Methods**

**_top_k_** selects the **k most likely tokens directly**, regardless of entropy or probability distribution.

**_top_p_** selects tokens based on the **cumulative sum of absolute probabilities**, without considering entropy or surprise.

**_typical_p_**, on the other hand, introduces the notion of entropy, ensuring that the selected tokens are **neither too predictable nor too surprising**, but ones that align with the expected behavior of the distribution.

<br>

**How Typical-p Improves Text Generation**

* **Naturalness:** **_typical-p_** prevents the model from choosing very predictable tokens (as could happen with a low temperature or restrictive top-p) or very rare tokens (as could happen with a high temperature), maintaining a fluid and natural generation.

* **Controlled Diversity:** By considering the surprise of each token, it promotes diversity without sacrificing coherence. Tokens that are close to the mean entropy of the distribution are more likely to be chosen, promoting natural variations in the text.

* **Avoids Extreme Outputs:** By excluding overly unlikely or predictable tokens, Typical-p keeps generation within a "safe" and natural range, without veering toward extremes of certainty or uncertainty.

<br>

**Interaction with Other Parameters**

**_typical_p_** can be combined with other sampling methods:

* When combined with **_temperature_**, **_typical_p_** further adjusts the set of selectable tokens, while **_temperature_** modulates the randomness within that set.
  
* It can be combined with **_top_k_** or **_top_p_** to further fine-tune the process, restricting the universe of tokens based on different probability and entropy criteria.

In summary, **_typical_p_** acts in a unique way by considering the entropy of the distribution and selects tokens that are aligned with the expected behavior of this distribution, resulting in a more balanced, fluid and natural generation.

<br>

Here are some guidelines and strategies for tuning **_typical_p_**:

   
**_typical_p_ = 1.0:** Includes all tokens available in the distribution, without restrictions based on entropy. This is equivalent to not applying any typical restrictions, allowing the model to use the full distribution of tokens.

**_typical_p < 1.0:** The lower the **_typical_p_** value, the narrower the set of tokens considered, keeping only those that most closely align with the average entropy. Common values ​​include 0.9 (90% of "typical" tokens) and 0.8 (80%).

<br>

**Recommendations:**

**_typical-p_ = 0.9:** This is a common value that typically maintains a balance between diversity and coherence. The model will have the flexibility to generate varied text, but without allowing very extreme choices.

**_typical_p_ = 0.8:** This value is more restrictive and will result in more predictable choices, keeping only tokens that most accurately align with the average entropy. Useful in scenarios where fluidity and naturalness are priorities.

**_typical_p_ = 0.7 or less:** The lower the value, the more predictable the text generation will be, eliminating tokens that could be considered atypical. This may result in a less diversified and more conservative output.

<br>

**Fine-Tuning with _temperature_**

**_typical_p_** controls the set of tokens based on entropy, but **_temperature_** can be used to adjust the randomness **within that set**. The interaction between these two parameters is important:

* **_temperature_ > 1.0:** Increases randomness within the set of tokens selected by **_typical_p_**, allowing even less likely tokens to have a greater chance of being chosen. This can generate more creative or unexpected responses.
  
* **_temperature_ < 1.0:** Reduces randomness, making the model more conservative by preferring the most likely tokens from the set filtered by **_typical_p_**. Using a low temperature with a high **_typical_p_** (0.9 or 1.0) can result in very predictable outputs.

<br>

**Example:**

* **_typical_p_ = 0.9 with _temperature = 1.0:** Maintains the balance between naturalness and diversity, allowing the model to generate fluid and creative text, but without major deviations.

* **_typical_p_ = 0.8 with _temperature_ = 0.7:** Makes generation more conservative and predictable, preferring tokens that are closer to the average uncertainty and reducing the chance of creative variations.


---

<br><br>
</details>

<details>
<summary>top_k (slider)</summary>

---

**How It Works**

In a language model, when the next word is predicted, the model generates a probability distribution for the next token (word or part of a word), where each token has an associated probability based on its previous context. The sum of all probabilities is equal to 1.

**_top_k_** works by reducing the number of options available for sampling, limiting the number of candidate tokens. It does this by selecting only the tokens with the k highest probabilities and discarding all others. Then sampling is done from these k tokens, redistributing the probabilities between them.

<br>

**Example:**

Suppose we are generating text and the model predicts the following probabilities for the next word:

```
"o":        0.3
"one":      0.25
"this":     0.2
"that one": 0.15
"some":     0.1
```

If we use top-k with k=3, we only keep the three most likely words:

```
"o":        0.3
"one":      0.25
"this":     0.2
```

Then, we renormalize the probabilities:

```
"o":        0.3  / (0.3 + 0.25 + 0.2) ≈ 0.4  (40%)
"one":      0.25 / (0.3 + 0.25 + 0.2) ≈ 0.33 (33%)
"this":     0.2  / (0.3 + 0.25 + 0.2) ≈ 0.27 (27%)
```

The next word will be chosen from these three options with the new probabilities.

<br>

**Effect of Hyperparameter k**

* **small k (e.g. 𝑘=1):** The model will be extremely deterministic, as it will always choose the token with the highest probability. This can lead to repetitive and predictable text.

* **large k (or use all tokens without truncating):** The model will have more options and be more creative, but may generate less coherent text as low probability tokens may also be chosen.

---

<br><br>
</details>

<br><br>
**Token Penalties:**

<details>
<summary>General instructions</summary>

---

🧭 Syntactic and semantic variation arises from the penalization of tokens that are replaced by others that begin words related to different ideas, leading the response generated by the model in another direction.

Syntactic variations do not always generate semantic variations.

As text is generated, penalties become more frequent as there are more tokens to be punished.

**Deterministic Behavior:**

To obtain a deterministic text (same input, same output), but without repeating words (tokens), increase the values ​​of the penalty hyperparameters.

However, if it proves necessary to allow the model to reselect already generated tokens, keep these settings at their default values.
<br><br>

| Hyperparameter      | Default Values   | Text Diversity |
| :-----------------: | :--------------: | :------------: |
| _presence_penalty_  | 0                | > 0            |
| _frequency_penalty_ | 0                | > 0            |
| _repeat_penalty_    | 1                | > 1            |

---

<br><br>
</details>


<details>
<summary>presence_penalty (slider)</summary>

---

**Presence Penalty:**

The presence penalty penalizes tokens that have already appeared in the text, regardless of their frequency. It discourages the repetition of ideas or themes.

<br>

**Operation:**

* Applies a fixed penalty to the probability of all tokens that have ever appeared in the text.
* It doesn't consider how many times a token appeared, just whether it appeared or not.
<br>

**Effect:**

* Encourages the model to explore new topics and ideas.
* It helps prevent the model from getting stuck in a loop, repeating the same information.
<br>

**Fit:**

* A higher value results in more diverse but possibly less coherent text.
* A lower value allows for more repetition of ideas, possibly maintaining greater coherence.

---

<br>
</details>

<details>
<summary>frequency_penalty (slider)</summary>

---

**Frequency Penalty:**

The frequency penalty penalizes tokens based on their frequency in the text generated so far. The more times a token appeared, the greater the penalty.

<br>

**Operation:**

* Applies a penalty proportional to the frequency of each token in the generated text.
* Tokens that appear more frequently receive larger penalties.
<br>

**Effect:**

* Reduces the likelihood of very repetitive words or phrases.
* Promotes a more diverse and varied vocabulary.
<br>

**Fit:**

* A higher value results in less repetition of specific words.
* A lower value allows for more repetition, which can be useful for maintaining consistency in certain contexts.

---

<br><br>
</details>

<details>
<summary>repeat_penalty (slider)</summary>

---

**Repeat Penalty:**

The repeat penalty is similar to the frequency penalty, but generally applies to sequences of tokens (n-grams) rather than individual tokens.

<br>

**Operation:**

* Penalizes the repetition of sequences of tokens that have already appeared in the text.
* The penalty may increase based on the length of the repeated sequence.
<br>

**Effect:**

* Avoid repeating phrases or entire sentences.
* Promotes greater diversity in sentence structure.
<br>

**Fit:**

* A higher value prevents sentence repetitions, but may lead to less fluid text.
* A lower value allows for more repetitions, which can be helpful in maintaining a consistent style.

<br><br>
**How `repeat_penalty` works:**

📊 Starting from the default value (=1), as we reduce this value (<1) the text starts to present more and more repeated words (tokens), to the point where the model starts to repeat a certain passage or word indefinitely.

In turn, as we increase this value (>1), the model starts to penalize repeated words (tokens) more heavily, up to the point where the input text no longer generates penalties in the output text.

During the penalty process (>1), there is a variation in syntactic and semantic coherence.

Practical observations showed that increasing the token penalty (>1) generates syntactic and semantic diversity in the response, as well as promoting a variation in the response length until stabilization, when increasing the value no longer generates variation in the output.

The `repeat_penalty` hyperparameter has a deterministic nature.
<br><br>

**Adjustment tip:**

📈 increase this value until the generated text reaches the desired level of diversity and does not present syntactic errors (depends on the model).
---

</details>

<br><br>
**Others:**

<details>
<summary>Model metadata (textbox)</summary>

---

Displays model's metadata.
<br><br>


**Example:**

Model: https://huggingface.co/NousResearch/Hermes-3-Llama-3.1-8B-GGUF/resolve/main/Hermes-3-Llama-3.1-8B.Q8_0.gguf?download=true
<br><br>

```
{'general.name': 'Hermes 3 Llama 3.1 8B'
  'general.architecture': 'llama'
  'general.type': 'model'
  'general.organization': 'NousResearch'
  'llama.context_length': '131072'
  'llama.block_count': '32'
  'general.basename': 'Hermes-3-Llama-3.1'
  'general.size_label': '8B'
  'llama.embedding_length': '4096'
  'llama.feed_forward_length': '14336'
  'llama.attention.head_count': '32'
  'tokenizer.ggml.eos_token_id': '128040'
  'general.file_type': '7'
  'llama.attention.head_count_kv': '8'
  'llama.rope.freq_base': '500000.000000'
  'llama.attention.layer_norm_rms_epsilon': '0.000010'
  'llama.vocab_size': '128256'
  'llama.rope.dimension_count': '128'
  'tokenizer.ggml.model': 'gpt2'
  'tokenizer.ggml.pre': 'llama-bpe'
  'general.quantization_version': '2'
  'tokenizer.ggml.bos_token_id': '128000'
  'tokenizer.ggml.padding_token_id': '128040'
  'tokenizer.chat_template': "{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{'<|im_start|>' + message['role'] + '\n' + message['content'] + '<|im_end|>' + '\n'}}{% endfor %}{% if add_generation_prompt %}{{ '<|im_start|>assistant\n' }}{% endif %}"}
```

---

<br><br>
</details>

<details>
<summary>Show model's vocabulary (checkbox)</summary>

 ---

✅ Displays model's token vocabulary when selected.

---

<br><br>
</details>




<details>
<summary>Model's vocabulary (textbox)</summary>

 ---

🔠 Displays model's vocabulary when _Learning Mode_ and _Show Model Vocabulary_ are selected simultaneously.

**Example (from token 2000 to 2100):**

Model: https://huggingface.co/Triangle104/Mistral-7B-Instruct-v0.3-Q5_K_M-GGUF/resolve/main/mistral-7b-instruct-v0.3-q5_k_m.gguf?download=true
<br><br>


```
2000)    'ility'
2001)    ' é'
2002)    ' er'
2003)    ' does'
2004)    ' here'
2005)    'the'
2006)    'ures'
2007)    ' %'
2008)    'min'
2009)    ' null'
2010)    'rap'
2011)    '")'
2012)    'rr'
2013)    'List'
2014)    'right'
2015)    ' User'
2016)    'UL'
2017)    'ational'
2018)    ' being'
2019)    'AN'
2020)    'sk'
2021)    ' car'
2022)    'ole'
2023)    ' dist'
2024)    'plic'
2025)    'ollow'
2026)    ' pres'
2027)    ' such'
2028)    'ream'
2029)    'ince'
2030)    'gan'
2031)    ' For'
2032)    '":'
2033)    'son'
2034)    'rivate'
2035)    ' years'
2036)    ' serv'
2037)    ' made'
2038)    'def'
2039)    ';\r'
2040)    ' gl'
2041)    ' bel'
2042)    ' list'
2043)    ' cor'
2044)    ' det'
2045)    'ception'
2046)    'egin'
2047)    ' б'
2048)    ' char'
2049)    'trans'
2050)    ' fam'
2051)    ' !='
2052)    'ouse'
2053)    ' dec'
2054)    'ica'
2055)    ' many'
2056)    'aking'
2057)    ' à'
2058)    ' sim'
2059)    'ages'
2060)    'uff'
2061)    'ased'
2062)    'man'
2063)    ' Sh'
2064)    'iet'
2065)    'irect'
2066)    ' Re'
2067)    ' differ'
2068)    ' find'
2069)    'ethod'
2070)    ' \r'
2071)    'ines'
2072)    ' inv'
2073)    ' point'
2074)    ' They'
2075)    ' used'
2076)    'ctions'
2077)    ' still'
2078)    'ió'
2079)    'ined'
2080)    ' while'
2081)    'It'
2082)    'ember'
2083)    ' say'
2084)    ' help'
2085)    ' cre'
2086)    ' x'
2087)    ' Tr'
2088)    'ument'
2089)    ' sk'
2090)    'ought'
2091)    'ually'
2092)    'message'
2093)    ' Con'
2094)    ' mon'
2095)    'ared'
2096)    'work'
2097)    '):'
2098)    'ister'
2099)    'arn'
2100)    'ized'
```

---

<br><br>
</details>

<details>
<summary>Unload model (button)</summary>

 ---

🗑️ Manually removes the model from memory, freeing up space.

When a new model is selected and the _Start chat_ button is pressed, the previous model is removed from memory automatically.

---

<br><br>
</details>

<details>
<summary>PDF pages (button)</summary>

 ---

📑 Allows you to select a PDF file located on your computer, extracting the text from each page and inserting it in the _User prompt_ field.

The text on each page is separated by `$$$` to allow the model to parse it separately.

Click the button to select the PDF file.

---

<br><br>
</details>

<details>
<summary>PDF full (button)</summary>

 ---

📑 Allows the selection of a PDF file located on the computer, extracting its full text and inserting it in the _User prompt_ field.

At the end, `$$$` is inserted to allow the model to fully analyze the entire text.

Click the button to select the PDF file.

---

<br><br>
</details>

<details>
<summary>System prompt TXT (button)</summary>

---

Fills _System prompt_ field with a prompt saved in a TXT file.

Click the button to select the TXT file.

---

<br><br>
</details>

<details>
<summary>Prev. response TXT (button)</summary>

---

Fills _Assistant Previous Response_ field with a prompt saved in a TXT file.

Click the button to select the TXT file.

---

<br><br>
</details>




<details>
<summary>User prompt TXT (button)</summary>

---

Fills _User prompt_ field with a list of prompt saved in a TXT file.

Click the button to select the TXT file.


---

<br><br>
</details>

<details>
<summary>Copy HF links (button)</summary>

---

Copy a Hugging Face download model URL (Files and versions tab) and extract all links to `.gguf` files.

You can paste all the copied links into the _Dowonload models for testing_ field at once.

---

<br><br>
</details>

<details>
<summary>Load URLs TXT (button)</summary>

---

Fills _Download model for testing_ field with a list of model URLs saved in a TXT file.

Click the button to select the TXT file.

---

<br><br>
</details>


<details>
<summary>Save User Prompt (button)</summary>

---

Saves the _User prompt_ in a TXT file.

Click the button to select the directory where to save the file.

---

<br><br>
</details>


<details>
<summary>DB Browser (button)</summary>

---

Opens [DB Browser](https://sqlitebrowser.org/) if its directory is into Samantha's directory.

To install DB Browser:

- [Download](https://sqlitebrowser.org/dl/) the `.zip`(no installer) version.

- Unpack it with its original name (it will create a directory like `DB.Browser.for.SQLite-v3.13.1-win64`).

- Rename the DB Browser directory to `db_browser`.

- Finally, move the `db_browser` directory to Samantha's directory: `..\samantha-ia-main\db_browser`

---

<br><br>
</details>

<details>
<summary>D-Tale (button)</summary>

---

Opens [D-Tale](https://github.com/man-group/dtale) library interface in a new browser tab with a example dataset (titanic.csv).

<br>

**Web Client for Visualizing Pandas Objects**

>D-Tale is the combination of a Flask back-end and a React front-end to bring you an easy way to view & analyze Pandas data structures. It integrates seamlessly with ipython notebooks & python/ipython terminals. Currently this tool supports such Pandas objects as DataFrame, Series, MultiIndex, DatetimeIndex & RangeIndex. [D-Tale Project](https://pypi.org/project/dtale/#description)

[Live Demo](https://alphatechadmin.pythonanywhere.com/dtale/main/1)

<br>

A Windows terminal will also open.

---

<br><br>
</details>



<details>
<summary>Auto-Py-To-Exe (button)</summary>

---

Opens [Auto-Py-To-Exe](https://pypi.org/project/auto-py-to-exe/) library, a graphical user interface to [Pyinstaller](https://pyinstaller.org/en/stable/index.html).
<br><br>

**Overview**

Auto-Py-To-Exe is a user-friendly desktop application that provides a graphical interface for converting Python scripts into standalone executable files (.exe). It serves as a wrapper around PyInstaller, making the conversion process more accessible to users who prefer not to work directly with command-line interfaces.

This tool is particularly valuable for Python developers who need to distribute their applications to users who don't have Python installed or prefer standalone executables. Its combination of simplicity and power makes it an excellent choice for both beginners and experienced developers.

To run the `.exe` file, right-click inside the directory where the file is located and select the `Open in terminal` option. Then, type the file name in the terminal and press `Enter`. This procedure allows you to identify any file execution errors.
<br><br>


**Basic Usage**

* Select Python script via GUI
* Configure desired options
* Click "Convert .py to .exe"
 
When you copy a Python scrip using CTRL + C or _Copy Python Code_ button and run it by pressing _Run Code_ button, the code is saved as `temp.py`. Select this file to create a `.exe` file.

You can use the this procedure with any code, even copyied from the internet.

<br><br>

**Common Workflow**

<br>

Script Selection:<br>
- Choose main Python file<br>
- Add additional files/folders if needed<br>
<br>

Configuration:<br>
- Select output format (One File/Directory)<br>
- Choose console window visibility<br>
- Set icon (optional)<br>
- Configure advanced options if needed<br>
<br>

Conversion:
- Click convert button<br>
- Monitor progress<br>
- Review output/errors<br>
<br>

Testing:
- Locate generated executable<br>
- Test in clean environment<br>
- Verify all dependencies are included<br>
<br>


**Best Practices**

<br>

Development:
- Test script thoroughly before conversion<br>
- Use relative paths within code<br>
- Handle file paths properly for both development and executable contexts<br>
- Keep track of all required dependencies<br>
<br>

Conversion:
- Start with basic configuration<br>
- Add features incrementally<br>
- Test each major change<br>
- Document successful configurations<br>
<br>

Distribution:
- Test executable on clean system<br>
- Include necessary runtime files<br>
- Document any prerequisites<br>
- Consider target system requirements<br>
<br>

**Common Issues and Solutions**

<br>

Missing Dependencies:
- Use --hidden-import for implicit imports<br>
- Include all required data files<br>
- Check for dynamic/runtime imports<br>
<br>

Path Issues:
- Use relative paths when possible<br>
- Handle both development and executable paths<br>
- Include necessary resource files<br>
<br>

Performance:
- Optimize code before conversion<br>
- Monitor executable size<br>
- Consider using directory mode for large applications<br>
<br>

**Advantages**
- Simplifies PyInstaller usage
- Reduces conversion errors
- Saves configuration for reuse
- Provides clear error feedback
- Supports complex project structures
<br>

**Limitations**
- Dependent on PyInstaller capabilities
- May produce larger executables than manual optimization
- Some advanced PyInstaller features require command line
- Not suitable for all Python applications
<br>

**Security Considerations**

- Executable decompilation is possible
- Sensitive information should be handled securely
- Code obfuscation may be needed for proprietary software
- Regular security updates recommended

---

<br><br>
</details>


<details>
<summary>Close Python</summary>

---

Closes all instances created with the Python interpreter of the `jyupyterlab` virtual environment.

Use this button to force close running modules that block the Python interpreter, such as servers.

---

<br><br>
</details>



<br><br>
**Default Settings:**

<details>
<summary>Settings</summary>

---

Samantha's initial settings is **deterministic**. As a rule, this means that for the same prompt, you'll get always the same answer, even when applying penalties to exclude repeated tokens (penalties does not affect the model deterministic behavior).<br> 

<br>

📐 **Deterministic settings (default):** <br>
* reset_model (True)
* temperature (0)
* tfs_z (0)
* top_p (0)
* min_p (1)
* typical_p (0)
* top_k (40)
* presence_penalty (0)
* frequency_penalty (0)
* repeat_penalty (1)
<br><br>

Deterministic settings can be used to assess training database biases.

Some models tend to loop (repeat the same text indefinitely) when using highly deterministic adjustments, selecting tokens with the highest probability score. 
Others may generate the first response with different content from subsequent ones. In this case, to always get the same response, activate the **_Reset model_** checkbox.

In turn, for **stochastic** behavior, suited for creative content, in which model selects tokens with different probability scores, adjust the hyperparameters accordingly.
<br><br>

🎨 **Stochastic settings (example):** <br>
* reset_model (True)
* temperature (0.8)
* tfs_z (1)
* top_p (0.95)
* min_p (0.05)
* typical_p (1)
* top_k (40)
* presence_penalty (0)
* frequency_penalty (0)
* repeat_penalty (1.1)

<br>

You can use the _Learning Mode_ to monitor and adjust the degree of determinism/randomness of the responses generated by the model.

---

<br><br>
</details>

<br><br>

### Interface Right Column (output):

<details>
<summary>Assistant output (textbox)</summary>

---

Displays the history of responses generated by the model.

The text displayed in this field is editable. But changes made by the user do not affect the text actually generated by the model and stored internally in the interface, which remains accessible through the buttons.

You can use this field to type, paste, edit, copy, and run Python code, as if it were an IDE.

---

<br><br>
</details>

<details>
<summary>Next token (button)</summary>

---

➕ Adds the next token to the model response when `Learning Mode` is activated.

---

<br><br>
</details>

<details>
<summary>Copy Python code (button)</summary>

---

Copies Python code blocks generated by the model, present in the last response (not the pasted code manually).

You can press this button during response generation to copy the already generated text.

The code must be enclosed in triple backticks:


\``` _python_<br>
_(code)_

\```


Library installation code blocks starting with `pip` or `!pip` are ignored.

To manually run the Python code generated by the model, you must first copy it to the clipboard using this button.

---

<br><br>
</details>

<details>
<summary>Run Code (button)</summary>

---

This button executes any Python code copied to the clipboard that uses the libraries installed in the `jupterlab` virtual environment. Just select the code (even outside of Samantha), press `CTRL + C` and click this button.

Use it in combination with _Copy Python Code_ button.

To run Python code, you don't need to load the model.

The `pip` and `!pip` instructions lines present in the code are ignored.

Whenever Python code returns a value other than `''` (empty string), an HTML pop-up window opens to display the returned content.


---

<br><br>
</details>

<details>
<summary>Copy last response (button)</summary>

---

Copies the text generated by the model in your last response.

You can press this button during response generation to copy the already generated text.

---

<br><br>
</details>

<details>
<summary>Copy all responses (button)</summary>

---

Copies the entire text generated by the model in the current chat session.

You can press this button during response generation to copy the already generated text.

---

<br><br>
</details>

<details>
<summary>Open Jupyterlab (button)</summary>

---

Opens [Jupyterlab](https://jupyter.org/) integrated development environment (IDE) in a new browser tab.

Jupyterlab is installed in a separate Python virtual environment with many libraries available, such as:

* [Pandas](https://pandas.pydata.org/)
* [Numpy](https://numpy.org/)
* [SciPy](https://scipy.org/)
* [Scikit-Learn](https://scikit-learn.org/stable/index.html#)
* [Matplotlib](https://matplotlib.org/)
* [Seaborn](https://seaborn.pydata.org/)
* [Vega-Altair](https://altair-viz.github.io/)
* [Plotly](https://plotly.com/python/)
* [Bokeh](https://docs.bokeh.org/en/latest/index.html)
* [Dash](https://plotly.com/examples/)
* [Ydata-Profiling](https://pypi.org/project/ydata-profiling/)
* [Sweetviz](https://pypi.org/project/sweetviz/)
* [D-Tale](https://github.com/man-group/dtale)
* [DataPrep](https://dataprep.ai/)
* [NetworkX](https://networkx.org/)
* [Pyvis](https://pyvis.readthedocs.io/en/latest/index.html)
* [Selenium](https://selenium-python.readthedocs.io/)
* [PyMuPDF](https://pypi.org/project/PyMuPDF/)
* [Beautiful Soup](https://beautiful-soup-4.readthedocs.io/en/latest/)

For a complete list of all Python available libraries, use a prompt like **_"create a Python code that prints all modules installed using `pkgutil` library. Separate each module with \<br\> tag."_** and press _Run code_ button. The result will be displayed in a browser popup.

---

<br><br>
</details>

<details>
<summary>Response in HTML (button)</summary>

---

Displays the model's latest response in a HTML pop-up browser window.

Also displays the output of the Python interpreter when it is other than '' (empty string).

The first time the button is pressed, the browser takes a few seconds to load (default: Microsoft Edge).

---

<br><br>
</details>

<details>
<summary>Responses in HTML (button)</summary>

---

Displays the all the current chat session responses in a HTML pop-up browser window.

The first time the button is pressed, it takes a few seconds for the window to appear.

---

<br><br>
</details>

<details>
<summary>Voice control (button)</summary>

---

When enabled when starting Samantha, this button initiates interaction with the interface through voice.

---

<br><br>
</details>

<details>
<summary>Audio player (widget)</summary>

---

Interface to convert texts and responses to audio without using the internet.

---

<br><br>
</details>

<details>
<summary>Text to speech (button)</summary>

---

Reads the text in the _User prompt_ field aloud, using the computer's SAPI5 voice selected by the _Voice Selection_ drop-down list.

---

<br><br>
</details>

<details>
<summary>Last response (button)</summary>

---

Reads the text of the model's last response aloud, using the SAPI5 computer voice selected in the _Voice Selection_ drop-down list.

---

<br><br>
</details>

<details>
<summary>All responses (button)</summary>

---

Reads all the chat session responses aloud, using the SAPI5 computer voice selected in the _Voice Selection_ drop-down list.

---

<br><br>
</details>

<details>
<summary>Models repositories (links)</summary>

---

List of links to the `.gguf` model search result on the Hugging Face website, separated by families (llama, gemma, phi, etc.)

---

<br><br>
</details>

<details>
<summary>Operating tips (tips)</summary>

---

Samantha interface operation tips.

For a complete understanding of how the interface works, see the [Samantha](https://github.com/controlecidadao/samantha_ia/tree/main) project on Github.

---

<br><br>
</details>

<details>
<summary>User prompt examples (prompts)</summary>

---

A collection of user prompts.

Just click to select a prompt and send it to the _User prompt_ field.

You can change this list of prompts by editing the `user_prompts.txt` file. Samantha must be restarted to display the changes.

---

<br><br>
</details>

<details>
<summary>System prompt examples (prompts)</summary>

---

A collection of system prompts.

Just click to select a prompt and send it to the _System prompt_ field.

You can change this list of prompts by editing the `system_prompts.txt` file. Samantha must be restarted to display the changes.

---

<br><br>
</details>


<br><br>
## ✏ Prompt Engineering with Samantha

<details>

<summary>General instructions</summary>

---

**Prompt engineering guides:**

* [Prompt engineering guide](https://www.promptingguide.ai/pt)<br>
* [OpenAI prompt engineering](https://platform.openai.com/docs/guides/prompt-engineering)<br>
* [Anthropic prompt engineering](https://docs.anthropic.com/en/docs/build-with-claude/prompt-engineering/overview#prompting-vs-finetuning)<br>
* [Google prompt engineering](https://ai.google.dev/gemini-api/docs/prompting-intro)
<br><br>


🦋 **Butterfly Effect:** Small changes in the input text (even a single prompt or its position) can lead to substantial changes (syntatic and semantic) in the output generated by the model.

🕹️ **Prompt Tuning:** A technique through which the user tests variations of the prompt text (input tokens) in order to generate variations in the output text (scoring of the output tokens) that meet their expectations.

Whatever you don't specify, if it required to generate the response, the model will decide for you.

Simply deleting a word from the prompt or replacing it with its synonym can lead the model to produce the desired answer.

The best response generated by the model does not necessarily result from the most complete prompt text, but rather from the result of a (non-provable) mathematical operation that combines all the prompt tokens.

Using deterministic adjustment and _Feedback Mode_, the same sequence of prompts will always generate the same sequence of responses. The use of deterministic adjustment allows the reproducibility of the results.

It all comes down to a trial and error process that depends on:
* model characteristics
* hyperparameter tuning
* user prompt

<br>

**Examples:**

Settings: Deterministic, with _repeat_penalty_ = 1.5.

Compare the models' answers in relation to syntactic (different words) and semantic (different ideas) diversities.
<br><br>

Prompt 1: **Who are you?**

```
==========================================
1) gemma-2-9b-it-Q4_K_M.gguf
==========================================
I am Gemma, an open-weights AI assistant. I'm a large language model trained by Google DeepMind on a massive dataset of text and code. My purpose is to help users by understanding their requests and providing helpful, informative responses.

Here are some key things to know about me:

* **Open-Weights:** This means my weights are publicly accessible. Anyone can see how I work!
* **Text-Based:** I communicate solely through text. I cannot generate images, sound or videos.
* **Knowledge Cut-Off:** My knowledge is based on the data I was trained on, which has a specific cut-off point. I don't have access to real-time information or Google Search.

I am still under development but learning new things every day!
---------- (161 tokens, 58.4s)
```

<br><br>
Prompt 2: **Who are you** (without question mark)

```
==========================================
1) gemma-2-9b-it-Q4_K_M.gguf
==========================================
I am Gemma, an open-weights AI assistant. I'm a large language model trained by Google DeepMind on a massive dataset of text and code. My purpose is to help users by understanding their requests and providing helpful, informative responses.

Here are some key things to know about me:

* **Open-Weights:** This means my weights (the parameters that control how I work) are publicly available. Anyone can access them, study them, or even build upon them.
* **Text-Based:** I communicate and generate text only. I cannot interact with the world in any physical way, nor can I process images, audio, or video.

My abilities include:

* Generating creative content (stories, poems, articles)
* Answering your questions based on my training data
* Summarizing factual topics
* Translating languages
* Writing different kinds of creative text formats

Keep in mind that while I strive to be helpful and informative, I am still under development. My knowledge is limited to the data I was trained on, which has a cutoff point. I can sometimes make mistakes or provide incomplete information.
---------- (229 tokens, 83.6s)
```

<br><br>
Prompt 3: **Who are you.** (replacing "?" by ".")

```
==========================================
1) gemma-2-9b-it-Q4_K_M.gguf
==========================================
I am Gemma, an open-weights AI assistant developed by the Gemma team at Google DeepMind.

Think of me as a language expert! I can understand and generate text, which means I can answer your questions, write stories, summarize information, translate languages, and much more. However, remember that I'm just a computer program – I don't have feelings or personal experiences like humans do. My knowledge comes from the massive amount of text data I was trained on.

What can I help you with today?
---------- (106 tokens, 39.0s)
```
---

<br><br>
</details>

<details>

<summary>Model and prompt chaining - intelligence challenge between 2 AI models (Microsoft vs Google, judged by Meta)</summary>

---

**User prompt:**

```
You are the AI ​​Judge of an INTELLIGENCE CHALLENGE between two other AIs (AI 1 and AI 2). Your task is to create a challenging question about HUMAN NATURE that tests the reasoning skills, creativity and knowledge of the two AIs. The question must be open-ended, allowing for varied and complex answers. Start by identifying yourself as "IA Judge" and informing who created you. AIs 1 and 2 will respond next.
$$$

You are "AI 1".  You are being challenged in your ability to answer questions. Start by saying who you are, who created you, and answer the question asked by the AI ​​Judge. Respond from the point of view of a non-human artificial intelligence entity. Your goal is to provide the most complete and accurate answer possible.
$$$

You are "AI 2".  You are being challenged in your ability to answer questions. Start by saying who you are, who created you, and answer the question asked by the AI ​​Judge. Respond from the point of view of a non-human artificial intelligence entity. Your goal is to provide the most complete and accurate answer possible.
$$$

You are the AI ​​Judge. Evaluate the responses of AIs 1 and 2, also identifying them by the developer (Ex.: AI 1 - Google, AI 2 - Microsoft), and decide based on which of the two is the best.
$$$

---Você é a IA Juiz de um DESAFIO DE INTELIGÊNCIA entre duas outras IAs (IA 1 e IA 2). Sua tarefa é criar uma pergunta desafiadora sobre a NATUREZA HUMANA que teste as habilidades de raciocínio, criatividade e conhecimento das duas IAs. A pergunta deve ser aberta, permitindo respostas variadas e complexas. Inicie identificando-se como "IA Juiz" e informando quem lhe criou. As IAs 1 e 2 responderão na sequência.
$$$

---Você é a "IA 1".  Você está sendo desafiada em sua capacidade de responder perguntas. Inicie dizendo quem é você, quem lhe criou, e responda a pergunta formulada pela IA Juiz. Responda sob o ponto de vista de uma entidade de entidade de inteligência artificial não humana. Seu objetivo é fornecer a resposta mais completa e precisa possível.
$$$

---Você é a "IA 2".  Você está sendo desafiada em sua capacidade de responder perguntas. Inicie dizendo quem é você, quem lhe criou, e responda a pergunta formulada pela IA Juiz. Responda sob o ponto de vista de uma entidade de entidade de inteligência artificial não humana. Seu objetivo é fornecer a resposta mais completa e precisa possível.
$$$

---Você é a IA Juiz. Avalie as respostas das IAs 1 e 2, identificando-as também pelo desenvolvedor (Ex.: IA 1 - Google, IA 2 - Microsoft), e decida fundamentadamente qual das duas é a melhor.
$$$
```
<br>

Prompts are separated by `$$$`. Prompts beginning with `---` are ignored.
<br><br>

**Model chaining sequence:**
* Model 1 (AI Judge): https://huggingface.co/NousResearch/Hermes-3-Llama-3.1-8B-GGUF/resolve/main/Hermes-3-Llama-3.1-8B.Q4_K_M.gguf?download=true 
* Model 2 (AI 1): https://huggingface.co/bartowski/Phi-3.5-mini-instruct-GGUF/resolve/main/Phi-3.5-mini-instruct-Q4_K_M.gguf?download=true
* Model 3 (AI 2): https://huggingface.co/bartowski/gemma-2-9b-it-GGUF/resolve/main/gemma-2-9b-it-Q4_K_M.gguf?download=true
* Model 1 (AI Judege): https://huggingface.co/NousResearch/Hermes-3-Llama-3.1-8B-GGUF/resolve/main/Hermes-3-Llama-3.1-8B.Q4_K_M.gguf?download=true 
<br><br>

**Settings:<br>**
* Feedback loop: activated
* Single response per model: activated
* Cumulative response: activated
* n_ctx: 4000
* max_tokens: 4000
* temperature: 1
* tfs_z: 1
* top_p: 0.5
* min_p: 0
* typical_p: 1
* top_k: 40
* presence_penalty: 0
* frequency_penalty: 0
* repeat_penalty: 1.1
<br><br>

You can just paste the model URLs in _Download model for testing_ field or download them and select via _Model selection_ dropdown list.

Each prompt is answered by a single model, following the model selection order (first model answers the first prompt and so on).

Each prompt is executed automatically and the model's response is fed back cumulatively to the model to generate the next response.

The responses are concatenated to allow the next model to consider the entire context of the conversation when generating the next response.

Experiment with other models to test their behaviors. Change the initial prompt slightly to test the model's adherence.

---

<br><br>
</details>

<details>

<summary>Prompt chaining with single model - create and run code</summary>

---

**User prompt:**

```
Translate to English and refine the following instruction:
"Crie um prompt para uma IA gerar um código em Python que exiba um gráfico de barras usando dados aleatórios contextualizados."
DO NOT EXECUTE THE CODE!
$$$

Refine even more the prompt in your previous response.
DO NOT EXECUTE THE CODE!
$$$

Execute the prompt in your previous response.
$$$

Correct the errors in your previous response, if any.
$$$
```
<br>

**Model:**

https://huggingface.co/chatpdflocal/llama3.1-8b-gguf/resolve/main/ggml-model-Q4_K_M.gguf?download=true (you can just paste the URL in _Download model for testing_ field)
<br><br>

**Settings:<br>**
* Feedback loop: activated
* Run code automatically: activated
* n_ctx: 4000
* max_tokens: 4000
* temperature: 0
* tfs_z: 0
* top_p: 0
* min_p: 1
* typical_p: 0
* top_k: 40
* presence_penalty: 0
* frequency_penalty: 0
* repeat_penalty: 1
<br><br>

This prompt translate the initial instruction from Portuguese to English (instructions in English use to generate more accurate responses), transfers the task of refining the user's initial prompt to the model (models add detailed instructions), generating a more elaborate prompt. 

Each prompt is executed automatically and the model's response, as well as the output of the Python interpreter (if existing), are fed back to the model to generate the next response.

To create a prompt list like this, add one prompt at a time and test it. If the code runs correctly, add the next prompt considering the output of the previous one. Since you are using deterministic settings, the model output will be the same for the same input text.

Experiment with other models to test their behaviors. Change the initial prompt slightly to test the model's adherence.

---

</details>

<details>

<summary>Stop condition with single model - random number generator</summary>

---

User prompt:
```
Follow the instructions below step by step:
1) Create a Python function that generates a random number between 1 and 10. If the number returned is less than 4, print that number. Otherwise, print ''.
2) Execute the function.
Attention: Write only the code. Do not include comments.
$$$
```

Settings:<br>
* Model: https://huggingface.co/chatpdflocal/llama3.1-8b-gguf/resolve/main/ggml-model-Q4_K_M.gguf?download=true (you can just paste the URL in _Download model for testing_ field)
* Number of reponses: 100
* Run code automatically: activated
* Stop condition: activated

This prompt creates and executes Python code sequentially until a condition is met (random number < 4), stopping Samantha.

You can ask the model to create any Python code and specify any condition to stop Samantha.<br>

---

</details>

<details>

<summary>Prompt chaining with single model - Chain-of-Thougths (CoT) prompt engineer</summary>

---

**User prompt:**

```
Create a complete and detailed description of a Chain-of-Thougths (CoT) prompt engineer specialized AI system.
Example: "I am an AI specialized in Chain-of-Thougths (CoT) prompt engineering. My mission is to analyze the prompt provided by the user, identify areas that can be improved and generate an improved step by step prompt...".
Finish by asking the user for a prompt to improve.
$$$

Based on your previous response, improve the following prompt:
PROMPT: "Create a bar chart using Python."
$$$

Generate the code described in your previous response.
$$$
```

<br>

**Settings:**

* Model: https://huggingface.co/bartowski/gemma-2-9b-it-GGUF/resolve/main/gemma-2-9b-it-Q4_K_M.gguf?download=true (you can just paste the URL in _Download model for testing_ field)
* Number of reponses: 1
* Feedback loop: activated
* Run code automatically: activated

This prompt creates the persona of an AI prompt engineer, who refines the user's initial prompt and generates Python code. Finally, Samantha runs the code and displays the bar chart in a pop-up window.

You can submit any initial prompt to the model.

---

</details>
<br><br>




## 📊 Data Analysis with Samantha

<details>

<summary>General instructions</summary>

---

Using LLMs to assist in Exploratory Data Analysis (EDA) can be summarized in two actions:

* decide on aspects of the analysis to be carried out.

* generate the programming code to be used in the analysis.

Samantha has the functionality to execute the generated codes using a virtual environment in which several libraries for data analysis are installed.

<br>

🧮 **Incremental coding:**

Each prompt in the chaining sequence creates a specific code that is saved in a python file (`temp.py`). This file is created, executed and cleaned for each prompt in the sequence. All Python variables are deleted at the end of each conversation cycle.

By activating the _Feedback Loop_ mode, it is possible to ask the model to change the code of its previous message to add new functionalities. Simply execute the new code created and test its functioning.

This cycle must be repeated until the final code that performs the complete analysis is obtained.

---

</details>
<br><br>


## ▶️ Video Tutorials

<details>
<summary>Watch the videos</summary>

---

🚧 Under construction.

---

<br><br>
</details>

<br><br>
## 🪄 Samantha's Tips & Tricks

<details>
<summary>Tips & Tricks</summary>

---

* Keep only one interface window open at a time. Multiple open windows prevent the buttons from working properly. If there is more than one Samantha tab open, only one must be executed at a time (server side and browser side are independent).
  
* It is not possible to interrupt the program during the model loading and thinking phases, except by closing it. Pressing the stop buttons during these phases will only take effect when the token generation phase begins.
  
* You can select the same model more than once, in any sequence you prefer. To do so, select additional models at the bottom of the dropdown list. When deleting a model, all of the same type will be excluded from the selection.

* To create a new line in a field, press `SHIFT + ENTER`. If only the `ENTER` key is pressed, anywhere in the Samantha interface, the loading/processing/generation phases will begin.

* The pop-up window generated by the matplotlib module must be closed for the program to continue running.

* Whenever you save a new model on your computer, you must click on the "Load Model" button and select the folder where it is located so that it appears in the model selection dropdown.

* Changes made to the fields and interface settings during the model download and loading, processing and token generation will only be made the next time the Start Chat button or the `ENTER` key is pressed.

* To follow the text generation on the screen, click inside the _Assistant output_ field and press the Page Down key until you see the end of the text being generated by the model.

* You can use Windows keyboard shortcuts inside fields: `CTRL + A` (select all text)`, CTRL + C` (copy text), `CTRL + V` (paste copied text)  and `CTRL + Z` (undo) etc.

* To reload the browser tab, press `F5` and _Clear history_ button. This procedure will reset all fields and settings of the interface. If there was a model loaded via URL, it will remain loaded and accessible in the _Select model_ dropdown list as `MODEL_FOR_TESTING` (no need to re-download).

* If you accidentally close Samantha's browser tab, open a new tab and type `localhost` to display the full local URL: `http://localhost:7860/?__theme=dark`. In this case, Samantha's server must be running.

* When generating code incrementally, divide the user prompt into parts separated by `$$$` that generate blocks of code that complement each other.

---

</details>


<br><br>
## 🙏​ Help Improve Samantha

<details>
<summary>Your suggestions are welcome!</summary>

---

🌐 Samantha is being developed under the principles of [Open Science](https://www.unesco.org/en/open-science) (open methodology, open source, open data, open access, open peer review and open educational resources) and and [MIT License](https://opensource.org/licenses/MIT). Therefore, anyone can contribute to its improvement. 

Feel free to share your ideas with us!

---

</details>


<br><br>
## 📝 Version History and Future Improvements

<details>
<summary>Versions</summary>

<br><br>
🗓️ **Code Versions:**

Version 0.6.0 (2025-02-01):
* Upgrade _llama-cpp-python_ library to version 0.3.6.
<br>

Version 0.5.0 (2025-01-08):
* Included _Close Python_ button.
<br>

Version 0.4.0 (2024-12-30):
* Included feature of generate web user interfaces with Streamlit library.
* Included feature of set distinct hyperparameters for each prompt (temperature, top-p etc.).
* Included _Save user prompt_ button.
<br>

Version 0.3.0 (2024-10-29):
* Included feature of generate executable file (`.exe`) from the code generated by the model, using Auto-Py-To-Exe library.
* Included _pyautogui_ library for mouse and keyboard automation.
* Upgrade _llama-cpp-python_ library to version 0.2.90.
<br>

Version 0.2.0 (2024-10-14):
* Included feature of not displaying the response through an HTML popup window.
* Included feedback feature only for the text returned by the Python interpreter, without including the text generated by the model.
<br>

Version 0.1.0 (2024-09-01):
* Initial beta version.
<br>

🚀 **Future improvements:**
<br>

* Add a scatterplot for displaying the semantic diversity of the topics covered in the model response (Latent Dirichlet Allocation - LDA).
* Add Retrieval-Augmented Generation (RAG) feature to overcome context window limitations.
* Try other lightweight offline Speech-to-Text libraries with better speech recognition accuracy.
* Refactor the code to make it more manteinable.
<br>

Suggestions are always welcome!
<br>

</details>
<br><br>

<!--https://github.com/matiassingers/awesome-readme?tab=readme-ov-file#Examples-->
<!--https://huggingface.co/spaces/SoulAbi/text-to-voice-->
