package LeetCode.src.Explore.Interview.GoogleInterview.DynamicProgramming.EditDistance.Java;

public class Solution {
    public static void main(String[] args) {
        String A = "Anshuman";
        String B = "Antihuman";
        System.out.println(minDistance(A, B));
    }
    
    public static int minDistance(String word1, String word2) {
        int m = word1.length();
        int n = word2.length();

        // if one of the strings is empty
        if (n * m == 0) {
            return n + m;
        }
        
        // array to store the conversion history
        int[][] cost = new int[m + 1][n + 1];

        // init boundaries
        for(int i = 0; i <= m; i++) {
            cost[i][0] = i;
        }
        for(int i = 1; i <= n; i++) {
            cost[0][i] = i;
        }
        
        // DP compute 
        for(int i = 0; i < m; i++) {
            for(int j = 0; j < n; j++) {
                if(word1.charAt(i) == word2.charAt(j)) {
                    cost[i + 1][j + 1] = cost[i][j];
                }
                else {
                    int replace = cost[i][j];
                    int delete = cost[i][j + 1];
                    int insert = cost[i + 1][j];
                    cost[i + 1][j + 1] = Math.min(replace, Math.min(delete, insert)) + 1;
                }
            }
        }
        return cost[m][n];
    }
}