![Request flow for shortening of a URL](data:image/png;base64,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)