![high level design](data:image/png;base64,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)