# Learning Computer Science

![logo](https://github.com/computer-science-engineering/learning-computer-science/blob/main/resources/images/logo/Logo%20LCS%20color/logo%20LCS%20color%20low%20res.png?raw=true)

1. [Overview](#overview)
2. [Project](#project)
   1. [Project Management](#project-management)
3. [Product](#product)
4. [Development](#development)
   1. [Contributing](#contributing)
5. [Links](#links)
6. [Notes](#notes)
7. [License](#license)

## Overview

Learning data structures, algorithms, machine learning and various computer science constructs by programming practice from resources around the web.

[![Discord](https://img.shields.io/discord/611637065913729036)](https://discord.gg/bv5FU8t) [![CircleCI](https://circleci.com/gh/computer-science-engineering/learning-computer-science/tree/main.svg?style=svg)](https://circleci.com/gh/computer-science-engineering/learning-computer-science/tree/main) 
[![Actions Status](https://github.com/computer-science-engineering/learning-computer-science/workflows/build-test/badge.svg)](https://github.com/computer-science-engineering/learning-computer-science/actions)
[![GitHub Super-Linter](https://github.com/computer-science-engineering/learning-computer-science/workflows/Lint%20Code%20Base/badge.svg)](https://github.com/computer-science-engineering/learning-computer-science/actions)
[![codecov](https://codecov.io/gh/computer-science-engineering/learning-computer-science/branch/main/graph/badge.svg)](https://codecov.io/gh/computer-science-engineering/learning-computer-science)

[More project metadata badges [here](./documentation/project/metadata.md). More CI/CD badges [here](./documentation/development/ci-cd.md#current-status).]

## Project

| Document | Link                                                                       |
| -------- | -------------------------------------------------------------------------- |
| Metadata | [./documentation/project/metadata.md](./documentation/project/metadata.md) |

### Project Management

[GitHub Projects](https://github.com/computer-science-engineering/learning-computer-science/projects)

## Product

| Document     | Link                                                                               |
| ------------ | ---------------------------------------------------------------------------------- |
| Installation | [./documentation/product/installation.md](./documentation/product/installation.md) |
| Usage        | [./documentation/product/usage.md](./documentation/product/usage.md)               |

## Development

| Document                | Link                                                                                                     |
| ----------------------- | -------------------------------------------------------------------------------------------------------- |
| Design and Architecture | [./documentation/development/design-architecture.md](./documentation/development/design-architecture.md) |
| Requirements            | [./documentation/development/requirements.md](./documentation/development/requirements.md)               |
| Testing                 | [./documentation/development/testing.md](./documentation/development/testing.md)                         |
| CI/CD                   | [./documentation/development/ci-cd.md](./documentation/development/ci-cd.md)                             |

### Contributing

[./.github/CONTRIBUTING.md](./.github/CONTRIBUTING.md)

## Links

- [Sourcegraph](https://sourcegraph.com/github.com/computer-science-engineering/learning-computer-science/)
- [Discord Server](https://discord.gg/bv5FU8t)

## Notes

1. Problems in the repository are not necessarily solved by me. The goal is to learn. Sometimes in the interest of time, that involves understanding an existing solution rather than spending an inordinate amount of time trying to solve it by myself. Where applicable I have provided references to the original solution.
2. Problems in this repository are not unique. Given that the same (or similar) problem may exist in multiple origins, more than a few problems are repeated. It is my goal to provide some sort of querying mechanism via a [website](https://github.com/computer-science-engineering/computer-science-engineering.github.io/projects/2) for users to view only a unique instance of a problem, either from a "first or default" origin or a specified origin.

## License

[MIT](https://github.com/computer-science-engineering/learning-computer-science/blob/main/LICENSE)
