require_relative '../../spec_helper'
require 'json'

describe Cyclonedx::ReportNodeModules do
  describe "#run" do
    it 'should report all the deps in the package.json if both\
        package-lock.json and yarn.lock files do not exist' do
      repo = Salus::Repo.new('spec/fixtures/report_node_modules/package_json_only')
      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: {})
      scanner.run

      node_cyclonedx = Cyclonedx::ReportNodeModules.new(scanner.report)
      expect(node_cyclonedx.build_components_object).to match_array(
        [
          {
            "type": "library",
          "group": "",
            "name": "@nerv-hq/control-system",
            "version": "1.2.3",
            "purl": "pkg:npm/%40nerv-hq/control-system",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "@magi-core/prediction",
            "version": "0.0.1",
            "purl": "pkg:npm/%40magi-core/prediction",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "classnames",
            "version": "^2.2.5",
            "purl": "pkg:npm/classnames",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "mobx",
            "version": "^3.2.1",
            "purl": "pkg:npm/mobx",
            "scope": "required"
          }
        ]
      )
    end

    it 'should report all the deps in the package-lock.json if present' do
      repo = Salus::Repo.new('spec/fixtures/report_node_modules/package_lock_json')
      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: {})
      scanner.run

      node_cyclonedx = Cyclonedx::ReportNodeModules.new(scanner.report)
      expect(node_cyclonedx.build_components_object).to match_array(
        [
          {
            "type": "library",
          "group": "",
            "name": "@nerv-hq/control-system",
            "version": "1.2.3",
            "purl": "pkg:npm/%40nerv-hq/control-system@1.2.3",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "@magi-core/prediction",
            "version": "0.0.1",
            "purl": "pkg:npm/%40magi-core/prediction@0.0.1",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "classnames",
            "version": "2.2.5",
            "purl": "pkg:npm/classnames@2.2.5",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "mobx",
            "version": "3.2.1",
            "purl": "pkg:npm/mobx@3.2.1",
            "scope": "required"
          }
        ]
      )
    end

    it 'should report all the deps in the yarn.lock if present' do
      repo = Salus::Repo.new('spec/fixtures/report_node_modules/yarn_lock')
      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: {})
      scanner.run

      node_cyclonedx = Cyclonedx::ReportNodeModules.new(scanner.report)
      expect(node_cyclonedx.build_components_object).to match_array(
        [
          {
            "type": "library",
          "group": "",
            "name": "@nerv-hq/control-system",
            "version": "1.2.3",
            "purl": "pkg:npm/%40nerv-hq/control-system@1.2.3",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "@magi-core/prediction",
            "version": "0.0.1",
            "purl": "pkg:npm/%40magi-core/prediction@0.0.1",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "classnames",
            "version": "2.2.5",
            "purl": "pkg:npm/classnames@2.2.5",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "mobx",
            "version": "3.2.1",
            "purl": "pkg:npm/mobx@3.2.1",
            "scope": "required"
          },
          {
            "type": "library",
          "group": "",
            "name": "eslint-plugin-internal",
            "version": "0.0.0",
            "purl": "pkg:npm/eslint-plugin-internal@0.0.0",
            "scope": "required"
          }
        ]
      )
    end

    it 'should report all the deps in the bower.json if present' do
      repo = Salus::Repo.new('spec/fixtures/report_node_modules/bower_json')
      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: {})
      scanner.run

      node_cyclonedx = Cyclonedx::ReportNodeModules.new(scanner.report)
      expect(node_cyclonedx.build_components_object).to match_array(
        [
          {
            "type": "library",
          "group": "",
             "name": "lodash",
             "version": "3.0.0",
             "purl": "pkg:npm/lodash@3.0.0",
             "scope": "required"
          },
          {
            "type": "library",
          "group": "",
             "name": "angular",
             "version": "1.3.0",
             "purl": "pkg:npm/angular@1.3.0",
             "scope": "required"
          },
          {
            "type": "library",
          "group": "",
             "name": "axios",
             "version": "0.17.0",
             "purl": "pkg:npm/axios@0.17.0",
             "scope": "required"
          },
          {
            "type": "library",
          "group": "",
             "name": "angular-ui-router",
             "version": "0.2.13",
             "purl": "pkg:npm/angular-ui-router@0.2.13",
             "scope": "required"
          }
        ]
      )
    end

    it 'should produce valid CycloneDX for bower.json' do
      repo = Salus::Repo.new('spec/fixtures/report_node_modules/bower_json')

      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: {})
      scanner.run

      cyclonedx_report = Cyclonedx::Report.new([[scanner.report, false]],
                                               { "spec_version" => "1.3" })
      cyclonedx_report_hash = cyclonedx_report.to_cyclonedx

      expect { Cyclonedx::Report.validate_cyclonedx(cyclonedx_report_hash) }.not_to raise_error
    end

    it 'should produce valid CycloneDX for including dev deps package-lock.json' do
      path = 'spec/fixtures/report_node_modules/validate_include_dev_deps_flag'
      config_file = YAML.load_file("#{path}/salus.yaml")
      scanner_config = config_file['scanner_configs']["ReportNodeModules"]

      repo = Salus::Repo.new(path)

      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: scanner_config)
      scanner.run

      cyclonedx_report = Cyclonedx::Report.new([[scanner.report, false]],
                                               { "spec_version" => "1.3" })
      cyclonedx_report_hash = cyclonedx_report.to_cyclonedx

      expect { Cyclonedx::Report.validate_cyclonedx(cyclonedx_report_hash) }.not_to raise_error
    end

    it 'should produce valid CycloneDX for excluding dev deps package-lock.json' do
      path = 'spec/fixtures/report_node_modules/validate_exclude_dev_deps_flag'
      config_file = YAML.load_file("#{path}/salus.yaml")
      scanner_config = config_file['scanner_configs']["ReportNodeModules"]

      repo = Salus::Repo.new(path)

      scanner = Salus::Scanners::ReportNodeModules.new(repository: repo, config: scanner_config)
      scanner.run

      cyclonedx_report = Cyclonedx::Report.new([[scanner.report, false]],
                                               { "spec_version" => "1.3" })
      cyclonedx_report_hash = cyclonedx_report.to_cyclonedx

      expect { Cyclonedx::Report.validate_cyclonedx(cyclonedx_report_hash) }.not_to raise_error
    end
  end
end
