require 'salus/bugsnag'

module Sarif
  class RepoNotEmptySarif < BaseSarif
    include Salus::SalusBugsnag

    REPO_NOT_EMPTY_URI = "https://github.com/coinbase/salus/blob/master/docs/scanners/"\
    "repository_not_blank.md".freeze

    def initialize(scan_report, repo_path = nil, scanner_config = {})
      super(scan_report, {}, repo_path)
      @uri = REPO_NOT_EMPTY_URI
      @logs = parse_scan_report!
      @scanner_config = scanner_config
    end

    def parse_scan_report!
      @scan_report.errors
    end

    def parse_issue(issue)
      # Example issue
      # {:message=>"Salus was run on a blank directory. This ..."}

      {
        id: "RNE0001",
        name: "RepositoryIsEmpty",
        details: issue[:message],
        level: "VERY LOW",
        uri: "",
        help_url: REPO_NOT_EMPTY_URI,
        properties: { severity: "VERY LOW" }
      }
    end
  end
end
