const fs = require('fs')

const removeFiles = (files = []) => {
  files.forEach(path => {
    if (fs.existsSync(path)) {
      fs.unlinkSync(path)
    }
  })
}

const filesToRemove = [
  'src/components/HelloWorld.vue',
  'src/router.js',
  'src/store.js'
]

const importsToRemove = [
  `import store from './store'`,
  `import router from './router'`
]

module.exports = (api, options, rootOptions) => {
  const {
    entryFile,
    generator: { imports }
  } = api

  api.extendPackage({
    dependencies: {
      'element-ui': '^2.4.11',
      'vuex-router-sync': '^5.0.0'
    }
  })

  // api.injectImports(entryFile, `import './registerElementUI'`)

  // Remove the default imports generated by vue-cli
  if (imports[entryFile]) {
    importsToRemove.forEach(itr => imports[entryFile].delete(itr))
  }

  // Remove the default files generated by vue-cli
  api.render(function(files) {
    filesToRemove.forEach(ftr => delete files[ftr])
  })
  api.render('./template/structure')

  api.onCreateComplete(() => {
    removeFiles(filesToRemove.map(ftr => api.resolve(ftr)))
  })
}
