<?php
namespace codename\parquet\format;

/**
 * Autogenerated by Thrift Compiler (0.15.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;

class PageHeader
{
    static public $isValidate = false;

    static public $_TSPEC = array(
        1 => array(
            'var' => 'type',
            'isRequired' => true,
            'type' => TType::I32,
            'class' => '\codename\parquet\format\PageType',
        ),
        2 => array(
            'var' => 'uncompressed_page_size',
            'isRequired' => true,
            'type' => TType::I32,
        ),
        3 => array(
            'var' => 'compressed_page_size',
            'isRequired' => true,
            'type' => TType::I32,
        ),
        4 => array(
            'var' => 'crc',
            'isRequired' => false,
            'type' => TType::I32,
        ),
        5 => array(
            'var' => 'data_page_header',
            'isRequired' => false,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\DataPageHeader',
        ),
        6 => array(
            'var' => 'index_page_header',
            'isRequired' => false,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\IndexPageHeader',
        ),
        7 => array(
            'var' => 'dictionary_page_header',
            'isRequired' => false,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\DictionaryPageHeader',
        ),
        8 => array(
            'var' => 'data_page_header_v2',
            'isRequired' => false,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\DataPageHeaderV2',
        ),
    );

    /**
     * the type of the page: indicates which of the *_header fields is set *
     * 
     * @var int
     */
    public $type = null;
    /**
     * Uncompressed page size in bytes (not including this header) *
     * 
     * @var int
     */
    public $uncompressed_page_size = null;
    /**
     * Compressed (and potentially encrypted) page size in bytes, not including this header *
     * 
     * @var int
     */
    public $compressed_page_size = null;
    /**
     * The 32bit CRC for the page, to be be calculated as follows:
     * - Using the standard CRC32 algorithm
     * - On the data only, i.e. this header should not be included. 'Data'
     *   hereby refers to the concatenation of the repetition levels, the
     *   definition levels and the column value, in this exact order.
     * - On the encoded versions of the repetition levels, definition levels and
     *   column values
     * - On the compressed versions of the repetition levels, definition levels
     *   and column values where possible;
     *   - For v1 data pages, the repetition levels, definition levels and column
     *     values are always compressed together. If a compression scheme is
     *     specified, the CRC shall be calculated on the compressed version of
     *     this concatenation. If no compression scheme is specified, the CRC
     *     shall be calculated on the uncompressed version of this concatenation.
     *   - For v2 data pages, the repetition levels and definition levels are
     *     handled separately from the data and are never compressed (only
     *     encoded). If a compression scheme is specified, the CRC shall be
     *     calculated on the concatenation of the uncompressed repetition levels,
     *     uncompressed definition levels and the compressed column values.
     *     If no compression scheme is specified, the CRC shall be calculated on
     *     the uncompressed concatenation.
     * - In encrypted columns, CRC is calculated after page encryption; the
     *   encryption itself is performed after page compression (if compressed)
     * If enabled, this allows for disabling checksumming in HDFS if only a few
     * pages need to be read.
     * 
     * 
     * @var int
     */
    public $crc = null;
    /**
     * @var \codename\parquet\format\DataPageHeader
     */
    public $data_page_header = null;
    /**
     * @var \codename\parquet\format\IndexPageHeader
     */
    public $index_page_header = null;
    /**
     * @var \codename\parquet\format\DictionaryPageHeader
     */
    public $dictionary_page_header = null;
    /**
     * @var \codename\parquet\format\DataPageHeaderV2
     */
    public $data_page_header_v2 = null;

    public function __construct($vals = null)
    {
        if (is_array($vals)) {
            if (isset($vals['type'])) {
                $this->type = $vals['type'];
            }
            if (isset($vals['uncompressed_page_size'])) {
                $this->uncompressed_page_size = $vals['uncompressed_page_size'];
            }
            if (isset($vals['compressed_page_size'])) {
                $this->compressed_page_size = $vals['compressed_page_size'];
            }
            if (isset($vals['crc'])) {
                $this->crc = $vals['crc'];
            }
            if (isset($vals['data_page_header'])) {
                $this->data_page_header = $vals['data_page_header'];
            }
            if (isset($vals['index_page_header'])) {
                $this->index_page_header = $vals['index_page_header'];
            }
            if (isset($vals['dictionary_page_header'])) {
                $this->dictionary_page_header = $vals['dictionary_page_header'];
            }
            if (isset($vals['data_page_header_v2'])) {
                $this->data_page_header_v2 = $vals['data_page_header_v2'];
            }
        }
    }

    public function getName()
    {
        return 'PageHeader';
    }


    public function read($input)
    {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->type);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->uncompressed_page_size);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->compressed_page_size);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->crc);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::STRUCT) {
                        $this->data_page_header = new \codename\parquet\format\DataPageHeader();
                        $xfer += $this->data_page_header->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::STRUCT) {
                        $this->index_page_header = new \codename\parquet\format\IndexPageHeader();
                        $xfer += $this->index_page_header->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 7:
                    if ($ftype == TType::STRUCT) {
                        $this->dictionary_page_header = new \codename\parquet\format\DictionaryPageHeader();
                        $xfer += $this->dictionary_page_header->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 8:
                    if ($ftype == TType::STRUCT) {
                        $this->data_page_header_v2 = new \codename\parquet\format\DataPageHeaderV2();
                        $xfer += $this->data_page_header_v2->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write($output)
    {
        $xfer = 0;
        $xfer += $output->writeStructBegin('PageHeader');
        if ($this->type !== null) {
            $xfer += $output->writeFieldBegin('type', TType::I32, 1);
            $xfer += $output->writeI32($this->type);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->uncompressed_page_size !== null) {
            $xfer += $output->writeFieldBegin('uncompressed_page_size', TType::I32, 2);
            $xfer += $output->writeI32($this->uncompressed_page_size);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->compressed_page_size !== null) {
            $xfer += $output->writeFieldBegin('compressed_page_size', TType::I32, 3);
            $xfer += $output->writeI32($this->compressed_page_size);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->crc !== null) {
            $xfer += $output->writeFieldBegin('crc', TType::I32, 4);
            $xfer += $output->writeI32($this->crc);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->data_page_header !== null) {
            if (!is_object($this->data_page_header)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('data_page_header', TType::STRUCT, 5);
            $xfer += $this->data_page_header->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->index_page_header !== null) {
            if (!is_object($this->index_page_header)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('index_page_header', TType::STRUCT, 6);
            $xfer += $this->index_page_header->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->dictionary_page_header !== null) {
            if (!is_object($this->dictionary_page_header)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('dictionary_page_header', TType::STRUCT, 7);
            $xfer += $this->dictionary_page_header->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->data_page_header_v2 !== null) {
            if (!is_object($this->data_page_header_v2)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('data_page_header_v2', TType::STRUCT, 8);
            $xfer += $this->data_page_header_v2->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }
}
