<?php
namespace codename\parquet\format;

/**
 * Autogenerated by Thrift Compiler (0.15.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;

/**
 * Description for file metadata
 */
class FileMetaData
{
    static public $isValidate = false;

    static public $_TSPEC = array(
        1 => array(
            'var' => 'version',
            'isRequired' => true,
            'type' => TType::I32,
        ),
        2 => array(
            'var' => 'schema',
            'isRequired' => true,
            'type' => TType::LST,
            'etype' => TType::STRUCT,
            'elem' => array(
                'type' => TType::STRUCT,
                'class' => '\codename\parquet\format\SchemaElement',
                ),
        ),
        3 => array(
            'var' => 'num_rows',
            'isRequired' => true,
            'type' => TType::I64,
        ),
        4 => array(
            'var' => 'row_groups',
            'isRequired' => true,
            'type' => TType::LST,
            'etype' => TType::STRUCT,
            'elem' => array(
                'type' => TType::STRUCT,
                'class' => '\codename\parquet\format\RowGroup',
                ),
        ),
        5 => array(
            'var' => 'key_value_metadata',
            'isRequired' => false,
            'type' => TType::LST,
            'etype' => TType::STRUCT,
            'elem' => array(
                'type' => TType::STRUCT,
                'class' => '\codename\parquet\format\KeyValue',
                ),
        ),
        6 => array(
            'var' => 'created_by',
            'isRequired' => false,
            'type' => TType::STRING,
        ),
        7 => array(
            'var' => 'column_orders',
            'isRequired' => false,
            'type' => TType::LST,
            'etype' => TType::STRUCT,
            'elem' => array(
                'type' => TType::STRUCT,
                'class' => '\codename\parquet\format\ColumnOrder',
                ),
        ),
        8 => array(
            'var' => 'encryption_algorithm',
            'isRequired' => false,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\EncryptionAlgorithm',
        ),
        9 => array(
            'var' => 'footer_signing_key_metadata',
            'isRequired' => false,
            'type' => TType::STRING,
        ),
    );

    /**
     * Version of this file *
     * 
     * @var int
     */
    public $version = null;
    /**
     * Parquet schema for this file.  This schema contains metadata for all the columns.
     * The schema is represented as a tree with a single root.  The nodes of the tree
     * are flattened to a list by doing a depth-first traversal.
     * The column metadata contains the path in the schema for that column which can be
     * used to map columns to nodes in the schema.
     * The first element is the root *
     * 
     * @var \codename\parquet\format\SchemaElement[]
     */
    public $schema = null;
    /**
     * Number of rows in this file *
     * 
     * @var int
     */
    public $num_rows = null;
    /**
     * Row groups in this file *
     * 
     * @var \codename\parquet\format\RowGroup[]
     */
    public $row_groups = null;
    /**
     * Optional key/value metadata *
     * 
     * @var \codename\parquet\format\KeyValue[]
     */
    public $key_value_metadata = null;
    /**
     * String for application that wrote this file.  This should be in the format
     * <Application> version <App Version> (build <App Build Hash>).
     * e.g. impala version 1.0 (build 6cf94d29b2b7115df4de2c06e2ab4326d721eb55)
     * 
     * 
     * @var string
     */
    public $created_by = null;
    /**
     * Sort order used for the min_value and max_value fields in the Statistics
     * objects and the min_values and max_values fields in the ColumnIndex
     * objects of each column in this file. Sort orders are listed in the order
     * matching the columns in the schema. The indexes are not necessary the same
     * though, because only leaf nodes of the schema are represented in the list
     * of sort orders.
     * 
     * Without column_orders, the meaning of the min_value and max_value fields
     * in the Statistics object and the ColumnIndex object is undefined. To ensure
     * well-defined behaviour, if these fields are written to a Parquet file,
     * column_orders must be written as well.
     * 
     * The obsolete min and max fields in the Statistics object are always sorted
     * by signed comparison regardless of column_orders.
     * 
     * @var \codename\parquet\format\ColumnOrder[]
     */
    public $column_orders = null;
    /**
     * Encryption algorithm. This field is set only in encrypted files
     * with plaintext footer. Files with encrypted footer store algorithm id
     * in FileCryptoMetaData structure.
     * 
     * @var \codename\parquet\format\EncryptionAlgorithm
     */
    public $encryption_algorithm = null;
    /**
     * Retrieval metadata of key used for signing the footer.
     * Used only in encrypted files with plaintext footer.
     * 
     * @var string
     */
    public $footer_signing_key_metadata = null;

    public function __construct($vals = null)
    {
        if (is_array($vals)) {
            if (isset($vals['version'])) {
                $this->version = $vals['version'];
            }
            if (isset($vals['schema'])) {
                $this->schema = $vals['schema'];
            }
            if (isset($vals['num_rows'])) {
                $this->num_rows = $vals['num_rows'];
            }
            if (isset($vals['row_groups'])) {
                $this->row_groups = $vals['row_groups'];
            }
            if (isset($vals['key_value_metadata'])) {
                $this->key_value_metadata = $vals['key_value_metadata'];
            }
            if (isset($vals['created_by'])) {
                $this->created_by = $vals['created_by'];
            }
            if (isset($vals['column_orders'])) {
                $this->column_orders = $vals['column_orders'];
            }
            if (isset($vals['encryption_algorithm'])) {
                $this->encryption_algorithm = $vals['encryption_algorithm'];
            }
            if (isset($vals['footer_signing_key_metadata'])) {
                $this->footer_signing_key_metadata = $vals['footer_signing_key_metadata'];
            }
        }
    }

    public function getName()
    {
        return 'FileMetaData';
    }


    public function read($input)
    {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->version);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->schema = array();
                        $_size84 = 0;
                        $_etype87 = 0;
                        $xfer += $input->readListBegin($_etype87, $_size84);
                        for ($_i88 = 0; $_i88 < $_size84; ++$_i88) {
                            $elem89 = null;
                            $elem89 = new \codename\parquet\format\SchemaElement();
                            $xfer += $elem89->read($input);
                            $this->schema []= $elem89;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->num_rows);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::LST) {
                        $this->row_groups = array();
                        $_size90 = 0;
                        $_etype93 = 0;
                        $xfer += $input->readListBegin($_etype93, $_size90);
                        for ($_i94 = 0; $_i94 < $_size90; ++$_i94) {
                            $elem95 = null;
                            $elem95 = new \codename\parquet\format\RowGroup();
                            $xfer += $elem95->read($input);
                            $this->row_groups []= $elem95;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::LST) {
                        $this->key_value_metadata = array();
                        $_size96 = 0;
                        $_etype99 = 0;
                        $xfer += $input->readListBegin($_etype99, $_size96);
                        for ($_i100 = 0; $_i100 < $_size96; ++$_i100) {
                            $elem101 = null;
                            $elem101 = new \codename\parquet\format\KeyValue();
                            $xfer += $elem101->read($input);
                            $this->key_value_metadata []= $elem101;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->created_by);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 7:
                    if ($ftype == TType::LST) {
                        $this->column_orders = array();
                        $_size102 = 0;
                        $_etype105 = 0;
                        $xfer += $input->readListBegin($_etype105, $_size102);
                        for ($_i106 = 0; $_i106 < $_size102; ++$_i106) {
                            $elem107 = null;
                            $elem107 = new \codename\parquet\format\ColumnOrder();
                            $xfer += $elem107->read($input);
                            $this->column_orders []= $elem107;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 8:
                    if ($ftype == TType::STRUCT) {
                        $this->encryption_algorithm = new \codename\parquet\format\EncryptionAlgorithm();
                        $xfer += $this->encryption_algorithm->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 9:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->footer_signing_key_metadata);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write($output)
    {
        $xfer = 0;
        $xfer += $output->writeStructBegin('FileMetaData');
        if ($this->version !== null) {
            $xfer += $output->writeFieldBegin('version', TType::I32, 1);
            $xfer += $output->writeI32($this->version);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->schema !== null) {
            if (!is_array($this->schema)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('schema', TType::LST, 2);
            $output->writeListBegin(TType::STRUCT, count($this->schema));
            foreach ($this->schema as $iter108) {
                $xfer += $iter108->write($output);
            }
            $output->writeListEnd();
            $xfer += $output->writeFieldEnd();
        }
        if ($this->num_rows !== null) {
            $xfer += $output->writeFieldBegin('num_rows', TType::I64, 3);
            $xfer += $output->writeI64($this->num_rows);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->row_groups !== null) {
            if (!is_array($this->row_groups)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('row_groups', TType::LST, 4);
            $output->writeListBegin(TType::STRUCT, count($this->row_groups));
            foreach ($this->row_groups as $iter109) {
                $xfer += $iter109->write($output);
            }
            $output->writeListEnd();
            $xfer += $output->writeFieldEnd();
        }
        if ($this->key_value_metadata !== null) {
            if (!is_array($this->key_value_metadata)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('key_value_metadata', TType::LST, 5);
            $output->writeListBegin(TType::STRUCT, count($this->key_value_metadata));
            foreach ($this->key_value_metadata as $iter110) {
                $xfer += $iter110->write($output);
            }
            $output->writeListEnd();
            $xfer += $output->writeFieldEnd();
        }
        if ($this->created_by !== null) {
            $xfer += $output->writeFieldBegin('created_by', TType::STRING, 6);
            $xfer += $output->writeString($this->created_by);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->column_orders !== null) {
            if (!is_array($this->column_orders)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('column_orders', TType::LST, 7);
            $output->writeListBegin(TType::STRUCT, count($this->column_orders));
            foreach ($this->column_orders as $iter111) {
                $xfer += $iter111->write($output);
            }
            $output->writeListEnd();
            $xfer += $output->writeFieldEnd();
        }
        if ($this->encryption_algorithm !== null) {
            if (!is_object($this->encryption_algorithm)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('encryption_algorithm', TType::STRUCT, 8);
            $xfer += $this->encryption_algorithm->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->footer_signing_key_metadata !== null) {
            $xfer += $output->writeFieldBegin('footer_signing_key_metadata', TType::STRING, 9);
            $xfer += $output->writeString($this->footer_signing_key_metadata);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }
}
