<?php
namespace codename\parquet\format;

/**
 * Autogenerated by Thrift Compiler (0.15.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;

/**
 * Crypto metadata for files with encrypted footer *
 */
class FileCryptoMetaData
{
    static public $isValidate = false;

    static public $_TSPEC = array(
        1 => array(
            'var' => 'encryption_algorithm',
            'isRequired' => true,
            'type' => TType::STRUCT,
            'class' => '\codename\parquet\format\EncryptionAlgorithm',
        ),
        2 => array(
            'var' => 'key_metadata',
            'isRequired' => false,
            'type' => TType::STRING,
        ),
    );

    /**
     * Encryption algorithm. This field is only used for files
     * with encrypted footer. Files with plaintext footer store algorithm id
     * inside footer (FileMetaData structure).
     * 
     * @var \codename\parquet\format\EncryptionAlgorithm
     */
    public $encryption_algorithm = null;
    /**
     * Retrieval metadata of key used for encryption of footer,
     * and (possibly) columns *
     * 
     * @var string
     */
    public $key_metadata = null;

    public function __construct($vals = null)
    {
        if (is_array($vals)) {
            if (isset($vals['encryption_algorithm'])) {
                $this->encryption_algorithm = $vals['encryption_algorithm'];
            }
            if (isset($vals['key_metadata'])) {
                $this->key_metadata = $vals['key_metadata'];
            }
        }
    }

    public function getName()
    {
        return 'FileCryptoMetaData';
    }


    public function read($input)
    {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->encryption_algorithm = new \codename\parquet\format\EncryptionAlgorithm();
                        $xfer += $this->encryption_algorithm->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->key_metadata);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write($output)
    {
        $xfer = 0;
        $xfer += $output->writeStructBegin('FileCryptoMetaData');
        if ($this->encryption_algorithm !== null) {
            if (!is_object($this->encryption_algorithm)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('encryption_algorithm', TType::STRUCT, 1);
            $xfer += $this->encryption_algorithm->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->key_metadata !== null) {
            $xfer += $output->writeFieldBegin('key_metadata', TType::STRING, 2);
            $xfer += $output->writeString($this->key_metadata);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }
}
