# Contributing to the Question Bank

> [!IMPORTANT]
> The Question Bank is a module newly added in version `v0.4.0`, so we haven't collected many resources yet. We hope you can join us in enriching our bank!

## How to Contribute

If you have recommended resources for the question bank, you can contribute in the following two ways:

### PR

Submitting a PR is the recommended method. When doing so, please follow these steps:

1. Fork your own branch.

2. Navigate to the [question-bank](https://github.com/codeacme17/examor/tree/main/docs/question-bank) folder.

3. Determine the language of the document; for English documents, enter the `en` folder.

4. Identify the category of your resource. If the current repository doesn't have a category that fits your resource, you can create a new folder and name it according to the category (e.g., resources related to programming are placed in the `programming` folder).

5. Create a folder for your resource, with the **folder name being the name of the resource** (this is crucial).

6. Filter by file type; currently, only `.md` type files are supported.

7. When submitting a PR, please provide the URL, description, and Icon of the resource in the PR. While these details are not mandatory, they are highly recommended.

If your resource is incorporated into our question bank, we'll mark you as a contributor to that resource in its card, linking to your GitHub, as a token of our gratitude!

### Issue or Discussion

You can also notify me of any recommended high-quality resources for inclusion in the [Issue](https://github.com/codeacme17/examor/issues) or [Discussion](https://github.com/codeacme17/examor/discussions) sections.

## Currently Included Resources (English)

### Programming Category

- [vue-component](https://vuejs.org/guide/components/registration.html)
- [vue-apis](https://vuejs.org/api/)
