import vue from '@vitejs/plugin-vue'
import vuetify, { transformAssetUrls } from 'vite-plugin-vuetify'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { TDesignResolver } from 'unplugin-vue-components/resolvers'
import { defineConfig } from 'vite'
import { fileURLToPath, URL } from 'node:url'

export default defineConfig({
  plugins: [
    vue({
      template: { transformAssetUrls },
    }),
    vuetify({
      autoImport: true,
    }),
    AutoImport({
      resolvers: [
        TDesignResolver({
          library: 'vue-next',
        }),
      ],
    }),
    Components({
      resolvers: [
        TDesignResolver({
          library: 'vue-next',
        }),
      ],
    }),
  ],

  define: { 'process.env': {} },

  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
    },
    extensions: ['.js', '.json', '.jsx', '.mjs', '.ts', '.tsx', '.vue'],
  },

  server: {
    port: 51818,
    proxy: {
      '/api': {
        target: `http://${process.env.DOCKER ? 'server' : '0.0.0.0'}:51717`,
        changeOrigin: true,
        rewrite: (pathStr) => pathStr.replace('/api', '/'),
      },
      '/ws': {
        target: `ws://${process.env.DOCKER ? 'server' : 'localhost'}:51717`,
        changeOrigin: true,
        ws: true,
        rewrite: (pathStr) => pathStr.replace('/ws', '/'),
      },
    },
  },
})
