## Proposed changes

> _Describe the big picture of your changes here to communicate to the maintainers why we should accept this pull request. If it fixes a bug or resolves a feature request, be sure to link to that issue._

## Types of changes

What types of changes does your code introduce to this project?
> _Put an `x` in the boxes that apply_

- [ ] Bugfix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation Update (if none of the other choices apply)

## Issues closed by changes

> _List here all issues closed by your changes. Use a list of items like `- [x] Close #0`_

- [x] Close #0

## Checklist

> _Put an `x` in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. We're here to help! This is simply a reminder of what we are going to look for before merging your code._

- [ ] I have read the [CONTRIBUTING](CONTRIBUTING.md) doc
- [ ] I agree with the [CODE OF CONDUCT](CODE_OF_CONDUCT.md)
- [ ] Lint and unit tests pass locally with my changes
- [ ] Codacy validates the quality of the modifications
- [ ] GitHub Actions CI workflow passes
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] I have added necessary documentation (if appropriate)
- [ ] Any dependent changes have been merged and published in downstream modules
