/**
 * Run this example using:
 *
 *    deno run --allow-net --allow-read ./examples/assigned-port/index.ts
 *
 *    if have the repo cloned locally OR
 *
 *    deno run --allow-net --allow-read https://raw.githubusercontent.com/cmorten/opine/main/examples/assigned-port/index.ts
 *
 *    if you don't!
 */

import opine from "../../mod.ts";

const app = opine();

app.get("/", function (_req, res) {
  res.send("Hello Deno!");
});

if (import.meta.main) {
  // Providing no port results in an available port being assigned
  // for you. You can determine the port using the returned Server
  // object.
  const server = app.listen();
  const address = server.addrs[0] as Deno.NetAddr;
  console.log(`Server started on ${address.hostname}:${address.port}`);
}

export { app };
