# Examples

This directory contains a series of self-contained examples that you can use as
starting points for your app, or as snippets to pull into your existing
applications:

- [assigned-port](./assigned-port) - A basic example of starting an Opine server
  with a port that is assigned for you.
- [content-negotiation](./content-negotiation) - An example of how to perform
  content negotiation using the `res.format()` method.
- [cors](./cors) - An example of using CORS with Opine.
- [dejs](./dejs) - Example of how to use Opine's template engine and rendering
  capabilities with the `dejs` module.
- [downloads](./downloads) - Dummy file index server using path matching
  patterns and `res.download()` to serve files to the user.
- [error](./error) - An example of how to use and write error middleware.
- [error-pages](./error-pages) - Example of how to use Opine's template engine
  and rendering capabilities for custom error pages.
- [eta](./eta) - Example of how to use Opine's template engine and rendering
  capabilities with the `eta` template engine.
- [graphql](./graphql) - Example of how to use Opine with
  [gql](https://github.com/deno-libs/gql) for a simple GraphQL server.
- [hello-world](./hello-world) - A basic example of how to configure and start
  an Opine server.
- [json](./json) - An example of how to use the `json` body-parser middleware in
  your Opine applications.
- [location](./location) - An example of how set the `Location` header using
  `res.location()` for a `301` redirect.
- [multi-router](./multi-router) - An example of how to use the Opine `Router`
  to mount several controllers onto a path within an application / API.
- [mvc](./mvc) - A basic MVC-style controllers example.
- [proxy](./proxy) - Example using `opine-http-proxy` as a proxy middleware.
- [raw](./raw) - An example of how to use the `raw` body-parser middleware in
  your Opine applications.
- [react](./react) - An example of how you can use Opine with React.
- [redirect](./redirect) - An example of how to redirect using `res.redirect`.
- [static-files](./static-files) - An example of how to serve static files to a
  user using the Opine `serveStatic` middleware.
- [text](./text) - An example of how to use the `text` body-parser middleware in
  your Opine applications.
- [urlencoded](./urlencoded) - An example of how to use the `urlencoded`
  body-parser middleware in your Opine applications.
