<?php
// +----------------------------------------------------------------------
// | 草莓原创内容分销系统 [ 草莓CDMS ]
// +----------------------------------------------------------------------
// | 版权所有 2019~2025 北京浩森宇特互联科技有限公司 [ http://www.ieasynet.com ]
// +----------------------------------------------------------------------
// | 官方网站：http://www.zhizuowangzhan.cn/
// +----------------------------------------------------------------------
// | 作者: 拼搏 <378184@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\model;

use think\Model;

/**
 * 图标模型
 * @package app\admin\model
 */
class Icon extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'admin_icon';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;

    /**
     * 图标列表
     * @author pinbo <378184@qq.com>
     * @return \think\model\relation\HasMany
     */
    public function icons()
    {
        return $this->hasMany('IconList', 'icon_id')->field('title,class,code');
    }

    /**
     * 获取图标css链接
     * @author pinbo <378184@qq.com>
     * @return array|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public static function getUrls()
    {
        $list = self::where('status', 1)->select();
        if ($list) {
            foreach ($list as $key => $item) {
                if ($item['icons']) {
                    $html = '<ul class="js-icon-list items-push-2x text-center">';
                    foreach ($item['icons'] as $icon) {
                        $html .= '<li title="'.$icon['title'].'"><i class="'.$icon['class'].'"></i> <code>'.$icon['code'].'</code></li>';
                    }
                    $html .= '</ul>';
                } else {
                    $html = '<p class="text-center text-muted">暂无图标</p>';
                }
                $list[$key]['html'] = $html;
            }
        }
        return $list;
    }
}
