/*
 * (C) 2003-2006 Gabest
 * (C) 2006-2013, 2015 see Authors.txt
 *
 * This file is part of MPC-HC.
 *
 * MPC-HC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-HC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include "MouseWndWithArtView.h"

class CMainFrame;

class CFullscreenWnd final : public CMouseWndWithArtView
{
    DECLARE_DYNAMIC(CFullscreenWnd)

    explicit CFullscreenWnd(CMainFrame* pMainFrame);
    bool IsWindow() const;
    void SetCursor(LPCWSTR lpCursorName);

private:
    CMainFrame* m_pMainFrame;
    HCURSOR		m_hCursor;
    bool		m_bCursorVisible = false;
    bool		m_bTrackingMouseLeave = false;

protected:
    BOOL PreCreateWindow(CREATESTRUCT& cs) override;
    BOOL PreTranslateMessage(MSG* pMsg) override;
    LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam) override;

    DECLARE_MESSAGE_MAP()

    afx_msg BOOL OnEraseBkgnd(CDC* pDC);
    afx_msg void OnDestroy();
};
