/*
 * Copyright (C) 2006-2008 Team MediaPortal http://www.team-mediaportal.com
 * (C) 2013, 2015-2016 see Authors.txt
 *
 * This file is part of MPC-HC.
 *
 * MPC-HC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-HC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "stdafx.h"
#include "FreeviewEPGDecode.h"
#include "Logger.h"

#define bitrev16(d) ((d << 8) & 0xff00) + ((d >> 8) & 0x00ff)
#define START   '\0'
#define STOP    '\0'
#define ESCAPE  '\1'

// Huffman Tables for FreeView

static const BYTE raw_huffman_table1[] = {
    0x01, 0x00, 0x01, 0x60, 0x01, 0x62, 0x01, 0x64,    0x01, 0x66, 0x01, 0x68, 0x01, 0x6A, 0x01, 0x6C,
    0x01, 0x6E, 0x01, 0x70, 0x01, 0x72, 0x01, 0x74,    0x01, 0x76, 0x01, 0x78, 0x01, 0x7A, 0x01, 0x7C,
    0x01, 0x7E, 0x01, 0x80, 0x01, 0x82, 0x01, 0x84,    0x01, 0x86, 0x01, 0x88, 0x01, 0x8A, 0x01, 0x8C,
    0x01, 0x8E, 0x01, 0x90, 0x01, 0x92, 0x01, 0x94,    0x01, 0x96, 0x01, 0x98, 0x01, 0x9A, 0x01, 0x9C,
    0x01, 0x9E, 0x02, 0x28, 0x02, 0x34, 0x02, 0x38,    0x02, 0x3A, 0x02, 0x3C, 0x02, 0x40, 0x02, 0x46,
    0x02, 0x84, 0x02, 0x9A, 0x02, 0x9E, 0x02, 0xB2,    0x02, 0xB4, 0x02, 0xBA, 0x03, 0x02, 0x03, 0x32,
    0x03, 0x54, 0x03, 0x80, 0x03, 0xAA, 0x03, 0xCC,    0x03, 0xF0, 0x04, 0x14, 0x04, 0x28, 0x04, 0x46,
    0x04, 0x5A, 0x04, 0x76, 0x04, 0x90, 0x04, 0xA0,    0x04, 0xA4, 0x04, 0xA6, 0x04, 0xA8, 0x04, 0xAA,
    0x04, 0xB2, 0x04, 0xB4, 0x05, 0x0A, 0x05, 0x3C,    0x05, 0x78, 0x05, 0xAE, 0x06, 0x06, 0x06, 0x38,
    0x06, 0x68, 0x06, 0x8C, 0x06, 0xDC, 0x06, 0xFA,    0x07, 0x2C, 0x07, 0x50, 0x07, 0x88, 0x07, 0xB2,
    0x08, 0x08, 0x08, 0x3E, 0x08, 0x4C, 0x08, 0x78,    0x08, 0xC4, 0x09, 0x04, 0x09, 0x30, 0x09, 0x58,
    0x09, 0x7A, 0x09, 0x94, 0x09, 0xB8, 0x09, 0xCC,    0x09, 0xCE, 0x09, 0xD0, 0x09, 0xD2, 0x09, 0xD4,
    0x09, 0xD6, 0x09, 0xD8, 0x0A, 0x24, 0x0A, 0x52,    0x0A, 0x9A, 0x0A, 0xE0, 0x0B, 0x32, 0x0B, 0x60,
    0x0B, 0xA0, 0x0B, 0xDC, 0x0C, 0x20, 0x0C, 0x30,    0x0C, 0x70, 0x0C, 0xB6, 0x0C, 0xE6, 0x0D, 0x34,
    0x0D, 0x86, 0x0D, 0xBC, 0x0D, 0xC4, 0x0E, 0x12,    0x0E, 0x5A, 0x0E, 0xA6, 0x0E, 0xE8, 0x0E, 0xFC,
    0x0F, 0x38, 0x0F, 0x5E, 0x0F, 0xA4, 0x0F, 0xCC,    0x0F, 0xCE, 0x0F, 0xD0, 0x0F, 0xD2, 0x0F, 0xD4,
    0x01, 0x09, 0xD4, 0x02, 0xC2, 0x03, 0x04, 0x08,    0xCC, 0x05, 0x06, 0xD1, 0xCB, 0x07, 0xB6, 0xAE,
    0xC4, 0xC8, 0x0A, 0x15, 0x0B, 0x0C, 0xC3, 0xC9,    0x0D, 0x0E, 0xD2, 0xCE, 0xC5, 0x0F, 0x10, 0xC7,
    0x11, 0xD5, 0xD6, 0x12, 0x13, 0xB2, 0xDA, 0x14,    0xB1, 0xB3, 0x16, 0x18, 0x17, 0xD3, 0xC6, 0xC1,
    0x19, 0x1A, 0xCD, 0xD0, 0xD7, 0x1B, 0xCA, 0x1C,    0xCF, 0x1D, 0xD9, 0x1E, 0x1F, 0xD8, 0xB8, 0x20,
    0x21, 0x22, 0xB4, 0xA7, 0x23, 0xA0, 0x24, 0x28,    0xB5, 0x25, 0x26, 0xED, 0xE3, 0x27, 0xF3, 0xF0,
    0x29, 0xB0, 0x2A, 0x2F, 0xB9, 0x2B, 0xA8, 0x2C,    0xF4, 0x2D, 0xB7, 0x2E, 0x9B, 0xEC, 0xE1, 0xE4,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x01, 0x26,
    0x02, 0x22, 0x03, 0x1E, 0xD7, 0x04, 0x05, 0xC9,    0x06, 0x07, 0xE6, 0xD1, 0x08, 0xD6, 0xAD, 0x09,
    0x0A, 0x13, 0x0B, 0xF2, 0xB7, 0x0C, 0x0D, 0x10,    0x0E, 0x0F, 0xAB, 0xAE, 0x9B, 0xEC, 0xE7, 0x11,
    0x12, 0xED, 0xDC, 0xAF, 0x14, 0x16, 0xE2, 0x15,    0xF6, 0xE4, 0xF9, 0x17, 0xA8, 0x18, 0xF5, 0x19,
    0xF0, 0x1A, 0x1B, 0xE5, 0x1C, 0xA2, 0x1D, 0xE3,    0xEB, 0xE8, 0x1F, 0xCD, 0xC7, 0x20, 0x21, 0xD5,
    0x80, 0xF7, 0x23, 0x24, 0xC3, 0xC2, 0x25, 0xD0,    0xC8, 0xC4, 0x27, 0x3C, 0x28, 0x2A, 0x29, 0xD4,
    0xEF, 0xC1, 0x2B, 0x3B, 0xF4, 0x2C, 0x2D, 0xCF,    0x2E, 0x31, 0x2F, 0xB1, 0xA6, 0x30, 0xB5, 0xDA,
    0x32, 0x36, 0x33, 0xD8, 0x34, 0xB9, 0xA7, 0x35,    0xA0, 0xB0, 0x37, 0x3A, 0x38, 0xF3, 0xB6, 0x39,
    0xEE, 0xB8, 0xB4, 0xB3, 0xE1, 0xC6, 0x3D, 0x3F,    0xCE, 0x3E, 0xCC, 0xD2, 0x40, 0xD3, 0x41, 0x43,
    0x42, 0xCA, 0xB2, 0xCB, 0xC5, 0x44, 0xD9, 0xE9,    0x01, 0x80, 0x02, 0xA0, 0x03, 0xAE, 0x04, 0xA1,
    0x05, 0xA2, 0x9B, 0xBA, 0xA0, 0x01, 0x9B, 0xC9,    0x9B, 0x9B, 0x9B, 0x9B, 0x01, 0xA0, 0x9B, 0x80,
    0x01, 0xA0, 0x02, 0xC2, 0x9B, 0xAE, 0x01, 0xF3,    0x02, 0x04, 0xED, 0x03, 0xF4, 0xA0, 0xC3, 0x05,
    0x06, 0x10, 0xE4, 0x07, 0x08, 0xF2, 0x09, 0xEE,    0xC7, 0x0A, 0x0B, 0xC4, 0xCC, 0x0C, 0xCF, 0x0D,
    0x0E, 0x0F, 0xE1, 0xCD, 0xCB, 0xC6, 0xF6, 0x11,    0x12, 0xC1, 0x13, 0x15, 0x14, 0xEC, 0xC2, 0xE5,
    0x16, 0x19, 0x17, 0xE9, 0x18, 0x80, 0xD3, 0xC5,    0xB6, 0x1A, 0x1B, 0xF7, 0x1C, 0xCE, 0x1D, 0xD2,
    0xB0, 0x1E, 0x9B, 0xE3, 0x01, 0xE3, 0x02, 0x04,    0xB1, 0x03, 0xCD, 0xD5, 0x05, 0x06, 0xD2, 0xC4,
    0xC8, 0x07, 0xD3, 0x08, 0xC6, 0x09, 0xC7, 0x0A,    0x9B, 0xD9, 0x01, 0x80, 0x9B, 0xA0, 0xAA, 0x01,
    0x02, 0x06, 0x03, 0xA0, 0xE4, 0x04, 0xE5, 0x05,    0x9B, 0xF9, 0x07, 0x08, 0xED, 0xF4, 0x09, 0xF3,
    0xE7, 0xEB, 0x9B, 0xA0, 0x01, 0xA0, 0x02, 0xB0,    0x9B, 0xAE, 0x01, 0x22, 0x02, 0x19, 0x03, 0x09,
    0x04, 0x07, 0xC5, 0x05, 0xED, 0x06, 0xCC, 0xC3,    0xC4, 0x08, 0xB0, 0xC9, 0x0A, 0xD4, 0x0B, 0x0F,
    0x0C, 0x0E, 0x0D, 0xC1, 0xD0, 0xDA, 0xF4, 0xD9,    0xB6, 0x10, 0x11, 0xB2, 0x12, 0x14, 0x13, 0xCE,
    0xB1, 0xD7, 0x15, 0xD2, 0x16, 0x18, 0x17, 0xE3,    0x9B, 0xD1, 0xE1, 0xCD, 0x1A, 0xD3, 0xD5, 0x1B,
    0x1C, 0x1D, 0xC6, 0xEF, 0x1E, 0x1F, 0xC2, 0xAE,    0x20, 0x21, 0xB8, 0xE9, 0xE4, 0xC8, 0x23, 0xA0,
    0xC7, 0xCF, 0x01, 0xAE, 0x02, 0x80, 0x03, 0x16,    0x04, 0x05, 0xC9, 0xD4, 0xC3, 0x06, 0x07, 0xC8,
    0x08, 0x14, 0x09, 0x0B, 0x0A, 0xD3, 0xB1, 0xCD,    0x0C, 0x12, 0x0D, 0x0E, 0xF4, 0xD2, 0xC6, 0x0F,
    0x10, 0x11, 0x9B, 0xEC, 0xE4, 0xD5, 0xE3, 0x13,    0xC5, 0xC1, 0xD7, 0x15, 0xB3, 0xC2, 0xA0, 0x17,
    0xF0, 0xB0, 0x01, 0x03, 0xB1, 0x02, 0xB4, 0xB2,    0xB7, 0x04, 0xB3, 0x05, 0xB5, 0x06, 0x07, 0x09,
    0xB6, 0x08, 0xB9, 0xA0, 0xC3, 0x0A, 0xB8, 0x0B,    0x0C, 0xD5, 0x0D, 0x0F, 0xC7, 0x0E, 0x9B, 0xD7,
    0xB0, 0x10, 0xD6, 0xD3, 0x01, 0x02, 0xB6, 0xA0,    0x03, 0xB0, 0x04, 0x06, 0x05, 0xF0, 0xB1, 0xE1,
    0x80, 0x07, 0x08, 0xB7, 0x09, 0x0E, 0xAD, 0x0A,    0x0B, 0xB4, 0x0C, 0x0D, 0xB8, 0xBA, 0xB5, 0xB2,
    0xF3, 0x0F, 0xF4, 0x10, 0x11, 0xA5, 0xAF, 0x12,    0x13, 0xD5, 0x14, 0xAC, 0xAE, 0x15, 0x9B, 0xEC,
    0x01, 0x04, 0x02, 0x80, 0xAE, 0x03, 0xB2, 0xA0,    0x05, 0x11, 0x06, 0xB0, 0x07, 0x0A, 0x08, 0x09,
    0xB5, 0xF3, 0xB6, 0xBA, 0xB8, 0x0B, 0xA7, 0x0C,    0x0D, 0xB4, 0x0E, 0xAD, 0x0F, 0xB7, 0xA9, 0x10,
    0x9B, 0xAC, 0x12, 0xB1, 0x13, 0xAF, 0xB3, 0x14,    0xD8, 0xB9, 0xB0, 0x01, 0x02, 0xB4, 0x03, 0x80,
    0x04, 0xA0, 0xBA, 0x05, 0x06, 0x08, 0x07, 0xB5,    0xAE, 0xB1, 0x09, 0xAF, 0xD7, 0x0A, 0x0B, 0xB7,
    0x0C, 0x0E, 0x0D, 0xB3, 0xEE, 0xB6, 0x0F, 0xDA,    0x10, 0xA7, 0x9B, 0xF3, 0xA0, 0x01, 0x80, 0x02,
    0x03, 0x04, 0xF2, 0xAF, 0x05, 0xC2, 0xB0, 0x06,    0x07, 0x09, 0xBA, 0x08, 0xB1, 0xB8, 0xAD, 0x0A,
    0x0B, 0xB4, 0x0C, 0x0F, 0xB6, 0x0D, 0x0E, 0xF4,    0x9B, 0xE5, 0x10, 0xB9, 0xB3, 0x11, 0xB7, 0xB5,
    0x80, 0x01, 0x02, 0xA0, 0x03, 0x0D, 0x04, 0xBA,    0x05, 0xB8, 0xB9, 0x06, 0x07, 0x0B, 0x08, 0xC9,
    0xD7, 0x09, 0x0A, 0xB2, 0x9B, 0xA7, 0xA9, 0x0C,    0xD0, 0xB5, 0x0E, 0xAF, 0x0F, 0xAE, 0xB0, 0x10,
    0xCD, 0x11, 0xD2, 0xAD, 0x80, 0x01, 0x02, 0xA0,    0x03, 0xB0, 0x04, 0xAF, 0x05, 0x08, 0x06, 0xAD,
    0x07, 0xF4, 0x9B, 0xE1, 0x09, 0xBA, 0xB3, 0xB1,    0x01, 0x02, 0x80, 0xA0, 0xB0, 0x03, 0x04, 0xBA,
    0x05, 0x0C, 0x06, 0xAE, 0xAD, 0x07, 0x08, 0xB4,    0xB6, 0x09, 0x0A, 0xB9, 0xB3, 0x0B, 0x9B, 0xF4,
    0x0D, 0xE9, 0x0E, 0xE1, 0xB8, 0xAF, 0x01, 0x80,    0x02, 0xA0, 0xB0, 0x03, 0x04, 0xAE, 0x05, 0xAF,
    0x06, 0x08, 0xB1, 0x07, 0x9B, 0xB4, 0xB5, 0x09,    0xB3, 0xB2, 0x01, 0xA0, 0xB0, 0x02, 0xBA, 0x03,
    0x04, 0x06, 0x05, 0x80, 0xF4, 0xF0, 0x07, 0x0D,    0x08, 0xB8, 0xB5, 0x09, 0xB9, 0x0A, 0xCD, 0x0B,
    0xC6, 0x0C, 0x9B, 0xE3, 0xAE, 0xB6, 0xB1, 0x01,    0x02, 0x80, 0x03, 0x06, 0xB9, 0x04, 0x05, 0xB0,
    0xA0, 0xB8, 0xAE, 0x07, 0x08, 0x09, 0xB7, 0xAF,    0xB6, 0x0A, 0x0B, 0xBA, 0x0C, 0xB4, 0x9B, 0xB3,
    0x01, 0xA0, 0xB0, 0x02, 0x03, 0xAE, 0xB2, 0x04,    0xB1, 0x05, 0x06, 0xB3, 0x07, 0xC3, 0x9B, 0xD4,
    0x01, 0xA0, 0x9B, 0xAE, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x01, 0x80, 0x02, 0xA0, 0x03, 0xBA,
    0x9B, 0xAE, 0x9B, 0xC8, 0x01, 0x09, 0x02, 0x06,    0x03, 0xF2, 0xED, 0x04, 0xF7, 0x05, 0xF5, 0x80,
    0xA0, 0x07, 0x08, 0xE7, 0xD4, 0xE3, 0x0A, 0x16,    0xEC, 0x0B, 0x0C, 0x15, 0x0D, 0xF4, 0x0E, 0xD2,
    0x0F, 0xF6, 0xD3, 0x10, 0x11, 0xD0, 0x12, 0x13,    0xE5, 0xC2, 0xB1, 0x14, 0xEB, 0xE8, 0xE6, 0xE9,
    0xEE, 0x17, 0x18, 0xE4, 0xF3, 0x19, 0xE2, 0x1A,    0xF0, 0x1B, 0xCD, 0x1C, 0x1D, 0xAE, 0x1E, 0x29,
    0x1F, 0x21, 0xE1, 0x20, 0xF8, 0xA7, 0x22, 0x25,    0xCE, 0x23, 0xBA, 0x24, 0xCC, 0xC6, 0xB2, 0x26,
    0x27, 0xFA, 0xC4, 0x28, 0x9B, 0xF1, 0x2A, 0xAD,    0xF9, 0xAA, 0x01, 0x02, 0xC3, 0xC2, 0x03, 0x16,
    0x04, 0xF2, 0x05, 0xE9, 0x06, 0xEC, 0x07, 0x0C,    0x80, 0x08, 0xCF, 0x09, 0x0A, 0xC1, 0x0B, 0xBA,
    0xAE, 0xF7, 0xF9, 0x0D, 0xB3, 0x0E, 0xD3, 0x0F,    0x10, 0x15, 0x11, 0xE8, 0x12, 0xD2, 0xA7, 0x13,
    0x14, 0xD4, 0x9B, 0xB4, 0xAA, 0xA0, 0x17, 0x18,    0xEF, 0xF5, 0xE1, 0xE5, 0x01, 0x02, 0xEF, 0xA0,
    0x03, 0x06, 0xEC, 0x04, 0xF2, 0x05, 0xE9, 0xE5,    0xE8, 0x07, 0xE1, 0x08, 0x09, 0x0A, 0xF5, 0xC2,
    0x0B, 0x10, 0xF9, 0x0C, 0x0D, 0xAE, 0xF7, 0x0E,    0x0F, 0xB2, 0xB4, 0xAA, 0xA1, 0x11, 0x12, 0x1D,
    0x80, 0x13, 0x14, 0xC9, 0x15, 0xC4, 0xD5, 0x16,    0xA7, 0x17, 0xEE, 0x18, 0xFA, 0x19, 0x1A, 0x1B,
    0xCF, 0xC5, 0xC1, 0x1C, 0x9B, 0xF3, 0xD3, 0xD4,    0x01, 0x19, 0x02, 0xEF, 0xF2, 0x03, 0x04, 0x0B,
    0xF4, 0x05, 0x06, 0xA0, 0x07, 0xCA, 0x08, 0x0A,    0x09, 0xAA, 0xC1, 0xE8, 0xAD, 0xA6, 0x0C, 0xF5,
    0x0D, 0x18, 0xF9, 0x0E, 0x0F, 0xBA, 0xA7, 0x10,    0x11, 0x16, 0x12, 0xCE, 0x13, 0x14, 0xCF, 0xC5,
    0x15, 0xE4, 0x9B, 0xD4, 0xD6, 0x17, 0xC4, 0xF7,    0x80, 0xC9, 0xE1, 0x1A, 0xE5, 0xE9, 0x01, 0x17,
    0xED, 0x02, 0x03, 0xF6, 0xC5, 0x04, 0x05, 0x06,    0xB4, 0xF9, 0xF5, 0x07, 0x08, 0xF3, 0x09, 0x15,
    0x0A, 0x0D, 0x0B, 0xE3, 0xAD, 0x0C, 0xD3, 0xAE,    0x0E, 0xF1, 0x0F, 0xDA, 0x10, 0x12, 0xA1, 0x11,
    0xE6, 0xD5, 0x13, 0x14, 0xCE, 0xCD, 0xCC, 0xC1,    0xE7, 0x16, 0xE5, 0xC3, 0x18, 0x25, 0x19, 0xEE,
    0x80, 0x1A, 0x1B, 0xE4, 0xF2, 0x1C, 0xC6, 0x1D,    0xD2, 0x1E, 0x1F, 0xBA, 0xF0, 0x20, 0x21, 0xF4,
    0x22, 0xD7, 0xEF, 0x23, 0x24, 0xC4, 0x9B, 0xF7,    0x26, 0xE1, 0x27, 0xF8, 0x28, 0xEC, 0xE9, 0x29,
    0xD8, 0x2A, 0x2B, 0xA0, 0xD4, 0xA7, 0x01, 0x17,    0xE9, 0x02, 0x03, 0xF2, 0xE5, 0x04, 0x05, 0xEC,
    0x06, 0x09, 0xC1, 0x07, 0xA0, 0x08, 0xE8, 0xF4,    0xCF, 0x0A, 0x0B, 0x13, 0x0C, 0xE6, 0x0D, 0x80,
    0x0E, 0x12, 0xCD, 0x0F, 0xF9, 0x10, 0x11, 0xC8,    0x9B, 0xA1, 0xAA, 0xCB, 0x14, 0xCC, 0x15, 0x16,
    0xEA, 0xC9, 0xAE, 0xB1, 0xE1, 0x18, 0xF5, 0xEF,    0x01, 0x16, 0x02, 0x15, 0x03, 0xCD, 0x04, 0x0F,
    0x05, 0xF5, 0x06, 0xE8, 0x07, 0xF9, 0xBA, 0x08,    0x09, 0x80, 0x0A, 0x0D, 0xA7, 0x0B, 0xD5, 0x0C,
    0x9B, 0xD9, 0xC1, 0x0E, 0xD4, 0xB4, 0xD8, 0x10,    0x11, 0xEC, 0xF7, 0x12, 0x13, 0xC3, 0xAD, 0x14,
    0xD0, 0xA0, 0xE1, 0xEF, 0xF2, 0x17, 0xE9, 0xE5,    0xEF, 0x01, 0x02, 0x03, 0xE1, 0xE9, 0xE5, 0x04,
    0xF5, 0x05, 0xD2, 0x06, 0xC1, 0x07, 0xAE, 0x08,    0x09, 0x10, 0x0A, 0xF9, 0x0B, 0x0F, 0x80, 0x0C,
    0x0D, 0xF7, 0x0E, 0xC4, 0x9B, 0xC9, 0xCC, 0xCD,    0xD3, 0x11, 0xC5, 0xF2, 0xD4, 0x01, 0x02, 0x03,
    0xF3, 0xEE, 0x04, 0x07, 0x05, 0xF4, 0x06, 0xA0,    0xC9, 0x80, 0x08, 0x0B, 0x09, 0xA7, 0x0A, 0xED,
    0xE4, 0xCE, 0x0C, 0xF2, 0x0D, 0x0F, 0x0E, 0xFA,    0xE1, 0xD9, 0xAE, 0x10, 0x11, 0x1A, 0xD3, 0x12,
    0x13, 0x16, 0x14, 0xC4, 0xD6, 0x15, 0xAC, 0xC1,    0xE6, 0x17, 0xEF, 0x18, 0xCF, 0x19, 0xF0, 0xC5,
    0xE3, 0x1B, 0x1C, 0x23, 0xEC, 0x1D, 0x1E, 0xC6,    0x1F, 0xE7, 0xC2, 0x20, 0x21, 0x22, 0x9B, 0xD2,
    0xCC, 0xC7, 0x24, 0xF9, 0x25, 0x26, 0xC3, 0xBA,    0x27, 0xF6, 0xEB, 0xE2, 0x01, 0x02, 0xE1, 0xF5,
    0x03, 0xE5, 0x04, 0xEF, 0x05, 0xE9, 0xA0, 0x06,    0xCB, 0x07, 0x08, 0x80, 0x09, 0x0B, 0x0A, 0xF3,
    0xD6, 0xA7, 0xC6, 0x0C, 0x0D, 0xE6, 0x0E, 0xC7,    0x9B, 0xC4, 0x01, 0x05, 0x02, 0xE9, 0x03, 0xE5,
    0xE1, 0x04, 0x80, 0xF2, 0x06, 0xF9, 0x07, 0xA0,    0xEF, 0x08, 0x09, 0x18, 0x0A, 0xF4, 0x0B, 0x16,
    0x0C, 0x0E, 0xAD, 0x0D, 0xB1, 0xA7, 0x0F, 0xCF,    0x10, 0x13, 0x11, 0x12, 0xD4, 0xCE, 0xBA, 0xAE,
    0x14, 0xF5, 0xAC, 0x15, 0x9B, 0xEC, 0x17, 0xC7,    0xE8, 0xF7, 0xEE, 0xD3, 0x01, 0x11, 0xE1, 0x02,
    0xE5, 0x03, 0x04, 0xF5, 0x05, 0xCB, 0x06, 0x10,    0xEC, 0x07, 0x08, 0xF9, 0x09, 0x0A, 0xCC, 0xC9,
    0x0B, 0x0C, 0xC3, 0xAE, 0x0D, 0x80, 0x0E, 0xA7,    0xC5, 0x0F, 0x9B, 0xD9, 0xC1, 0xA0, 0xEF, 0xE9,
    0x01, 0x19, 0x02, 0xE1, 0xE5, 0x03, 0xD4, 0x04,    0x80, 0x05, 0x06, 0xE3, 0x07, 0x16, 0x08, 0xF2,
    0x09, 0x10, 0x0A, 0xDA, 0x0B, 0xE8, 0x0C, 0xD1,    0x0D, 0x0E, 0xBA, 0xAE, 0xA7, 0x0F, 0x9B, 0xF7,
    0x11, 0xA0, 0xC3, 0x12, 0xCB, 0x13, 0xD0, 0x14,    0xCD, 0x15, 0xD3, 0xD2, 0xC5, 0x17, 0x18, 0xC6,
    0xB1, 0xC9, 0xEF, 0x1A, 0x1B, 0xE9, 0xF9, 0xF5,    0x01, 0xE5, 0xEF, 0x02, 0x03, 0xE9, 0x04, 0xE1,
    0x05, 0xF5, 0xC3, 0x06, 0x07, 0x13, 0xC5, 0x08,    0x09, 0x10, 0x0A, 0x0B, 0xC7, 0xA7, 0x0C, 0xC9,
    0xCD, 0x0D, 0xD4, 0x0E, 0xAE, 0x0F, 0x9B, 0xDA,    0xD9, 0x11, 0xC1, 0x12, 0xA0, 0x80, 0xC6, 0x14,
    0xC2, 0xC8, 0x01, 0x14, 0x02, 0x04, 0xA7, 0x03,    0xCD, 0xEC, 0xE6, 0x05, 0x06, 0x12, 0x07, 0xF2,
    0x08, 0xD3, 0x09, 0x11, 0x0A, 0xC3, 0x0B, 0xE7,    0x0C, 0x0D, 0xC1, 0xEA, 0xE3, 0x0E, 0x0F, 0xD2,
    0xC5, 0x10, 0x9B, 0xCC, 0xF8, 0xAE, 0xE4, 0x13,    0xFA, 0xE2, 0x15, 0x2A, 0x16, 0x22, 0x17, 0xED,
    0xF0, 0x18, 0x19, 0xF6, 0x1A, 0x1D, 0x1B, 0xF4,    0xAD, 0x1C, 0xE9, 0xE5, 0x1E, 0xA0, 0x1F, 0xE1,
    0x20, 0xEF, 0xB2, 0x21, 0xD0, 0xBA, 0x23, 0x25,    0xE8, 0x24, 0xF7, 0xD5, 0x80, 0x26, 0x27, 0x28,
    0xD4, 0xCF, 0xCB, 0x29, 0xF3, 0xCE, 0xF5, 0xEE,    0x01, 0x03, 0x02, 0xF2, 0xE5, 0xE1, 0xEC, 0x04,
    0x05, 0xEF, 0x06, 0xE9, 0x07, 0x08, 0xC4, 0xF5,    0x09, 0xE8, 0x0A, 0x0C, 0xA0, 0x0B, 0xC8, 0xCD,
    0xB2, 0x0D, 0xD3, 0x0E, 0x0F, 0x10, 0xBA, 0xAA,    0x11, 0x16, 0x12, 0xF3, 0x13, 0xC9, 0x14, 0x15,
    0xD9, 0xCC, 0xC3, 0x9B, 0x17, 0x18, 0x80, 0xC7,    0xA7, 0x19, 0xF9, 0x1A, 0xCF, 0xAE, 0x01, 0xF5,
    0x02, 0x03, 0xC9, 0x80, 0xD6, 0x04, 0x05, 0xA0,    0x06, 0xC3, 0x9B, 0xA7, 0x01, 0x02, 0xE1, 0xEF,
    0x03, 0xE5, 0xE9, 0x04, 0x05, 0xF5, 0x06, 0xC5,    0xC4, 0x07, 0x08, 0x80, 0x09, 0xE8, 0x0A, 0x15,
    0xC9, 0x0B, 0x0C, 0x12, 0x0D, 0x0F, 0xA7, 0x0E,    0xC2, 0xAE, 0x10, 0xD3, 0xA6, 0x11, 0x9B, 0xC3,
    0xA0, 0x13, 0xCE, 0x14, 0xD4, 0xB1, 0xF9, 0xEE,    0x01, 0x09, 0x02, 0x08, 0x03, 0xEF, 0x04, 0xE1,
    0xEE, 0x05, 0x06, 0xF7, 0x07, 0xC1, 0xB2, 0xD0,    0xF0, 0xF5, 0x0A, 0x25, 0x0B, 0x21, 0x0C, 0xE5,
    0x0D, 0xE9, 0x0E, 0x1A, 0x0F, 0x19, 0xCF, 0x10,    0xF9, 0x11, 0x12, 0xBF, 0xC2, 0x13, 0x14, 0xF2,
    0x15, 0x18, 0xB5, 0x16, 0xC3, 0x17, 0x9B, 0xD9,    0xBA, 0xB1, 0xC9, 0xA0, 0xEC, 0x1B, 0x1C, 0x80,
    0xC5, 0x1D, 0x1E, 0xC8, 0xE7, 0x1F, 0xAA, 0x20,    0xB3, 0xAE, 0x22, 0xE3, 0x23, 0xEB, 0xED, 0x24,
    0xF1, 0xCD, 0xE8, 0xF4, 0xE8, 0x01, 0x02, 0x04,    0x03, 0xEF, 0xE5, 0xF2, 0x05, 0xD6, 0x06, 0x18,
    0xE1, 0x07, 0x08, 0xE9, 0x09, 0x16, 0x0A, 0xF9,    0x0B, 0xD0, 0x0C, 0x15, 0x0D, 0x0E, 0xD4, 0xD3,
    0xC2, 0x0F, 0xD5, 0x10, 0xC1, 0x11, 0x12, 0x13,    0xC3, 0xAA, 0x14, 0xCE, 0x9B, 0xD9, 0xD8, 0xF3,
    0xCD, 0x17, 0xBA, 0xB4, 0xF7, 0x19, 0x1A, 0x1E,    0x1B, 0xCF, 0xAE, 0x1C, 0x1D, 0xC9, 0xA0, 0x80,
    0x1F, 0xC8, 0xF5, 0xD7, 0xEE, 0x01, 0xF0, 0x02,    0x03, 0x09, 0x04, 0xCB, 0xD2, 0x05, 0x06, 0xC5,
    0x07, 0xE7, 0x08, 0xA0, 0xAD, 0xF2, 0x0A, 0xEC,    0xD3, 0x0B, 0x0C, 0xF3, 0x0D, 0xD4, 0x0E, 0x0F,
    0xB2, 0xED, 0x10, 0x80, 0xAE, 0x11, 0xE3, 0x12,    0xEB, 0x13, 0x14, 0x15, 0x9B, 0xFA, 0xF4, 0xC2,
    0x01, 0xA0, 0x02, 0x04, 0xBA, 0x03, 0xE5, 0xE1,    0x05, 0xE9, 0xB3, 0x06, 0x07, 0x09, 0x08, 0xC3,
    0xA7, 0xB4, 0x0A, 0x80, 0x0B, 0xEF, 0x0C, 0xC9,    0x0D, 0x0E, 0xF3, 0xC4, 0xAE, 0x0F, 0xB8, 0x10,
    0x11, 0x13, 0x12, 0xF5, 0x9B, 0xC5, 0xF2, 0xC2,    0x01, 0x0F, 0x02, 0xEF, 0x03, 0xE8, 0x04, 0x0E,
    0xAE, 0x05, 0x06, 0xF9, 0xF5, 0x07, 0x80, 0x08,    0x09, 0xC1, 0x0A, 0x0D, 0x0B, 0xD9, 0xC9, 0x0C,
    0x9B, 0xEC, 0xD4, 0xA0, 0xCF, 0xF2, 0x10, 0xE5,    0xE1, 0xE9, 0x01, 0x0C, 0x80, 0x02, 0xD4, 0x03,
    0x04, 0xE3, 0x05, 0xED, 0x06, 0xD5, 0x07, 0x08,    0xE1, 0xD8, 0xAD, 0x09, 0xF8, 0x0A, 0x0B, 0xB9,
    0x9B, 0xE9, 0xA0, 0xF4, 0x01, 0xEF, 0x02, 0xE5,    0xF5, 0x03, 0x04, 0xA0, 0xF6, 0x05, 0xE1, 0x06,
    0x07, 0x11, 0x08, 0x0B, 0xEE, 0x09, 0xC4, 0x0A,    0xF7, 0xF3, 0x0C, 0xF2, 0x0D, 0x0E, 0xD2, 0xCC,
    0x80, 0x0F, 0xC3, 0x10, 0x9B, 0xCE, 0xD0, 0xA7,    0x01, 0xEF, 0xE1, 0x02, 0xE9, 0x03, 0x04, 0x05,
    0xCF, 0xF5, 0xE5, 0x06, 0xA0, 0x07, 0x08, 0x80,    0x09, 0xBA, 0x9B, 0xAD, 0x9B, 0x9B, 0x9B, 0xF8,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x01, 0x1F, 0x02, 0x0D, 0x03, 0xF2, 0x04, 0xED,
    0x05, 0x0C, 0x06, 0x07, 0xE5, 0xA7, 0x08, 0xF7,    0x09, 0xE6, 0x0A, 0xBA, 0xA1, 0x0B, 0xAD, 0xE1,
    0xE2, 0x80, 0x0E, 0xF4, 0xE3, 0x0F, 0x10, 0x1E,    0x11, 0x1D, 0x12, 0xF5, 0x13, 0xE8, 0x14, 0x15,
    0xEF, 0xF8, 0x16, 0x1C, 0x17, 0xAE, 0xF1, 0x18,    0xEA, 0x19, 0x1A, 0xBF, 0x1B, 0xCA, 0x9B, 0xD5,
    0xCE, 0xAC, 0xFA, 0xF6, 0xF0, 0xE7, 0x20, 0x23,    0xEC, 0x21, 0xF3, 0x22, 0xA0, 0xE4, 0xEE, 0x24,
    0xF9, 0x25, 0xE9, 0xEB, 0x01, 0x04, 0x02, 0x03,    0xF2, 0xEF, 0xE5, 0xE1, 0x05, 0x13, 0xE9, 0x06,
    0x07, 0xF5, 0x08, 0xF3, 0xE8, 0x09, 0xB3, 0x0A,    0x0B, 0xA7, 0x0C, 0x0E, 0x0D, 0xF4, 0xEE, 0xE4,
    0xEA, 0x0F, 0x10, 0xF7, 0x11, 0xED, 0x12, 0xAE,    0x9B, 0xBA, 0x14, 0x15, 0xF9, 0xEC, 0x16, 0xA0,
    0xE2, 0x80, 0x01, 0x07, 0xEB, 0x02, 0xEF, 0x03,    0x04, 0xF2, 0x05, 0x06, 0xEC, 0xF9, 0xF3, 0x80,
    0x08, 0x23, 0xE8, 0x09, 0x0A, 0x22, 0xA0, 0x0B,    0x0C, 0x0E, 0xE3, 0x0D, 0xBA, 0xD0, 0x0F, 0xF5,
    0x10, 0x15, 0x11, 0xC4, 0x12, 0x13, 0xCC, 0xCB,    0x14, 0xC1, 0xEE, 0xA7, 0x16, 0x20, 0xC7, 0x17,
    0xF1, 0x18, 0x19, 0x1A, 0xC2, 0xC9, 0x1B, 0x1D,    0x1C, 0xE6, 0xCD, 0x9B, 0xB8, 0x1E, 0x1F, 0xC6,
    0xF7, 0xD1, 0xE2, 0x21, 0xAE, 0xC3, 0xE9, 0xE1,    0xF4, 0xE5, 0x01, 0x21, 0x02, 0x08, 0x03, 0xE5,
    0x04, 0xF9, 0xEF, 0x05, 0x06, 0xF5, 0xA7, 0x07,    0xBA, 0xE8, 0x09, 0x0C, 0xE9, 0x0A, 0xE4, 0x0B,
    0xF2, 0xEC, 0xF3, 0x0D, 0x0E, 0x1A, 0x0F, 0xF6,    0x10, 0x19, 0xE3, 0x11, 0xBF, 0x12, 0x13, 0xED,
    0x14, 0x18, 0x15, 0xA9, 0x16, 0xF0, 0x17, 0xFA,    0x9B, 0xB4, 0xAF, 0xEB, 0xEE, 0xF7, 0xE7, 0x1B,
    0x1C, 0xAE, 0x1D, 0x1E, 0xA1, 0xAD, 0xE6, 0x1F,    0xAC, 0x20, 0xF4, 0xE2, 0x22, 0xA0, 0x80, 0xE1,
    0x01, 0x0F, 0x02, 0xA0, 0xF3, 0x03, 0xF4, 0x04,    0x05, 0x0C, 0x06, 0x0B, 0x07, 0x08, 0xE7, 0xE6,
    0xF8, 0x09, 0x0A, 0xE8, 0xD0, 0xC2, 0xE9, 0xF0,    0xED, 0x0D, 0xE2, 0x0E, 0xEB, 0xBA, 0x10, 0x14,
    0x11, 0xF2, 0x12, 0xEE, 0xEC, 0x13, 0xE3, 0xE4,    0x15, 0x28, 0x80, 0x16, 0x17, 0xE5, 0x18, 0x1D,
    0xF6, 0x19, 0x1A, 0xEF, 0x1B, 0xAE, 0xAC, 0x1C,    0xB4, 0xBF, 0x1E, 0xF9, 0xA7, 0x1F, 0x20, 0x21,
    0xD6, 0xFA, 0x22, 0xEA, 0x23, 0xF5, 0x24, 0xAD,    0x25, 0xA1, 0x26, 0xF1, 0x27, 0xC7, 0x9B, 0xD3,
    0xE1, 0xF7, 0xA0, 0x01, 0x02, 0x13, 0x03, 0xEF,    0x04, 0xF4, 0xAE, 0x05, 0x80, 0x06, 0x07, 0x0C,
    0x08, 0xF9, 0xA7, 0x09, 0x0A, 0xEE, 0xE3, 0x0B,    0xAC, 0xF3, 0x0D, 0xF5, 0x0E, 0xEC, 0xE7, 0x0F,
    0xAD, 0x10, 0x11, 0xBA, 0x12, 0xEB, 0x9B, 0xE2,    0x14, 0x15, 0xE1, 0xE9, 0x16, 0xE5, 0xF2, 0xE6,
    0x01, 0x03, 0xE8, 0x02, 0x80, 0xE5, 0xA0, 0x04,    0x05, 0x0F, 0xE9, 0x06, 0x07, 0x0D, 0xF3, 0x08,
    0x09, 0xE2, 0xB2, 0x0A, 0x0B, 0x0C, 0xAE, 0xAC,    0xA7, 0xF4, 0x0E, 0xEC, 0xE7, 0xEF, 0x10, 0x11,
    0xBA, 0xF2, 0x12, 0xE1, 0x13, 0xF5, 0x14, 0xEE,    0xA1, 0x15, 0x16, 0xE4, 0x17, 0xF9, 0xF7, 0x18,
    0x19, 0xED, 0x1A, 0x1D, 0x1B, 0x1C, 0xF0, 0xE6,    0xC0, 0xAD, 0x1E, 0xBF, 0x1F, 0xBB, 0x9B, 0xFA,
    0xE5, 0x01, 0x02, 0x1A, 0x03, 0xEF, 0x04, 0xE9,    0x05, 0x06, 0xE2, 0xF5, 0x07, 0x0A, 0x08, 0x09,
    0xF7, 0xE4, 0xEE, 0xF9, 0x0B, 0x0C, 0xA1, 0xEC,    0x0D, 0xAE, 0xA7, 0x0E, 0xF3, 0x0F, 0xED, 0x10,
    0x11, 0xBA, 0x12, 0x13, 0xE6, 0xBF, 0xE3, 0x14,    0x15, 0x16, 0xF6, 0xF1, 0xE7, 0x17, 0x18, 0x19,
    0xE8, 0x9B, 0xAC, 0xAA, 0x1B, 0x1D, 0xE1, 0x1C,    0xF2, 0x80, 0xA0, 0xF4, 0x01, 0x17, 0x02, 0xEE,
    0xE3, 0x03, 0x04, 0x14, 0x05, 0xE1, 0xF0, 0x06,    0x07, 0x11, 0x08, 0xAD, 0x09, 0xA7, 0x0A, 0x10,
    0x0B, 0xE8, 0x0C, 0x0F, 0x0D, 0xAC, 0xAE, 0x0E,    0x9B, 0xEA, 0xF9, 0xAF, 0xBA, 0xF7, 0xF8, 0x12,
    0x13, 0xF1, 0xF5, 0xE9, 0xF6, 0x15, 0xA0, 0x16,    0xFA, 0x80, 0x18, 0x1F, 0x19, 0x1B, 0x1A, 0xEF,
    0xF2, 0xE4, 0xEC, 0x1C, 0xED, 0x1D, 0x1E, 0xE6,    0xE2, 0xEB, 0x20, 0x21, 0xE7, 0xF3, 0xF4, 0xE5,
    0xF9, 0x01, 0x02, 0xEF, 0x03, 0xE5, 0x04, 0xE1,    0x05, 0xF5, 0x06, 0xE9, 0x80, 0x07, 0x9B, 0xA0,
    0x01, 0x04, 0xA0, 0x02, 0xE9, 0x03, 0xF9, 0xF3,    0xE5, 0x05, 0x80, 0x06, 0x07, 0xE6, 0x08, 0x0E,
    0x09, 0xE1, 0x0A, 0xBA, 0xA7, 0x0B, 0x0C, 0xF7,    0x0D, 0xE8, 0xE2, 0xAC, 0xEC, 0x0F, 0xEB, 0x10,
    0x11, 0xAE, 0xEF, 0x12, 0x13, 0x1E, 0x14, 0x1C,    0x15, 0x1B, 0x16, 0x18, 0x17, 0xEA, 0xF0, 0xAF,
    0xAD, 0x19, 0x1A, 0xD3, 0x9B, 0xF2, 0xF5, 0xE3,    0xBF, 0x1D, 0xE4, 0xF4, 0x1F, 0xEE, 0xED, 0xA1,
    0x01, 0x06, 0x02, 0xE5, 0xEC, 0x03, 0x04, 0xF9,    0xF5, 0x05, 0xF4, 0xED, 0x07, 0x09, 0x08, 0xE1,
    0x80, 0xE4, 0x0A, 0x22, 0xEF, 0x0B, 0xF3, 0x0C,    0x0D, 0x13, 0x0E, 0xEB, 0xE6, 0x0F, 0x10, 0xF6,
    0x11, 0xAE, 0xFA, 0x12, 0xE8, 0xAA, 0x14, 0x21,    0xE2, 0x15, 0xBA, 0x16, 0xF7, 0x17, 0x18, 0xF0,
    0x19, 0x1A, 0xE7, 0xAC, 0x1B, 0x1C, 0xF2, 0xEE,    0x1D, 0xAD, 0xA1, 0x1E, 0x1F, 0xBF, 0x20, 0xC3,
    0x9B, 0xEA, 0xA7, 0xE3, 0xE9, 0xA0, 0x01, 0x13,    0x02, 0x04, 0x03, 0xED, 0xE9, 0x80, 0x05, 0xA0,
    0xF9, 0x06, 0xE2, 0x07, 0x08, 0x0F, 0xEC, 0x09,    0xBA, 0x0A, 0xE8, 0x0B, 0x0C, 0xA7, 0x0D, 0xAE,
    0x0E, 0xEB, 0x9B, 0xE4, 0xE6, 0x10, 0xB4, 0x11,    0xF7, 0x12, 0xF2, 0xF5, 0xE5, 0x14, 0x15, 0xE1,
    0x16, 0xF0, 0xEF, 0x17, 0xEE, 0xF3, 0x01, 0x23,    0x02, 0x10, 0xE9, 0x03, 0x04, 0xE1, 0x05, 0x0E,
    0x06, 0x0C, 0xF2, 0x07, 0xF6, 0x08, 0x09, 0xAC,    0xA1, 0x0A, 0xFA, 0x0B, 0xC2, 0xAA, 0x0D, 0xE6,
    0xAD, 0xAE, 0xF9, 0x0F, 0xF5, 0xEA, 0x11, 0x21,    0xF3, 0x12, 0x13, 0x14, 0xA7, 0xEB, 0x15, 0xEF,
    0x16, 0x20, 0xEC, 0x17, 0x18, 0xED, 0x19, 0x1F,    0x1A, 0xBF, 0xF7, 0x1B, 0x1C, 0xF1, 0x1D, 0xF0,
    0xBB, 0x1E, 0xAF, 0x9B, 0xE8, 0xE2, 0xF8, 0xBA,    0xE5, 0x22, 0xE3, 0xEE, 0x24, 0x25, 0xE7, 0xA0,
    0xE4, 0x26, 0x80, 0xF4, 0x01, 0x07, 0xF2, 0x02,    0x03, 0x04, 0xE6, 0xA0, 0xF7, 0x05, 0x06, 0xF4,
    0xE1, 0xE2, 0x08, 0x0E, 0x09, 0x0C, 0xEF, 0x0A,    0xE3, 0x0B, 0xF9, 0x80, 0x0D, 0xF5, 0xF0, 0xE4,
    0xEE, 0x0F, 0x10, 0x12, 0xED, 0x11, 0xF3, 0xEB,    0xEC, 0x13, 0x14, 0x26, 0x15, 0xF6, 0x16, 0x23,
    0x17, 0xE8, 0x18, 0x21, 0x19, 0xBF, 0xCA, 0x1A,    0x1B, 0x20, 0xB4, 0x1C, 0x1D, 0xA9, 0xD3, 0x1E,
    0xC4, 0x1F, 0x9B, 0xF1, 0xAC, 0xC7, 0xBA, 0x22,    0xAE, 0xAD, 0xA1, 0x24, 0xA7, 0x25, 0xFA, 0xF8,
    0xE7, 0x27, 0x28, 0xE9, 0xE5, 0xEA, 0x01, 0x05,    0xE5, 0x02, 0x80, 0x03, 0xF3, 0x04, 0xEC, 0xF2,
    0x06, 0x0A, 0xE9, 0x07, 0xA0, 0x08, 0xE8, 0x09,    0xF4, 0xA7, 0xEF, 0x0B, 0xF0, 0x0C, 0xE1, 0x0D,
    0x0E, 0x0F, 0xE4, 0xED, 0xF9, 0x10, 0x11, 0x19,    0x12, 0xBA, 0x13, 0x18, 0xE2, 0x14, 0x15, 0xEE,
    0x16, 0xEB, 0x17, 0xAC, 0x9B, 0xE3, 0xAD, 0xAE,    0x1A, 0xA1, 0xF7, 0xF5, 0x01, 0xF5, 0x02, 0x80,
    0x03, 0xBA, 0x9B, 0xA7, 0x01, 0x10, 0x02, 0x09,    0xA0, 0x03, 0x04, 0xF9, 0x05, 0x08, 0x06, 0xEB,
    0xA7, 0x07, 0xE6, 0xAE, 0xF2, 0xED, 0x0A, 0xE9,    0xE4, 0x0B, 0x0C, 0xEE, 0x0D, 0xF5, 0x0E, 0xE3,
    0x0F, 0xE2, 0xAC, 0xF0, 0x11, 0x13, 0x12, 0xE5,    0xF3, 0xF4, 0x14, 0x15, 0xE1, 0x80, 0x16, 0xEF,
    0x17, 0xEC, 0x18, 0xE7, 0x19, 0xBA, 0xF6, 0x1A,    0xF7, 0x1B, 0x1C, 0xEA, 0xAD, 0x1D, 0xE8, 0x1E,
    0xC7, 0x1F, 0xF1, 0x20, 0x21, 0xD3, 0xA1, 0x22,    0x23, 0x25, 0xAA, 0x24, 0x9B, 0xC5, 0xD4, 0x26,
    0xB1, 0xAF, 0x01, 0x23, 0x02, 0x0A, 0x03, 0x09,    0xF3, 0x04, 0x05, 0xBB, 0x06, 0x07, 0xAE, 0xA1,
    0x08, 0xF9, 0xAC, 0xE6, 0xE9, 0xE8, 0x0B, 0xF4,    0x0C, 0x1F, 0x0D, 0x13, 0x0E, 0xEF, 0xF0, 0x0F,
    0x10, 0xA7, 0x11, 0xEB, 0x12, 0xED, 0xBF, 0xF7,    0x14, 0xE3, 0xE1, 0x15, 0x16, 0xEE, 0xE4, 0x17,
    0x18, 0xE2, 0xE7, 0x19, 0xF1, 0x1A, 0x1B, 0x1D,    0x1C, 0xC5, 0x9B, 0xA9, 0xAD, 0x1E, 0xD7, 0xB1,
    0xE5, 0x20, 0xBA, 0x21, 0x22, 0xF5, 0xEC, 0xF2,    0xA0, 0x80, 0x01, 0x1F, 0x02, 0x18, 0xE9, 0x03,
    0xE1, 0x04, 0x05, 0xF4, 0x06, 0x0C, 0xA7, 0x07,    0xF7, 0x08, 0xBF, 0x09, 0xFA, 0x0A, 0x0B, 0xAC,
    0xF6, 0xAD, 0xBA, 0x0D, 0xA1, 0x0E, 0xEE, 0x0F,    0xE4, 0x10, 0xD0, 0x11, 0xA9, 0x12, 0xE7, 0x13,
    0x9B, 0x14, 0xD3, 0x15, 0x16, 0xB4, 0xEB, 0x17,    0xEA, 0xF0, 0x19, 0x80, 0xF2, 0x1A, 0xF9, 0x1B,
    0xED, 0x1C, 0x1D, 0x1E, 0xAE, 0xE2, 0xC5, 0xE6,    0x20, 0x22, 0xA0, 0x21, 0xF3, 0xEF, 0x23, 0xE8,
    0x24, 0xE5, 0xF5, 0x25, 0xE3, 0xEC, 0x01, 0x0C,    0xF2, 0x02, 0x03, 0x04, 0xE5, 0xED, 0x05, 0x06,
    0xE3, 0xE7, 0xE2, 0x07, 0x80, 0x08, 0xFA, 0x09,    0x0A, 0xA7, 0xEB, 0x0B, 0xE6, 0xAC, 0x0D, 0x1E,
    0xF3, 0x0E, 0x0F, 0x10, 0xF0, 0xE9, 0xEC, 0x11,    0xF9, 0x12, 0xA0, 0x13, 0xAD, 0x14, 0x15, 0xBA,
    0xF7, 0x16, 0x17, 0x18, 0xF6, 0xF8, 0x19, 0xEF,    0xEA, 0x1A, 0xF5, 0x1B, 0xAE, 0x1C, 0x1D, 0xE8,
    0xBF, 0x9B, 0x1F, 0xEE, 0xF4, 0x20, 0xE4, 0xE1,    0x01, 0xE5, 0x02, 0xE9, 0x03, 0xE1, 0x04, 0xEF,
    0xA0, 0x05, 0x06, 0x80, 0xF9, 0x07, 0x08, 0xF3,    0x09, 0xF2, 0x9B, 0xAE, 0xF3, 0x01, 0x02, 0x1B,
    0xA0, 0x03, 0x04, 0xE9, 0xE1, 0x05, 0x06, 0x0F,    0x07, 0x0D, 0xED, 0x08, 0x09, 0xE2, 0xEA, 0x0A,
    0x0B, 0xAD, 0xE7, 0x0C, 0xAE, 0xBA, 0x0E, 0xE4,    0xEB, 0xF2, 0x10, 0xF9, 0x11, 0xEC, 0x12, 0x14,
    0x13, 0xAC, 0xE3, 0xE6, 0x15, 0xE8, 0x16, 0xF0,    0xF4, 0x17, 0x18, 0xF1, 0x19, 0xA7, 0x1A, 0xBF,
    0x9B, 0xC2, 0x80, 0x1C, 0xEF, 0x1D, 0xEE, 0xE5,    0x01, 0x12, 0xF0, 0x02, 0x03, 0x10, 0x04, 0x07,
    0xEF, 0x05, 0xE5, 0x06, 0xF5, 0xE6, 0xE3, 0x08,    0xF9, 0x09, 0x0A, 0xAC, 0x0B, 0x0C, 0xE7, 0xE1,
    0x0D, 0xB9, 0x0E, 0xA7, 0x0F, 0xF8, 0x9B, 0xF3,    0x80, 0x11, 0xE9, 0xED, 0xA0, 0xF4, 0xA0, 0x01,
    0x02, 0x80, 0x03, 0x1C, 0x04, 0x0B, 0x05, 0xEF,    0x06, 0x09, 0x07, 0xEE, 0xE9, 0x08, 0xBF, 0xE6,
    0xF4, 0x0A, 0xAC, 0xF0, 0xF3, 0x0C, 0xE4, 0x0D,    0x0E, 0x10, 0xED, 0x0F, 0xF2, 0xE7, 0xE3, 0x11,
    0x12, 0x1B, 0xFA, 0x13, 0x14, 0x1A, 0xB2, 0x15,    0xF6, 0x16, 0xF9, 0x17, 0xE8, 0x18, 0x19, 0xEA,
    0x9B, 0xA9, 0xA1, 0xEB, 0xAD, 0xD4, 0x1D, 0x22,    0xE1, 0x1E, 0x1F, 0x20, 0xA7, 0xE2, 0x21, 0xAE,
    0xF7, 0xE5, 0xEC, 0xBA, 0x01, 0x02, 0xFA, 0x80,    0x03, 0x05, 0x04, 0xE9, 0xF9, 0xE5, 0x06, 0x07,
    0xF7, 0xA0, 0xEC, 0x08, 0xE1, 0x09, 0xEF, 0x0A,    0x0B, 0x0C, 0xED, 0xBA, 0x0D, 0xE3, 0xAC, 0x0E,
    0x0F, 0xE2, 0xF5, 0x10, 0x11, 0xA1, 0x12, 0x13,    0x9B, 0xF4, 0xE8, 0xBF, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x00, 0x00,
};

static const BYTE  raw_huffman_table2[] = {
    0x01, 0x00, 0x01, 0x60, 0x01, 0x62, 0x01, 0x64,    0x01, 0x66, 0x01, 0x68, 0x01, 0x6A, 0x01, 0x6C,
    0x01, 0x6E, 0x01, 0x70, 0x01, 0x72, 0x01, 0x74,    0x01, 0x76, 0x01, 0x78, 0x01, 0x7A, 0x01, 0x7C,
    0x01, 0x7E, 0x01, 0x80, 0x01, 0x82, 0x01, 0x84,    0x01, 0x86, 0x01, 0x88, 0x01, 0x8A, 0x01, 0x8C,
    0x01, 0x8E, 0x01, 0x90, 0x01, 0x92, 0x01, 0x94,    0x01, 0x96, 0x01, 0x98, 0x01, 0x9A, 0x01, 0x9C,
    0x01, 0x9E, 0x02, 0x3C, 0x02, 0x54, 0x02, 0x9A,    0x02, 0x9C, 0x02, 0xAA, 0x02, 0xAE, 0x02, 0xC4,
    0x03, 0x50, 0x03, 0xBC, 0x03, 0xD2, 0x03, 0xEA,    0x03, 0xEE, 0x04, 0x14, 0x04, 0x92, 0x05, 0x12,
    0x05, 0x76, 0x05, 0xBA, 0x06, 0x04, 0x06, 0x42,    0x06, 0x88, 0x06, 0xCC, 0x07, 0x0A, 0x07, 0x4A,
    0x07, 0x86, 0x07, 0xC2, 0x07, 0xF8, 0x08, 0x08,    0x08, 0x0A, 0x08, 0x0C, 0x08, 0x0E, 0x08, 0x10,
    0x08, 0x26, 0x08, 0x30, 0x08, 0xA2, 0x08, 0xF0,    0x09, 0x4C, 0x09, 0xA8, 0x0A, 0x12, 0x0A, 0x58,
    0x0A, 0xA0, 0x0A, 0xDE, 0x0B, 0x44, 0x0B, 0x7C,    0x0B, 0xCA, 0x0C, 0x10, 0x0C, 0x6C, 0x0C, 0xB0,
    0x0D, 0x24, 0x0D, 0x70, 0x0D, 0x88, 0x0D, 0xD0,    0x0E, 0x44, 0x0E, 0x9A, 0x0E, 0xF2, 0x0F, 0x3C,
    0x0F, 0x76, 0x0F, 0xA4, 0x0F, 0xD2, 0x0F, 0xF4,    0x10, 0x36, 0x10, 0x38, 0x10, 0x48, 0x10, 0x4A,
    0x10, 0x4C, 0x10, 0x88, 0x10, 0xEC, 0x11, 0x38,    0x11, 0xA8, 0x12, 0x02, 0x12, 0x7A, 0x12, 0xBE,
    0x13, 0x0C, 0x13, 0x5C, 0x13, 0xB2, 0x13, 0xCC,    0x14, 0x1A, 0x14, 0x6E, 0x14, 0xBC, 0x15, 0x12,
    0x15, 0x70, 0x15, 0xBC, 0x15, 0xD4, 0x16, 0x30,    0x16, 0x88, 0x16, 0xE8, 0x17, 0x3C, 0x17, 0x6E,
    0x17, 0xBA, 0x18, 0x06, 0x18, 0x5E, 0x18, 0xA6,    0x18, 0xA8, 0x18, 0xAA, 0x18, 0xAC, 0x18, 0xAE,
    0x01, 0x14, 0x02, 0x0C, 0x03, 0x0A, 0x04, 0xCA,    0xC8, 0x05, 0xCF, 0x06, 0xCB, 0x07, 0xB2, 0x08,
    0xD1, 0x09, 0xB9, 0xB8, 0x0B, 0xC4, 0xC9, 0xD2,    0xC1, 0x0D, 0x0E, 0x13, 0x0F, 0xC6, 0x10, 0xDB,
    0x11, 0x12, 0xF0, 0xE2, 0xD5, 0xA8, 0xAE, 0xD7,    0x15, 0x2A, 0xC3, 0x16, 0xD3, 0x17, 0x18, 0xCD,
    0x19, 0xCC, 0x1A, 0x1D, 0xB1, 0x1B, 0xB3, 0x1C,    0xB6, 0xB5, 0x1E, 0xD6, 0x1F, 0x20, 0xDA, 0xB7,
    0xB4, 0x21, 0x22, 0x29, 0x23, 0x28, 0x24, 0xF7,    0xF4, 0x25, 0xE1, 0x26, 0xE0, 0x27, 0x9B, 0xED,
    0xA7, 0xA2, 0xD8, 0xA0, 0x2B, 0xD4, 0x2C, 0x2D,    0xC2, 0xD0, 0x2E, 0xCE, 0x2F, 0xC5, 0xD9, 0xC7,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x01, 0x2B,
    0x02, 0x1D, 0x03, 0x0A, 0x04, 0xEF, 0x05, 0x08,    0xC1, 0x06, 0x07, 0xF6, 0xEB, 0xCF, 0x09, 0xCD,
    0xC7, 0xCE, 0xF3, 0x0B, 0xE4, 0x0C, 0x0D, 0xE5,    0x0E, 0xF9, 0x0F, 0x1C, 0x10, 0x11, 0xB3, 0xB8,
    0xB6, 0x12, 0xB0, 0x13, 0x14, 0xD8, 0x15, 0x1B,    0xDC, 0x16, 0x17, 0xA4, 0xAB, 0x18, 0x19, 0xF8,
    0x1A, 0xDD, 0xAF, 0xBF, 0xC0, 0xE0, 0xF1, 0xD5,    0xE1, 0x1E, 0x1F, 0x29, 0xDB, 0x20, 0x21, 0x26,
    0x22, 0xC8, 0xAD, 0x23, 0xD6, 0x24, 0x25, 0xB5,    0xA7, 0xB9, 0x27, 0xCC, 0x28, 0xB1, 0xD9, 0xA0,
    0x2A, 0xF0, 0xC2, 0xC3, 0x2C, 0x42, 0xF4, 0x2D,    0x2E, 0x31, 0x2F, 0xE2, 0xD4, 0x30, 0xCA, 0xC6,
    0x32, 0x3C, 0x33, 0xD3, 0x34, 0xD2, 0x35, 0xCB,    0x36, 0xB2, 0xA8, 0x37, 0xDA, 0x38, 0x39, 0x3A,
    0x9B, 0xAE, 0xA6, 0x3B, 0xA2, 0xFA, 0xE7, 0x3D,    0xF5, 0x3E, 0xEA, 0x3F, 0x80, 0x40, 0xB7, 0x41,
    0xB4, 0xD1, 0x43, 0x49, 0x44, 0x47, 0x45, 0xE3,    0xF2, 0x46, 0xC4, 0xD7, 0xE8, 0x48, 0xEE, 0xEC,
    0x4A, 0x4B, 0xF7, 0xE9, 0x4C, 0xE6, 0x4D, 0xED,    0x4E, 0xD0, 0xC9, 0xC5, 0x01, 0xA0, 0x02, 0x80,
    0x03, 0xAE, 0xBA, 0x04, 0x05, 0xDB, 0x06, 0x0B,    0x07, 0xA2, 0xA9, 0x08, 0xA7, 0x09, 0x0A, 0xBF,
    0x9B, 0xDD, 0xAF, 0xA1, 0x01, 0x0C, 0x02, 0x05,    0x03, 0xAE, 0xF0, 0x04, 0xE6, 0xD7, 0x06, 0x0A,
    0x07, 0xC2, 0xD3, 0x08, 0xCA, 0x09, 0xC5, 0xC4,    0x0B, 0xD4, 0xF4, 0xC3, 0x0D, 0xA0, 0x0E, 0x18,
    0xE9, 0x0F, 0x10, 0x12, 0xED, 0x11, 0xF7, 0xE7,    0x13, 0x14, 0xE2, 0xCC, 0xAD, 0x15, 0xD0, 0x16,
    0x17, 0xEC, 0x9B, 0xE1, 0x19, 0x1B, 0x80, 0x1A,    0xEE, 0xC9, 0x1C, 0xAC, 0x1D, 0x1E, 0xE3, 0xC8,
    0x1F, 0x21, 0xF2, 0x20, 0xD9, 0xD1, 0x22, 0xCB,    0xC7, 0xC1, 0x9B, 0x9B, 0xB1, 0x01, 0x02, 0xB3,
    0xB4, 0x03, 0x04, 0xB2, 0x05, 0xB7, 0x06, 0xB5,    0x9B, 0xB9, 0x01, 0xA0, 0x9B, 0xAC, 0x01, 0xA0,
    0x02, 0xF7, 0x03, 0xC2, 0xC5, 0x04, 0x05, 0x0A,    0xB2, 0x06, 0x07, 0x08, 0xCF, 0xB4, 0x09, 0xCA,
    0x9B, 0xD0, 0xC1, 0xD2, 0x01, 0xF3, 0x02, 0x12,    0x03, 0xF4, 0xEC, 0x04, 0x05, 0x06, 0xEE, 0xAE,
    0xC3, 0x07, 0x08, 0x0A, 0xD3, 0x09, 0xE6, 0xE7,    0x0B, 0xF0, 0x0C, 0x0D, 0xEF, 0xCB, 0x0E, 0xE1,
    0x0F, 0xBF, 0x10, 0xD7, 0x11, 0xD6, 0xB2, 0xB0,    0xA0, 0x13, 0x14, 0x29, 0x15, 0xF2, 0xC2, 0x16,
    0x17, 0x19, 0x18, 0xC4, 0xC6, 0xE8, 0x1A, 0x1D,    0x1B, 0xC8, 0x1C, 0xF5, 0xC5, 0xB7, 0xCE, 0x1E,
    0x1F, 0xCF, 0x20, 0x24, 0x21, 0xBA, 0x22, 0xB9,    0x23, 0xD9, 0xAD, 0xA7, 0xA1, 0x25, 0x26, 0xF9,
    0xA9, 0x27, 0x28, 0xFA, 0x9B, 0xB1, 0x2A, 0x33,    0x2B, 0xC1, 0xE4, 0x2C, 0x2D, 0x32, 0x2E, 0xD2,
    0x2F, 0xC9, 0xD0, 0x30, 0x31, 0xCA, 0xB8, 0xB5,    0x80, 0xD4, 0x34, 0x38, 0xF6, 0x35, 0x36, 0xE9,
    0x37, 0xC7, 0xF7, 0xE2, 0x39, 0x3A, 0xE3, 0xED,    0x3B, 0xAC, 0x3C, 0xCC, 0x3D, 0xE5, 0x3E, 0x41,
    0x3F, 0xF1, 0xB6, 0x40, 0xEA, 0xD1, 0x42, 0xCD,    0x43, 0xEB, 0x44, 0x45, 0xD8, 0xD5, 0xB4, 0xB3,
    0x01, 0x1C, 0x02, 0xB1, 0xD0, 0x03, 0x04, 0x10,    0x05, 0x0B, 0x06, 0xE1, 0x07, 0x0A, 0xED, 0x08,
    0xE4, 0x09, 0xEC, 0xB9, 0xEF, 0xC5, 0xD3, 0x0C,    0xC4, 0x0D, 0xD7, 0x0E, 0x0F, 0xD5, 0xB4, 0xC9,
    0x11, 0xD4, 0xD2, 0x12, 0x13, 0xCB, 0x14, 0x17,    0xC6, 0x15, 0xB3, 0x16, 0xDA, 0xD6, 0xE6, 0x18,
    0x19, 0xE8, 0xA0, 0x1A, 0x1B, 0xCF, 0x9B, 0xF5,    0x1D, 0x22, 0x1E, 0xF4, 0xB2, 0x1F, 0xF0, 0x20,
    0x21, 0xE5, 0xF6, 0xF3, 0x23, 0x33, 0x24, 0xB5,    0x25, 0x2A, 0x26, 0x29, 0xE2, 0x27, 0x28, 0xE7,
    0xF7, 0xC2, 0xC7, 0xB8, 0x2B, 0x2C, 0xCD, 0xC8,    0xC3, 0x2D, 0xCC, 0x2E, 0x2F, 0xEE, 0x30, 0xE9,
    0xEB, 0x31, 0xA7, 0x32, 0xD8, 0xB7, 0xCE, 0x34,    0x35, 0xE3, 0xCA, 0xC1, 0xA0, 0x01, 0x02, 0xAE,
    0x03, 0x80, 0x04, 0xAC, 0xBA, 0x05, 0x06, 0xBB,    0x07, 0xA1, 0x08, 0xA8, 0x09, 0x0A, 0x9B, 0xEF,
    0xBF, 0xA9, 0xAA, 0x01, 0x02, 0x03, 0xF3, 0xA0,    0x04, 0x06, 0xED, 0x05, 0xE7, 0xEB, 0xF4, 0x07,
    0x08, 0xE4, 0x09, 0xF9, 0x0A, 0xE5, 0xE9, 0x0B,    0x9B, 0xEE, 0x01, 0xEE, 0x9B, 0xA0, 0x01, 0xA0,
    0x02, 0xD3, 0x03, 0xB0, 0x04, 0xC1, 0xB5, 0x05,    0x06, 0x12, 0x07, 0x08, 0xB2, 0xA2, 0x09, 0xB1,
    0x0A, 0x0E, 0xD1, 0x0B, 0x0C, 0x0D, 0xD4, 0xC2,    0xB7, 0xB6, 0xA7, 0x0F, 0x10, 0xB4, 0x80, 0x11,
    0x9B, 0xE9, 0xE2, 0xB3, 0x01, 0x05, 0xA0, 0x02,    0x03, 0x04, 0xF4, 0xE2, 0xF7, 0xF5, 0x06, 0x13,
    0x07, 0x12, 0x08, 0xEF, 0xE3, 0x09, 0xB9, 0x0A,    0xD3, 0x0B, 0xC3, 0x0C, 0x0D, 0xC8, 0xC6, 0x0E,
    0x0F, 0xCB, 0x10, 0xD2, 0x11, 0xB0, 0xB4, 0xFA,    0xF3, 0xE6, 0x14, 0x21, 0x15, 0x1E, 0x16, 0x1D,
    0xE8, 0x17, 0x18, 0x1B, 0x19, 0xD7, 0xC1, 0x1A,    0xEA, 0xD0, 0x1C, 0xE7, 0xB6, 0xC2, 0xB1, 0xF9,
    0x1F, 0xEC, 0x20, 0xF2, 0xE5, 0xE9, 0x22, 0x35,    0x23, 0xE4, 0xE1, 0x24, 0x25, 0x2A, 0x26, 0xCA,
    0x27, 0x29, 0x28, 0xF1, 0xF6, 0xDA, 0xB5, 0xD4,    0xC4, 0x2B, 0x2C, 0xCD, 0x2D, 0xC9, 0x2E, 0xCE,
    0x2F, 0xD9, 0x30, 0x34, 0x31, 0xD6, 0x32, 0xD1,    0xA7, 0x33, 0x9B, 0xF8, 0xB3, 0xB8, 0x36, 0x3A,
    0xED, 0x37, 0x38, 0xEE, 0x39, 0xB2, 0xC5, 0xCC,    0xF0, 0x3B, 0x3C, 0x3E, 0xB7, 0x3D, 0xD5, 0xEB,
    0xC7, 0xCF, 0x01, 0xA0, 0x02, 0x80, 0x03, 0x3E,    0x04, 0x2F, 0x05, 0x07, 0x06, 0xF5, 0xE1, 0xDB,
    0x08, 0x23, 0x09, 0x16, 0xB4, 0x0A, 0x0B, 0x15,    0xCE, 0x0C, 0x0D, 0x0E, 0xC5, 0xBA, 0x0F, 0x14,
    0x10, 0xE2, 0x11, 0x12, 0xBF, 0xED, 0xD1, 0x13,    0xD5, 0xBB, 0xCB, 0xD9, 0xF4, 0xCA, 0x17, 0x18,
    0xB5, 0xCC, 0x19, 0xF0, 0x1A, 0xD2, 0xF2, 0x1B,    0xE8, 0x1C, 0x1D, 0xCF, 0xA2, 0x1E, 0x1F, 0x20,
    0xB8, 0xB6, 0x21, 0xEB, 0xE4, 0x22, 0x9B, 0xEE,    0x24, 0x2D, 0x25, 0x26, 0xD4, 0xC1, 0xCD, 0x27,
    0x28, 0xD0, 0xD6, 0x29, 0xAC, 0x2A, 0xAD, 0x2B,    0xF9, 0x2C, 0xAA, 0xA6, 0xC8, 0x2E, 0xC3, 0xB2,
    0xE9, 0x30, 0x31, 0x33, 0x32, 0xB3, 0xD3, 0xD7,    0x34, 0x38, 0xEF, 0x35, 0x36, 0xC4, 0x37, 0xF3,
    0xF7, 0xC6, 0xB1, 0x39, 0xC2, 0x3A, 0x3B, 0xC9,    0x3C, 0xC7, 0xA7, 0x3D, 0xE6, 0xA8, 0x3F, 0xAE,
    0xB0, 0xE3, 0x01, 0x07, 0x02, 0xE3, 0x03, 0x05,    0xB5, 0x04, 0xD4, 0xE6, 0xB8, 0x06, 0xC2, 0xB2,
    0x08, 0x31, 0x09, 0x21, 0x0A, 0x15, 0x0B, 0xB3,    0x0C, 0x14, 0xC6, 0x0D, 0x0E, 0xED, 0x0F, 0x11,
    0x10, 0xCA, 0xF6, 0xF0, 0x12, 0xB9, 0xE8, 0x13,    0xEC, 0xE9, 0xF3, 0xCD, 0xB7, 0x16, 0x17, 0x20,
    0xC8, 0x18, 0xD7, 0x19, 0xCC, 0x1A, 0x1B, 0x1F,    0x1C, 0xEF, 0xD6, 0x1D, 0x1E, 0xF9, 0x9B, 0xE7,
    0xD1, 0xB0, 0xC4, 0xC1, 0x22, 0x2A, 0xB6, 0x23,    0x24, 0x26, 0x25, 0xD3, 0xC7, 0xD5, 0x27, 0x28,
    0xE4, 0xCF, 0xCE, 0x29, 0xA0, 0xC9, 0xE1, 0x2B,    0x2C, 0xB4, 0x2D, 0x2F, 0x2E, 0xC3, 0xC5, 0xD2,
    0x30, 0xD0, 0xCB, 0xF4, 0xB1, 0xE5, 0xB0, 0x01,    0x02, 0x0E, 0x03, 0x06, 0x04, 0xE1, 0x05, 0xF3,
    0xB4, 0xF4, 0x07, 0xF0, 0x08, 0x0A, 0x09, 0xB5,    0xB3, 0xB7, 0x0B, 0x0D, 0x0C, 0xDD, 0xA9, 0xAF,
    0xAD, 0xB1, 0x0F, 0xA0, 0x10, 0x11, 0xAE, 0xB8,    0x12, 0xAC, 0xB6, 0x13, 0x14, 0x15, 0x80, 0xB9,
    0x16, 0xB2, 0xA5, 0x17, 0xBA, 0x18, 0x19, 0x1F,    0x1A, 0xE6, 0x1B, 0x1E, 0x1C, 0xEC, 0xC3, 0x1D,
    0x9B, 0xCA, 0xBB, 0xA7, 0x20, 0xED, 0xF9, 0x21,    0xEB, 0xA1, 0x01, 0x09, 0xB9, 0x02, 0x03, 0x05,
    0x04, 0xA0, 0xB6, 0xB8, 0x06, 0xB2, 0x07, 0xAF,    0x08, 0xB7, 0x80, 0xAD, 0x0A, 0x20, 0xB1, 0x0B,
    0x0C, 0xAE, 0xDD, 0x0D, 0x0E, 0x1F, 0xA9, 0x0F,    0xA7, 0x10, 0xD8, 0x11, 0x12, 0x1E, 0x13, 0x18,
    0x14, 0x15, 0xF0, 0xED, 0xA1, 0x16, 0xE5, 0x17,    0xE2, 0xE1, 0x19, 0xBB, 0x1A, 0xA6, 0x1B, 0x1C,
    0xC4, 0xC3, 0xA5, 0x1D, 0x9B, 0xEF, 0xF4, 0xD2,    0xBA, 0xF3, 0x21, 0xB0, 0xB5, 0x22, 0xB3, 0x23,
    0xB4, 0x24, 0xAC, 0xF8, 0x01, 0x0F, 0x02, 0x05,    0xA0, 0x03, 0x04, 0xAF, 0xDD, 0xF0, 0xAE, 0x06,
    0x07, 0x09, 0x08, 0xB1, 0xB6, 0xB2, 0x0A, 0x0B,    0xBA, 0xAD, 0x0C, 0xA9, 0x0D, 0x0E, 0xC4, 0xB3,
    0xF4, 0xB7, 0x10, 0xB0, 0xB5, 0x11, 0x12, 0xAC,    0x13, 0xB4, 0x14, 0x1E, 0x80, 0x15, 0xEE, 0x16,
    0xE1, 0x17, 0xA7, 0x18, 0x19, 0xBB, 0xF3, 0x1A,    0xA2, 0x1B, 0x1C, 0x1D, 0x9B, 0xE9, 0xD7, 0xCC,
    0xB8, 0xB9, 0x01, 0x1A, 0xA0, 0x02, 0x03, 0x08,    0x04, 0x05, 0xB2, 0xB1, 0xA9, 0x06, 0xC4, 0x07,
    0xB7, 0xB3, 0x09, 0x0B, 0xBA, 0x0A, 0xB4, 0x80,    0xAD, 0x0C, 0x0D, 0xB5, 0x0E, 0xB6, 0x0F, 0xC2,
    0x10, 0x13, 0x11, 0xBB, 0xEE, 0x12, 0xF0, 0xE5,    0x14, 0x19, 0x15, 0xE2, 0x16, 0x17, 0xE1, 0xA6,
    0xA5, 0x18, 0x9B, 0xEB, 0xA7, 0xC1, 0xB0, 0x1B,    0xAE, 0x1C, 0xAF, 0x1D, 0x1E, 0xDD, 0xAC, 0x1F,
    0x20, 0xF4, 0xB8, 0x21, 0xB9, 0x22, 0xF2, 0xF3,    0x01, 0x07, 0x02, 0xA0, 0xB4, 0x03, 0xAF, 0x04,
    0xB1, 0x05, 0xB2, 0x06, 0xBA, 0xA7, 0x08, 0x0A,    0xAE, 0x09, 0xB5, 0xAD, 0xB0, 0x0B, 0x0C, 0x0F,
    0x0D, 0xDD, 0x0E, 0xB8, 0xF4, 0xB3, 0xAC, 0x10,    0xA9, 0x11, 0x12, 0x80, 0x13, 0xB6, 0x14, 0x1A,
    0xB9, 0x15, 0x16, 0xC3, 0x17, 0xF8, 0x18, 0x19,    0xE6, 0xE5, 0xE2, 0xCC, 0xB7, 0x1B, 0xBB, 0x1C,
    0x1D, 0x20, 0x1E, 0xED, 0xA5, 0x1F, 0x9B, 0xE9,    0xC9, 0x21, 0xF0, 0xE3, 0x01, 0x11, 0xB0, 0x02,
    0xAE, 0x03, 0x04, 0xF0, 0xAF, 0x05, 0xB3, 0x06,    0xBA, 0x07, 0xB4, 0x08, 0x09, 0x10, 0x0A, 0x0C,
    0x0B, 0xBB, 0xE5, 0xA7, 0x0D, 0xED, 0x0E, 0xEB,    0x0F, 0xEC, 0x9B, 0xE6, 0xE3, 0xB1, 0xA0, 0x12,
    0x13, 0x15, 0xB5, 0x14, 0xE1, 0xAD, 0x16, 0x1B,    0x17, 0xB6, 0x18, 0x19, 0xA9, 0xF3, 0x1A, 0xAC,
    0x80, 0xF4, 0x1C, 0x1E, 0xB2, 0x1D, 0xB7, 0xB9,    0xB8, 0xDD, 0x01, 0x0E, 0xA0, 0x02, 0x03, 0x08,
    0x04, 0xDD, 0x05, 0xB1, 0x06, 0xAD, 0xB6, 0x07,    0x80, 0xAB, 0x09, 0x0B, 0xB7, 0x0A, 0xB5, 0xB4,
    0xA9, 0x0C, 0x0D, 0xB8, 0xB3, 0xB2, 0xAE, 0x0F,    0x10, 0xB0, 0x11, 0x12, 0xAC, 0xBA, 0xAF, 0x13,
    0x14, 0xF4, 0x15, 0xB9, 0xA7, 0x16, 0x17, 0x19,    0x18, 0xE1, 0xED, 0xE5, 0xBF, 0x1A, 0xBB, 0x1B,
    0x1C, 0x1D, 0xE6, 0xE2, 0xCD, 0x1E, 0xA2, 0x1F,    0x9B, 0xE9, 0x01, 0x17, 0x02, 0x11, 0x03, 0xA0,
    0xB8, 0x04, 0x05, 0x10, 0x06, 0xB6, 0x07, 0xB3,    0x80, 0x08, 0x09, 0x0D, 0x0A, 0xD2, 0xA7, 0x0B,
    0x0C, 0xE6, 0x9B, 0xF3, 0xBB, 0x0E, 0x0F, 0xED,    0xC1, 0xBF, 0xB2, 0xB1, 0x12, 0xB0, 0xB7, 0x13,
    0xAF, 0x14, 0x15, 0xF4, 0x16, 0xAC, 0xBA, 0xF0,    0x18, 0xAE, 0x19, 0xAD, 0x1A, 0xDD, 0x1B, 0x1D,
    0xB9, 0x1C, 0xE1, 0xB4, 0xA9, 0xB5, 0x01, 0x12,    0x02, 0xA0, 0xB4, 0x03, 0x04, 0xB0, 0xAF, 0x05,
    0x06, 0x07, 0xBA, 0xAC, 0x08, 0x09, 0xF0, 0xAD,    0x0A, 0xE1, 0x0B, 0x80, 0x0C, 0xBB, 0x0D, 0x0E,
    0xEC, 0xA7, 0x0F, 0x10, 0xE6, 0xC4, 0xC1, 0x11,    0x9B, 0xE9, 0x13, 0x1A, 0x14, 0x15, 0xB9, 0xB7,
    0x16, 0xB8, 0xB3, 0x17, 0xA9, 0x18, 0x19, 0xF4,    0xE3, 0xB2, 0xAE, 0x1B, 0xB1, 0x1C, 0xB5, 0x1D,
    0xB6, 0xDD, 0x01, 0x08, 0x02, 0x03, 0xB5, 0xDD,    0x04, 0x07, 0x05, 0xB0, 0xB2, 0x06, 0xB1, 0xAF,
    0xAE, 0xAD, 0x09, 0x19, 0x0A, 0x0B, 0xB4, 0xB8,    0x0C, 0xB6, 0xB3, 0x0D, 0xF4, 0x0E, 0x0F, 0xA9,
    0xBA, 0x10, 0xAC, 0x11, 0x12, 0x13, 0xF0, 0xBB,    0x14, 0x80, 0x15, 0x16, 0xEE, 0xED, 0xE1, 0x17,
    0x18, 0xE5, 0x9B, 0xEB, 0x1A, 0xB9, 0xA0, 0xB7,    0x01, 0xA0, 0x02, 0xB0, 0x03, 0xB3, 0x04, 0x07,
    0x05, 0xB1, 0x06, 0xB4, 0x9B, 0xB5, 0xD4, 0xC3,    0x9B, 0xA0, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x01, 0xA0, 0x02, 0x80, 0xBA, 0x03, 0x04, 0x0A,    0xA1, 0x05, 0xBB, 0x06, 0xA7, 0x07, 0x08, 0xAC,
    0x09, 0xAF, 0x9B, 0xD1, 0xDB, 0xAE, 0xEB, 0x01,    0xA0, 0x02, 0x03, 0xD4, 0x04, 0xE2, 0x9B, 0xC8,
    0x01, 0x22, 0x02, 0xA0, 0x03, 0x04, 0xF3, 0xED,    0xE4, 0x05, 0xE3, 0x06, 0x07, 0xE2, 0x08, 0x1C,
    0x09, 0x10, 0x0A, 0x0D, 0xC3, 0x0B, 0xD0, 0x0C,    0xD8, 0xCB, 0xAC, 0x0E, 0xAD, 0x0F, 0xB3, 0xA6,
    0xE8, 0x11, 0xF9, 0x12, 0x13, 0x15, 0x14, 0xCD,    0xCC, 0xD7, 0x16, 0xD9, 0xAA, 0x17, 0xEA, 0x18,
    0xC7, 0x19, 0xCF, 0x1A, 0xB4, 0x1B, 0x9B, 0xC5,    0x1D, 0x20, 0xAE, 0x1E, 0xD3, 0x1F, 0xC1, 0xC9,
    0x21, 0xC2, 0xEB, 0xD4, 0x23, 0x38, 0x24, 0x34,    0xF2, 0x25, 0xF5, 0x26, 0x27, 0xF4, 0x28, 0x30,
    0x29, 0xF6, 0x2A, 0x2F, 0x2B, 0xD2, 0x2C, 0xE5,    0x2D, 0x2E, 0xEF, 0xB1, 0xA7, 0xBA, 0xC6, 0xFA,
    0x31, 0xF0, 0xF1, 0x32, 0x33, 0xE1, 0xCE, 0xF8,    0x35, 0xEC, 0xE7, 0x36, 0x37, 0xE6, 0xF7, 0xE9,
    0xC4, 0xEE, 0x01, 0x23, 0xC3, 0x02, 0xE1, 0x03,    0x04, 0xE9, 0x05, 0xEC, 0x06, 0x11, 0x07, 0x08,
    0xD4, 0xAE, 0x09, 0xF9, 0xC1, 0x0A, 0xCF, 0x0B,    0xBA, 0x0C, 0x0D, 0xD7, 0xC5, 0x0E, 0x0F, 0xF7,
    0xAD, 0x10, 0xD8, 0xD6, 0x12, 0x22, 0xC9, 0x13,    0x14, 0x17, 0x15, 0x16, 0xA6, 0xB3, 0xEA, 0xCD,
    0x18, 0x20, 0x19, 0x1F, 0xAA, 0x1A, 0x1B, 0xD2,    0x1C, 0x1E, 0x1D, 0xD5, 0xD1, 0xB4, 0xD3, 0xC6,
    0xAC, 0xB1, 0xC4, 0x21, 0x9B, 0xD0, 0xE8, 0xA0,    0x24, 0x26, 0x25, 0xF2, 0xF5, 0xEF, 0xE5, 0xC2,
    0x01, 0x13, 0xE8, 0x02, 0x03, 0xC2, 0x04, 0xF2,    0xA7, 0x05, 0x06, 0xE5, 0x07, 0xF9, 0x08, 0xC9,
    0xC1, 0x09, 0x0A, 0x11, 0xAA, 0x0B, 0xD2, 0x0C,    0xFA, 0x0D, 0x0E, 0xB1, 0x0F, 0xEE, 0xBA, 0x10,
    0x9B, 0xE2, 0x12, 0xF7, 0xB2, 0xD5, 0x14, 0x2C,    0xE1, 0x15, 0xAE, 0x16, 0x17, 0xE9, 0x18, 0xF5,
    0x19, 0xAC, 0x1A, 0x23, 0x1B, 0x1C, 0xC3, 0xC4,    0x1D, 0x80, 0x1E, 0x22, 0xBF, 0x1F, 0x20, 0xAD,
    0x21, 0xA1, 0xCB, 0xB7, 0xCF, 0xC8, 0x24, 0x25,    0xD3, 0xD4, 0x26, 0xC7, 0x27, 0xCA, 0xC5, 0x28,
    0x29, 0xF3, 0xD0, 0x2A, 0x2B, 0xB4, 0xC6, 0xA9,    0xEF, 0x2D, 0xA0, 0xEC, 0x01, 0x02, 0xE1, 0xAC,
    0x03, 0x04, 0xF2, 0xEF, 0xE5, 0x05, 0xE9, 0x06,    0x07, 0x1F, 0x08, 0x0A, 0x09, 0xA0, 0xAE, 0xDD,
    0x0B, 0xA7, 0x0C, 0x1E, 0x0D, 0x19, 0x0E, 0x18,    0x0F, 0xCD, 0xC6, 0x10, 0x11, 0x16, 0x12, 0x14,
    0xA9, 0x13, 0xD5, 0xD2, 0x15, 0xC5, 0xC2, 0xB4,    0xB9, 0x17, 0xB8, 0xB7, 0xA6, 0xD6, 0xE8, 0x1A,
    0x1B, 0x1C, 0xAA, 0xF3, 0x1D, 0xE4, 0xED, 0xEA,    0xF7, 0xD7, 0x20, 0xF5, 0x21, 0x28, 0x22, 0x25,
    0x23, 0xCE, 0xF4, 0x24, 0xAD, 0xC7, 0xC3, 0x26,    0x27, 0xC9, 0xCF, 0xC1, 0xF9, 0x29, 0x2A, 0xCA,
    0x2B, 0xBA, 0x2C, 0xD3, 0xF6, 0x2D, 0x9B, 0xD4,    0x01, 0x08, 0x02, 0x07, 0xF0, 0x03, 0x04, 0x06,
    0xF3, 0x05, 0xAE, 0xE9, 0xF2, 0xF5, 0xE1, 0xEE,    0x09, 0x33, 0x0A, 0x0C, 0x0B, 0xED, 0xC5, 0xA0,
    0xF8, 0x0D, 0x0E, 0x10, 0x0F, 0xBA, 0xF9, 0xF4,    0x11, 0x23, 0xE7, 0x12, 0x13, 0x20, 0x14, 0x1F,
    0x15, 0x1E, 0x16, 0xEB, 0x17, 0x1A, 0x18, 0x19,    0xD7, 0xD3, 0xC8, 0xB9, 0x1B, 0xF1, 0xA9, 0x1C,
    0xD0, 0x1D, 0x9B, 0xFA, 0xE6, 0xEF, 0xD2, 0xC6,    0xF7, 0x21, 0x22, 0xC3, 0xD5, 0xCC, 0xB4, 0x24,
    0x25, 0x2E, 0xE3, 0x26, 0x27, 0x2A, 0x28, 0xE5,    0xCD, 0x29, 0xCF, 0xC1, 0xCE, 0x2B, 0x2C, 0xA7,
    0x2D, 0xDA, 0xD4, 0xAC, 0xE2, 0x2F, 0x30, 0x31,    0xE8, 0xC9, 0x32, 0xC4, 0xB2, 0xAD, 0xEC, 0x34,
    0xF6, 0xE4, 0x01, 0x21, 0xEF, 0x02, 0xE5, 0x03,    0xEC, 0x04, 0xF5, 0x05, 0x06, 0x07, 0xA0, 0xCF,
    0x08, 0x10, 0x09, 0xC1, 0x0A, 0x0C, 0xAE, 0x0B,    0xCD, 0xC5, 0x0D, 0xCC, 0x0E, 0xD4, 0xBA, 0x0F,
    0xF9, 0xAC, 0x11, 0xC2, 0xE6, 0x12, 0x13, 0x15,    0x14, 0xC3, 0xD5, 0xA7, 0xD7, 0x16, 0x17, 0xB1,
    0x18, 0x1B, 0xAD, 0x19, 0x1A, 0xE8, 0xAA, 0xCB,    0xC9, 0x1C, 0x1D, 0x1E, 0xC6, 0x9B, 0x1F, 0x20,
    0xD8, 0xD2, 0xBB, 0xB4, 0xF2, 0x22, 0xE9, 0xE1,    0x01, 0x02, 0xF2, 0xE1, 0x03, 0x1B, 0x04, 0xEF,
    0x05, 0xF5, 0x06, 0xEE, 0xD8, 0x07, 0x08, 0x0D,    0x09, 0xB4, 0xAD, 0x0A, 0x0B, 0x0C, 0xBB, 0xAC,
    0xC1, 0xCE, 0x0E, 0xD0, 0xC3, 0x0F, 0xC2, 0x10,    0x11, 0xBA, 0x12, 0x13, 0xCF, 0xCC, 0x14, 0x17,
    0x15, 0x16, 0xCB, 0xB2, 0xB1, 0xA7, 0xE2, 0x18,    0x19, 0x1A, 0x9B, 0xED, 0xD4, 0xD3, 0xE5, 0x1C,
    0x1D, 0xE9, 0x1E, 0xEC, 0x1F, 0x20, 0xF9, 0xA0,    0x21, 0xF7, 0x22, 0xE8, 0x23, 0xCD, 0xAE, 0xC9,
    0x01, 0x02, 0xE5, 0xE1, 0xEF, 0x03, 0xE9, 0x04,    0x05, 0xF5, 0xD2, 0x06, 0x07, 0x1B, 0xD0, 0x08,
    0x09, 0xC9, 0x0A, 0x0B, 0xD3, 0xAE, 0x0C, 0x14,    0x0D, 0xC7, 0x0E, 0xC5, 0x0F, 0x10, 0xB1, 0xA6,
    0x11, 0x12, 0xD8, 0xD7, 0xC4, 0x13, 0x9B, 0xF2,    0xA9, 0x15, 0x16, 0x17, 0xCF, 0xCC, 0x18, 0x19,
    0xC8, 0xF7, 0xF6, 0x1A, 0xF3, 0xC6, 0xF9, 0x1C,    0x1D, 0x1E, 0xD1, 0xCD, 0xC1, 0xA0, 0xEE, 0x01,
    0x02, 0x29, 0x03, 0x0D, 0x04, 0xF3, 0xD4, 0x05,    0xE3, 0x06, 0x07, 0xA7, 0x08, 0x0A, 0x09, 0xC3,
    0xC5, 0xB6, 0xD0, 0x0B, 0x0C, 0xF1, 0xE5, 0xB5,    0x0E, 0x1A, 0x0F, 0xE1, 0x10, 0xED, 0x11, 0x12,
    0xC1, 0xF6, 0x13, 0x16, 0xF7, 0x14, 0x15, 0xF9,    0xD3, 0xB9, 0xBA, 0x17, 0xCD, 0x18, 0x19, 0xC6,
    0xC2, 0xA9, 0x1B, 0x1C, 0xFA, 0xAE, 0x1D, 0xE4,    0x1E, 0xEC, 0x1F, 0xD6, 0xF0, 0x20, 0x21, 0x28,
    0xE2, 0x22, 0x23, 0x24, 0xCE, 0xD1, 0xEB, 0x25,    0x26, 0xCF, 0x27, 0xBF, 0x9B, 0xE8, 0xAD, 0xCC,
    0xF4, 0x2A, 0x2B, 0xF2, 0xA0, 0x2C, 0x2D, 0xC9,    0x2E, 0x30, 0x2F, 0xE6, 0xD2, 0xAC, 0x31, 0xEF,
    0x32, 0xD9, 0xE7, 0xC4, 0x01, 0x1B, 0xE5, 0x02,    0x03, 0xF5, 0x04, 0xE9, 0xA0, 0x05, 0x06, 0x1A,
    0x07, 0x0E, 0x08, 0xF2, 0x09, 0x0D, 0xCD, 0x0A,    0xC3, 0x0B, 0xA1, 0x0C, 0xF7, 0xD2, 0xCA, 0xAC,
    0x0F, 0x18, 0x10, 0x11, 0xC2, 0xAD, 0xD6, 0x12,    0xEE, 0x13, 0x14, 0x17, 0xC6, 0x15, 0xC7, 0x16,
    0x9B, 0xCC, 0xB7, 0xA7, 0xF3, 0x19, 0xCB, 0xD4,    0xC4, 0xAE, 0xE1, 0xEF, 0x01, 0x02, 0xE9, 0xE1,
    0xE5, 0x03, 0x04, 0x16, 0x05, 0x06, 0xEE, 0xEF,    0x07, 0xF2, 0xA7, 0x08, 0x09, 0xAE, 0x0A, 0x12,
    0xD4, 0x0B, 0x0C, 0x0D, 0xB5, 0xB4, 0xC1, 0x0E,    0xAD, 0x0F, 0xD6, 0x10, 0x11, 0xCC, 0x9B, 0xF6,
    0x13, 0xC7, 0xF7, 0x14, 0xB3, 0x15, 0xBA, 0xA1,    0x17, 0xF9, 0x18, 0xA0, 0xF5, 0x19, 0x1A, 0xEC,
    0x1B, 0xE8, 0x1C, 0xAC, 0x1D, 0x20, 0xB2, 0x1E,    0xA9, 0x1F, 0xB6, 0xB1, 0x21, 0xCD, 0x22, 0xD3,
    0x23, 0x24, 0xC9, 0xBF, 0x25, 0x26, 0xEB, 0xD9,    0xCE, 0xC5, 0x01, 0x21, 0xE9, 0x02, 0x03, 0xDD,
    0xF5, 0x04, 0x05, 0x06, 0xEC, 0xC1, 0x07, 0xF9,    0x08, 0x13, 0x09, 0x0A, 0xC9, 0xD2, 0x0B, 0x0C,
    0xCF, 0xA7, 0x0D, 0x12, 0x0E, 0xAE, 0x0F, 0xF4,    0x10, 0xE8, 0xC5, 0x11, 0xD4, 0xD0, 0xC3, 0xD9,
    0x14, 0xA0, 0x15, 0xAC, 0x16, 0x1B, 0x17, 0xC6,    0x18, 0xC7, 0x19, 0xD7, 0x1A, 0xA2, 0xC4, 0xB7,
    0xCC, 0x1C, 0x1D, 0xD3, 0xCA, 0x1E, 0x1F, 0x80,    0x20, 0xEA, 0x9B, 0xD5, 0xEF, 0x22, 0xE5, 0xE1,
    0x01, 0x29, 0xEF, 0x02, 0x03, 0xE5, 0x04, 0xE3,    0x05, 0xF9, 0x06, 0x0E, 0x07, 0xA0, 0x08, 0xC3,
    0xB1, 0x09, 0xC1, 0x0A, 0x0B, 0x0C, 0xDA, 0xCB,    0xC2, 0x0D, 0xAC, 0xA7, 0x0F, 0x27, 0x10, 0x18,
    0xE8, 0x11, 0xFA, 0x12, 0xE6, 0x13, 0x14, 0xF3,    0x15, 0x16, 0xED, 0xCA, 0x9B, 0x17, 0xF4, 0xD6,
    0xC9, 0x19, 0x1A, 0x21, 0x1B, 0x1C, 0xD2, 0xD7,    0xCF, 0x1D, 0x1E, 0xC4, 0x1F, 0x20, 0xD1, 0xCE,
    0xB6, 0xB2, 0xAE, 0x22, 0x23, 0x25, 0xB4, 0x24,    0xEC, 0xAD, 0xC5, 0x26, 0xA9, 0xF7, 0xC6, 0x28,
    0xD4, 0xD8, 0x2A, 0xE1, 0x2B, 0xE9, 0x2C, 0xF5,    0x2D, 0xF2, 0xD3, 0xD0, 0x01, 0x21, 0xE1, 0x02,
    0x03, 0xE9, 0x04, 0x20, 0x05, 0x15, 0x06, 0x13,    0x07, 0x09, 0x08, 0xC2, 0xA9, 0xA7, 0xC9, 0x0A,
    0x0B, 0xD9, 0xC3, 0x0C, 0x0D, 0x0F, 0x0E, 0xCD,    0xC4, 0xAE, 0x10, 0xCF, 0x11, 0x12, 0xEB, 0xDA,
    0xD1, 0xC7, 0xF9, 0x14, 0xC6, 0xA0, 0xC1, 0x16,    0xE7, 0x17, 0x18, 0x19, 0xCC, 0xC8, 0x1A, 0x1F,
    0xD7, 0x1B, 0x1C, 0x1D, 0xAC, 0xCA, 0x1E, 0xE8,    0xD8, 0x9B, 0xCE, 0xD4, 0xF5, 0xC5, 0xEF, 0xE5,
    0x01, 0x21, 0x02, 0x07, 0x03, 0x04, 0xF3, 0xCE,    0x05, 0xFA, 0x06, 0xD5, 0xEF, 0xCA, 0x08, 0x0B,
    0xF2, 0x09, 0x0A, 0xE8, 0xE2, 0xED, 0x0C, 0x20,    0x0D, 0x1F, 0x0E, 0xC8, 0x0F, 0x16, 0x10, 0xF4,
    0xCB, 0x11, 0x12, 0xB2, 0xAC, 0x13, 0xBA, 0x14,    0xA1, 0x15, 0xC5, 0xC4, 0xEB, 0x17, 0x18, 0x1A,
    0x19, 0xD3, 0xEA, 0xCC, 0xC2, 0x1B, 0x1C, 0xC9,    0xE5, 0x1D, 0x1E, 0xD0, 0xB8, 0xB4, 0xCF, 0xF6,
    0xE6, 0xF7, 0x22, 0x2B, 0x23, 0x2A, 0xF5, 0x24,    0xAE, 0x25, 0x26, 0xE3, 0x27, 0xE4, 0xE7, 0x28,
    0xE9, 0x29, 0xD7, 0xAD, 0xF0, 0xEC, 0x2C, 0xEE,    0x2D, 0xA7, 0xA0, 0x2E, 0x2F, 0xF8, 0xE1, 0x30,
    0xD2, 0x31, 0x32, 0xD6, 0x33, 0x35, 0x34, 0xC1,    0xF9, 0xAF, 0x36, 0xC3, 0xCD, 0x37, 0x38, 0xC6,
    0x39, 0xD4, 0x9B, 0xF1, 0x01, 0x24, 0x02, 0x23,    0xE9, 0x03, 0xE8, 0x04, 0x05, 0x21, 0x06, 0x16,
    0x07, 0x0C, 0xC2, 0x08, 0x09, 0xCF, 0x0A, 0xF9,    0x0B, 0xD4, 0xCC, 0xC7, 0xC4, 0x0D, 0x0E, 0xAC,
    0xCD, 0x0F, 0x10, 0x15, 0xAA, 0x11, 0x12, 0xCA,    0xD6, 0x13, 0x14, 0xA6, 0x9B, 0xA9, 0xC1, 0xD3,
    0xC3, 0x17, 0x18, 0xF3, 0x19, 0x1A, 0xC5, 0xA7,    0x1B, 0xB3, 0x1C, 0x1D, 0xF7, 0xC6, 0x1E, 0x1F,
    0xE6, 0xD2, 0x20, 0xF4, 0xD9, 0xC9, 0x22, 0xF5,    0xAE, 0xA0, 0xE5, 0xEC, 0x25, 0xE1, 0xEF, 0xF2,
    0x01, 0xF5, 0xD6, 0x02, 0x03, 0xA0, 0x04, 0xAE,    0xE1, 0x05, 0x06, 0x0B, 0xF7, 0x07, 0x08, 0xA6,
    0x09, 0xA7, 0xD4, 0x0A, 0x9B, 0xF3, 0xC5, 0xC3,    0x01, 0x22, 0x02, 0xE1, 0x03, 0x0F, 0xF0, 0x04,
    0x05, 0xC5, 0xA0, 0x06, 0x07, 0x0B, 0xC4, 0x08,    0xC6, 0x09, 0xF7, 0x0A, 0xF4, 0xC9, 0xAE, 0x0C,
    0x0D, 0x0E, 0xCE, 0xA6, 0xD6, 0xC8, 0x10, 0xF5,    0xE8, 0x11, 0xF9, 0x12, 0x13, 0x15, 0xD4, 0x14,
    0xC2, 0xEE, 0xD3, 0x16, 0x17, 0xC1, 0x18, 0xA7,    0x19, 0x1D, 0xC3, 0x1A, 0x1B, 0x1C, 0xAC, 0xF3,
    0xD5, 0xCD, 0xCF, 0x1E, 0x1F, 0x20, 0xAD, 0x9B,    0x21, 0xBA, 0xB2, 0xD2, 0x23, 0xEF, 0xE9, 0xE5,
    0x01, 0xDD, 0x02, 0x16, 0x03, 0x05, 0xE1, 0x04,    0xF0, 0xAC, 0xE8, 0x06, 0xCC, 0x07, 0x08, 0xEB,
    0xF7, 0x09, 0xF1, 0x0A, 0xD0, 0x0B, 0xC1, 0x0C,    0x0D, 0x15, 0x0E, 0xF2, 0x0F, 0x14, 0xAA, 0x10,
    0x11, 0x13, 0xC7, 0x12, 0xA7, 0xBF, 0xFD, 0xC4,    0xB4, 0xB1, 0xD3, 0xD7, 0x17, 0x1A, 0x18, 0x19,
    0xE9, 0xF5, 0xEF, 0xE3, 0x1B, 0xF4, 0xE5, 0x1C,    0x1D, 0x1F, 0x1E, 0xA0, 0xCD, 0xEE, 0x20, 0xED,
    0xEC, 0x21, 0x22, 0xF9, 0x23, 0x2C, 0x24, 0xAE,    0xC3, 0x25, 0x26, 0x9B, 0xCF, 0x27, 0x28, 0xC2,
    0xAD, 0x29, 0x2A, 0x2B, 0xD2, 0xCB, 0xCA, 0xC6,    0x2D, 0x36, 0x2E, 0xC5, 0xC9, 0x2F, 0x80, 0x30,
    0x31, 0x32, 0xB3, 0xB2, 0x33, 0x35, 0x34, 0xF3,    0xBA, 0xA9, 0xEA, 0xE2, 0xF6, 0x37, 0x38, 0xE7,
    0xFA, 0x39, 0xC8, 0xD4, 0xE8, 0x01, 0x02, 0x04,    0xEF, 0x03, 0xD6, 0xF7, 0x05, 0x07, 0xF2, 0x06,
    0xE1, 0xE9, 0x08, 0xE5, 0xF5, 0x09, 0x0A, 0x0C,    0xC8, 0x0B, 0xA0, 0xF9, 0xD7, 0x0D, 0x0E, 0x14,
    0x0F, 0xCD, 0xD3, 0x10, 0xC1, 0x11, 0x12, 0xD8,    0x13, 0xAD, 0xD4, 0xD5, 0x15, 0xF8, 0x16, 0x1D,
    0x17, 0xF3, 0xAE, 0x18, 0x19, 0xCC, 0x1A, 0xB4,    0x1B, 0xC7, 0x1C, 0xBB, 0xBA, 0xAA, 0x1E, 0xCA,
    0x1F, 0x22, 0xC3, 0x20, 0xCF, 0x21, 0xC5, 0xAC,    0x23, 0xE3, 0x24, 0x28, 0x25, 0x26, 0xD0, 0xB1,
    0x9B, 0x27, 0xD2, 0xCE, 0xA7, 0x29, 0x2A, 0xC4,    0xC9, 0xC2, 0x01, 0x25, 0xCB, 0x02, 0x03, 0xD3,
    0x04, 0x24, 0x05, 0x09, 0xE7, 0x06, 0x07, 0x08,    0xEB, 0xF4, 0xC5, 0xAD, 0x0A, 0x1B, 0x0B, 0x0D,
    0xC6, 0x0C, 0xE6, 0xB8, 0x0E, 0x11, 0xAC, 0x0F,    0xE8, 0x10, 0xE2, 0xC4, 0x12, 0xDA, 0x13, 0x16,
    0x14, 0x15, 0xE5, 0xD6, 0xD0, 0xC9, 0x17, 0x18,    0xC2, 0xC1, 0x19, 0x1A, 0xC8, 0xC3, 0xBA, 0xA9,
    0x1C, 0xAE, 0xB2, 0x1D, 0x1E, 0x1F, 0xE9, 0xF7,    0xE1, 0x20, 0xA1, 0x21, 0x22, 0xE4, 0x23, 0xFA,
    0x9B, 0xD4, 0xF3, 0xF2, 0xEE, 0x26, 0xF0, 0x27,    0x28, 0xEC, 0x29, 0xD2, 0xA0, 0x2A, 0xED, 0x2B,
    0xE3, 0xCE, 0x01, 0x03, 0x02, 0xA0, 0xAE, 0xE1,    0x04, 0xE9, 0x05, 0xE5, 0x06, 0x16, 0x07, 0xC3,
    0x08, 0x0C, 0x09, 0xC6, 0x0A, 0xB1, 0x0B, 0xAF,    0xB6, 0xB2, 0x0D, 0xC9, 0x0E, 0xB4, 0x0F, 0xAD,
    0xB5, 0x10, 0x11, 0x13, 0xB7, 0x12, 0xB9, 0xF9,    0x14, 0x15, 0xD0, 0xC8, 0xC1, 0xB8, 0x17, 0xEF,
    0x18, 0x1C, 0x19, 0x1B, 0xF2, 0x1A, 0xC4, 0xF5,    0xC5, 0xF3, 0x1D, 0x24, 0x1E, 0xA7, 0x1F, 0xAC,
    0xBB, 0x20, 0x9B, 0x21, 0xB3, 0x22, 0x23, 0xD7,    0xE6, 0xC2, 0xBA, 0xEC, 0x01, 0x1B, 0xE8, 0x02,
    0x03, 0xE1, 0xF2, 0x04, 0x05, 0xCF, 0x06, 0x0D,    0x07, 0xA0, 0x08, 0x09, 0xC2, 0xAE, 0x0A, 0x0B,
    0xA7, 0xCD, 0x0C, 0xD4, 0xB2, 0xBA, 0xF9, 0x0E,    0x0F, 0x1A, 0xC9, 0x10, 0x11, 0x18, 0xC8, 0x12,
    0xEC, 0x13, 0x14, 0xF5, 0x15, 0x16, 0xB5, 0xA9,    0x17, 0xC5, 0x9B, 0xED, 0xD6, 0x19, 0xF3, 0xAC,
    0xD7, 0xC1, 0xE9, 0x1C, 0xEF, 0xE5, 0x01, 0xA0,    0x02, 0x04, 0xE1, 0x03, 0xFA, 0xED, 0x05, 0x12,
    0x06, 0x11, 0x07, 0xD5, 0x08, 0x0F, 0x09, 0x0B,    0xD3, 0x0A, 0xB9, 0xA7, 0xBA, 0x0C, 0x0D, 0xD8,
    0xA9, 0x0E, 0x9B, 0xF9, 0xD6, 0x10, 0xE3, 0xE9,    0xAD, 0xE5, 0x13, 0xF4, 0x14, 0x15, 0xF5, 0xC9,
    0x16, 0xAC, 0xB5, 0xAE, 0x01, 0xEF, 0xE5, 0x02,    0xF5, 0x03, 0x04, 0x16, 0xE1, 0x05, 0x06, 0x0A,
    0xEE, 0x07, 0xF2, 0x08, 0x09, 0xCE, 0xAE, 0xCD,    0x0B, 0x0D, 0x0C, 0xCF, 0xCC, 0xF3, 0x0E, 0xE9,
    0x0F, 0xED, 0x10, 0xD0, 0x11, 0x14, 0x12, 0xD2,    0xAD, 0x13, 0x9B, 0xE4, 0xB2, 0x15, 0xC3, 0xAC,
    0xF6, 0xA0, 0x01, 0x10, 0x02, 0xE1, 0x03, 0x0F,    0x04, 0x0E, 0x05, 0xDA, 0x06, 0x0D, 0x07, 0x08,
    0xF9, 0xB4, 0xAC, 0x09, 0x0A, 0x0B, 0xE6, 0xAD,    0x80, 0x0C, 0x9B, 0xEC, 0xCF, 0xAE, 0xA0, 0xF5,
    0xFA, 0xE9, 0xE5, 0xEF, 0x01, 0xD3, 0x02, 0xC1,    0x03, 0x20, 0xB2, 0x04, 0x05, 0x16, 0x06, 0xEE,
    0x07, 0x10, 0x08, 0x0B, 0x09, 0xC3, 0x0A, 0x80,    0xCA, 0xC2, 0xE6, 0x0C, 0x0D, 0xCB, 0x0E, 0xDA,
    0xC6, 0x0F, 0xF3, 0xD6, 0x11, 0xF2, 0x12, 0xCD,    0xC8, 0x13, 0x14, 0xD0, 0x15, 0xC9, 0xD5, 0xC7,
    0xED, 0x17, 0x18, 0xEC, 0x19, 0xE2, 0x1A, 0xE3,    0x1B, 0xD4, 0xCC, 0x1C, 0x1D, 0xCE, 0x1E, 0xC4,
    0xCF, 0x1F, 0x9B, 0xD7, 0xD2, 0xB1, 0x9B, 0xF8,    0x01, 0x80, 0x02, 0xA0, 0x03, 0xAE, 0x04, 0xDB,
    0x05, 0xBA, 0x06, 0xAC, 0x07, 0xBB, 0x9B, 0xDD,    0x9B, 0x9B, 0x9B, 0x9B, 0x01, 0x0E, 0x02, 0x08,
    0x03, 0xF7, 0x04, 0x06, 0x05, 0xF3, 0xD7, 0xF2,    0xC1, 0x07, 0xE5, 0xC3, 0x09, 0xC8, 0x0A, 0xEE,
    0x0B, 0xF4, 0x0C, 0x0D, 0xEF, 0xE4, 0xE2, 0xD2,    0x0F, 0x1D, 0x10, 0x16, 0x11, 0x14, 0xE7, 0x12,
    0x13, 0xEC, 0xCF, 0xCC, 0x15, 0xE3, 0xE8, 0xC7,    0x17, 0xC4, 0x18, 0x1C, 0x19, 0xC2, 0x1A, 0xE6,
    0xCA, 0x1B, 0x9B, 0xCD, 0xD4, 0xD3, 0xD0, 0xC6,    0x01, 0x09, 0x02, 0xEE, 0x03, 0xF2, 0xED, 0x04,
    0x05, 0xE4, 0xF0, 0x06, 0xF7, 0x07, 0x08, 0xFA,    0xAC, 0xA7, 0x0A, 0x0E, 0x0B, 0xF4, 0x0C, 0xF3,
    0xE9, 0x0D, 0xF5, 0xF6, 0x0F, 0x31, 0x10, 0x2F,    0xF9, 0x11, 0x12, 0xE7, 0x13, 0x2B, 0xAE, 0x14,
    0x15, 0xE5, 0x16, 0x17, 0xE1, 0xAD, 0x18, 0xEA,    0xF1, 0x19, 0x1A, 0x1F, 0xA1, 0x1B, 0x1C, 0x1E,
    0x9B, 0x1D, 0xCA, 0xDD, 0xBB, 0xA9, 0x20, 0xBF,    0x21, 0x29, 0x22, 0xAF, 0x23, 0x24, 0xD2, 0xD3,
    0xD6, 0x25, 0x26, 0x28, 0xDB, 0x27, 0xD7, 0xB1,    0xD0, 0x80, 0x2A, 0xC0, 0xCE, 0xCC, 0x2C, 0xE6,
    0x2D, 0xE8, 0x2E, 0xF8, 0xBA, 0xEF, 0xE3, 0x30,    0xE2, 0xEB, 0xA0, 0xEC, 0x01, 0x03, 0xE5, 0x02,
    0xF5, 0xE1, 0x04, 0x05, 0xF9, 0xEF, 0x06, 0x25,    0xEC, 0x07, 0x08, 0x24, 0xF3, 0x09, 0x0A, 0x1B,
    0x0B, 0xE3, 0xEA, 0x0C, 0x0D, 0xA7, 0x0E, 0xBA,    0x0F, 0x14, 0xBF, 0x10, 0xE6, 0x11, 0x12, 0xBB,
    0xAF, 0x13, 0xD8, 0xA2, 0xF6, 0x15, 0x16, 0xF0,    0x17, 0xC4, 0x18, 0xC0, 0x19, 0xEB, 0x80, 0x1A,
    0x9B, 0xA1, 0x1C, 0x1D, 0xAC, 0xAE, 0x1E, 0x21,    0x1F, 0x20, 0xF7, 0xE4, 0xE8, 0xA6, 0x22, 0xF4,
    0x23, 0xAD, 0xED, 0xEE, 0xA0, 0xE2, 0xF2, 0xE9,    0x01, 0x04, 0xEF, 0x02, 0x03, 0xE1, 0xE9, 0xEC,
    0x05, 0x08, 0xE5, 0x06, 0x07, 0xEB, 0xF5, 0xF2,    0xE8, 0x09, 0x0A, 0xF4, 0xA0, 0x0B, 0x0C, 0x0D,
    0xF9, 0xE3, 0x0E, 0x2F, 0x0F, 0xF3, 0x10, 0x1B,    0x11, 0xC7, 0x12, 0xEE, 0xBA, 0x13, 0x14, 0x16,
    0x15, 0xF7, 0xE2, 0x9B, 0x17, 0xC5, 0xA1, 0x18,    0x19, 0xD6, 0x1A, 0xA9, 0xF0, 0xC8, 0x1C, 0x2D,
    0x1D, 0x1F, 0x1E, 0xAD, 0xCE, 0xFA, 0xC1, 0x20,    0x21, 0x23, 0xBF, 0x22, 0xD1, 0xD0, 0x24, 0x29,
    0xBB, 0x25, 0x26, 0xED, 0xD5, 0x27, 0x80, 0x28,    0xDD, 0xDB, 0xC2, 0x2A, 0xAF, 0x2B, 0xD7, 0x2C,
    0xD2, 0xD4, 0xC4, 0x2E, 0xCC, 0xA7, 0xAE, 0x30,    0x31, 0xAC, 0x32, 0x36, 0xCB, 0x33, 0xE4, 0x34,
    0x35, 0xC6, 0xCD, 0xD3, 0x37, 0xC3, 0xF1, 0xC9,    0xA0, 0x01, 0x02, 0x1F, 0x03, 0xE5, 0x04, 0x1B,
    0x05, 0xAE, 0x06, 0xE4, 0x07, 0x08, 0xE8, 0xBA,    0xED, 0x09, 0x0A, 0xE6, 0x0B, 0x0D, 0xA1, 0x0C,
    0x80, 0xA9, 0x0E, 0x0F, 0xEB, 0xBB, 0x10, 0xAF,    0x11, 0x1A, 0x12, 0x16, 0xFA, 0x13, 0x14, 0xC0,
    0x15, 0xC3, 0xDA, 0xDB, 0x17, 0xF1, 0x9B, 0x18,    0xDD, 0x19, 0xD4, 0xE0, 0xA2, 0xEA, 0x1C, 0xEF,
    0x1D, 0xEC, 0x1E, 0xAD, 0xF7, 0xEE, 0x20, 0x29,    0xE1, 0x21, 0x22, 0xF2, 0xF5, 0x23, 0x24, 0xF6,
    0x25, 0xA7, 0x26, 0x28, 0x27, 0xBF, 0xF0, 0xF4,    0xE2, 0xE3, 0xE9, 0x2A, 0x2B, 0xF3, 0x2C, 0xF9,
    0xE7, 0xAC, 0x01, 0x35, 0x02, 0x10, 0x03, 0x08,    0xE4, 0x04, 0xE3, 0x05, 0xF8, 0x06, 0xE6, 0x07,
    0xAD, 0xE8, 0x09, 0xE1, 0x0A, 0x0B, 0xF6, 0xE9,    0xF9, 0x0C, 0x0D, 0xE2, 0xEB, 0x0E, 0x0F, 0xBA,
    0xA9, 0xF1, 0xF3, 0x11, 0x12, 0x13, 0xE5, 0xF7,    0x14, 0xF4, 0xED, 0x15, 0xAC, 0x16, 0xA7, 0x17,
    0x18, 0x32, 0x19, 0xBF, 0xFA, 0x1A, 0x1B, 0x30,    0x1C, 0x20, 0x1D, 0xB4, 0xA2, 0x1E, 0x1F, 0xC4,
    0xD4, 0xC3, 0xC2, 0x21, 0x22, 0x25, 0x9B, 0x23,    0x24, 0xDB, 0xD6, 0xC7, 0xC0, 0x26, 0x27, 0xCC,
    0xB1, 0x28, 0x29, 0x2B, 0x2A, 0xC5, 0xB2, 0xCE,    0x2C, 0x2D, 0xC6, 0xC1, 0x2E, 0x2F, 0xDC, 0xD0,
    0xCD, 0xC8, 0xAF, 0x31, 0xDD, 0xBB, 0xF5, 0x33,    0xA1, 0x34, 0x80, 0xEA, 0xA0, 0x36, 0xF2, 0x37,
    0x38, 0xEE, 0xEC, 0x39, 0xAE, 0x3A, 0xF0, 0x3B,    0xE7, 0xEF, 0x01, 0x1E, 0xEF, 0x02, 0xE9, 0x03,
    0x04, 0xE1, 0xF4, 0x05, 0x06, 0xEC, 0x07, 0x08,    0xF3, 0xF9, 0x09, 0x17, 0x0A, 0x15, 0xBF, 0x0B,
    0x0C, 0xBA, 0xED, 0x0D, 0x0E, 0xE3, 0x0F, 0x12,    0x10, 0xF0, 0xE8, 0x11, 0x80, 0xE4, 0xAF, 0x13,
    0xBB, 0x14, 0xEB, 0xF6, 0x16, 0xAC, 0xA7, 0xE7,    0xAE, 0x18, 0x19, 0xAD, 0x1A, 0x1D, 0x9B, 0x1B,
    0xA1, 0x1C, 0xA9, 0xF7, 0xE2, 0xEE, 0xA0, 0x1F,    0xF2, 0x20, 0xE5, 0x21, 0xF5, 0xE6, 0x01, 0x23,
    0x02, 0x1F, 0xE1, 0x03, 0x04, 0xF5, 0x05, 0x0B,    0x06, 0xAC, 0x07, 0x0A, 0x08, 0xA7, 0xE4, 0x09,
    0xBF, 0xED, 0xAD, 0xBA, 0xEE, 0x0C, 0xF9, 0x0D,    0x0E, 0x1E, 0x0F, 0xE2, 0x10, 0x14, 0x11, 0xA1,
    0x12, 0xBB, 0xEB, 0x13, 0xA9, 0xA2, 0x15, 0xE6,    0x16, 0x80, 0xF0, 0x17, 0x18, 0x1C, 0x19, 0xE3,
    0x9B, 0x1A, 0xE0, 0x1B, 0xF6, 0xC0, 0x1D, 0xAF,    0xDD, 0xFA, 0xF4, 0xF7, 0xE8, 0x20, 0xF2, 0x21,
    0xEC, 0x22, 0xE7, 0xAE, 0x24, 0xA0, 0x25, 0xE5,    0xE9, 0x26, 0xF3, 0xEF, 0xE5, 0x01, 0x02, 0x03,
    0xEF, 0xE9, 0xA0, 0x04, 0x05, 0xE1, 0x06, 0x16,    0x07, 0xF2, 0x08, 0x13, 0x09, 0xF9, 0xE4, 0x0A,
    0x0B, 0xF7, 0x0C, 0x11, 0x0D, 0xE3, 0xA9, 0x0E,    0x0F, 0x10, 0xF0, 0xBB, 0xAF, 0x80, 0x12, 0xBF,
    0xE8, 0xEB, 0x14, 0xEC, 0xF3, 0x15, 0xA7, 0xAD,    0x17, 0xF4, 0x18, 0x19, 0xAE, 0xEE, 0x1A, 0xF5,
    0xAC, 0x1B, 0x1C, 0x27, 0x1D, 0xED, 0xA1, 0x1E,    0x1F, 0xE6, 0x20, 0xE7, 0x21, 0xF6, 0xF1, 0x22,
    0x9B, 0x23, 0xA2, 0x24, 0x25, 0x26, 0xFA, 0xEA,    0xDD, 0xAA, 0xBA, 0xE2, 0x01, 0x26, 0x02, 0x09,
    0xF4, 0x03, 0x04, 0xEC, 0xE1, 0x05, 0xF0, 0x06,    0xFA, 0x07, 0x08, 0xE2, 0xAD, 0xF8, 0xF3, 0x0A,
    0x0B, 0x0C, 0xED, 0xE4, 0xF6, 0x0D, 0xE6, 0x0E,    0xA0, 0x0F, 0xEB, 0x10, 0x11, 0x1D, 0xF5, 0x12,
    0xAE, 0x13, 0x14, 0xF7, 0x15, 0xE9, 0x16, 0xBA,    0xAF, 0x17, 0x18, 0xBF, 0x19, 0xD2, 0x1A, 0x1B,
    0x80, 0xC3, 0x9B, 0x1C, 0xC4, 0xBB, 0xF1, 0x1E,    0xAC, 0x1F, 0x20, 0xA7, 0x21, 0xEA, 0xE8, 0x22,
    0x23, 0xF9, 0xD0, 0x24, 0x25, 0xA1, 0xA9, 0xD3,    0xEE, 0x27, 0x28, 0x29, 0xEF, 0xE3, 0x2A, 0xE5,
    0xE7, 0xF2, 0xEF, 0x01, 0x02, 0xF5, 0x03, 0xE1,    0x04, 0xE5, 0xE9, 0x05, 0x06, 0xF9, 0x07, 0xA0,
    0x08, 0xAE, 0xA7, 0x09, 0x0A, 0xF4, 0xEE, 0x0B,    0x0C, 0xF3, 0x9B, 0xE8, 0x01, 0x26, 0x02, 0x07,
    0xF3, 0x03, 0xAE, 0x04, 0x05, 0x06, 0xA7, 0xE1,    0xF0, 0xAC, 0x08, 0xE9, 0x09, 0x16, 0x0A, 0xF9,
    0x0B, 0x15, 0xAF, 0x0C, 0x0D, 0x13, 0x0E, 0x0F,    0xF2, 0x9B, 0xBF, 0x10, 0xEA, 0x11, 0xA9, 0x12,
    0xF6, 0xD2, 0x14, 0xE2, 0xF4, 0xE7, 0xAD, 0xEF,    0x17, 0x18, 0xEC, 0xE6, 0xEE, 0x19, 0x1A, 0x1C,
    0x1B, 0xBA, 0xF7, 0xED, 0x1D, 0x25, 0xE8, 0x1E,    0x1F, 0xE4, 0x20, 0x21, 0xBB, 0xE3, 0xD3, 0x22,
    0xA1, 0x23, 0xC0, 0x24, 0xA2, 0x80, 0xF5, 0xEB,    0xA0, 0xE5, 0x01, 0x11, 0x02, 0x10, 0x03, 0x04,
    0xF5, 0xE4, 0xF9, 0x05, 0x06, 0x0B, 0xAE, 0x07,    0xF6, 0x08, 0x09, 0xE3, 0x0A, 0xBA, 0xF2, 0xE8,
    0xF4, 0x0C, 0xE6, 0x0D, 0xAD, 0x0E, 0x0F, 0xE2,    0xEE, 0xE7, 0xE1, 0xE9, 0x12, 0x29, 0xEC, 0x13,
    0x14, 0xEF, 0xF3, 0x15, 0x16, 0x17, 0xED, 0xEB,    0xF0, 0x18, 0x19, 0xAC, 0xA7, 0x1A, 0x1B, 0xF7,
    0xBF, 0x1C, 0x1D, 0x22, 0xA1, 0x1E, 0x1F, 0xAF,    0xBB, 0x20, 0x21, 0x9B, 0xC0, 0xEA, 0xFA, 0x23,
    0x24, 0x25, 0xC5, 0xAA, 0x26, 0x80, 0xA9, 0x27,    0xA2, 0x28, 0xDB, 0xDD, 0xE5, 0xA0, 0x01, 0x02,
    0xE1, 0xE5, 0x03, 0x24, 0x04, 0x06, 0x05, 0xF0,    0xAE, 0xF3, 0x07, 0xEF, 0x08, 0x0E, 0x09, 0xF9,
    0xAC, 0x0A, 0xDD, 0x0B, 0xBA, 0x0C, 0x0D, 0xF2,    0xBF, 0xA1, 0x0F, 0xE2, 0xAF, 0x10, 0x11, 0x14,
    0xA7, 0x12, 0x13, 0xE6, 0x80, 0xF7, 0x15, 0x20,    0xEC, 0x16, 0x17, 0xE8, 0x18, 0x1F, 0x19, 0x1A,
    0xA9, 0x9B, 0x1B, 0xE4, 0x1C, 0xE7, 0x1D, 0x1E,    0xDB, 0xF6, 0xEB, 0xFA, 0xF4, 0xC0, 0xEE, 0x21,
    0xAD, 0x22, 0xB4, 0x23, 0xBB, 0xE3, 0x25, 0xA0,    0xE9, 0x26, 0xF5, 0xED, 0x01, 0x20, 0x02, 0xA0,
    0x03, 0xF4, 0xF3, 0x04, 0x05, 0x0F, 0x06, 0x0D,    0x07, 0xF5, 0xED, 0x08, 0x09, 0xF7, 0x0A, 0xFA,
    0xF0, 0x0B, 0x0C, 0xBB, 0xAF, 0x80, 0x0E, 0xF6,    0xEC, 0xAD, 0x10, 0xAE, 0xE6, 0x11, 0x12, 0x1B,
    0x13, 0xBA, 0xE8, 0x14, 0x15, 0xF8, 0x16, 0xA9,    0x9B, 0x17, 0xC2, 0x18, 0x19, 0x1A, 0xDD, 0xA2,
    0xC0, 0xAA, 0x1C, 0x1D, 0xE2, 0xEA, 0xF2, 0x1E,    0x1F, 0xBF, 0xA1, 0xF1, 0x21, 0x26, 0xE7, 0x22,
    0xE1, 0x23, 0xE3, 0x24, 0x25, 0xEE, 0xEB, 0xA7,    0x27, 0xE4, 0x28, 0xE5, 0xE9, 0x29, 0x2A, 0xEF,
    0xF9, 0xAC, 0x01, 0x10, 0x02, 0x06, 0x03, 0xF5,    0xEC, 0x04, 0xF6, 0x05, 0xEB, 0xE9, 0x07, 0xA0,
    0x08, 0x09, 0xF3, 0xF0, 0x0A, 0x0E, 0xE7, 0x0B,    0x0C, 0xE5, 0x0D, 0xE8, 0xAD, 0xAC, 0x0F, 0xE3,
    0xF9, 0xE1, 0x11, 0x2D, 0xF2, 0x12, 0x13, 0x14,    0xF4, 0xEF, 0x15, 0xF7, 0x16, 0xE4, 0x17, 0xE2,
    0xAE, 0x18, 0x19, 0x28, 0x1A, 0xA7, 0x1B, 0xBA,    0x1C, 0xBF, 0xA1, 0x1D, 0xCA, 0x1E, 0x1F, 0x22,
    0x20, 0xBB, 0xA2, 0x21, 0xDD, 0xC0, 0xC7, 0x23,    0x9B, 0x24, 0x25, 0x26, 0xB4, 0x80, 0xC2, 0x27,
    0xCF, 0xC3, 0x29, 0xF8, 0x2A, 0xFA, 0x2B, 0xEA,    0x2C, 0xF1, 0xAF, 0xA9, 0x2E, 0xEE, 0xED, 0xE6,
    0x01, 0x0E, 0x02, 0x0D, 0x03, 0xEC, 0xF0, 0x04,    0x05, 0xF4, 0x06, 0xED, 0x07, 0xE4, 0xAD, 0x08,
    0x09, 0xBF, 0x0A, 0x0C, 0x0B, 0xE6, 0x80, 0xBB,    0xEB, 0xA1, 0xA0, 0xEF, 0x0F, 0x24, 0x10, 0xF2,
    0x11, 0x12, 0xF5, 0xE8, 0xF3, 0x13, 0x14, 0x23,    0x15, 0xF9, 0x16, 0x20, 0x17, 0xBA, 0x18, 0x1F,
    0x19, 0xE3, 0x1A, 0xAF, 0x1B, 0xE7, 0x1C, 0xA9,    0x1D, 0xA2, 0x1E, 0xD3, 0x9B, 0xC2, 0xEE, 0xF7,
    0x21, 0x22, 0xA7, 0xDD, 0xAB, 0xE2, 0xAE, 0xAC,    0x25, 0xE5, 0xE1, 0xE9, 0x01, 0xF5, 0x02, 0x03,
    0xAC, 0xAE, 0x04, 0xA0, 0x05, 0x0B, 0x06, 0xE2,    0x07, 0xE1, 0x08, 0x09, 0xBF, 0xBA, 0x0A, 0xA9,
    0x9B, 0xF7, 0xA7, 0xE9, 0x01, 0x25, 0x02, 0x03,    0xE1, 0xEF, 0x04, 0x05, 0xF3, 0xF4, 0x06, 0x1E,
    0x07, 0x1D, 0x08, 0x1C, 0xE6, 0x09, 0x0A, 0xA7,    0x0B, 0xBA, 0x0C, 0x18, 0x0D, 0x17, 0x0E, 0xF1,
    0x0F, 0xBB, 0x10, 0x15, 0x11, 0xA2, 0xD4, 0x12,    0x13, 0xDA, 0xAA, 0x14, 0xC4, 0xC2, 0x16, 0xDD,
    0xF8, 0x9B, 0xEA, 0x80, 0xA1, 0x19, 0xAF, 0x1A,    0x1B, 0xA9, 0xB8, 0xFA, 0xAC, 0xF6, 0xF5, 0xED,
    0xE4, 0x1F, 0x20, 0xEB, 0x21, 0x22, 0xAD, 0xE2,    0x23, 0xF0, 0xF7, 0x24, 0xBF, 0xE8, 0x26, 0x2D,
    0xE9, 0x27, 0x28, 0x29, 0xEE, 0xF9, 0x2A, 0x2C,    0x2B, 0xEC, 0xE3, 0xE7, 0xAE, 0xF2, 0xA0, 0xE5,
    0xA0, 0x01, 0x02, 0x19, 0x03, 0xF4, 0xAE, 0x04,    0x05, 0xAC, 0x06, 0xE3, 0x07, 0x0A, 0x08, 0xEE,
    0x09, 0xE2, 0xA1, 0xE7, 0x0B, 0xED, 0xE6, 0x0C,    0xF2, 0x0D, 0x0E, 0x0F, 0xAF, 0xA9, 0x10, 0x80,
    0x11, 0xF6, 0x12, 0x14, 0x13, 0xA2, 0xEA, 0x9B,    0x15, 0xFA, 0xDB, 0x16, 0x17, 0xC0, 0x18, 0xD4,
    0xF8, 0xE0, 0x1A, 0x2A, 0x1B, 0x1C, 0xEF, 0xF3,    0x1D, 0x27, 0xF5, 0x1E, 0x1F, 0x22, 0xF9, 0x20,
    0xF7, 0x21, 0xBF, 0xAD, 0xBA, 0x23, 0x24, 0xA7,    0x25, 0xF1, 0x26, 0xE4, 0xDD, 0xBB, 0xF0, 0x28,
    0x29, 0xE1, 0xEC, 0xEB, 0xE5, 0x2B, 0xE8, 0xE9,    0x01, 0x1C, 0x02, 0x1B, 0xE9, 0x03, 0xE1, 0x04,
    0xF5, 0x05, 0x06, 0xAE, 0x07, 0xE3, 0x08, 0xAD,    0xEE, 0x09, 0x0A, 0xBF, 0xA1, 0x0B, 0x0C, 0x0D,
    0xE7, 0xBB, 0x0E, 0x0F, 0xD0, 0x80, 0x10, 0xA9,    0x11, 0x17, 0xC0, 0x12, 0x13, 0xDD, 0xC6, 0x14,
    0xEA, 0x15, 0xDC, 0x16, 0xCB, 0xC3, 0xC5, 0x18,    0x19, 0xA2, 0x9B, 0x1A, 0xB1, 0xDB, 0xEF, 0xE5,
    0xE8, 0x1D, 0x1E, 0xA0, 0x1F, 0x23, 0x20, 0xF2,    0x21, 0xF4, 0x22, 0xEC, 0xF6, 0xED, 0x24, 0xF3,
    0xF9, 0x25, 0x26, 0x2F, 0x27, 0xF7, 0x28, 0x2D,    0x29, 0xE2, 0xFA, 0x2A, 0xF8, 0x2B, 0xF0, 0x2C,
    0xAF, 0xEB, 0xBA, 0x2E, 0xE4, 0xE6, 0xAC, 0xA7,    0x01, 0x25, 0x02, 0x22, 0x03, 0x05, 0x04, 0xE4,
    0xE2, 0xA0, 0xE5, 0x06, 0xE9, 0x07, 0x08, 0x1D,    0xF9, 0x09, 0xFA, 0x0A, 0x0B, 0x1A, 0x0C, 0xAD,
    0xF7, 0x0D, 0xF1, 0x0E, 0xEA, 0x0F, 0x10, 0x11,    0xF5, 0xBF, 0x12, 0x19, 0x13, 0x15, 0x14, 0x9B,
    0xDC, 0x80, 0x16, 0x18, 0xBB, 0x17, 0xD4, 0xDD,    0xCA, 0xA9, 0xAF, 0xA1, 0xEF, 0x1B, 0xBA, 0x1C,
    0xE8, 0xF6, 0x1E, 0x21, 0xA7, 0x1F, 0xAC, 0x20,    0xAE, 0xF8, 0xE6, 0xEB, 0x23, 0xF4, 0x24, 0xEC,
    0xE1, 0xE7, 0x26, 0x29, 0x27, 0xEE, 0xF0, 0x28,    0xE3, 0xED, 0xF3, 0xF2, 0x01, 0xE5, 0x02, 0xE9,
    0xE1, 0x03, 0x04, 0xEF, 0x05, 0xAE, 0x06, 0xA0,    0x07, 0x14, 0x08, 0xA7, 0xF5, 0x09, 0x0A, 0x0C,
    0xAD, 0x0B, 0xE7, 0xF6, 0xAC, 0x0D, 0x0E, 0xEC,    0x0F, 0xEB, 0xE2, 0x10, 0xF4, 0x11, 0xE4, 0x12,
    0xAF, 0x13, 0x9B, 0xB1, 0x15, 0xF9, 0xF3, 0x16,    0xF2, 0x17, 0xEE, 0x18, 0xC0, 0xBA, 0x01, 0x05,
    0xE9, 0x02, 0x03, 0xE5, 0x04, 0xE1, 0xAE, 0xF7,    0x06, 0x07, 0xA0, 0xF3, 0xE8, 0x08, 0x09, 0xEF,
    0xEE, 0x0A, 0x0B, 0x19, 0x0C, 0x18, 0x0D, 0x16,    0x0E, 0x13, 0x0F, 0x10, 0xE6, 0xDD, 0xA1, 0x11,
    0x12, 0xE7, 0x80, 0xF5, 0xBA, 0x14, 0x15, 0xEB,    0xBF, 0xF4, 0xE3, 0x17, 0xED, 0xA7, 0xAC, 0xEC,
    0xF2, 0x1A, 0x1B, 0xF9, 0x1C, 0xE2, 0xE4, 0x1D,    0xAD, 0x1E, 0x1F, 0xF0, 0x20, 0xA9, 0x21, 0xEA,
    0x22, 0xF1, 0xAF, 0x23, 0xBB, 0x24, 0x25, 0xDB,    0x9B, 0xC2, 0x01, 0x11, 0x02, 0xF0, 0x03, 0x07,
    0xE9, 0x04, 0xF5, 0x05, 0xE6, 0x06, 0xAC, 0xED,    0xE1, 0x08, 0x09, 0xE5, 0x0A, 0xEF, 0x0B, 0xF9,
    0x0C, 0xB9, 0xF3, 0x0D, 0x0E, 0xBF, 0xC1, 0x0F,    0x10, 0xAF, 0xB4, 0xA1, 0x12, 0xF4, 0x13, 0xA0,
    0xE3, 0x14, 0x15, 0xAD, 0xAE, 0x16, 0x17, 0x1B,    0x18, 0xA7, 0xBA, 0x19, 0xEC, 0x1A, 0xF8, 0xE2,
    0xF1, 0x1C, 0xE8, 0x1D, 0xF7, 0x1E, 0x1F, 0xA9,    0x20, 0x21, 0xE7, 0x80, 0x22, 0xBB, 0x23, 0x25,
    0x24, 0xF6, 0x9B, 0xC3, 0xC6, 0xC5, 0x01, 0xA0,    0x02, 0x13, 0xEF, 0x03, 0x04, 0xF3, 0x05, 0x12,
    0x06, 0xE1, 0xF7, 0x07, 0x08, 0xE2, 0x09, 0x0F,    0x0A, 0xBB, 0xA9, 0x0B, 0x0C, 0xEB, 0xFA, 0x0D,
    0x0E, 0xEA, 0xF9, 0xF8, 0xCA, 0x10, 0x11, 0xAF,    0x9B, 0xF5, 0xE9, 0xE4, 0x14, 0x1A, 0x15, 0xAE,
    0x16, 0xAC, 0x17, 0xEE, 0x18, 0x19, 0xBF, 0xF2,    0xF0, 0xE6, 0x1B, 0x1E, 0xE5, 0x1C, 0x1D, 0xBA,
    0xF4, 0xED, 0xA7, 0x1F, 0x20, 0xEC, 0x21, 0xAD,    0x22, 0xE3, 0x23, 0x24, 0xE8, 0xA1, 0x25, 0xE7,
    0x26, 0xDD, 0x27, 0x80, 0x28, 0xA2, 0x29, 0xB2,    0x2A, 0x2B, 0xF6, 0xD4, 0xC5, 0xD0, 0x01, 0x22,
    0x02, 0x09, 0x03, 0xE1, 0x04, 0xEC, 0x05, 0x08,    0xE3, 0x06, 0xA7, 0x07, 0xBA, 0xF4, 0xAC, 0xAE,
    0x0A, 0xFA, 0xF9, 0x0B, 0xEF, 0x0C, 0xF7, 0x0D,    0x0E, 0x16, 0x0F, 0xED, 0xEB, 0x10, 0x11, 0x12,
    0xF3, 0xAF, 0x13, 0xE4, 0xE8, 0x14, 0xA1, 0x15,    0xE6, 0xF2, 0x17, 0x18, 0xAD, 0xF5, 0x19, 0xE2,
    0x1A, 0x1E, 0x1B, 0xF0, 0xC0, 0x1C, 0x1D, 0xF6,    0xF1, 0xEE, 0x1F, 0xBF, 0xA9, 0x20, 0xE7, 0x21,
    0x9B, 0xDD, 0xE5, 0x23, 0xA0, 0xE9, 0x9B, 0x9B,    0x9B, 0x9B, 0x9B, 0x80, 0x9B, 0x9B, 0x9B, 0x9B,
};

bool IsFreeviewEPG(WORD wNetworkID, const BYTE* pBuffer, size_t uLength)
{
    return (uLength > 1 && (wNetworkID == 9018 || wNetworkID == 59) && pBuffer[0] == 0x1f);
}

CString DecodeFreeviewEPG(const BYTE* pBuffer, size_t uLength)
{
    CString uncompressedString;

    if (pBuffer[1] == 1 || pBuffer[1] == 2) {
        const BYTE* table;
        if (pBuffer[1] == 1) {
            table = raw_huffman_table1;
        } else {
            table = raw_huffman_table2;
        }
        pBuffer += 2;

        size_t j = 0;

        BYTE prevc = START, nextc;
        do {
            short offset = bitrev16(((USHORT*)table)[prevc]);
            USHORT* base = (USHORT*)&table[offset];
            BYTE node = 0;
            BYTE* next_node;
            BYTE bit;

            do {
                bit = (pBuffer[j >> 3] >> (7 - (j & 7))) & 1;
                j++;
                next_node = (BYTE*)&base[node];
                node = next_node[bit];
            } while ((next_node[bit] & 0x80) == 0);

            nextc = next_node[bit] ^ 0x80;

            if (nextc == 0x1b) {
                do {
                    nextc = 0;
                    for (size_t k = 0; k < 8; k++) {
                        bit = (pBuffer[j >> 3] >> (7 - (j & 7))) & 1;
                        nextc = (nextc << 1) | bit;
                        j++;
                    }
                    uncompressedString.AppendChar(nextc);
                } while (nextc & 0x80);
            } else {
                uncompressedString.AppendChar(nextc);
            }

            prevc = nextc;
        } while (nextc != STOP);
    } else {
        BDA_LOG(_T("unsupported huffman table version %d, only version 1 and 2 are supported"), pBuffer[0]);
    }

    return uncompressedString;
}
