#ifndef ISPP_INVOKED
/*
 * (C) 2013-2018 see Authors.txt
 *
 * This file is part of MPC-HC.
 *
 * MPC-HC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-HC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#endif

#ifndef MPC_HC_CONFIG_H
#define MPC_HC_CONFIG_H

#ifndef _T
#if !defined(ISPP_INVOKED) && (defined(UNICODE) || defined(_UNICODE))
#define _T(text) L##text
#else
#define _T(text) text
#endif
#endif

#define WEBSITE_URL  _T("https://github.com/clsid2/mpc-hc/releases")
#define DOWNLOAD_URL _T("https://github.com/clsid2/mpc-hc/releases")
#define UPDATE_URL   _T("https://github.com/clsid2/mpc-hc/raw/develop/version.txt")
#define BACKUP_UPDATE_URL   _T("https://cdn.jsdelivr.net/gh/clsid2/mpc-hc@develop/version.txt")
#define TRAC_URL     _T("https://github.com/clsid2/mpc-hc/issues")
#define BUGS_URL     _T("https://github.com/clsid2/mpc-hc/issues")

#define USE_STATIC_UNRAR 1

#define USE_LIBASS 1

#ifndef USE_DRDUMP_CRASH_REPORTER
#define USE_DRDUMP_CRASH_REPORTER 0
#endif

#define SHADERS_DIR _T("Shaders")
#define SHADERS_DIR11 _T("Shaders11")
#define SHADERS_EXT _T(".hlsl")

#define USE_LAVFILTERS 1

// If this is enabled, the registered LAV Filters can be loaded as internal filters
#define ENABLE_LOAD_EXTERNAL_LAVF_AS_INTERNAL 1

#define DO_MAKE_STR(x)          _T(#x)
#define MAKE_STR(x)             DO_MAKE_STR(x)

#define MPC_DX_SDK_MONTH  _T("June")
#define MPC_DX_SDK_YEAR   2010
// Used in the installer
#define MPC_DX_SDK_NUMBER 43
#define MPC_D3D_COMPILER_VERSION 47
#ifndef ISPP_INVOKED
// Used in build scripts
#define MPCHC_WINSDK_VER 8.1
#endif


#define TRACE_GRAPH_BUILD 0
#define TRACE_SANEAR      0
#define TRACE_SUBTITLES   0

#endif // MPC_HC_CONFIG_H
