/*
 * (C) 2003-2006 Gabest
 * (C) 2006-2017 see Authors.txt
 *
 * This file is part of MPC-HC.
 *
 * MPC-HC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-HC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include <dvdmedia.h>
#include <dmodshow.h>
#include <ks.h>
#include <ksmedia.h>
#include <MMReg.h>
#include <wmcodecdsp.h>

#define WAVE_FORMAT_DOLBY_AC3 0x2000
// {00002000-0000-0010-8000-00aa00389b71}
DEFINE_GUID(MEDIASUBTYPE_WAVE_DOLBY_AC3, WAVE_FORMAT_DOLBY_AC3, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38,
            0x9b, 0x71);

#define WAVE_FORMAT_DVD_DTS 0x2001
// {00002001-0000-0010-8000-00aa00389b71}
DEFINE_GUID(MEDIASUBTYPE_WAVE_DTS, WAVE_FORMAT_DVD_DTS, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// Be compatible with 3ivx
#define WAVE_FORMAT_AAC 0x00FF
// {000000FF-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_AAC, WAVE_FORMAT_AAC, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_LATM_AAC 0x01FF
// {000001FF-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_LATM_AAC, WAVE_FORMAT_LATM_AAC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b,
            0x71);

// ... and also compatible with nero
// btw, older nero parsers use a lower-case fourcc, newer upper-case (why can't it just offer both?)
// {4134504D-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_MP4A, 0x4134504D, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {6134706D-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_mp4a, 0x6134706D, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_MP3 0x0055
// 00000055-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MP3, WAVE_FORMAT_MP3, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_FLAC 0xF1AC
// 0000F1AC-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FLAC, WAVE_FORMAT_FLAC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {1541C5C0-CDDF-477d-BC0A-86F8AE7F8354}
DEFINE_GUID(MEDIASUBTYPE_FLAC_FRAMED, 0x1541c5c0, 0xcddf, 0x477d, 0xbc, 0xa, 0x86, 0xf8, 0xae, 0x7f, 0x83, 0x54);

#define WAVE_FORMAT_TTA1 0x77A1
// {000077A1-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_TTA1, WAVE_FORMAT_TTA1, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_WAVPACK4 0x5756
// {00005756-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_WAVPACK4, WAVE_FORMAT_WAVPACK4, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_AMR, 0x000000FE, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
// {726D6173-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_SAMR, 0x726D6173, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_VP70, 0x30375056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_VP80, 0x30385056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_VP90, 0x30395056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_AV01, 0x31305641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(MEDIASUBTYPE_IMA4, 0x34616D69, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
// {34616D69-0000-0010-8000-00AA00389B71}

DEFINE_GUID(MEDIASUBTYPE_SAWB, 0x62776173, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {DA5B82EE-6BD2-426f-BF1E-30112DA78AE1}
DEFINE_GUID(MEDIASUBTYPE_SVCD_SUBPICTURE, 0xda5b82ee, 0x6bd2, 0x426f, 0xbf, 0x1e, 0x30, 0x11, 0x2d, 0xa7, 0x8a, 0xe1);

// {7B57308F-5154-4c36-B903-52FE76E184FC}
DEFINE_GUID(MEDIASUBTYPE_CVD_SUBPICTURE, 0x7b57308f, 0x5154, 0x4c36, 0xb9, 0x3, 0x52, 0xfe, 0x76, 0xe1, 0x84, 0xfc);

// {0E3A2342-F6E2-4c91-BDAE-87C71EAD0D63}
DEFINE_GUID(MEDIASUBTYPE_MPEG2_PVA, 0xe3a2342, 0xf6e2, 0x4c91, 0xbd, 0xae, 0x87, 0xc7, 0x1e, 0xad, 0xd, 0x63);

// {6B6D0800-9ADA-11d0-A520-00A0D10129C0}
DEFINE_GUID(CLSID_NetShowSource, 0x6b6d0800, 0x9ada, 0x11d0, 0xa5, 0x20, 0x0, 0xa0, 0xd1, 0x1, 0x29, 0xc0);

// DirectShowMedia

// {5E9C9EE0-2E4A-4f22-9906-7BBBB75AA2B6}
DEFINE_GUID(MEDIASUBTYPE_DirectShowMedia, 0x5e9c9ee0, 0x2e4a, 0x4f22, 0x99, 0x6, 0x7b, 0xbb, 0xb7, 0x5a, 0xa2, 0xb6);

// Dirac

// {A29DA00F-A22B-40ea-98DE-2F7FECADA5DE}
DEFINE_GUID(MEDIASUBTYPE_Dirac, 0xa29da00f, 0xa22b, 0x40ea, 0x98, 0xde, 0x2f, 0x7f, 0xec, 0xad, 0xa5, 0xde);

// {64726376-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_DiracVideo, 0x64726376, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {D2667A7E-4055-4244-A65F-DDDDF2B74BD7}
DEFINE_GUID(FORMAT_DiracVideoInfo, 0xd2667a7e, 0x4055, 0x4244, 0xa6, 0x5f, 0xdd, 0xdd, 0xf2, 0xb7, 0x4b, 0xd7);

// {63617264-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_DRAC, 0x63617264, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

struct DIRACINFOHEADER
{
    VIDEOINFOHEADER2 hdr;
    DWORD cbSequenceHeader;
    DWORD dwSequenceHeader[1];
};

// MP4

// {08E22ADA-B715-45ed-9D20-7B87750301D4}
DEFINE_GUID(MEDIASUBTYPE_MP4, 0x8e22ada, 0xb715, 0x45ed, 0x9d, 0x20, 0x7b, 0x87, 0x75, 0x3, 0x1, 0xd4);

// FLV

// {F2FAC0F1-3852-4670-AAC0-9051D400AC54}
DEFINE_GUID(MEDIASUBTYPE_FLV, 0xf2fac0f1, 0x3852, 0x4670, 0xaa, 0xc0, 0x90, 0x51, 0xd4, 0x0, 0xac, 0x54);

// 31564C46-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FLV1, 0x31564C46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31766C66-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_flv1, 0x31766C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34564C46-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FLV4, 0x34564C46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34766C66-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_flv4, 0x34766C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30355056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP50, 0x30355056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30357076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp50, 0x30357076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP60, 0x30365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30367076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp60, 0x30367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP61, 0x31365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31367076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp61, 0x31367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP62, 0x32365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32367076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp62, 0x32367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 41365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP6A, 0x41365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 61367076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp6a, 0x61367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 46365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP6F, 0x46365056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 66367076-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vp6f, 0x66367076, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

//
// RealMedia
//

enum
{
    WAVE_FORMAT_14_4 = 0x2002,
    WAVE_FORMAT_28_8 = 0x2003,
    WAVE_FORMAT_ATRC = 0x0270, // WAVE_FORMAT_SONY_SCX,
    WAVE_FORMAT_COOK = 0x2004,
    WAVE_FORMAT_DNET = 0x2005,
    WAVE_FORMAT_RAAC = 0x2006,
    WAVE_FORMAT_RACP = 0x2007,
    WAVE_FORMAT_SIPR = 0x0130, // WAVE_FORMAT_SIPROLAB_ACEPLNET,
};

// {57428EC6-C2B2-44a2-AA9C-28F0B6A5C48E}
DEFINE_GUID(MEDIASUBTYPE_RealMedia, 0x57428ec6, 0xc2b2, 0x44a2, 0xaa, 0x9c, 0x28, 0xf0, 0xb6, 0xa5, 0xc4, 0x8e);

// 30315652-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RV10, 0x30315652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30325652-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RV20, 0x30325652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30335652-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RV30, 0x30335652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30345652-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RV40, 0x30345652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31345652-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RV41, 0x31345652, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 345f3431-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_14_4, 0x345f3431, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 385f3832-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_28_8, 0x385f3832, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4b4f4f43-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_COOK, 0x4b4f4f43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 54454e44-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DNET, 0x54454e44, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 52504953-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SIPR, 0x52504953, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 00000130-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SIPR_WAVE, WAVE_FORMAT_SIPR, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43414152-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RAAC, 0x43414152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 50434152-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RACP, 0x50434152, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#define WAVE_FORMAT_RALF mmioFOURCC('R', 'A', 'L', 'F')
DEFINE_GUID(MEDIASUBTYPE_RALF, WAVE_FORMAT_RALF, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// QuickTime PCM

// 454E4F4E-0000-0010-8000-00AA00389B71 (unsigned 8-bit)
DEFINE_GUID(MEDIASUBTYPE_PCM_NONE, 0x454E4F4E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 20776172-0000-0010-8000-00AA00389B71 (unsigned 8-bit, signed big-endian 16 bit)
DEFINE_GUID(MEDIASUBTYPE_PCM_RAW, 0x20776172, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 736f7774-0000-0010-8000-00AA00389B71 (signed 8-bit, signed big-endian 16-bit)
DEFINE_GUID(MEDIASUBTYPE_PCM_TWOS, 0x736f7774, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 74776f73-0000-0010-8000-00AA00389B71 (signed 8-bit, signed little-endian 16-bit)
DEFINE_GUID(MEDIASUBTYPE_PCM_SOWT, 0x74776f73, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34326E69-0000-0010-8000-00AA00389B71 (signed big-endian int24)
DEFINE_GUID(MEDIASUBTYPE_PCM_IN24, 0x34326E69, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32336E69-0000-0010-8000-00AA00389B71 (signed big-endian int32)
DEFINE_GUID(MEDIASUBTYPE_PCM_IN32, 0x32336E69, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32336C66-0000-0010-8000-00AA00389B71 (signed big-endian float32)
DEFINE_GUID(MEDIASUBTYPE_PCM_FL32, 0x32336C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34366C66-0000-0010-8000-00AA00389B71 (signed big-endian float64)
DEFINE_GUID(MEDIASUBTYPE_PCM_FL64, 0x34366C66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// Reverse GUIDs for little-endian 'in24', 'in32', 'fl32', 'fl64'
// 696E3234-0000-0010-8000-00AA00389B71 (signed little-endian int24, reverse 'in24')
DEFINE_GUID(MEDIASUBTYPE_PCM_IN24_le, 0x696E3234, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);
// 696E3332-0000-0010-8000-00AA00389B71 (signed little-endian int32, reverse 'in32')
DEFINE_GUID(MEDIASUBTYPE_PCM_IN32_le, 0x696E3332, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);
// 666C3332-0000-0010-8000-00AA00389B71 (signed little-endian float32, reverse 'fl32')
DEFINE_GUID(MEDIASUBTYPE_PCM_FL32_le, 0x666C3332, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);
// 666C3634-0000-0010-8000-00AA00389B71 (signed little-endian float64, reverse 'fl64')
DEFINE_GUID(MEDIASUBTYPE_PCM_FL64_le, 0x666C3634, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

//
// PS2
//

#define WAVE_FORMAT_PS2_PCM 0xF521
// 0000F521-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_PS2_PCM, WAVE_FORMAT_PS2_PCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_PS2_ADPCM 0xF522
// 0000F522-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_PS2_ADPCM, WAVE_FORMAT_PS2_ADPCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b,
            0x71);

#define WAVE_FORMAT_ADPCM_SWF 0x5346
// 00005346-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ADPCM_SWF,
            WAVE_FORMAT_ADPCM_SWF, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 41564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ADPCM_AMV,
            0x41564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);


struct WAVEFORMATEXPS2 : public WAVEFORMATEX
{
    DWORD dwInterleave;

    struct WAVEFORMATEXPS2()
    {
        memset(this, 0, sizeof(*this));
        cbSize = sizeof(WAVEFORMATEXPS2) - sizeof(WAVEFORMATEX);
    }
};

// {4F3D3D21-6D7C-4f73-AA05-E397B5EAE0AA}
DEFINE_GUID(MEDIASUBTYPE_PS2_SUB, 0x4f3d3d21, 0x6d7c, 0x4f73, 0xaa, 0x5, 0xe3, 0x97, 0xb5, 0xea, 0xe0, 0xaa);

// ATRAC

// 43525441-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ATRC, 0x43525441, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 00000270-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ATRAC3, WAVE_FORMAT_SONY_SCX, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#define WAVE_FORMAT_ATRAC3P 0xE923AABF
// E923AABF-CB58-4471-A119-FFFA01E4CE62
DEFINE_GUID(MEDIASUBTYPE_ATRAC3P, 0xE923AABF, 0xCB58, 0x4471, 0xA1, 0x19, 0xFF, 0xFA, 0x01, 0xE4, 0xCE, 0x62);

// Haali's video renderer

// {760A8F35-97E7-479d-AAF5-DA9EFF95D751}
DEFINE_GUID(CLSID_DXR, 0x760a8f35, 0x97e7, 0x479d, 0xaa, 0xf5, 0xda, 0x9e, 0xff, 0x95, 0xd7, 0x51);

// {E1A8B82A-32CE-4B0D-BE0D-AA68C772E423}
DEFINE_GUID(CLSID_MadVR, 0xE1A8B82A, 0x32CE, 0x4B0D, 0xBE, 0x0D, 0xAA, 0x68, 0xC7, 0x72, 0xE4, 0x23);

// {71F080AA-8661-4093-B15E-4F6903E77D0A}
DEFINE_GUID(CLSID_MPCVR, 0x71F080AA, 0x8661, 0x4093, 0xB1, 0x5E, 0x4F, 0x69, 0x03, 0xE7, 0x7D, 0x0A);

// {C1F400A4-3F08-11D3-9F0B-006008039E37}
DEFINE_GUID(CLSID_NullRenderer, 0xC1F400A4, 0x3F08, 0x11D3, 0x9F, 0x0B, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37);

// {A0025E90-E45B-11D1-ABE9-00A0C905F375}
DEFINE_GUID(CLSID_OverlayMixer2, 0xA0025E90, 0xE45B, 0x11D1, 0xAB, 0xE9, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75);

//
// Ogg
//

// 9FF48807-E133-40AA-826F-9B2959E5232D
DEFINE_GUID(CLSID_MPCHCOggSplitter, 0x9FF48807, 0xE133, 0x40AA, 0x82, 0x6F, 0x9B, 0x29, 0x59, 0xE5, 0x23, 0x2D);

// 6D3688CE-3E9D-42F4-92CA-8A11119D25CD
DEFINE_GUID(CLSID_MPCHCOggSource, 0x6D3688CE, 0x3E9D, 0x42F4, 0x92, 0xCA, 0x8A, 0x11, 0x11, 0x9D, 0x25, 0xCD);

// f07e245f-5a1f-4d1e-8bff-dc31d84a55ab
DEFINE_GUID(CLSID_OggSplitter, 0xf07e245f, 0x5a1f, 0x4d1e, 0x8b, 0xff, 0xdc, 0x31, 0xd8, 0x4a, 0x55, 0xab);

// {078C3DAA-9E58-4d42-9E1C-7C8EE79539C5}
DEFINE_GUID(CLSID_OggSplitPropPage, 0x78c3daa, 0x9e58, 0x4d42, 0x9e, 0x1c, 0x7c, 0x8e, 0xe7, 0x95, 0x39, 0xc5);

// 8cae96b7-85b1-4605-b23c-17ff5262b296
DEFINE_GUID(CLSID_OggMux, 0x8cae96b7, 0x85b1, 0x4605, 0xb2, 0x3c, 0x17, 0xff, 0x52, 0x62, 0xb2, 0x96);

// {AB97AFC3-D08E-4e2d-98E0-AEE6D4634BA4}
DEFINE_GUID(CLSID_OggMuxPropPage, 0xab97afc3, 0xd08e, 0x4e2d, 0x98, 0xe0, 0xae, 0xe6, 0xd4, 0x63, 0x4b, 0xa4);

// {889EF574-0656-4B52-9091-072E52BB1B80}
DEFINE_GUID(CLSID_VorbisEnc, 0x889ef574, 0x0656, 0x4b52, 0x90, 0x91, 0x07, 0x2e, 0x52, 0xbb, 0x1b, 0x80);

// {c5379125-fd36-4277-a7cd-fab469ef3a2f}
DEFINE_GUID(CLSID_VorbisEncPropPage, 0xc5379125, 0xfd36, 0x4277, 0xa7, 0xcd, 0xfa, 0xb4, 0x69, 0xef, 0x3a, 0x2f);

// 02391f44-2767-4e6a-a484-9b47b506f3a4
DEFINE_GUID(CLSID_VorbisDec, 0x02391f44, 0x2767, 0x4e6a, 0xa4, 0x84, 0x9b, 0x47, 0xb5, 0x06, 0xf3, 0xa4);

// 77983549-ffda-4a88-b48f-b924e8d1f01c
DEFINE_GUID(CLSID_OggDSAboutPage, 0x77983549, 0xffda, 0x4a88, 0xb4, 0x8f, 0xb9, 0x24, 0xe8, 0xd1, 0xf0, 0x1c);

// {D2855FA9-61A7-4db0-B979-71F297C17A04}
DEFINE_GUID(MEDIASUBTYPE_Ogg, 0xd2855fa9, 0x61a7, 0x4db0, 0xb9, 0x79, 0x71, 0xf2, 0x97, 0xc1, 0x7a, 0x4);

// cddca2d5-6d75-4f98-840e-737bedd5c63b
DEFINE_GUID(MEDIASUBTYPE_Vorbis, 0xcddca2d5, 0x6d75, 0x4f98, 0x84, 0x0e, 0x73, 0x7b, 0xed, 0xd5, 0xc6, 0x3b);

// 6bddfa7e-9f22-46a9-ab5e-884eff294d9f
DEFINE_GUID(FORMAT_VorbisFormat, 0x6bddfa7e, 0x9f22, 0x46a9, 0xab, 0x5e, 0x88, 0x4e, 0xff, 0x29, 0x4d, 0x9f);

typedef struct tagVORBISFORMAT
{
    WORD nChannels;
    DWORD nSamplesPerSec;
    DWORD nMinBitsPerSec;
    DWORD nAvgBitsPerSec;
    DWORD nMaxBitsPerSec;
    float fQuality;
} VORBISFORMAT, *PVORBISFORMAT, FAR *LPVORBISFORMAT;

// {8D2FD10B-5841-4a6b-8905-588FEC1ADED9}
DEFINE_GUID(MEDIASUBTYPE_Vorbis2, 0x8d2fd10b, 0x5841, 0x4a6b, 0x89, 0x5, 0x58, 0x8f, 0xec, 0x1a, 0xde, 0xd9);

// {B36E107F-A938-4387-93C7-55E966757473}
DEFINE_GUID(FORMAT_VorbisFormat2, 0xb36e107f, 0xa938, 0x4387, 0x93, 0xc7, 0x55, 0xe9, 0x66, 0x75, 0x74, 0x73);

typedef struct tagVORBISFORMAT2
{
    DWORD Channels;
    DWORD SamplesPerSec;
    DWORD BitsPerSample;
    DWORD HeaderSize[3]; // 0: Identification, 1: Comment, 2: Setup
} VORBISFORMAT2, *PVORBISFORMAT2, FAR *LPVORBISFORMAT2;

//
// Matroska
//

// {1AC0BEBD-4D2B-45ad-BCEB-F2C41C5E3788}
DEFINE_GUID(MEDIASUBTYPE_Matroska, 0x1ac0bebd, 0x4d2b, 0x45ad, 0xbc, 0xeb, 0xf2, 0xc4, 0x1c, 0x5e, 0x37, 0x88);

// {E487EB08-6B26-4be9-9DD3-993434D313FD}
DEFINE_GUID(MEDIATYPE_Subtitle, 0xe487eb08, 0x6b26, 0x4be9, 0x9d, 0xd3, 0x99, 0x34, 0x34, 0xd3, 0x13, 0xfd);

// {87C0B230-03A8-4fdf-8010-B27A5848200D}
DEFINE_GUID(MEDIASUBTYPE_UTF8, 0x87c0b230, 0x3a8, 0x4fdf, 0x80, 0x10, 0xb2, 0x7a, 0x58, 0x48, 0x20, 0xd);

// {3020560F-255A-4ddc-806E-6C5CC6DCD70A}
DEFINE_GUID(MEDIASUBTYPE_SSA, 0x3020560f, 0x255a, 0x4ddc, 0x80, 0x6e, 0x6c, 0x5c, 0xc6, 0xdc, 0xd7, 0xa);

// {326444F7-686F-47ff-A4B2-C8C96307B4C2}
DEFINE_GUID(MEDIASUBTYPE_ASS, 0x326444f7, 0x686f, 0x47ff, 0xa4, 0xb2, 0xc8, 0xc9, 0x63, 0x7, 0xb4, 0xc2);

// {370689E7-B226-4f67-978D-F10BC1A9C6AE}
DEFINE_GUID(MEDIASUBTYPE_ASS2, 0x370689e7, 0xb226, 0x4f67, 0x97, 0x8d, 0xf1, 0xb, 0xc1, 0xa9, 0xc6, 0xae);

// {76C421C4-DB89-42ec-936E-A9FBC1794714}
DEFINE_GUID(MEDIASUBTYPE_SSF, 0x76c421c4, 0xdb89, 0x42ec, 0x93, 0x6e, 0xa9, 0xfb, 0xc1, 0x79, 0x47, 0x14);

// {B753B29A-0A96-45be-985F-68351D9CAB90}
DEFINE_GUID(MEDIASUBTYPE_USF, 0xb753b29a, 0xa96, 0x45be, 0x98, 0x5f, 0x68, 0x35, 0x1d, 0x9c, 0xab, 0x90);

// {F7239E31-9599-4e43-8DD5-FBAF75CF37F1}
DEFINE_GUID(MEDIASUBTYPE_VOBSUB, 0xf7239e31, 0x9599, 0x4e43, 0x8d, 0xd5, 0xfb, 0xaf, 0x75, 0xcf, 0x37, 0xf1);

// {A33D2F7D-96BC-4337-B23B-A8B9FBC295E9}
DEFINE_GUID(FORMAT_SubtitleInfo, 0xa33d2f7d, 0x96bc, 0x4337, 0xb2, 0x3b, 0xa8, 0xb9, 0xfb, 0xc2, 0x95, 0xe9);

// {04EBA53E-9330-436c-9133-553EC87031DC}
DEFINE_GUID(MEDIASUBTYPE_HDMVSUB, 0x4eba53e, 0x9330, 0x436c, 0x91, 0x33, 0x55, 0x3e, 0xc8, 0x70, 0x31, 0xdc);

// {C886D215-F485-40BB-8DB6-FADBC619A45D}
DEFINE_GUID(MEDIASUBTYPE_WEBVTT, 0xc886d215, 0xf485, 0x40bb, 0x8d, 0xb6, 0xfa, 0xdb, 0xc6, 0x19, 0xa4, 0x5d);

#pragma pack(push, 1)
typedef struct
{
    DWORD dwOffset;
    CHAR IsoLang[4];      // three letter lang code + terminating zero
    WCHAR TrackName[256]; // 256 chars ought to be enough for everyone :)
} SUBTITLEINFO;
#pragma pack(pop)

// SUBTITLEINFO structure content starting at dwOffset (also the content of CodecPrivate)
// --------------------------------------------------------------------------------------
//
// Here the text should start with the Byte Order Mark, even though
// UTF-8 is preferred, it also helps identifying the encoding type.
//
// MEDIASUBTYPE_USF:
//
// <?xml version="1.0" encoding="UTF-8"?>
// <!-- DOCTYPE USFSubtitles SYSTEM "USFV100.dtd" -->
// <?xml-stylesheet type="text/xsl" href="USFV100.xsl"?>
//
// <USFSubtitles version="1.0">
// ... every element excluding <subtitles></subtitles> ...
// </USFSubtitles>
//
// MEDIASUBTYPE_SSA/ASS:
//
// The file header and all sub-sections except [Events]
//
// MEDIATYPE_VOBSUB:
//
// TODO
//

// Data description of the media samples (everything is UTF-8 encoded here)
// ------------------------------------------------------------------------
//
// MEDIASUBTYPE_USF:
//
// The text _inside_ the <subtitle>..</subtitle> element.
//
// Since timing is set on the sample, there is no need to put
// <subtitle start=".." stop=".." duration=".."> into the data.
//
// MEDIASUBTYPE_SSA/ASS:
//
// Comma separated values similar to the "Dialogue: ..." line with these fields:
// ReadOrder, Layer, Style, Name, MarginL, MarginR, MarginV, Effect, Text
//
// With the exception of ReadOrder every field can be found in ASS files. The
// ReadOrder field is needed for the decoder to be able to reorder the streamed
// samples as they were placed originally in the file.
//
// If the source is only SSA, the Layer field can be left empty.
//
// MEDIATYPE_VOBSUB:
//
// Standard dvd subpic data, without the stream id at the beginning.
//

// Matroska CodecID mappings
// ------------------------
//
// S_TEXT/ASCII <-> MEDIATYPE_Text      MEDIASUBTYPE_NULL   FORMAT_None
// S_TEXT/UTF8  <-> MEDIATYPE_Subtitle  MEDIASUBTYPE_UTF8   FORMAT_SubtitleInfo
// S_TEXT/SSA   <-> MEDIATYPE_Subtitle  MEDIASUBTYPE_SSA    FORMAT_SubtitleInfo
// S_TEXT/ASS   <-> MEDIATYPE_Subtitle  MEDIASUBTYPE_ASS    FORMAT_SubtitleInfo
// S_TEXT/USF   <-> MEDIATYPE_Subtitle  MEDIASUBTYPE_USF    FORMAT_SubtitleInfo
// S_VOBSUB     <-> MEDIATYPE_Subtitle  MEDIASUBTYPE_VOBSUB FORMAT_SubtitleInfo
// S_VOBSUB/ZLIB<-> MEDIATYPE_Subtitle  MEDIASUBTYPE_VOBSUB FORMAT_SubtitleInfo
//

/*
DEFINE_GUID( MEDIATYPE_MPEG2_SECTIONS,
    0x455f176c, 0x4b06, 0x47ce, 0x9a, 0xef, 0x8c, 0xae, 0xf7, 0x3d, 0xf7, 0xb5);

DEFINE_GUID(MEDIASUBTYPE_ATSC_SI,
0xb3c7397c, 0xd303, 0x414d, 0xb3, 0x3c, 0x4e, 0xd2, 0xc9, 0xd2, 0x97, 0x33);

DEFINE_GUID(MEDIASUBTYPE_DVB_SI,
0xe9dd31a3, 0x221d, 0x4adb, 0x85, 0x32, 0x9a, 0xf3, 0x9, 0xc1, 0xa4, 0x8);


// {C892E55B-252D-42b5-A316-D997E7A5D995}
DEFINE_GUID(MEDIASUBTYPE_MPEG2DATA,
0xc892e55b, 0x252d, 0x42b5, 0xa3, 0x16, 0xd9, 0x97, 0xe7, 0xa5, 0xd9, 0x95);

*/

// ASF
// {6B6D0801-9ADA-11D0-A520-00A0D10129C0}
DEFINE_GUID(MEDIASUBTYPE_ASF,
            0x6b6d0801, 0x9ada, 0x11d0, 0xa5, 0x20, 0x00, 0xa0, 0xd1, 0x01, 0x29, 0xc0);

// H264

// 6F29D2AD-E130-45AA-B42F-F623AD354A90
DEFINE_GUID(MEDIASUBTYPE_ArcsoftH264, 0x6F29D2AD, 0xE130, 0x45AA, 0xB4, 0x2F, 0xF6, 0x23, 0xAD, 0x35, 0x4A, 0x90);

// 48535356-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VSSH, 0x48535356, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 68737376-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_vssh, 0x68737376, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43564144-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DAVC, 0x43564144, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 63766164-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_davc, 0x63766164, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43564150-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_PAVC, 0x43564150, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 63766170-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_pavc, 0x63766170, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31637661-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_avc1, 0x31637661, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31564343-0000-0010-8000-00AA00389B71 (custom H.264 FourCC used by Haali Media Splitter)
DEFINE_GUID(MEDIASUBTYPE_CCV1, 0x31564343, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 8D2D71CB-243F-45E3-B2D8-5FD7967EC09B		<= Use by MediaPortal for example...
DEFINE_GUID(MEDIASUBTYPE_H264_bis, 0x8D2D71CB, 0x243F, 0x45E3, 0xB2, 0xD8, 0x5F, 0xD7, 0x96, 0x7E, 0xC0, 0x9B);

// 676C6178-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_xalg, 0x676C6178, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 676C7661-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_avlg, 0x676C7661, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33515653-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_SVQ3, 0x33515653, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_XVID, 0x44495658, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_xvid, 0x64697678, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30355844-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_DX50, 0x30355844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30357864-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_dx50, 0x30357864, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIVX, 0x58564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 78766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_divx, 0x78766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 78766944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_Divx, 0x78766944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 5634504d-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_MP4V, 0x5634504d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 7634706D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_mp4v, 0x7634706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31564933-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_3IV1, 0x31564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31766933-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_3iv1, 0x31766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32564933-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_3IV2, 0x32564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32766933-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_3iv2, 0x32766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 58564933-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_3IVX, 0x58564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 78766933-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_3ivx, 0x78766933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 305A4C42-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_BLZ0, 0x305A4C42, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 307A6C62-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_blz0, 0x307A6C62, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {564F4547-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_GEOV, 0x564F4547, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56344D44-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DM4V, 0x56344D44, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 76346D64-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_dm4v, 0x76346D64, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4D475844-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DXGM, 0x4D475844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 6D677864-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_dxgm, 0x6D677864, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 53444646-0000-0010-8000-00aa00389b71
DEFINE_GUID(MEDIASUBTYPE_FFDS, 0x53444646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 73646666-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ffds, 0x73646666, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 57465646-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FVFW, 0x57465646, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 77667666-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_fvfw, 0x77667666, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34504D46-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FMP4, 0x34504D46, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34706D66-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_fmp4, 0x34706D66, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34584448-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HDX4, 0x34584448, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34786468-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_hdx4, 0x34786468, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34504D4C-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_LMP4, 0x34504D4C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34706D6C-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_lmp4, 0x34706D6C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4749444E-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_NDIG, 0x4749444E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 6769646E-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ndig, 0x6769646E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34504D52-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RMP4, 0x34504D52, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34706D72-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_rmp4, 0x34706D72, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34504D53-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SMP4, 0x34504D53, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34706D73-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_smp4, 0x34706D73, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 47444553-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SEDG, 0x47444553, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 67646573-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_sedg, 0x67646573, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4D475844-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DGXM, 0x4D475844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34504D55-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_UMP4, 0x34504D55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34706D75-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ump4, 0x34706D75, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 46315657-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_WV1F, 0x46315657, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 66317677-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_wv1f, 0x66317677, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 58495658-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_XVIX, 0x58495658, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 78697678-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_xvix, 0x78697678, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31515653-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SVQ1, 0x31515653, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33363248-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_H263, 0x33363248, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33363268-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_h263, 0x33363268, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33363249-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_I263, 0x33363249, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33363269-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_i263, 0x33363269, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31363248-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_H261, 0x31363248, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31363268-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_h261, 0x31363268, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_S263, 0x33363273, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33363273-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_s263, 0x33363273, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AMVV, 0x56564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 46564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AMVF, 0x46564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33585644-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVX3, 0x33585644, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33787664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_dvx3, 0x33787664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 44564933-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_3IVD, 0x44564933, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV3, 0x33564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div3, 0x33766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 314C4F43-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_COL1, 0x314C4F43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 316C6F63-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_col1, 0x316C6F63, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV4, 0x34564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div4, 0x34766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV5, 0x35564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div5, 0x35766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 36564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV6, 0x36564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 36766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div6, 0x36766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31345041-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AP41, 0x31345041, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31347061-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ap41, 0x31347061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 3347504D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MPG3, 0x3347504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 3367706D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_mpg3, 0x3367706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV2, 0x32564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div2, 0x32766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31564944-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DIV1, 0x31564944, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31766964-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_div1, 0x31766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 3134504D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MP41, 0x3134504D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 3134706D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_mp41, 0x3134706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4F454854-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_THEORA, 0x4F454854, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 6F656874-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_theora, 0x6F656874, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 63637374-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_TSCC, 0x63637374, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32637374-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_TSC2, 0x32637374, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30355649-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IV50, 0x30355649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31345649-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IV41, 0x31345649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31335649-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IV31, 0x31335649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32335649-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IV32, 0x32335649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 48564443-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CDVH, 0x48564443, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43564443-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CDVC, 0x43564443, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35564443-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CDV5, 0x35564443, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35325644-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DV25, 0x35325644, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 30355644-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DV50, 0x30355644, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 70637664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVCP, 0x70637664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 70707664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVPP, 0x70707664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 70357664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DV5P, 0x70357664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 6E357664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DV5N, 0x6E357664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 70637664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVC, 0x20637664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 31687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH1, 0x31687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 32687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH2, 0x32687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 33687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH3, 0x33687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 34687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH4, 0x34687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 35687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH5, 0x35687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 36687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVH6, 0x36687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 71687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVHQ, 0x71687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 70687664-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DVHP, 0x70687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 76645641-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AVdv, 0x76645641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 31645641-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AVd1, 0x31645641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 31535046-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_FPS1, 0x31535046, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 55594648-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HuffYUV, 0x55594648, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 5347414C-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_Lagarith, 0x5347414C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 64697663-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CVID, 0x64697663, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 694B4942-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_BIKI, 0x694B4942, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 624B4942-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_BIKB, 0x624B4942, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 664b4942-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_BIKf, 0x664b4942, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

DEFINE_GUID(FORMAT_RLTheora, 0xe69b30d1, 0x7d65, 0x4166, 0xb9, 0x90, 0x10, 0x3d, 0xa8, 0xc9, 0x11, 0xe3);

// 62706A6D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MJPGB, 0x62706A6D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 30365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP30, 0x30335056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30365056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP31, 0x31335056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 324B4D53-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SMK2, 0x324B4D53, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 344B4D53-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SMK4, 0x344B4D53, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 44435343-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CSCD, 0x44435343, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 47455051-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_QPEG, 0x47455051, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 302E3151-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_QP10, 0x302E3151, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 312E3151-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_QP11, 0x312E3151, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 485A534D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MSZH, 0x485A534D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 42494C5A-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ZLIB, 0x42494C5A, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 20676E70-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_PNG, 0x20676E70, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_TIFF, MAKEFOURCC('T', 'I', 'F', 'F'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_BMP, MAKEFOURCC('B', 'M', 'P', ' '), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_GIF, MAKEFOURCC('G', 'I', 'F', ' '), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_TGA, MAKEFOURCC('T', 'G', 'A', ' '), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_WEBP, MAKEFOURCC('W', 'E', 'B', 'P'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_FSV1, 0x31565346, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_CRAM, MAKEFOURCC('C', 'R', 'A', 'M'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_MSVC, MAKEFOURCC('M', 'S', 'V', 'C'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_WHAM, MAKEFOURCC('W', 'H', 'A', 'M'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_8BPS, MAKEFOURCC('8', 'B', 'P', 'S'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_LOCO, MAKEFOURCC('L', 'O', 'C', 'O'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ZMBV, MAKEFOURCC('Z', 'M', 'B', 'V'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_VCR1, MAKEFOURCC('V', 'C', 'R', '1'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_AASC, MAKEFOURCC('A', 'A', 'S', 'C'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_SNOW, MAKEFOURCC('S', 'N', 'O', 'W'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_FFV1, MAKEFOURCC('F', 'F', 'V', '1'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_FFVH, MAKEFOURCC('F', 'F', 'V', 'H'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_v410, MAKEFOURCC('v', '4', '1', '0'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_VMNC, MAKEFOURCC('V', 'M', 'n', 'c'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// {3267706D-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_MPG2, 0x3267706D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// Apple ProRes
DEFINE_GUID(MEDIASUBTYPE_apch, 0x68637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_apcn, 0x6e637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_apcs, 0x73637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_apco, 0x6f637061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_ap4h, 0x68347061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_ap4x, 0x78347061, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// Apple ICOD
DEFINE_GUID(MEDIASUBTYPE_icod, 0x646F6369, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// Ut Video
DEFINE_GUID(MEDIASUBTYPE_ULRA, MAKEFOURCC('U', 'L', 'R', 'A'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULRG, MAKEFOURCC('U', 'L', 'R', 'G'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULY0, MAKEFOURCC('U', 'L', 'Y', '0'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULY2, MAKEFOURCC('U', 'L', 'Y', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULY4, MAKEFOURCC('U', 'L', 'Y', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UQY2, MAKEFOURCC('U', 'Q', 'Y', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UQRG, MAKEFOURCC('U', 'Q', 'R', 'G'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UQRA, MAKEFOURCC('U', 'Q', 'R', 'A'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULH0, MAKEFOURCC('U', 'L', 'H', '0'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULH2, MAKEFOURCC('U', 'L', 'H', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ULH4, MAKEFOURCC('U', 'L', 'H', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMY2, MAKEFOURCC('U', 'M', 'Y', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMH2, MAKEFOURCC('U', 'M', 'H', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMY4, MAKEFOURCC('U', 'M', 'Y', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMH4, MAKEFOURCC('U', 'M', 'H', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMRG, MAKEFOURCC('U', 'M', 'R', 'G'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_UMRA, MAKEFOURCC('U', 'M', 'R', 'A'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// G2M
DEFINE_GUID(MEDIASUBTYPE_G2M2, MAKEFOURCC('G', '2', 'M', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_G2M3, MAKEFOURCC('G', '2', 'M', '3'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_G2M4, MAKEFOURCC('G', '2', 'M', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_G2M5, MAKEFOURCC('G', '2', 'M', '5'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// CFHD
DEFINE_GUID(MEDIASUBTYPE_CFHD, MAKEFOURCC('C', 'F', 'H', 'D'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// MagicYUV
DEFINE_GUID(MEDIASUBTYPE_MAGY, MAKEFOURCC('M', 'A', 'G', 'Y'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_M8RG, MAKEFOURCC('M', '8', 'R', 'G'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8RA, MAKEFOURCC('M', '8', 'R', 'A'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8G0, MAKEFOURCC('M', '8', 'G', '0'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8Y0, MAKEFOURCC('M', '8', 'Y', '0'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8Y2, MAKEFOURCC('M', '8', 'Y', '2'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8Y4, MAKEFOURCC('M', '8', 'Y', '4'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

DEFINE_GUID(MEDIASUBTYPE_M8YA, MAKEFOURCC('M', '8', 'Y', 'A'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// MagicYUV
DEFINE_GUID(MEDIASUBTYPE_FICV, MAKEFOURCC('F', 'I', 'C', 'V'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// DNxHD
// {6E645641-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_AVdn, 0x6E645641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// DNxHR
// {68645641-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_AVdh, 0x68645641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// JPEG2000
// {32706A6D-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_mjp2, 0x32706A6D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {43324A4D-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_MJ2C, 0x43324A4D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {43324A4C-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_LJ2C, 0x43324A4C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {4B324A4C-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_LJ2K, 0x4B324A4C, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {324A5049-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_IPJ2, 0x324A5049, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {D80FA03C-35C1-4FA1-8C8E-375C8667166E}
DEFINE_GUID(MEDIASUBTYPE_LAV_RAWVIDEO, 0xd80fa03c, 0x35c1, 0x4fa1, 0x8c, 0x8e, 0x37, 0x5c, 0x86, 0x67, 0x16, 0x6e);

// {434C4641-0000-0010-8000-00AA00389B71}
DEFINE_GUID(MEDIASUBTYPE_FLIC, 0x434C4641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// {}
DEFINE_GUID(MEDIASUBTYPE_THPV, MAKEFOURCC('T', 'H', 'P', 'V'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

DEFINE_GUID(MEDIASUBTYPE_ROQV, MAKEFOURCC('R', 'o', 'Q', 'V'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// 31435648-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HVC1, 0x31435648, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43564548-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HEVC, 0x43564548, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30314D48-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HM10, 0x30314D48, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35363248-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_H265, 0x35363248, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// VVC ("VVC1")
DEFINE_GUID(MEDIASUBTYPE_VVC1, MAKEFOURCC('V', 'V', 'C', '1'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B,
            0x71);

// Full MVC
DEFINE_GUID(MEDIASUBTYPE_AMVC, MAKEFOURCC('A', 'M', 'V', 'C'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b,
            0x71);

// Full MVC in mp4-form
DEFINE_GUID(MEDIASUBTYPE_MVC1, MAKEFOURCC('M', 'V', 'C', '1'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b,
            0x71);

// Subset MVC
DEFINE_GUID(MEDIASUBTYPE_EMVC, MAKEFOURCC('E', 'M', 'V', 'C'), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b,
            0x71);

// 4B435544-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DUCK, 0x4B435544, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30324D54-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_TM20, 0x30324D54, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 20636D73-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_smc, 0x20636D73, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4C584956-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VIXL, 0x4C584956, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 49544C55-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ULTI, 0x49544C55, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31564E57-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_WNV1, 0x31564E57, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 76757963-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_CYUV, 0x76757963, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31565341-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AVS1, 0x31565341, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 32565341-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AVS2, 0x32565341, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31325452-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_RT21, 0x31325452, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 6E525641-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_AVRn, 0x6E525641, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 47504a4c-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_LJPG, 0x47504a4c, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4C47504A-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_JPGL, 0x4C47504A, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 534c4a4d-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MJLS, 0x534c4a4d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 41504a4d-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MJPA, 0x41504a4d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 42504a4d-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MJPB, 0x42504a4d, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 58355053-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SP5X, 0x58355053, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 31706148-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_Hap1, 0x31706148, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 35706148-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_Hap5, 0x35706148, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 59706148-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_HapY, 0x59706148, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 33445844-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DXD3, 0x33445844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 49445844-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_DXDI, 0x49445844, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 574D5632-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_2VMW, 0x574D5632, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 56334357-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_WC3V, 0x56334357, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 4345444D-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MDEC, 0x4345444D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 564D5834-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_4XMV, 0x564D5834, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 43425241-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ARBC, 0x43425241, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 30345056-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VP40, 0x30345056, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 34355053-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_SP54, 0x34355053, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// 3156474B-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_KGV1, 0x3156474B, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

// Audio codecs

// 41564D41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IMA_AMV, 0x41564D41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 4C4C454E-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_NELLYMOSER, 0x4C4C454E, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000006-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ALAW, WAVE_FORMAT_ALAW, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000007-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MULAW, WAVE_FORMAT_MULAW, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000031-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_MSGSM610, WAVE_FORMAT_GSM610, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000002-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ADPCM_MS, WAVE_FORMAT_ADPCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000022-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_TRUESPEECH, WAVE_FORMAT_DSPGROUP_TRUESPEECH, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00,
            0x38, 0x9b, 0x71);

// 00000075-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VOXWARE_RT29, WAVE_FORMAT_VOXWARE_RT29, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38,
            0x9b, 0x71);

// 324D4451-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_QDM2, 0x324D4451, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 63616C61-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ALAC, 0x63616C61, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// B82196E9-1B3F-4796-A636-46239087B38E   dsfTAKsource specific
DEFINE_GUID(MEDIASUBTYPE_TAK, 0xB82196E9, 0x1B3F, 0x4796, 0xA6, 0x36, 0x46, 0x23, 0x90, 0x87, 0xB3, 0x8E);

// 20534C41-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_ALS, 0x20534C41, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 0000729A-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_729A, 0x0000729A, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000133-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_G729, 0x00000133, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 36323767-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_G726, 0x36323767, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000401-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IMC, 0x00000401, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 0000011-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_IMA_WAV, WAVE_FORMAT_IMA_ADPCM, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {A23EB7FC-510B-466F-9FBF-5F878F69347C}   LAVF/LAVC specific
DEFINE_GUID(MEDIASUBTYPE_BD_LPCM_AUDIO, 0xa23eb7fc, 0x510b, 0x466f, 0x9f, 0xbf, 0x5f, 0x87, 0x8f, 0x69, 0x34, 0x7c);

// {53544441-0000-0010-8000-00AA00389B71}   AAC-ADTS LAVF/LAVC specific
#define WAVE_FORMAT_AAC_ADTS mmioFOURCC('A', 'D', 'T', 'S')
DEFINE_GUID(MEDIASUBTYPE_AAC_ADTS, WAVE_FORMAT_AAC_ADTS, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {33534541-0000-0010-8000-00AA00389B71} S302M AES3
#define WAVE_FORMAT_S302M_AES3 mmioFOURCC('A', 'E', 'S', '3')
DEFINE_GUID(MEDIASUBTYPE_AES3, WAVE_FORMAT_S302M_AES3, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// {949F97FD-56F6-4527-B4AE-DDEB375AB80F}		Mpc-hc specific !
DEFINE_GUID(MEDIASUBTYPE_HDMV_LPCM_AUDIO, 0x949f97fd, 0x56f6, 0x4527, 0xb4, 0xae, 0xdd, 0xeb, 0x37, 0x5a, 0xb8, 0xf);

#define WAVE_FORMAT_MLP mmioFOURCC('M', 'L', 'P', ' ')
DEFINE_GUID(MEDIASUBTYPE_MLP, WAVE_FORMAT_MLP, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#define WAVE_FORMAT_SPEEX 0xA109
DEFINE_GUID(MEDIASUBTYPE_SPEEX, WAVE_FORMAT_SPEEX, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#ifndef WAVE_FORMAT_OPUS
#define WAVE_FORMAT_OPUS 0x704F
#endif
DEFINE_GUID(MEDIASUBTYPE_OPUS, WAVE_FORMAT_OPUS, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_OPUS_OLD mmioFOURCC('O', 'P', 'U', 'S')
DEFINE_GUID(MEDIASUBTYPE_OPUS_OLD, WAVE_FORMAT_OPUS_OLD, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_DSDL mmioFOURCC('D', 'S', 'D', 'L')
DEFINE_GUID(MEDIASUBTYPE_DSDL, WAVE_FORMAT_DSDL, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_DSDM mmioFOURCC('D', 'S', 'D', 'M')
DEFINE_GUID(MEDIASUBTYPE_DSDM, WAVE_FORMAT_DSDM, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_DSD1 mmioFOURCC('D', 'S', 'D', '1')
DEFINE_GUID(MEDIASUBTYPE_DSD1, WAVE_FORMAT_DSD1, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define WAVE_FORMAT_DSD8 mmioFOURCC('D', 'S', 'D', '8')
DEFINE_GUID(MEDIASUBTYPE_DSD8, WAVE_FORMAT_DSD8, 0x000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000014-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_G723, 0x00000014, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 00000111-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_VIVO_G723, 0x00000111, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

// 20455041-0000-0010-8000-00AA00389B71
DEFINE_GUID(MEDIASUBTYPE_APE, 0x20455041, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);


struct WAVEFORMATEX_HDMV_LPCM : public WAVEFORMATEX
{
    BYTE channel_conf;

    struct WAVEFORMATEX_HDMV_LPCM()
    {
        memset(this, 0, sizeof(*this));
        cbSize = sizeof(WAVEFORMATEX_HDMV_LPCM) - sizeof(WAVEFORMATEX);
    }
};

// {AFBC2343-3DCB-4047-9655-E1E62A61B1C5}
DEFINE_GUID(MEDIASUBTYPE_FFMPEG_AUDIO, 0xafbc2343, 0x3dcb, 0x4047, 0x96, 0x55, 0xe1, 0xe6, 0x2a, 0x61, 0xb1, 0xc5);

// {35189950-CAC9-4C8D-819D-B6FAEE15DD9D}
DEFINE_GUID(FORMAT_WaveFormatExFFMPEG, 0x35189950, 0xcac9, 0x4c8d, 0x81, 0x9d, 0xb6, 0xfa, 0xee, 0x15, 0xdd, 0x9d);

struct WAVEFORMATEXFFMPEG
{
    int nCodecId;
    WAVEFORMATEX wfex;

    struct WAVEFORMATEXFFMPEG()
    {
        nCodecId = 0;
    }
};

// {20884BC2-629F-45EA-B1C5-FA4FFA438250}
DEFINE_GUID(MEDIASUBTYPE_LAVBluRay, 0x20884bc2, 0x629f, 0x45ea, 0xb1, 0xc5, 0xfa, 0x4f, 0xfa, 0x43, 0x82, 0x50);

// {D51BD5A3-7548-11cf-A520-0080C77EF58A}
DEFINE_GUID(CLSID_MultFile, 0xd51bd5a3, 0x7548, 0x11cf, 0xa5, 0x20, 0x0, 0x80, 0xc7, 0x7e, 0xf5, 0x8a);

// Additionnal DXVA GUIDs

// Intel ClearVideo VC1 bitstream decoder
DEFINE_GUID(DXVA_Intel_VC1_ClearVideo, 0xBCC5DB6D, 0xA2B6, 0x4AF0, 0xAC, 0xE4, 0xAD, 0xB1, 0xF7, 0x87, 0xBC, 0x89);
DEFINE_GUID(DXVA_Intel_VC1_ClearVideo_2, 0xE07EC519, 0xE651, 0x4CD6, 0xAC, 0x84, 0x13, 0x70, 0xCC, 0xEE, 0xC8, 0x51);

// Intel ClearVideo H264 bitstream decoder
DEFINE_GUID(DXVA_Intel_H264_ClearVideo, 0x604F8E68, 0x4951, 0x4C54, 0x88, 0xFE, 0xAB, 0xD2, 0x5C, 0x15, 0xB3, 0xD6);

// Nvidia MPEG-4 ASP bitstream decoder
// 9947EC6F-689B-11DC-A320-0019DBBC4184
DEFINE_GUID(DXVA_MPEG4_ASP, 0x9947EC6F, 0x689B, 0x11DC, 0xA3, 0x20, 0x00, 0x19, 0xDB, 0xBC, 0x41, 0x84);

// Filter/Commercial GUIDs

DEFINE_GUID(CLSID_AC3Filter, 0xA753A1EC, 0x973E, 0x4718, 0xAF, 0x8E, 0xA3, 0xF5, 0x54, 0xD4, 0x5C, 0x44);

// {212690FB-83E5-4526-8FD7-74478B7939CD} from wmcodecdsp.h
DEFINE_GUID(CLSID_CMPEG2VidDecoderDS, 0x212690FB, 0x83E5, 0x4526, 0x8F, 0xD7, 0x74, 0x47, 0x8B, 0x79, 0x39, 0xCD);

// {39F498AF-1A09-4275-B193-673B0BA3D478}
DEFINE_GUID(CLSID_CMpeg2DecFilter, 0x39F498AF, 0x1A09, 0x4275, 0xB1, 0x93, 0x67, 0x3B, 0x0B, 0xA3, 0xD4, 0x78);

// Nvidia Video Decoder - {71E4616A-DB5E-452B-8CA5-71D9CC7805E9}
DEFINE_GUID(CLSID_NvidiaVideoDecoder, 0x71E4616A, 0xDB5E, 0x452B, 0x8C, 0xA5, 0x71, 0xD9, 0xCC, 0x78, 0x05, 0xE9);

// Sonic Cinemaster Video Decoder - {D7D50E8D-DD72-43C2-8587-A0C197D837D2}
DEFINE_GUID(CLSID_SonicCinemasterVideoDecoder, 0xD7D50E8D, 0xDD72, 0x43C2, 0x85, 0x87, 0xA0, 0xC1, 0x97, 0xD8, 0x37, 0xD2);

// RDP DirectShow Redirection Filter - {AB9D6472-752F-43F6-B29E-61207BDA8E06}
DEFINE_GUID(CLSID_RDPDShowRedirectionFilter, 0xAB9D6472, 0x752F, 0x43F6, 0xB2, 0x9E, 0x61, 0x20, 0x7B, 0xDA, 0x8E, 0x06);

// ReClock - {9DC15360-914C-46B8-B9DF-E67FD36C6A}
DEFINE_GUID(CLSID_ReClock, 0x9DC15360, 0x914C, 0x46B8, 0xB9, 0xDF, 0xBF, 0xE6, 0x7F, 0xD3, 0x6C, 0x6A);

// MPC(BE) Audio Renderer - {601D2A2B-9CDE-40BD-8650-0485E3522727}
DEFINE_GUID(CLSID_MPCBEAudioRenderer, 0x601D2A2B, 0x9CDE, 0x40BD, 0x86, 0x50, 0x04, 0x85, 0xE3, 0x52, 0x27, 0x27);

// Morgan's Stream Switcher - {D3CD7858-971A-4838-ACEC-40CA5D529DC8}
DEFINE_GUID(CLSID_MorganStreamSwitcher, 0xD3CD7858, 0x971A, 0x4838, 0xAC, 0xEC, 0x40, 0xCA, 0x5D, 0x52, 0x9D, 0xC8);

// FFDShow DXVA Decoder - {0B0EFF97-C750-462C-9488-B10E7D87F1A6}
DEFINE_GUID(CLSID_FFDShowDXVADecoder, 0x0B0EFF97, 0xC750, 0x462C, 0x94, 0x88, 0xB1, 0x0E, 0x7D, 0x87, 0xF1, 0xA6);

// Microsoft DTV-DVD Audio Decoder - {E1F1A0B8-BEEE-490D-BA7C-066C40B5E2B9}
DEFINE_GUID(CLSID_MSDVTDVDAudioDecoder, 0xE1F1A0B8, 0xBEEE, 0x490D, 0xBA, 0x7C, 0x06, 0x6C, 0x40, 0xB5, 0xE2, 0xB9);

// Old MPC-HC filters
DEFINE_GUID(CLSID_MPCMpegSplitter, 0xDC257063, 0x045F, 0x4BE2, 0xBD, 0x5B, 0xE1, 0x22, 0x79, 0xC4, 0x64, 0xF0);
DEFINE_GUID(CLSID_MPCMpegSplitterSource, 0x1365BE7A, 0xC86A, 0x473C, 0x9A, 0x41, 0xC0, 0xA6, 0xE8, 0x2C, 0x9F, 0xA3);
DEFINE_GUID(CLSID_MPCVideoDecoder, 0x008BAC12, 0xFBAF, 0x497b, 0x96, 0x70, 0xBC, 0x6F, 0x6F, 0xBA, 0xE2, 0xC4);
DEFINE_GUID(CLSID_MPCShoutcastSource, 0x68F540E9, 0x766F, 0x44d2, 0xAB, 0x07, 0xE2, 0x6C, 0xC6, 0xD2, 0x7A, 0x79);

// DirectVobSub || VSFilter (auto-loading version) - {9852A670-F845-491B-9BE6-EBD841B8A613}
DEFINE_GUID(CLSID_VSFilter, 0x9852A670, 0xF845, 0x491B, 0x9B, 0xE6, 0xEB, 0xD8, 0x41, 0xB8, 0xA6, 0x13);

// DirectVobSub || VSFilter - {93A22E7A-5091-45EF-BA61-6DA26156A5D0}
DEFINE_GUID(CLSID_VSFilter2, 0x93A22E7A, 0x5091, 0x45EF, 0xBA, 0x61, 0x6D, 0xA2, 0x61, 0x56, 0xA5, 0xD0);

// XySubFilter - {2DFCB782-EC20-4A7C-B530-4577ADB33F21}
DEFINE_GUID(CLSID_XySubFilter, 0x2DFCB782, 0xEC20, 0x4A7C, 0xB5, 0x30, 0x45, 0x77, 0xAD, 0xB3, 0x3F, 0x21);

// XySubFilterAutoLoader - {6B237877-902B-4C6C-92F6-E63169A5166C}
DEFINE_GUID(CLSID_XySubFilter_AutoLoader, 0x6B237877, 0x902B, 0x4C6C, 0x92, 0xF6, 0xE6, 0x31, 0x69, 0xA5, 0x16, 0x6C);

// sanear (internal version)
// SaneAudioRenderer::Factory::GetFilterGuid() is the right way do optain it,
// but we link DSUtil to everything and consequently will have to link sanear to everything.
DEFINE_GUID(CLSID_SANEAR_INTERNAL, 0x2AE00773, 0x819A, 0x40FB, 0xA5, 0x54, 0x54, 0x82, 0x7E, 0x11, 0x63, 0x59);

// sanear (standalone version) - {DF557071-C9FD-433A-9627-81E0D3640ED9}
DEFINE_GUID(CLSID_SANEAR, 0xdf557071, 0xc9fd, 0x433a, 0x96, 0x27, 0x81, 0xe0, 0xd3, 0x64, 0xe, 0xd9);

// AssFilter - {8A3704F3-BE3B-4944-9FF3-EE8757FDBDA5}
DEFINE_GUID(CLSID_AssFilter, 0x8A3704F3, 0xBE3B, 0x4944, 0x9F, 0xF3, 0xEE, 0x87, 0x57, 0xFD, 0xBD, 0xA5);

// AssFilterAutoLoader - {8A6DFC6A-0A79-4790-85DA-0688B8093B54}
DEFINE_GUID(CLSID_AssFilter_AutoLoader, 0x8A6DFC6A, 0x0A79, 0x4790, 0x85, 0xDA, 0x06, 0x88, 0xB8, 0x09, 0x3B, 0x54);

// Generate Still Video - {7DF62B50-6843-11D2-9EEB-006008039E37}
DEFINE_GUID(CLSID_StillVideo, 0x7DF62B50, 0x6843, 0x11D2, 0x9E, 0xEB, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37);

// MPC Image Source - {7DB5C3B3-2419-4508-B1D0-F2D22DA8E439}
DEFINE_GUID(CLSID_MPCImageSource, 0x7DB5C3B3, 0x2419, 0x4508, 0xB1, 0xD0, 0xF2, 0xD2, 0x2D, 0xA8, 0xE4, 0x39);

DEFINE_GUID(CLSID_Generic_WDM_FilterProxy, 0x17CCA71B, 0xECD7, 0x11D0, 0xB9, 0x08, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96);

// uncompressed
#define DEFINE_GUID_FOURCC(FOURCC) \
    DEFINE_GUID(MEDIASUBTYPE_##FOURCC, FOURCC_##FOURCC, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

//uncompressed
#define FOURCC_YUY2 mmioFOURCC('Y','U','Y','2')
#define FOURCC_V422 mmioFOURCC('V','4','2','2')
#define FOURCC_YV12 mmioFOURCC('Y','V','1','2')
#define FOURCC_YVYU mmioFOURCC('Y','V','Y','U')
#define FOURCC_UYVY mmioFOURCC('U','Y','V','Y')
#define FOURCC_YUYV mmioFOURCC('Y','U','Y','V')
#define FOURCC_VYUY mmioFOURCC('V','Y','U','Y')
#define FOURCC_I420 mmioFOURCC('I','4','2','0')
#define FOURCC_IYUV mmioFOURCC('I','Y','U','V')
#define FOURCC_444P mmioFOURCC('4','4','4','P')
#define FOURCC_YV24 mmioFOURCC('Y','V','2','4') // YUV 4:4:4
#define FOURCC_422P mmioFOURCC('4','2','2','P')
#define FOURCC_YV16 mmioFOURCC('Y','V','1','6') // YUV 4:2:2
#define FOURCC_411P mmioFOURCC('4','1','1','P')
#define FOURCC_Y41B mmioFOURCC('Y','4','1','B') // YUV 4:1:1
#define FOURCC_410P mmioFOURCC('4','1','0','P')
#define FOURCC_PAL1 mmioFOURCC('P','A','L','1')
#define FOURCC_PAL4 mmioFOURCC('P','A','L','4')
#define FOURCC_PAL8 mmioFOURCC('P','A','L','8')
#define FOURCC_RGB2 mmioFOURCC('R','G','B','2')
#define FOURCC_RGB3 mmioFOURCC('R','G','B','3')
#define FOURCC_RGB5 mmioFOURCC('R','G','B','5')
#define FOURCC_RGB6 mmioFOURCC('R','G','B','6')
#define FOURCC_CLJR mmioFOURCC('C','L','J','R')
#define FOURCC_Y800 mmioFOURCC('Y','8','0','0')
#define FOURCC_NV12 mmioFOURCC('N','V','1','2')
#define FOURCC_NV21 mmioFOURCC('N','V','2','1')
#define FOURCC_P010 mmioFOURCC('P','0','1','0')
#define FOURCC_P016 mmioFOURCC('P','0','1','6')
#define FOURCC_420R mmioFOURCC('4','2','0','R')
#define FOURCC_422R mmioFOURCC('4','2','2','R')
#define FOURCC_444R mmioFOURCC('4','4','4','R')
#define FOURCC_P210 mmioFOURCC('P','2','1','0')
#define FOURCC_P216 mmioFOURCC('P','2','1','6')
#define FOURCC_AYUV mmioFOURCC('A','Y','U','V')
#define FOURCC_Y416 mmioFOURCC('Y','4','1','6')

#define FOURCC_nv12 mmioFOURCC('n','v','1','2')
#define FOURCC_yv12 mmioFOURCC('y','v','1','2')
#define FOURCC_ICM1 mmioFOURCC('I','C','M','1')
#define FOURCC_ICM2 mmioFOURCC('I','C','M','2')
#define FOURCC_ICM3 mmioFOURCC('I','C','M','3')
#define FOURCC_ICM4 mmioFOURCC('I','C','M','4')
#define FOURCC_yuy2 mmioFOURCC('y','u','y','2')
#define FOURCC_uyvy mmioFOURCC('u','y','v','y')
#define FOURCC_cyuv mmioFOURCC('c','y','u','v')
#define FOURCC_UYNV mmioFOURCC('U','Y','N','V')
#define FOURCC_UYNY mmioFOURCC('U','Y','N','Y')
#define FOURCC_HDYC mmioFOURCC('H','D','Y','C')
#define FOURCC_uyv1 mmioFOURCC('u','y','v','1')
#define FOURCC_2Vu1 mmioFOURCC('2','V','u','1')
#define FOURCC_VDTZ mmioFOURCC('V','D','T','Z')
#define FOURCC_YUV2 mmioFOURCC('Y','U','V','2')
#define FOURCC_yuv2 mmioFOURCC('y','u','v','2')
#define FOURCC_2vuy mmioFOURCC('2','v','u','y')
#define FOURCC_2Vuy mmioFOURCC('2','V','u','y')
#define FOURCC_yuvu mmioFOURCC('y','u','v','u')
#define FOURCC_yuvs mmioFOURCC('y','u','v','s')
#define FOURCC_I422 mmioFOURCC('I','4','2','2')
#define FOURCC_Y422 mmioFOURCC('Y','4','2','2')
#define FOURCC_V422 mmioFOURCC('V','4','2','2')
#define FOURCC_Y42B mmioFOURCC('Y','4','2','B')
#define FOURCC_P422 mmioFOURCC('P','4','2','2')
#define FOURCC_YUNV mmioFOURCC('Y','U','N','V')
#define FOURCC_AVUI mmioFOURCC('A','V','U','I')
#define FOURCC_I444 mmioFOURCC('I','4','4','4')
#define FOURCC_v308 mmioFOURCC('v','3','0','8')
#define FOURCC_v408 mmioFOURCC('v','4','0','8')
#define FOURCC_24BG mmioFOURCC('2','4','B','G')
#define FOURCC_BGRA mmioFOURCC('B','G','R','A')
#define FOURCC_ABGR mmioFOURCC('A','B','G','R')
#define FOURCC_RGBA mmioFOURCC('R','G','B','A')
#define FOURCC_RGB0 mmioFOURCC('R','G','B','0')
#define FOURCC_0RGB mmioFOURCC('0','R','G','B')
#define FOURCC_b48r mmioFOURCC('b','4','8','r')
#define FOURCC_RBA64 mmioFOURCC('R','B','A',64)
#define FOURCC_64RBA mmioFOURCC(64,'R','B','A')
#define FOURCC_b64a mmioFOURCC('b','6','4','a')
#define FOURCC_Y410 mmioFOURCC('Y','4','1','0')
#define FOURCC_v216 mmioFOURCC('v','2','1','6')
#define FOURCC_v416 mmioFOURCC('v','4','1','6')
#define FOURCC_Y8   mmioFOURCC('Y','8',0x20,0x20)
#define FOURCC_Y16  mmioFOURCC('Y','1',0,16)

DEFINE_GUID_FOURCC(422P)
DEFINE_GUID_FOURCC(444P)
DEFINE_GUID_FOURCC(411P)
DEFINE_GUID_FOURCC(410P)
DEFINE_GUID_FOURCC(VYUY)
DEFINE_GUID_FOURCC(Y800)
DEFINE_GUID_FOURCC(NV21)
DEFINE_GUID_FOURCC(YV16)
DEFINE_GUID_FOURCC(YV24)
DEFINE_GUID_FOURCC(420R)
DEFINE_GUID_FOURCC(422R)
DEFINE_GUID_FOURCC(444R)
DEFINE_GUID_FOURCC(Y416)

DEFINE_GUID_FOURCC(nv12)
DEFINE_GUID_FOURCC(yv12)
DEFINE_GUID_FOURCC(ICM1)
DEFINE_GUID_FOURCC(ICM2)
DEFINE_GUID_FOURCC(ICM3)
DEFINE_GUID_FOURCC(ICM4)
DEFINE_GUID_FOURCC(yuy2)
DEFINE_GUID_FOURCC(uyvy)
DEFINE_GUID_FOURCC(cyuv)
DEFINE_GUID_FOURCC(UYNV)
DEFINE_GUID_FOURCC(UYNY)
DEFINE_GUID_FOURCC(HDYC)
DEFINE_GUID_FOURCC(uyv1)
DEFINE_GUID_FOURCC(2Vu1)
DEFINE_GUID_FOURCC(VDTZ)
DEFINE_GUID_FOURCC(YUV2)
DEFINE_GUID_FOURCC(yuv2)
DEFINE_GUID_FOURCC(2vuy)
DEFINE_GUID_FOURCC(2Vuy)
DEFINE_GUID_FOURCC(yuvu)
DEFINE_GUID_FOURCC(yuvs)
DEFINE_GUID_FOURCC(I422)
DEFINE_GUID_FOURCC(Y422)
DEFINE_GUID_FOURCC(V422)
DEFINE_GUID_FOURCC(Y42B)
DEFINE_GUID_FOURCC(P422)
DEFINE_GUID_FOURCC(YUNV)
DEFINE_GUID_FOURCC(AVUI)
DEFINE_GUID_FOURCC(I444)
DEFINE_GUID_FOURCC(v308)
DEFINE_GUID_FOURCC(v408)
DEFINE_GUID_FOURCC(24BG)
DEFINE_GUID_FOURCC(BGRA)
DEFINE_GUID_FOURCC(ABGR)
DEFINE_GUID_FOURCC(RGBA)
DEFINE_GUID_FOURCC(RGB0)
DEFINE_GUID_FOURCC(0RGB)
DEFINE_GUID_FOURCC(b48r)
DEFINE_GUID_FOURCC(RBA64)
DEFINE_GUID_FOURCC(64RBA)
DEFINE_GUID_FOURCC(b64a)
DEFINE_GUID_FOURCC(Y410)
DEFINE_GUID_FOURCC(v216)
DEFINE_GUID_FOURCC(v416)
DEFINE_GUID_FOURCC(Y8)
DEFINE_GUID_FOURCC(Y16)
