### Quick Start

**The latest version of this documentation is available on [GitHub](https://github.com/Microsoft/vcpkg/tree/master/docs/README.md).**

Vcpkg helps you manage C and C++ libraries on Windows, Linux and MacOS. This tool and ecosystem are constantly evolving; your involvement is vital to its success!

### Examples

- [Installing and Using Packages Example: sqlite](examples/installing-and-using-packages.md)
- [Packaging Zipfiles Example: zlib](examples/packaging-zipfiles.md)
- [Packaging GitHub Repositories Example: libogg](examples/packaging-github-repos.md)
- [Patching Example: Patching libpng to work for x64-uwp](examples/patching.md)
- [Getting Started with Versioning](examples/versioning.getting-started.md)

### Command Line Reference

- [Command Line Reference](commands/index.md)

### User Help

- [Buildsystem Integration](users/buildsystems/integration.md)
- [Triplet files](users/triplets.md)
- [Configuration and Environment](users/config-environment.md)
- [Authentication](users/authentication.md)
- [Manifest Mode](users/manifests.md)
- [Binary Caching](users/binarycaching.md)
- [Asset Caching](users/assetcaching.md)
- [Versioning](users/versioning.md)
- [Usage with Android](users/android.md)
- [Usage with Mingw-w64](users/mingw.md)
- [Host Dependencies](users/host-dependencies.md)
- [Using Registries](users/registries.md)

### Maintainer Help

- [Manifest Files - vcpkg.json](maintainers/manifest-files.md)
- [Control Files](maintainers/control-files.md)
- [Portfile Functions](maintainers/portfile-functions.md)
- [Authoring Script Ports](maintainers/authoring-script-ports.md)
- [Common CMake Definitions](maintainers/vcpkg_common_definitions.md)
- [Maintainer Guidelines](maintainers/maintainer-guide.md)
- [Creating Registries](maintainers/registries.md)
- [CMake Guidelines](maintainers/cmake-guidelines.md)

### [Vcpkg-Tool](https://github.com/microsoft/vcpkg-tool) Maintainer Help

- [Testing](https://github.com/microsoft/vcpkg-tool/tree/main/docs/testing.md)
- [Benchmarking](https://github.com/microsoft/vcpkg-tool/tree/main/docs/benchmarking.md)
- [Layout of the vcpkg source tree](https://github.com/microsoft/vcpkg-tool/tree/main/docs/layout.md)

### Community Resources (not directly affiliated with vcpkg)

- [vcpkg.info](https://vcpkg.info/) - Package index + search
- [vcpkgx](https://vcpkgx.com/) - Package index + search
- [vcpkg index](https://vcpkg.dev/) - Package index + search

### Blog posts

- [Vcpkg Host Dependencies for Cross-Compilation](https://devblogs.microsoft.com/cppblog/vcpkg-host-dependencies/)
- [Registries: Bring your own libraries to vcpkg](https://devblogs.microsoft.com/cppblog/registries-bring-your-own-libraries-to-vcpkg/)
- [Vcpkg: Accelerate your team development environment with binary caching and manifests](https://devblogs.microsoft.com/cppblog/vcpkg-accelerate-your-team-development-environment-with-binary-caching-and-manifests/)
- [Vcpkg: 2019.06 Update (overlay ports, overlay triplets, `vcpkg_check_features`)](https://devblogs.microsoft.com/cppblog/vcpkg-2019-06-update/)
- [Announcing a single C++ library manager for Linux, macOS and Windows: Vcpkg](https://blogs.msdn.microsoft.com/vcblog/2018/04/24/announcing-a-single-c-library-manager-for-linux-macos-and-windows-vcpkg/)
- [Vcpkg: Using multiple enlistments to handle multiple versions of a library](https://blogs.msdn.microsoft.com/vcblog/2017/10/23/vcpkg-using-multiple-enlistments/)
- [Vcpkg: introducing the export command](https://blogs.msdn.microsoft.com/vcblog/2017/05/03/vcpkg-introducing-export-command/)
- [Binary Compatibility and Pain-free Upgrade Why Moving to Visual Studio 2017 is almost "too easy"](https://blogs.msdn.microsoft.com/vcblog/2017/03/07/binary-compatibility-and-pain-free-upgrade-why-moving-to-visual-studio-2017-is-almost-too-easy/)
- [Vcpkg recent enhancements](https://blogs.msdn.microsoft.com/vcblog/2017/02/14/vcpkg-recent-enhancements/)
- [Vcpkg 3 Months Anniversary, Survey](https://blogs.msdn.microsoft.com/vcblog/2017/01/11/vcpkg-3-months-anniversary-survey/)
- [Vcpkg updates: Static linking is now available](https://blogs.msdn.microsoft.com/vcblog/2016/11/01/vcpkg-updates-static-linking-is-now-available/)
- [Vcpkg: a tool to acquire and build C++ open source libraries on Windows](https://blogs.msdn.microsoft.com/vcblog/2016/09/19/vcpkg-a-tool-to-acquire-and-build-c-open-source-libraries-on-windows/)

### Other

- [FAQ](about/faq.md)
- [Privacy](about/privacy.md)
