<p align="center">
  <a href="https://classicvalues.dev">
    <img src="https://avatars.githubusercontent.com/u/71681815?s=400&u=d2fd084b77b464587cdf224deb1fb944f190d853&v=4" alt="Classic Values logo" width="250">
  </a>
</p>

<h3 align="center">Classic Values UI</h3>

<p align="center">
Software Gaming Development Company!
Classic Games on Mobile Devices.
    <br>
    <a href="https://classicvalues.dev/apps/"><strong>Explore our Applications »</strong></a>
    <br>
    <br>
        <a href="https://github.com/classicvalues/classicvalues-website-update/issues/new?assignees=&labels=&template=bug_report.md&title=">Report bug</a>
            ·
        <a href="https://github.com/classicvalues/classicvalues-website-update/issues/new?assignees=&labels=feature&template=feature_request.md&title=">Request feature</a>
            ·
        <a href="https://classicvalues.dev/./#^%/blog">Blog</a>
</p>

## Table of contents

- [Quick start](#quick-start)
- [What's included](#whats-included)
- [Bugs and feature requests](#bugs-and-feature-requests)
- [Documentation](#documentation)
- [Contributing](#contributing)
- [Versioning](#versioning)
- [Creators](#creators)
- [Thanks](#thanks)
- [Copyright and license](#copyright-and-license)

## Quick start

Several quick start options are available:

- [Download the latest release](https://github.com/classicvalues/classicvalues-website-update/archive/refs/tags/v1.0.1.zip)
- Clone the repo: `git clone https://github.com/classicvalues/classicvalues-website-update.git`
- Clone with GitHub CLI: `gh repo clone classicvalues/classicvalues-website-update`

Read the [Getting started page](https://coreui.io/docs/getting-started/introduction/) for information on the framework contents, templates and examples, and more.

## What's included

Within the download you'll find the following directories and files, logically grouped common assets and along with, both, compiled and mini variations. You will see something along the lines of this:

```text
coreui/
├── css/
│   ├── coreui-grid.css
│   ├── coreui-grid.css.map
│   ├── coreui-grid.min.css
│   ├── coreui-grid.min.css.map
│   ├── coreui-grid.rtl.css
│   ├── coreui-grid.rtl.css.map
│   ├── coreui-grid.rtl.min.css
│   ├── coreui-grid.rtl.min.css.map
│   ├── coreui-reboot.css
│   ├── coreui-reboot.css.map
│   ├── coreui-reboot.min.css
│   ├── coreui-reboot.min.css.map
│   ├── coreui-reboot.rtl.css
│   ├── coreui-reboot.rtl.css.map
│   ├── coreui-reboot.rtl.min.css
│   ├── coreui-reboot.rtl.min.css.map
│   ├── coreui-utilities.css
│   ├── coreui-utilities.css.map
│   ├── coreui-utilities.min.css
│   ├── coreui-utilities.min.css.map
│   ├── coreui-utilities.rtl.css
│   ├── coreui-utilities.rtl.css.map
│   ├── coreui-utilities.rtl.min.css
│   ├── coreui-utilities.rtl.min.css.map
│   ├── coreui.css
│   ├── coreui.css.map
│   ├── coreui.min.css
│   ├── coreui.min.css.map
│   ├── coreui.rtl.css
│   ├── coreui.rtl.css.map
│   ├── coreui.rtl.min.css
│   └── coreui.rtl.min.css.map
└── js/
    ├── coreui.bundle.js
    ├── coreui.bundle.js.map
    ├── coreui.bundle.min.js
    ├── coreui.bundle.min.js.map
    ├── coreui.esm.js
    ├── coreui.esm.js.map
    ├── coreui.esm.min.js
    ├── coreui.esm.min.js.map
    ├── coreui.js
    ├── coreui.js.map
    ├── coreui.min.js
    └── coreui.min.js.map
```

We provide compiled CSS and JS (`coreui.*`), as well as compiled and minified CSS and JS (`coreui.min.*`). [source maps](https://developers.google.com/web/tools/chrome-devtools/javascript/source-maps) (`coreui.*.map`) are available for use with certain browsers' developer tools. Bundled JS files (`coreui.bundle.js` and minified `coreui.bundle.min.js`) include [Popper](https://popper.js.org/). These can all be accessed by pressing the **(".")** period button on the keyboard from your perfered file location. This will open a web-based VSCode web editor from [GitHub.dev](https://github.dev/classicvalues/classicvalues-website-update/)

## Bugs, feature requests, and Q&A

Have a bug or a feature request? Please first read the [issue guidelines](https://github.com/classicvalues/classicvalues-website-update/blob/master/.github/CONTRIBUTING.md#using-the-issue-tracker) and search for existing and closed issues. If your problem or idea is not addressed yet, [please open a new issue](https://github.com/classicvalues/classicvalues-website-update/issues/new).

## Documentation

The documentation for Classic Values UI is hosted at our website [CoreUI](https://classicvalues.dev/./#^%/software/ui/#^%/)

### Running documentation locally

1. Run `npm install` to install the Node.js dependencies, including Hugo (the site builder).
2. Run `npm start` to create live-server on `http://localhost:9001/` in your browser, hosted on your local server port 9001.
3. Run `npm run test` (or a specific npm script) to rebuild distributed CSS and JavaScript files, as well as our docs assets.
4. From the root `/classicvalues-website-update` directory, run `npm run docs-serve` in the command line.
5. Open `http://localhost:9001/` in your browser, and voilà.

Learn more about using Hugo by reading its [documentation](https://gohugo.io/documentation/).

## Contributing

Please read through our [contributing guidelines](https://github.com/classicvalues/classicvalues-website-update/blob/master/.github/CONTRIBUTING.md). Included are directions for opening issues, coding standards, and notes on development.

Editor preferences are available in the [editor config](https://github.com/classicvalues/classicvalues-website-update/blob/master/.editorconfig) for easy use in common text editors. Read more and download plugins at <https://editorconfig.org/>.

Be sure to use GitHub Dev on [GitHub.dev](https://github.dev/classicvalues/classicvalues-website-update) which create a web editor from the current repository on a web based VSCode editor, right at yout fingertips.

## Versioning

For transparency into our release cycle and in striving to maintain backward compatibility, CoreUI is maintained under [the Semantic Versioning guidelines](http://semver.org/).

See [the Releases section of our project](https://github.com/classicvalues/classicvalues-website-update/releases) for changelogs for each release version.

## Creators

**Classic Values**

- <https://twitter.com/_classicvalues>
- <https://github.com/classicvalues>
- <https://www.linkedin.com/in/santiago-de-jesus-villalobos-gonz%C3%A1lez/>

<!-- Needs work! Extend Thank you to Shields.io, Boost & Beast Teams, as well as CoreUI themselves, Lukasz, Mark, and "Fat" as well as Juliani, A., Berges, V., Teng, E., Cohen, A., Harper, J., Elion, C., Goy, C., Gao, Y., Henry, H., Mattar, M., Lange, D., et. al. (2020). Unity: A General Platform for Intelligent Agents. _arXiv preprint [arXiv:1809.02627](https://arxiv.org/abs/1809.02627)._ https://github.com/Unity-Technologies/ml-agents.--> 
## Thanks 
CoreUI is designed as the extension of [Bootstrap](https://getbootstrap.com). Special thanks for [Bootstrap team](https://getbootstrap.com/docs/5.0/about/team/) and [Bootstrap's contributors](https://github.com/twbs/bootstrap/graphs/contributors). 
 
## Copyright and License
Copyright 2021 creativeLabs Łukasz Holeczek. Code released under the [MIT License](https://github.com/coreui/coreui/blob/main/LICENSE). Docs released under [Creative Commons](https://creativecommons.org/licenses/by/3.0/).
